/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.contingency.Contingency;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.LoadFlowParametersOverride;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import java.util.List;
import java.util.Optional;

public class ContingencyLoadFlowParameters
extends AbstractExtension<Contingency>
implements LoadFlowParametersOverride {
    private Boolean distributedSlack;
    private Boolean areaInterchangeControl;
    private LoadFlowParameters.BalanceType balanceType;
    private List<String> outerLoopNames;

    public String getName() {
        return "contingency-load-flow-parameters";
    }

    @Override
    public boolean isDistributedSlack(LoadFlowParameters loadFlowParameters) {
        return this.distributedSlack != null ? this.distributedSlack.booleanValue() : loadFlowParameters.isDistributedSlack();
    }

    @Override
    public boolean isAreaInterchangeControl(OpenLoadFlowParameters loadFlowParametersExt) {
        return this.areaInterchangeControl != null ? this.areaInterchangeControl.booleanValue() : loadFlowParametersExt.isAreaInterchangeControl();
    }

    @Override
    public LoadFlowParameters.BalanceType getBalanceType(LoadFlowParameters loadFlowParameters) {
        return this.balanceType != null ? this.balanceType : loadFlowParameters.getBalanceType();
    }

    @Override
    public List<String> getOuterLoopNames(OpenLoadFlowParameters loadFlowParametersExt) {
        return this.outerLoopNames != null ? this.outerLoopNames : loadFlowParametersExt.getOuterLoopNames();
    }

    public Optional<Boolean> isDistributedSlack() {
        return Optional.ofNullable(this.distributedSlack);
    }

    public Optional<Boolean> isAreaInterchangeControl() {
        return Optional.ofNullable(this.areaInterchangeControl);
    }

    public Optional<LoadFlowParameters.BalanceType> getBalanceType() {
        return Optional.ofNullable(this.balanceType);
    }

    public Optional<List<String>> getOuterLoopNames() {
        return Optional.ofNullable(this.outerLoopNames);
    }

    public ContingencyLoadFlowParameters setDistributedSlack(Boolean distributedSlack) {
        this.distributedSlack = distributedSlack;
        return this;
    }

    public ContingencyLoadFlowParameters setAreaInterchangeControl(Boolean areaInterchangeControl) {
        this.areaInterchangeControl = areaInterchangeControl;
        return this;
    }

    public ContingencyLoadFlowParameters setBalanceType(LoadFlowParameters.BalanceType balanceType) {
        this.balanceType = balanceType;
        return this;
    }

    public ContingencyLoadFlowParameters setOuterLoopNames(List<String> outerLoopNames) {
        this.outerLoopNames = outerLoopNames;
        return this;
    }
}

