/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa.extensions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.Contingency;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.sa.extensions.ContingencyLoadFlowParameters;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

@AutoService(value={ExtensionJsonSerializer.class})
public class ContingencyLoadFlowParametersJsonSerializer
implements ExtensionJsonSerializer<Contingency, ContingencyLoadFlowParameters> {
    public String getExtensionName() {
        return "contingency-load-flow-parameters";
    }

    public String getCategoryName() {
        return "security-analysis";
    }

    public Class<? super ContingencyLoadFlowParameters> getExtensionClass() {
        return ContingencyLoadFlowParameters.class;
    }

    public void serialize(ContingencyLoadFlowParameters extension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Optional<Boolean> distributedSlack = extension.isDistributedSlack();
        Optional<Boolean> areaInterchangeControl = extension.isAreaInterchangeControl();
        Optional<LoadFlowParameters.BalanceType> balanceType = extension.getBalanceType();
        Optional<List<String>> outerLoopNames = extension.getOuterLoopNames();
        jsonGenerator.writeStartObject();
        if (distributedSlack.isPresent()) {
            jsonGenerator.writeBooleanField("distributedSlack", distributedSlack.get().booleanValue());
        }
        if (areaInterchangeControl.isPresent()) {
            jsonGenerator.writeBooleanField("areaInterchangeControl", areaInterchangeControl.get().booleanValue());
        }
        if (balanceType.isPresent()) {
            jsonGenerator.writeStringField("balanceType", balanceType.get().name());
        }
        if (outerLoopNames.isPresent()) {
            jsonGenerator.writeArrayFieldStart("outerLoopNames");
            for (String name : outerLoopNames.get()) {
                jsonGenerator.writeString(name);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    public ContingencyLoadFlowParameters deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ContingencyLoadFlowParameters contingencyLoadFlowParameters = new ContingencyLoadFlowParameters();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (jsonParser.currentName().equals("distributedSlack")) {
                jsonParser.nextToken();
                boolean distributedSlack = (Boolean)jsonParser.readValueAs(Boolean.class);
                contingencyLoadFlowParameters.setDistributedSlack(distributedSlack);
                continue;
            }
            if (jsonParser.currentName().equals("areaInterchangeControl")) {
                jsonParser.nextToken();
                boolean areaInterchangeControl = (Boolean)jsonParser.readValueAs(Boolean.class);
                contingencyLoadFlowParameters.setAreaInterchangeControl(areaInterchangeControl);
                continue;
            }
            if (jsonParser.currentName().equals("balanceType")) {
                jsonParser.nextToken();
                LoadFlowParameters.BalanceType balanceType = LoadFlowParameters.BalanceType.valueOf((String)((String)jsonParser.readValueAs(String.class)));
                contingencyLoadFlowParameters.setBalanceType(balanceType);
                continue;
            }
            if (jsonParser.currentName().equals("outerLoopNames")) {
                jsonParser.nextToken();
                List outerLoopNames = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)jsonParser, String.class);
                contingencyLoadFlowParameters.setOuterLoopNames(outerLoopNames);
                continue;
            }
            throw new PowsyblException("Unexpected field: " + jsonParser.currentName());
        }
        return contingencyLoadFlowParameters;
    }
}

