/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcloadFlowEngine;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.ac.solver.AcSolverUtil;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.NetworkSlackBusSelector;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SlackBusSelector;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.sensi.AbstractSensitivityAnalysis;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AcSensitivityAnalysis
extends AbstractSensitivityAnalysis<AcVariableType, AcEquationType> {
    public AcSensitivityAnalysis(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, SensitivityAnalysisParameters parameters) {
        super(matrixFactory, connectivityFactory, parameters);
    }

    private void calculateSensitivityValues(List<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> lfFactors, AbstractSensitivityAnalysis.SensitivityFactorGroupList<AcVariableType, AcEquationType> factorGroups, DenseMatrix factorsState, int contingencyIndex, SensitivityResultWriter resultWriter) {
        HashSet<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> lfFactorsSet = new HashSet<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>>(lfFactors);
        lfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION).forEach(factor -> {
            if (!AcSensitivityAnalysis.filterSensitivityValue(0.0, factor.getVariableType(), factor.getFunctionType(), this.parameters)) {
                resultWriter.writeSensitivityValue(factor.getIndex(), contingencyIndex, 0.0, AcSensitivityAnalysis.unscaleFunction(factor, factor.getFunctionReference()));
            }
        });
        for (AbstractSensitivityAnalysis.SensitivityFactorGroup<AcVariableType, AcEquationType> factorGroup : factorGroups.getList()) {
            for (AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType> factor2 : factorGroup.getFactors()) {
                double sensi;
                if (!lfFactorsSet.contains(factor2)) continue;
                if (factor2.getSensitivityValuePredefinedResult() != null) {
                    sensi = factor2.getSensitivityValuePredefinedResult();
                } else {
                    if (!factor2.getFunctionEquationTerm().isActive()) {
                        throw new PowsyblException("Found an inactive equation for a factor that has no predefined result");
                    }
                    sensi = factor2.getFunctionEquationTerm().calculateSensi(factorsState, factorGroup.getIndex());
                }
                double ref = factor2.getFunctionPredefinedResult() != null ? factor2.getFunctionPredefinedResult().doubleValue() : factor2.getFunctionReference();
                double unscaledSensi = AcSensitivityAnalysis.unscaleSensitivity(factor2, sensi);
                if (AcSensitivityAnalysis.filterSensitivityValue(unscaledSensi, factor2.getVariableType(), factor2.getFunctionType(), this.parameters)) continue;
                resultWriter.writeSensitivityValue(factor2.getIndex(), contingencyIndex, unscaledSensi, AcSensitivityAnalysis.unscaleFunction(factor2, ref));
            }
        }
    }

    private void setFunctionReferences(List<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> factors) {
        for (AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType> factor : factors) {
            if (factor.getFunctionPredefinedResult() != null) {
                factor.setFunctionReference(factor.getFunctionPredefinedResult());
                continue;
            }
            factor.setFunctionReference(factor.getFunctionEquationTerm().eval());
        }
    }

    private void calculatePostContingencySensitivityValues(List<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> lfFactors, LfContingency lfContingency, LfNetwork lfNetwork, AcLoadFlowContext context, AbstractSensitivityAnalysis.SensitivityFactorGroupList<AcVariableType, AcEquationType> factorGroups, Map<LfBus, Double> participationByBus, LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, int contingencyIndex, SensitivityResultWriter resultWriter, boolean hasTransformerBusTargetVoltage) {
        if (lfParameters.isDistributedSlack() && Math.abs(lfContingency.getActivePowerLoss()) > 0.0) {
            ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(lfParameters.getBalanceType(), lfParametersExt.isLoadPowerFactorConstant(), lfParametersExt.isUseActiveLimits());
            activePowerDistribution.run(lfNetwork, lfContingency.getActivePowerLoss());
        }
        if (!AcSensitivityAnalysis.runLoadFlow(context, false)) {
            resultWriter.writeContingencyStatus(contingencyIndex, SensitivityAnalysisResult.Status.FAILURE);
            return;
        }
        resultWriter.writeContingencyStatus(contingencyIndex, SensitivityAnalysisResult.Status.SUCCESS);
        if (hasTransformerBusTargetVoltage) {
            for (LfBranch branch : lfNetwork.getBranches()) {
                branch.getVoltageControl().ifPresent(vc -> branch.setVoltageControlEnabled(true));
            }
            lfNetwork.fixTransformerVoltageControls();
        }
        if (!(!factorGroups.hasMultiVariables() || lfContingency.getLostLoads().isEmpty() && lfContingency.getLostGenerators().isEmpty())) {
            Set<LfBus> affectedBuses = lfContingency.getLoadAndGeneratorBuses();
            this.rescaleGlsk(factorGroups, affectedBuses);
        }
        DenseMatrix factorsStates = AcSensitivityAnalysis.initFactorsRhs(context.getEquationSystem(), factorGroups, participationByBus);
        context.getJacobianMatrix().solveTransposed(factorsStates);
        this.setFunctionReferences(lfFactors);
        this.calculateSensitivityValues(lfFactors, factorGroups, factorsStates, contingencyIndex, resultWriter);
    }

    private static boolean runLoadFlow(AcLoadFlowContext context, boolean isRunningBaseSituation) {
        AcLoadFlowResult result = new AcloadFlowEngine(context).run();
        if (result.isSuccess() || result.getSolverStatus() == AcSolverStatus.NO_CALCULATION) {
            return true;
        }
        if (isRunningBaseSituation) {
            if (result.getOuterLoopResult().status() != OuterLoopStatus.STABLE) {
                throw new PowsyblException("Initial load flow of base situation ended with outer loop status " + result.getOuterLoopResult().statusText());
            }
            throw new PowsyblException("Initial load flow of base situation ended with solver status " + result.getSolverStatus());
        }
        LOGGER.warn("Load flow failed with result={}", (Object)result);
        return false;
    }

    @Override
    public void analyse(Network network, List<PropagatedContingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, ReportNode reportNode, LfTopoConfig topoConfig) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(contingencies);
        Objects.requireNonNull(factorReader);
        Objects.requireNonNull(resultWriter);
        Objects.requireNonNull(reportNode);
        LoadFlowParameters lfParameters = this.parameters.getLoadFlowParameters();
        OpenLoadFlowParameters lfParametersExt = OpenLoadFlowParameters.get(lfParameters);
        Pair<Boolean, Boolean> hasBusTargetVoltage = this.hasBusTargetVoltage(factorReader, network);
        boolean breakers = topoConfig.isBreaker();
        if (breakers && Boolean.TRUE.equals(hasBusTargetVoltage.getLeft())) {
            throw new PowsyblException("Switch contingency is not yet supported with sensitivity function of type BUS_VOLTAGE");
        }
        if (Boolean.TRUE.equals(hasBusTargetVoltage.getRight())) {
            lfParameters.setTransformerVoltageControlOn(true);
        }
        SlackBusSelector slackBusSelector = SlackBusSelector.fromMode(lfParametersExt.getSlackBusSelectionMode(), lfParametersExt.getSlackBusesIds(), lfParametersExt.getPlausibleActivePowerLimit(), lfParametersExt.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(), lfParametersExt.getSlackBusCountryFilter());
        if (lfParameters.isReadSlackBus()) {
            slackBusSelector = new NetworkSlackBusSelector(network, lfParametersExt.getSlackBusCountryFilter(), slackBusSelector);
        }
        LfNetworkParameters lfNetworkParameters = new LfNetworkParameters().setSlackBusSelector(slackBusSelector).setConnectivityFactory(this.connectivityFactory).setGeneratorVoltageRemoteControl(lfParametersExt.isVoltageRemoteControl()).setMinImpedance(true).setTwtSplitShuntAdmittance(lfParameters.isTwtSplitShuntAdmittance()).setBreakers(breakers).setPlausibleActivePowerLimit(lfParametersExt.getPlausibleActivePowerLimit()).setComputeMainConnectedComponentOnly(true).setCountriesToBalance(lfParameters.getCountriesToBalance()).setDistributedOnConformLoad(lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setPhaseControl(lfParameters.isPhaseShifterRegulationOn()).setTransformerVoltageControl(lfParameters.isTransformerVoltageControlOn()).setVoltagePerReactivePowerControl(lfParametersExt.isVoltagePerReactivePowerControl()).setGeneratorReactivePowerRemoteControl(lfParametersExt.isGeneratorReactivePowerRemoteControl()).setTransformerReactivePowerControl(lfParametersExt.isTransformerReactivePowerControl()).setLoadFlowModel(lfParameters.isDc() ? LoadFlowModel.DC : LoadFlowModel.AC).setShuntVoltageControl(lfParameters.isShuntCompensatorVoltageControlOn()).setReactiveLimits(lfParameters.isUseReactiveLimits()).setHvdcAcEmulation(lfParameters.isHvdcAcEmulation()).setMinPlausibleTargetVoltage(lfParametersExt.getMinPlausibleTargetVoltage()).setMaxPlausibleTargetVoltage(lfParametersExt.getMaxPlausibleTargetVoltage()).setMinNominalVoltageTargetVoltageCheck(lfParametersExt.getMinNominalVoltageTargetVoltageCheck()).setCacheEnabled(false).setSimulateAutomationSystems(false).setReferenceBusSelector(ReferenceBusSelector.DEFAULT_SELECTOR).setAreaInterchangeControlAreaType(lfParametersExt.getAreaInterchangeControlAreaType()).setForceTargetQInReactiveLimits(lfParametersExt.isForceTargetQInReactiveLimits()).setDisableInconsistentVoltageControls(lfParametersExt.isDisableInconsistentVoltageControls());
        try (LfNetworkList lfNetworks = Networks.load(network, lfNetworkParameters, topoConfig, reportNode);){
            LfNetwork lfNetwork = lfNetworks.getLargest().orElseThrow(() -> new PowsyblException("Empty network"));
            this.checkContingencies(contingencies);
            this.checkLoadFlowParameters(lfParameters);
            Map<String, SensitivityVariableSet> variableSetsById = variableSets.stream().collect(Collectors.toMap(SensitivityVariableSet::getId, Function.identity()));
            AbstractSensitivityAnalysis.SensitivityFactorHolder allFactorHolder = this.readAndCheckFactors(network, variableSetsById, factorReader, lfNetwork, breakers);
            List allLfFactors = allFactorHolder.getAllFactors();
            LOGGER.info("Running AC sensitivity analysis with {} factors and {} contingencies", (Object)allLfFactors.size(), (Object)contingencies.size());
            AbstractSensitivityAnalysis.SensitivityFactorHolder validFactorHolder = this.writeInvalidFactors(allFactorHolder, resultWriter, contingencies);
            List<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> validLfFactors = validFactorHolder.getAllFactors();
            AcLoadFlowParameters acParameters = OpenLoadFlowParameters.createAcParameters(network, lfParameters, lfParametersExt, this.matrixFactory, this.connectivityFactory, breakers, true);
            acParameters.setDetailedReport(lfParametersExt.getReportedFeatures().contains((Object)OpenLoadFlowParameters.ReportedFeatures.NEWTON_RAPHSON_SENSITIVITY_ANALYSIS));
            try (AcLoadFlowContext context = new AcLoadFlowContext(lfNetwork, acParameters);){
                Map<LfBus, Double> slackParticipationByBus;
                AcSensitivityAnalysis.runLoadFlow(context, true);
                AbstractSensitivityAnalysis.SensitivityFactorGroupList<AcVariableType, AcEquationType> factorGroups = this.createFactorGroups(validLfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID).collect(Collectors.toList()));
                if (lfParameters.isDistributedSlack()) {
                    List<ParticipatingElement> participatingElements = this.getParticipatingElements(lfNetwork.getBuses(), lfParameters.getBalanceType(), lfParametersExt);
                    slackParticipationByBus = participatingElements.stream().collect(Collectors.toMap(ParticipatingElement::getLfBus, element -> -element.getFactor(), Double::sum));
                } else {
                    slackParticipationByBus = Collections.singletonMap(lfNetwork.getSlackBus(), -1.0);
                }
                if (Boolean.TRUE.equals(hasBusTargetVoltage.getRight())) {
                    for (LfBranch branch : lfNetwork.getBranches()) {
                        branch.getVoltageControl().ifPresent(vc -> branch.setVoltageControlEnabled(true));
                    }
                    lfNetwork.fixTransformerVoltageControls();
                }
                DenseMatrix factorsStates = AcSensitivityAnalysis.initFactorsRhs(context.getEquationSystem(), factorGroups, slackParticipationByBus);
                context.getJacobianMatrix().solveTransposed(factorsStates);
                this.setFunctionReferences(validLfFactors);
                this.calculateSensitivityValues(validFactorHolder.getFactorsForBaseNetwork(), factorGroups, factorsStates, -1, resultWriter);
                NetworkState networkState = NetworkState.save(lfNetwork);
                ((AcLoadFlowParameters)context.getParameters()).setVoltageInitializer(new PreviousValueVoltageInitializer());
                contingencies.forEach(contingency -> {
                    LOGGER.info("Simulate contingency '{}'", (Object)contingency.getContingency().getId());
                    contingency.toLfContingency(lfNetwork).ifPresentOrElse(lfContingency -> {
                        Set<LfBus> slackConnectedComponent;
                        List<AbstractSensitivityAnalysis.LfSensitivityFactor<AcVariableType, AcEquationType>> contingencyFactors = validFactorHolder.getFactorsForContingency(lfContingency.getId());
                        contingencyFactors.forEach(lfFactor -> {
                            lfFactor.setSensitivityValuePredefinedResult(null);
                            lfFactor.setFunctionPredefinedResult(null);
                        });
                        lfContingency.apply(lfParameters.getBalanceType());
                        this.setPredefinedResults(contingencyFactors, lfContingency.getDisabledNetwork(), (PropagatedContingency)contingency);
                        boolean hasChanged = false;
                        if (lfContingency.getDisabledNetwork().getBuses().isEmpty()) {
                            LOGGER.debug("Contingency '{}' without loss of connectivity", (Object)lfContingency.getId());
                            slackConnectedComponent = new HashSet<LfBus>(lfNetwork.getBuses());
                        } else {
                            LOGGER.debug("Contingency '{}' with loss of connectivity", (Object)lfContingency.getId());
                            slackConnectedComponent = new HashSet<LfBus>(lfNetwork.getBuses()).stream().filter(Predicate.not(lfContingency.getDisabledNetwork().getBuses()::contains)).collect(Collectors.toSet());
                            hasChanged = this.rescaleGlsk(factorGroups, lfContingency.getDisabledNetwork().getBuses());
                        }
                        Map<LfBus, Double> postContingencySlackParticipationByBus = lfParameters.isDistributedSlack() ? this.getParticipatingElements(slackConnectedComponent, lfParameters.getBalanceType(), lfParametersExt).stream().collect(Collectors.toMap(ParticipatingElement::getLfBus, element -> -element.getFactor(), Double::sum)) : Collections.singletonMap(lfNetwork.getSlackBus(), -1.0);
                        this.calculatePostContingencySensitivityValues(contingencyFactors, (LfContingency)lfContingency, lfNetwork, context, factorGroups, postContingencySlackParticipationByBus, lfParameters, lfParametersExt, lfContingency.getIndex(), resultWriter, Boolean.TRUE.equals(hasBusTargetVoltage.getRight()));
                        if (hasChanged) {
                            this.rescaleGlsk(factorGroups, Collections.emptySet());
                        }
                        networkState.restore();
                    }, () -> {
                        AcSolverUtil.initStateVector(lfNetwork, context.getEquationSystem(), ((AcLoadFlowParameters)context.getParameters()).getVoltageInitializer());
                        this.calculateSensitivityValues(validFactorHolder.getFactorsForContingency(contingency.getContingency().getId()), factorGroups, factorsStates, contingency.getIndex(), resultWriter);
                        resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.NO_IMPACT);
                    });
                });
            }
        }
    }
}

