/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.dc.fastdc.AbstractComputedElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedContingencyElement;
import com.powsybl.openloadflow.dc.fastdc.ConnectivityBreakAnalysis;
import com.powsybl.openloadflow.dc.fastdc.WoodburyEngine;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.BusState;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.NetworkSlackBusSelector;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SlackBusSelector;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.sensi.AbstractSensitivityAnalysis;
import com.powsybl.openloadflow.util.Derivable;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import com.powsybl.sensitivity.SensitivityVariableType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DcSensitivityAnalysis
extends AbstractSensitivityAnalysis<DcVariableType, DcEquationType> {
    private static final double FUNCTION_REFERENCE_ZER0_THRESHOLD = 1.0E-13;

    public DcSensitivityAnalysis(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, SensitivityAnalysisParameters parameters) {
        super(matrixFactory, connectivityFactory, parameters);
    }

    private static DcLoadFlowParameters createDcLoadFlowParameters(LfNetworkParameters networkParameters, MatrixFactory matrixFactory, LoadFlowParameters lfParameters, OpenLoadFlowParameters parametersExt) {
        DcEquationSystemCreationParameters equationSystemCreationParameters = new DcEquationSystemCreationParameters().setUpdateFlows(true).setForcePhaseControlOffAndAddAngle1Var(true).setUseTransformerRatio(lfParameters.isDcUseTransformerRatio()).setDcApproximationType(parametersExt.getDcApproximationType());
        return ((DcLoadFlowParameters)((DcLoadFlowParameters)new DcLoadFlowParameters().setNetworkParameters(networkParameters)).setEquationSystemCreationParameters(equationSystemCreationParameters).setMatrixFactory(matrixFactory)).setDistributedSlack(lfParameters.isDistributedSlack()).setBalanceType(lfParameters.getBalanceType()).setSetVToNan(true).setMaxOuterLoopIterations(parametersExt.getMaxOuterLoopIterations());
    }

    private DenseMatrix calculateFlowStates(DcLoadFlowContext loadFlowContext, List<ParticipatingElement> participatingElements, DisabledNetwork disabledNetwork, ReportNode reportNode) {
        List<Object> busStates = Collections.emptyList();
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
        if (parameters.isDistributedSlack()) {
            busStates = ElementState.save(participatingElements.stream().map(ParticipatingElement::getLfBus).collect(Collectors.toSet()), BusState::save);
        }
        double[] dx = WoodburyEngine.runDcLoadFlowWithModifiedTargetVector(loadFlowContext, disabledNetwork, reportNode);
        if (parameters.isDistributedSlack()) {
            ElementState.restore(busStates);
        }
        return new DenseMatrix(dx.length, 1, dx);
    }

    private void createBranchSensitivityValue(AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType> factor, AbstractSensitivityAnalysis.SensitivityFactorGroup<DcVariableType, DcEquationType> factorGroup, DenseMatrix flowStates, DenseMatrix factorStates, PropagatedContingency contingency, SensitivityResultWriter resultWriter, DisabledNetwork disabledNetwork) {
        Pair<Optional<Double>, Optional<Double>> predefinedResults = this.getPredefinedResults(factor, disabledNetwork, contingency);
        Optional sensitivityValuePredefinedResult = (Optional)predefinedResults.getLeft();
        Optional functionPredefinedResults = (Optional)predefinedResults.getRight();
        double sensitivityValue = sensitivityValuePredefinedResult.orElse(0.0);
        double functionValue = functionPredefinedResults.orElse(0.0);
        Derivable<DcVariableType> p1 = factor.getFunctionEquationTerm();
        if (functionPredefinedResults.isEmpty()) {
            functionValue = p1.calculateSensi(flowStates, 0);
        }
        if (sensitivityValuePredefinedResult.isEmpty()) {
            sensitivityValue = p1.calculateSensi(factorStates, factorGroup.getIndex());
        }
        functionValue = DcSensitivityAnalysis.fixZeroFunctionReference(contingency, functionValue);
        double unscaledSensi = DcSensitivityAnalysis.unscaleSensitivity(factor, sensitivityValue);
        if (!DcSensitivityAnalysis.filterSensitivityValue(unscaledSensi, factor.getVariableType(), factor.getFunctionType(), this.parameters)) {
            resultWriter.writeSensitivityValue(factor.getIndex(), contingency != null ? contingency.getIndex() : -1, unscaledSensi, DcSensitivityAnalysis.unscaleFunction(factor, functionValue));
        }
    }

    private static double fixZeroFunctionReference(PropagatedContingency contingency, double functionValue) {
        if (contingency != null) {
            return Math.abs(functionValue) < 1.0E-13 ? 0.0 : functionValue;
        }
        return functionValue;
    }

    private DenseMatrix calculateFactorStates(DcLoadFlowContext loadFlowContext, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, List<ParticipatingElement> participatingElements) {
        Map<LfBus, Double> slackParticipationByBus = participatingElements.isEmpty() ? Map.of(loadFlowContext.getNetwork().getSlackBus(), -1.0) : participatingElements.stream().collect(Collectors.toMap(ParticipatingElement::getLfBus, element -> -element.getFactor(), Double::sum));
        DenseMatrix factorStates = DcSensitivityAnalysis.initFactorsRhs(loadFlowContext.getEquationSystem(), factorGroups, slackParticipationByBus);
        loadFlowContext.getJacobianMatrix().solveTransposed(factorStates);
        return factorStates;
    }

    private void calculateSensitivityValues(List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> lfFactors, DenseMatrix factorStates, DenseMatrix flowStates, PropagatedContingency contingency, SensitivityResultWriter resultWriter, DisabledNetwork disabledNetwork) {
        if (lfFactors.isEmpty()) {
            return;
        }
        lfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION).forEach(factor -> this.createBranchSensitivityValue((AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>)factor, null, flowStates, factorStates, contingency, resultWriter, disabledNetwork));
        Map factorsByGroup = lfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID).collect(Collectors.groupingBy(AbstractSensitivityAnalysis.LfSensitivityFactor::getGroup, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry e : factorsByGroup.entrySet()) {
            AbstractSensitivityAnalysis.SensitivityFactorGroup factorGroup = (AbstractSensitivityAnalysis.SensitivityFactorGroup)e.getKey();
            List factorsForThisGroup = (List)e.getValue();
            for (AbstractSensitivityAnalysis.LfSensitivityFactor factor2 : factorsForThisGroup) {
                this.createBranchSensitivityValue(factor2, factorGroup, flowStates, factorStates, contingency, resultWriter, disabledNetwork);
            }
        }
    }

    private void calculateSensitivityValuesForAContingency(DcLoadFlowContext loadFlowContext, OpenLoadFlowParameters lfParametersExt, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, DenseMatrix factorStates, DenseMatrix contingenciesStates, DenseMatrix flowStates, PropagatedContingency contingency, Map<String, ComputedContingencyElement> contingencyElementByBranch, Set<LfBus> disabledBuses, List<ParticipatingElement> participatingElements, Set<String> elementsToReconnect, SensitivityResultWriter resultWriter, ReportNode reportNode, Set<LfBranch> partialDisabledBranches, boolean rhsChangedAfterConnectivityBreak) {
        List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> factors = validFactorHolder.getFactorsForContingency(contingency.getContingency().getId());
        List<ComputedContingencyElement> contingencyElements = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).collect(Collectors.toList());
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        Set<LfBranch> disabledBranches = contingency.getBranchIdsToOpen().keySet().stream().map(lfNetwork::getBranchById).collect(Collectors.toSet());
        disabledBranches.addAll(partialDisabledBranches);
        DisabledNetwork disabledNetwork = new DisabledNetwork(disabledBuses, disabledBranches);
        DenseMatrix newFactorStates = factorStates;
        WoodburyEngine engine = new WoodburyEngine(((DcLoadFlowParameters)loadFlowContext.getParameters()).getEquationSystemCreationParameters(), contingencyElements, contingenciesStates);
        if (contingency.getGeneratorIdsToLose().isEmpty() && contingency.getLoadIdsToLose().isEmpty()) {
            DenseMatrix newFlowStates = flowStates;
            if (rhsChangedAfterConnectivityBreak) {
                newFactorStates = this.calculateFactorStates(loadFlowContext, factorGroups, participatingElements);
            }
            Set lostPhaseControllers = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).map(AbstractComputedElement::getLfBranch).filter(LfBranch::hasPhaseControllerCapability).collect(Collectors.toSet());
            if (!disabledBuses.isEmpty() || !lostPhaseControllers.isEmpty()) {
                newFlowStates = this.calculateFlowStates(loadFlowContext, participatingElements, disabledNetwork, reportNode);
            }
            engine.toPostContingencyStates(newFlowStates);
            engine.toPostContingencyStates(newFactorStates);
            this.calculateSensitivityValues(factors, newFactorStates, newFlowStates, contingency, resultWriter, disabledNetwork);
            if (contingency.hasNoImpact()) {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.NO_IMPACT);
            } else {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
            }
        } else {
            DcLoadFlowParameters lfParameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
            NetworkState networkState = NetworkState.save(lfNetwork);
            List<ParticipatingElement> newParticipatingElements = participatingElements;
            boolean participatingElementsChanged = false;
            boolean rhsChangedAfterGlskRescaling = false;
            LfContingency lfContingency = contingency.toLfContingency(lfNetwork).orElse(null);
            if (lfContingency != null) {
                lfContingency.apply(lfParameters.getBalanceType());
                if (DcSensitivityAnalysis.isDistributedSlackOnGenerators(lfParameters) && !contingency.getGeneratorIdsToLose().isEmpty()) {
                    Set<LfGenerator> participatingGeneratorsToRemove = lfContingency.getLostGenerators();
                    newParticipatingElements = participatingElements.stream().filter(participatingElement -> !participatingGeneratorsToRemove.contains(participatingElement.getElement())).map(participatingElement -> new ParticipatingElement(participatingElement.getElement(), participatingElement.getFactor())).collect(Collectors.toList());
                    ParticipatingElement.normalizeParticipationFactors(newParticipatingElements);
                    participatingElementsChanged = true;
                } else if (DcSensitivityAnalysis.isDistributedSlackOnLoads(lfParameters) && !contingency.getLoadIdsToLose().isEmpty()) {
                    newParticipatingElements = this.getParticipatingElements(lfNetwork.getBuses(), lfParameters.getBalanceType(), lfParametersExt);
                    participatingElementsChanged = true;
                }
                if (factorGroups.hasMultiVariables()) {
                    Set<LfBus> impactedBuses = lfContingency.getLoadAndGeneratorBuses();
                    rhsChangedAfterGlskRescaling = this.rescaleGlsk(factorGroups, impactedBuses);
                }
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
            } else {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.NO_IMPACT);
            }
            if (participatingElementsChanged || rhsChangedAfterGlskRescaling || rhsChangedAfterConnectivityBreak) {
                newFactorStates = this.calculateFactorStates(loadFlowContext, factorGroups, newParticipatingElements);
            }
            DenseMatrix newFlowStates = this.calculateFlowStates(loadFlowContext, newParticipatingElements, disabledNetwork, reportNode);
            engine.toPostContingencyStates(newFlowStates);
            engine.toPostContingencyStates(newFactorStates);
            this.calculateSensitivityValues(factors, newFactorStates, newFlowStates, contingency, resultWriter, disabledNetwork);
            networkState.restore();
        }
    }

    private void processContingenciesBreakingConnectivity(ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult, DcLoadFlowContext loadFlowContext, LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, List<ParticipatingElement> participatingElements, Map<String, ComputedContingencyElement> contingencyElementByBranch, DenseMatrix flowStates, DenseMatrix factorsStates, DenseMatrix contingenciesStates, SensitivityResultWriter resultWriter, ReportNode reportNode) {
        PropagatedContingency contingency = connectivityAnalysisResult.getPropagatedContingency();
        Set<LfBus> disabledBuses = connectivityAnalysisResult.getDisabledBuses();
        Set<LfBranch> partialDisabledBranches = connectivityAnalysisResult.getPartialDisabledBranches();
        for (LfHvdc hvdc : loadFlowContext.getNetwork().getHvdcs()) {
            if (!(Networks.isIsolatedBusForHvdc(hvdc.getBus1(), disabledBuses) ^ Networks.isIsolatedBusForHvdc(hvdc.getBus2(), disabledBuses))) continue;
            contingency.getGeneratorIdsToLose().add(hvdc.getConverterStation1().getId());
            contingency.getGeneratorIdsToLose().add(hvdc.getConverterStation2().getId());
        }
        List<ParticipatingElement> participatingElementsForThisConnectivity = participatingElements;
        boolean rhsChanged = false;
        if (lfParameters.isDistributedSlack()) {
            rhsChanged = participatingElements.stream().anyMatch(element -> disabledBuses.contains(element.getLfBus()));
        }
        if (factorGroups.hasMultiVariables()) {
            rhsChanged |= this.rescaleGlsk(factorGroups, disabledBuses);
        }
        if (rhsChanged) {
            participatingElementsForThisConnectivity = lfParameters.isDistributedSlack() ? this.getParticipatingElements(connectivityAnalysisResult.getSlackConnectedComponent(), lfParameters.getBalanceType(), lfParametersExt) : Collections.emptyList();
        }
        this.calculateSensitivityValuesForAContingency(loadFlowContext, lfParametersExt, validFactorHolder, factorGroups, factorsStates, contingenciesStates, flowStates, contingency, contingencyElementByBranch, disabledBuses, participatingElementsForThisConnectivity, connectivityAnalysisResult.getElementsToReconnect(), resultWriter, reportNode, partialDisabledBranches, rhsChanged);
    }

    @Override
    public void analyse(Network network, List<PropagatedContingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, ReportNode reportNode, LfTopoConfig topoConfig) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(contingencies);
        Objects.requireNonNull(variableSets);
        Objects.requireNonNull(factorReader);
        Objects.requireNonNull(resultWriter);
        LoadFlowParameters lfParameters = this.parameters.getLoadFlowParameters();
        OpenLoadFlowParameters lfParametersExt = OpenLoadFlowParameters.get(lfParameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean breakers = topoConfig.isBreaker();
        SlackBusSelector slackBusSelector = SlackBusSelector.fromMode(lfParametersExt.getSlackBusSelectionMode(), lfParametersExt.getSlackBusesIds(), lfParametersExt.getPlausibleActivePowerLimit(), lfParametersExt.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(), lfParametersExt.getSlackBusCountryFilter());
        if (lfParameters.isReadSlackBus()) {
            slackBusSelector = new NetworkSlackBusSelector(network, lfParametersExt.getSlackBusCountryFilter(), slackBusSelector);
        }
        LfNetworkParameters lfNetworkParameters = new LfNetworkParameters().setSlackBusSelector(slackBusSelector).setConnectivityFactory(this.connectivityFactory).setGeneratorVoltageRemoteControl(false).setMinImpedance(true).setTwtSplitShuntAdmittance(lfParameters.isTwtSplitShuntAdmittance()).setBreakers(breakers).setPlausibleActivePowerLimit(lfParametersExt.getPlausibleActivePowerLimit()).setComputeMainConnectedComponentOnly(true).setCountriesToBalance(lfParameters.getCountriesToBalance()).setDistributedOnConformLoad(lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setPhaseControl(false).setTransformerVoltageControl(false).setVoltagePerReactivePowerControl(false).setGeneratorReactivePowerRemoteControl(false).setTransformerReactivePowerControl(false).setLoadFlowModel(LoadFlowModel.DC).setShuntVoltageControl(false).setReactiveLimits(false).setHvdcAcEmulation(false).setCacheEnabled(false).setReferenceBusSelector(ReferenceBusSelector.DEFAULT_SELECTOR);
        try (LfNetworkList lfNetworks = Networks.load(network, lfNetworkParameters, topoConfig, reportNode);){
            LfNetwork lfNetwork = lfNetworks.getLargest().orElseThrow(() -> new PowsyblException("Empty network"));
            this.checkContingencies(contingencies);
            PropagatedContingency.cleanContingencies(lfNetwork, contingencies);
            this.checkLoadFlowParameters(lfParameters);
            Map<String, SensitivityVariableSet> variableSetsById = variableSets.stream().collect(Collectors.toMap(SensitivityVariableSet::getId, Function.identity()));
            AbstractSensitivityAnalysis.SensitivityFactorHolder allFactorHolder = this.readAndCheckFactors(network, variableSetsById, factorReader, lfNetwork, breakers);
            List allLfFactors = allFactorHolder.getAllFactors();
            allLfFactors.stream().filter(lfFactor -> lfFactor.getFunctionType() != SensitivityFunctionType.BRANCH_ACTIVE_POWER_1 && lfFactor.getFunctionType() != SensitivityFunctionType.BRANCH_ACTIVE_POWER_2 && lfFactor.getFunctionType() != SensitivityFunctionType.BRANCH_ACTIVE_POWER_3 || lfFactor.getVariableType() != SensitivityVariableType.INJECTION_ACTIVE_POWER && lfFactor.getVariableType() != SensitivityVariableType.TRANSFORMER_PHASE && lfFactor.getVariableType() != SensitivityVariableType.TRANSFORMER_PHASE_1 && lfFactor.getVariableType() != SensitivityVariableType.TRANSFORMER_PHASE_2 && lfFactor.getVariableType() != SensitivityVariableType.TRANSFORMER_PHASE_3 && lfFactor.getVariableType() != SensitivityVariableType.HVDC_LINE_ACTIVE_POWER).findFirst().ifPresent(ignored -> {
                throw new PowsyblException("Only variables of type TRANSFORMER_PHASE, TRANSFORMER_PHASE_1, TRANSFORMER_PHASE_2, TRANSFORMER_PHASE_3, INJECTION_ACTIVE_POWER and HVDC_LINE_ACTIVE_POWER, and functions of type BRANCH_ACTIVE_POWER_1, BRANCH_ACTIVE_POWER_2 and BRANCH_ACTIVE_POWER_3 are yet supported in DC");
            });
            LOGGER.info("Running DC sensitivity analysis with {} factors and {} contingencies", (Object)allLfFactors.size(), (Object)contingencies.size());
            DcLoadFlowParameters dcLoadFlowParameters = DcSensitivityAnalysis.createDcLoadFlowParameters(lfNetworkParameters, this.matrixFactory, lfParameters, lfParametersExt);
            AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder = this.writeInvalidFactors(allFactorHolder, resultWriter, contingencies);
            List validLfFactors = validFactorHolder.getAllFactors();
            LOGGER.info("{}/{} factors are valid", (Object)validLfFactors.size(), (Object)allLfFactors.size());
            try (DcLoadFlowContext loadFlowContext = new DcLoadFlowContext(lfNetwork, dcLoadFlowParameters, false);){
                VoltageInitializer voltageInitializer = lfParameters.getVoltageInitMode() == LoadFlowParameters.VoltageInitMode.PREVIOUS_VALUES ? new PreviousValueVoltageInitializer() : new UniformValueVoltageInitializer();
                DcLoadFlowEngine.initStateVector(lfNetwork, loadFlowContext.getEquationSystem(), voltageInitializer);
                AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups = this.createFactorGroups(validLfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID).collect(Collectors.toList()));
                List<ParticipatingElement> participatingElements = lfParameters.isDistributedSlack() ? this.getParticipatingElements(lfNetwork.getBuses(), lfParameters.getBalanceType(), lfParametersExt) : Collections.emptyList();
                DenseMatrix baseFlowStates = this.calculateFlowStates(loadFlowContext, participatingElements, new DisabledNetwork(), reportNode);
                DenseMatrix workingFlowStates = new DenseMatrix(baseFlowStates.getRowCount(), baseFlowStates.getColumnCount());
                DenseMatrix baseFactorStates = this.calculateFactorStates(loadFlowContext, factorGroups, participatingElements);
                DenseMatrix workingFactorStates = new DenseMatrix(baseFactorStates.getRowCount(), baseFactorStates.getColumnCount());
                this.calculateSensitivityValues(validFactorHolder.getFactorsForBaseNetwork(), baseFactorStates, baseFlowStates, null, resultWriter, new DisabledNetwork());
                ArrayList<PropagatedContingency> contingenciesWithFactors = new ArrayList<PropagatedContingency>();
                contingencies.forEach(contingency -> {
                    List lfFactors = validFactorHolder.getFactorsForContingencies(List.of(contingency.getContingency().getId()));
                    if (!lfFactors.isEmpty()) {
                        contingenciesWithFactors.add((PropagatedContingency)contingency);
                    } else {
                        resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
                    }
                });
                ConnectivityBreakAnalysis.ConnectivityBreakAnalysisResults connectivityBreakAnalysisResults = ConnectivityBreakAnalysis.run(loadFlowContext, contingenciesWithFactors);
                LOGGER.info("Processing contingencies with no connectivity break");
                for (PropagatedContingency contingency2 : connectivityBreakAnalysisResults.nonBreakingConnectivityContingencies()) {
                    workingFlowStates.copyValuesFrom(baseFlowStates);
                    workingFactorStates.copyValuesFrom(baseFactorStates);
                    this.calculateSensitivityValuesForAContingency(loadFlowContext, lfParametersExt, validFactorHolder, factorGroups, workingFactorStates, connectivityBreakAnalysisResults.contingenciesStates(), workingFlowStates, contingency2, connectivityBreakAnalysisResults.contingencyElementByBranch(), Collections.emptySet(), participatingElements, Collections.emptySet(), resultWriter, reportNode, Collections.emptySet(), false);
                }
                LOGGER.info("Processing contingencies with connectivity break");
                for (ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult : connectivityBreakAnalysisResults.connectivityAnalysisResults()) {
                    workingFlowStates.copyValuesFrom(baseFlowStates);
                    workingFactorStates.copyValuesFrom(baseFactorStates);
                    this.processContingenciesBreakingConnectivity(connectivityAnalysisResult, loadFlowContext, lfParameters, lfParametersExt, validFactorHolder, factorGroups, participatingElements, connectivityBreakAnalysisResults.contingencyElementByBranch(), workingFlowStates, workingFactorStates, connectivityBreakAnalysisResults.contingenciesStates(), resultWriter, reportNode);
                }
            }
            stopwatch.stop();
            LOGGER.info("DC sensitivity analysis done in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

