/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityVariableType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;

public class SensitivityFactoryJsonRecorder
implements SensitivityFactorReader {
    private final SensitivityFactorReader delegate;
    private final Path jsonFile;

    public SensitivityFactoryJsonRecorder(SensitivityFactorReader delegate, Path jsonFile) {
        this.delegate = Objects.requireNonNull(delegate);
        this.jsonFile = Objects.requireNonNull(jsonFile);
    }

    public void read(SensitivityFactorReader.Handler handler) {
        Objects.requireNonNull(handler);
        JsonUtil.writeJson((Path)this.jsonFile, jsonGenerator -> {
            try {
                jsonGenerator.writeStartArray();
                this.delegate.read((functionType, functionId, variableType, variableId, variableSet, contingencyContext) -> {
                    SensitivityFactor.writeJson((JsonGenerator)jsonGenerator, (SensitivityFunctionType)functionType, (String)functionId, (SensitivityVariableType)variableType, (String)variableId, (boolean)variableSet, (ContingencyContext)contingencyContext);
                    handler.onFactor(functionType, functionId, variableType, variableId, variableSet, contingencyContext);
                });
                jsonGenerator.writeEndArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

