/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Lists2 {
    private Lists2() {
    }

    public static <E> List<List<E>> partition(List<E> list, int partitionCount) {
        Objects.requireNonNull(list);
        if (partitionCount == 0) {
            throw new IllegalArgumentException("Partition count should be > 0");
        }
        ArrayList<List<List<E>>> partitions = new ArrayList<List<List<E>>>();
        int partitionSize = list.size() / partitionCount;
        int remainder = list.size() % partitionCount;
        int partitionStart = 0;
        for (int partition = 0; partition < partitionCount; ++partition) {
            int adjustedPartitionSize = partitionSize;
            if (partition < remainder) {
                ++adjustedPartitionSize;
            }
            partitions.add(list.subList(partitionStart, partitionStart + adjustedPartitionSize));
            partitionStart += adjustedPartitionSize;
        }
        return partitions;
    }
}

