/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.util;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeBuilder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.openloadflow.network.LfBus;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class Reports {
    public static final String NETWORK_NUM_CC = "networkNumCc";
    public static final String NETWORK_NUM_SC = "networkNumSc";
    private static final String ITERATION = "iteration";
    private static final String ITERATION_COUNT = "iterationCount";
    private static final String NETWORK_ID = "networkId";
    private static final String IMPACTED_GENERATOR_COUNT = "impactedGeneratorCount";
    private static final String IMPACTED_TRANSFORMER_COUNT = "impactedTransformerCount";
    private static final String IMPACTED_SHUNT_COUNT = "impactedShuntCount";
    private static final String BUS_ID = "busId";
    private static final String GENERATORS_ID = "generatorIds";
    private static final String CONTROLLER_BUS_ID = "controllerBusId";
    private static final String CONTROLLED_BUS_ID = "controlledBusId";
    private static final String ACTION_ID = "actionId";
    private static final String CONTINGENCY_ID = "contingencyId";
    public static final String MISMATCH = "mismatch";
    public static final String LF_NETWORK_KEY = "olf.lfNetwork";
    public static final String POST_CONTINGENCY_SIMULATION_KEY = "olf.postContingencySimulation";

    private Reports() {
    }

    public static void reportNetworkSize(ReportNode reportNode, int busCount, int branchCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.networkSize")).withUntypedValue("busCount", busCount)).withUntypedValue("branchCount", branchCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportNetworkBalance(ReportNode reportNode, double activeGeneration, double activeLoad, double reactiveGeneration, double reactiveLoad) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.networkBalance")).withUntypedValue("activeGeneration", activeGeneration)).withUntypedValue("activeLoad", activeLoad)).withUntypedValue("reactiveGeneration", reactiveGeneration)).withUntypedValue("reactiveLoad", reactiveLoad)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportNotUniqueControlledBusKeepingFirstControl(ReportNode reportNode, String generatorIds, String controllerBusId, String controlledBusId, String controlledBusGenId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.notUniqueControlledBusKeepingFirstControl")).withUntypedValue(GENERATORS_ID, generatorIds)).withUntypedValue(CONTROLLER_BUS_ID, controllerBusId)).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withUntypedValue("controlledBusGenId", controlledBusGenId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportNotUniqueControlledBusDisablingControl(ReportNode reportNode, String generatorIds, String controllerBusId, String controlledBusId, String controlledBusGenId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.notUniqueControlledBusDisablingControl")).withUntypedValue(GENERATORS_ID, generatorIds)).withUntypedValue(CONTROLLER_BUS_ID, controllerBusId)).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withUntypedValue("controlledBusGenId", controlledBusGenId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportNotUniqueTargetVControllerBusKeepingFirstControl(ReportNode reportNode, String generatorIds, String controllerBusId, Double keptTargetV, Double rejectedTargetV) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.notUniqueTargetVControllerBusKeepingFirstControl")).withUntypedValue(GENERATORS_ID, generatorIds)).withUntypedValue(CONTROLLER_BUS_ID, controllerBusId)).withUntypedValue("keptTargetV", keptTargetV.doubleValue())).withUntypedValue("rejectedTargetV", rejectedTargetV.doubleValue())).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportNotUniqueTargetVControllerBusDisablingControl(ReportNode reportNode, String generatorIds, String controllerBusId, Double targetV1, Double targetV2) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.notUniqueTargetVControllerBusDisablingControl")).withUntypedValue(GENERATORS_ID, generatorIds)).withUntypedValue(CONTROLLER_BUS_ID, controllerBusId)).withUntypedValue("targetV1", targetV1.doubleValue())).withUntypedValue("targetV2", targetV2.doubleValue())).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportControllerShuntAlreadyInVoltageControl(ReportNode reportNode, String controllerShuntId, String controlledBusId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.controllerShuntAlreadyInVoltageControl")).withUntypedValue("controllerShuntId", controllerShuntId)).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportBusAlreadyControlledWithDifferentTargetV(ReportNode reportNode, String controllerBusId, String controlledBusId, String busesId, Double keptTargetV, Double ignoredTargetV) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.busAlreadyControlledWithDifferentTargetV")).withUntypedValue(CONTROLLER_BUS_ID, controllerBusId)).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withUntypedValue("busesId", busesId)).withUntypedValue("keptTargetV", keptTargetV.doubleValue())).withUntypedValue("ignoredTargetV", ignoredTargetV.doubleValue())).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportBranchControlledAtBothSides(ReportNode reportNode, String controlledBranchId, String keptSide, String rejectedSide) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.branchControlledAtBothSides")).withUntypedValue("controlledBranchId", controlledBranchId)).withUntypedValue("keptSide", keptSide)).withUntypedValue("rejectedSide", rejectedSide)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportNetworkMustHaveAtLeastOneBusGeneratorVoltageControlEnabled(ReportNode reportNode) {
        ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.networkMustHaveAtLeastOneBusGeneratorVoltageControlEnabled")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportComponentsWithoutGenerators(ReportNode reportNode, int deadComponentsCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.componentsWithoutGenerators")).withUntypedValue("deadComponentsCount", deadComponentsCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportMismatchDistributionFailure(ReportNode reportNode, double remainingMismatch) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.mismatchDistributionFailure")).withTypedValue(MISMATCH, remainingMismatch, "Mismatch")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportResidualDistributionMismatch(ReportNode reportNode, double remainingMismatch) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.residualDistributionMismatch")).withTypedValue(MISMATCH, remainingMismatch, "Mismatch")).withSeverity(TypedValue.DEBUG_SEVERITY)).add();
    }

    public static void reportMismatchDistributionSuccess(ReportNode reportNode, double slackBusActivePowerMismatch, int iterationCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.mismatchDistributionSuccess")).withTypedValue("initialMismatch", slackBusActivePowerMismatch, "Mismatch")).withUntypedValue(ITERATION_COUNT, iterationCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportAreaNoInterchangeControl(ReportNode reportNode, String area, String reason) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.areaNoInterchangeControl")).withUntypedValue("area", area)).withUntypedValue("reason", reason)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static ReportNode reportAreaInterchangeControlDistributionFailure(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.areaInterchangeControlDistributionFailure")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportAreaInterchangeControlAreaMismatch(ReportNode reportNode, String area, double mismatch) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.areaInterchangeControlAreaMismatch")).withUntypedValue("area", area)).withTypedValue(MISMATCH, mismatch, "Mismatch")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportAreaInterchangeControlAreaDistributionSuccess(ReportNode reportNode, String area, double mismatch, int iterationCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.areaInterchangeControlAreaDistributionSuccess")).withUntypedValue("area", area)).withTypedValue(MISMATCH, mismatch, "Mismatch")).withUntypedValue(ITERATION_COUNT, iterationCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode reportPvToPqBuses(ReportNode reportNode, int pvToPqBusCount, int remainingPvBusCount) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.pvToPqBuses")).withUntypedValue("pvToPqBusCount", pvToPqBusCount)).withUntypedValue("remainingPvBusCount", remainingPvBusCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportPvToPqMaxQ(ReportNode reportNode, LfBus controllerBus, double busQ, double maxQ, boolean log, Logger logger) {
        ReportNode newNode = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.pvToPqMaxQ")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("busQ", busQ * 100.0, "REACTIVE_POWER")).withTypedValue("maxQ", maxQ * 100.0, "REACTIVE_POWER")).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        if (log) {
            logger.trace(newNode.getMessage());
        }
    }

    public static void reportPvToPqMinQ(ReportNode reportNode, LfBus controllerBus, double busQ, double minQ, boolean log, Logger logger) {
        ReportNode newNode = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.PvToPqMinQ")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("busQ", busQ * 100.0, "REACTIVE_POWER")).withTypedValue("minQ", minQ * 100.0, "REACTIVE_POWER")).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        if (log) {
            logger.trace(newNode.getMessage());
        }
    }

    public static void reportPvToPqMinRealisticV(ReportNode reportNode, LfBus controllerBus, double targetQ, double minRealisticV, boolean log, Logger logger) {
        ReportNode newNode = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.PvToPqMinRealisticV")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("targetQ", targetQ * 100.0, "REACTIVE_POWER")).withTypedValue("minRealisticV", minRealisticV * controllerBus.getNominalV(), "VOLTAGE")).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        if (log) {
            logger.trace(newNode.getMessage());
        }
    }

    public static void reportPvToPqMaxRealisticV(ReportNode reportNode, LfBus controllerBus, double targetQ, double maxRealisticV, boolean log, Logger logger) {
        ReportNode newNode = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.PvToPqMaxRealisticV")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("targetQ", targetQ * 100.0, "REACTIVE_POWER")).withTypedValue("maxRealisticV", maxRealisticV * controllerBus.getNominalV(), "VOLTAGE")).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        if (log) {
            logger.trace(newNode.getMessage());
        }
    }

    public static ReportNode reportPqToPvBuses(ReportNode reportNode, int pqToPvBusCount, int blockedPqBusCount) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.PqToPvBuses")).withUntypedValue("pqToPvBusCount", pqToPvBusCount)).withUntypedValue("blockedPqBusCount", blockedPqBusCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode createRootReportPvPqSwitchLimit(ReportNode firstRootReportNode, LfBus controllerBus, int limit, boolean log, Logger logger) {
        ReportNode result = ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withResourceBundles(new String[]{"com.powsybl.openloadflow.reports"})).withMessageTemplate("olf.pvPqSwitchLimit")).withUntypedValue(BUS_ID, controllerBus.getId())).withUntypedValue("limit", limit)).withSeverity(TypedValue.TRACE_SEVERITY)).build();
        if (log) {
            logger.trace(result.getMessage());
        }
        return result;
    }

    public static ReportNode createRootReportPqToPvBusMaxLimit(ReportNode firstRootReportNode, LfBus controllerBus, LfBus controlledBus, double targetV, boolean log, Logger logger) {
        ReportNode result = ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withResourceBundles(new String[]{"com.powsybl.openloadflow.reports"})).withMessageTemplate("olf.pqToPvBusMaxLimit")).withUntypedValue(BUS_ID, controllerBus.getId())).withUntypedValue("busV", controlledBus.getV() * controlledBus.getNominalV())).withUntypedValue("targetV", targetV * controlledBus.getNominalV())).withSeverity(TypedValue.TRACE_SEVERITY)).build();
        if (log) {
            logger.trace(result.getMessage());
        }
        return result;
    }

    public static ReportNode createRootReportPqToPvBusMinLimit(ReportNode firstRootReportNode, LfBus controllerBus, LfBus controlledBus, double targetV, boolean log, Logger logger) {
        ReportNode result = ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withResourceBundles(new String[]{"com.powsybl.openloadflow.reports"})).withMessageTemplate("olf.pqToPvBusMinLimit")).withUntypedValue(BUS_ID, controllerBus.getId())).withUntypedValue("busV", controlledBus.getV() * controlledBus.getNominalV())).withUntypedValue("targetV", targetV * controlledBus.getNominalV())).withSeverity(TypedValue.TRACE_SEVERITY)).build();
        if (log) {
            logger.trace(result.getMessage());
        }
        return result;
    }

    public static void reportBusForcedToBePv(ReportNode reportNode, String busId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.busForcedToBePv")).withUntypedValue(BUS_ID, busId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportBusesWithUpdatedQLimits(ReportNode reportNode, int numBusesWithUpdatedQLimits) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.busWithUpdatedQLimits")).withUntypedValue("numBusesWithUpdatedQLimits", numBusesWithUpdatedQLimits)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode reportReactiveControllerBusesToPqBuses(ReportNode reportNode, int remoteReactivePowerControllerBusToPqCount) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.reactiveControllerBusesToPqBuses")).withUntypedValue("remoteReactivePowerControllerBusToPqCount", remoteReactivePowerControllerBusToPqCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode createRootReportReactiveControllerBusesToPqMaxQ(ReportNode firstRootReportNode, LfBus controllerBus, double busQ, double maxQ, boolean log, Logger logger) {
        ReportNode result = ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withResourceBundles(new String[]{"com.powsybl.openloadflow.reports"})).withMessageTemplate("olf.reactiveControllerBusesToPqMaxQ")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("busQ", busQ * 100.0, "REACTIVE_POWER")).withTypedValue("maxQ", maxQ * 100.0, "REACTIVE_POWER")).withSeverity(TypedValue.TRACE_SEVERITY)).build();
        if (log) {
            logger.trace(result.getMessage());
        }
        return result;
    }

    public static ReportNode createRootReportReactiveControllerBusesToPqMinQ(ReportNode firstRootReportNode, LfBus controllerBus, double busQ, double minQ, boolean log, Logger logger) {
        ReportNode result = ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withResourceBundles(new String[]{"com.powsybl.openloadflow.reports"})).withMessageTemplate("olf.reactiveControllerBusesToPqMinQ")).withUntypedValue(BUS_ID, controllerBus.getId())).withTypedValue("busQ", busQ * 100.0, "REACTIVE_POWER")).withTypedValue("minQ", minQ * 100.0, "REACTIVE_POWER")).withSeverity(TypedValue.TRACE_SEVERITY)).build();
        if (log) {
            logger.trace(result.getMessage());
        }
        return result;
    }

    public static void reportStandByAutomatonActivation(ReportNode reportNode, String busId, double newTargetV) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.standByAutomatonActivation")).withUntypedValue(BUS_ID, busId)).withUntypedValue("newTargetV", newTargetV)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportCurrentLimiterPstsChangedTaps(ReportNode reportNode, int numOfCurrentLimiterPstsThatChangedTap) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.currentLimiterPstsChangedTaps")).withUntypedValue("numOfCurrentLimiterPstsThatChangedTap", numOfCurrentLimiterPstsThatChangedTap)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportActivePowerControlPstsChangedTaps(ReportNode reportNode, int numOfActivePowerControlPstsThatChangedTap) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.activePowerControlPstsChangedTaps")).withUntypedValue("numOfActivePowerControlPstsThatChangedTap", numOfActivePowerControlPstsThatChangedTap)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportTransformerControlAlreadyExistsWithDifferentTargetV(ReportNode reportNode, String firstControllerId, String newControllerId, String controlledBusId, double vcTargetValue, double targetValue) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlAlreadyExistsWithDifferentTargetV")).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withUntypedValue("firstControllerId", firstControllerId)).withUntypedValue("newControllerId", newControllerId)).withUntypedValue("vcTargetValue", vcTargetValue)).withUntypedValue("targetValue", targetValue)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportTransformerControlAlreadyExistsUpdateDeadband(ReportNode reportNode, String firstControllerId, String newControllerId, String controlledBusId, double newTargetDeadband, Double oldTargetDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlAlreadyExistsUpdateDeadband")).withUntypedValue(CONTROLLED_BUS_ID, controlledBusId)).withUntypedValue("firstControllerId", firstControllerId)).withUntypedValue("newControllerId", newControllerId)).withUntypedValue("newTargetDeadband", newTargetDeadband)).withUntypedValue("oldTargetDeadband", oldTargetDeadband == null ? "---" : oldTargetDeadband.toString())).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportTransformerControlBusesOutsideDeadband(ReportNode reportNode, int numTransformerControlBusesOutsideDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlBusesOutsideDeadband")).withUntypedValue("numTransformerControlBusesOutsideDeadband", numTransformerControlBusesOutsideDeadband)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportTransformerControlBranchesOutsideDeadband(ReportNode reportNode, int numTransformerControlBranchesOutsideDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlBranchesOutsideDeadband")).withUntypedValue("numTransformerControlBranchesOutsideDeadband", numTransformerControlBranchesOutsideDeadband)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportTransformerControlChangedTaps(ReportNode reportNode, int numTransformerControlAdjusted) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlChangedTaps")).withUntypedValue("numTransformerControlAdjusted", numTransformerControlAdjusted)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportTransformerControlTapLimit(ReportNode reportNode, int numTransformerControlTapLimit) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformerControlTapLimit")).withUntypedValue("numTransformerControlTapLimit", numTransformerControlTapLimit)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportShuntVoltageControlChangedSection(ReportNode reportNode, int numShuntVoltageControlAdjusted) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.shuntVoltageControlChangedSection")).withUntypedValue("numShuntVoltageControlAdjusted", numShuntVoltageControlAdjusted)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportUnsuccessfulOuterLoop(ReportNode reportNode, String outerLoopStatus) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.outerLoopStatus")).withUntypedValue("outerLoopStatus", outerLoopStatus)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportMaxOuterLoopIterations(ReportNode reportNode, int iterationCount, boolean withLog, Logger logger) {
        ReportNode added = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.maxOuterLoopIterations")).withUntypedValue("outerLoopIterationCount", iterationCount)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
        if (withLog) {
            logger.error(added.getMessage());
        }
    }

    public static void reportDcLfSolverFailure(ReportNode reportNode, String errorMessage) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.dcLfFailure")).withUntypedValue("errorMessage", errorMessage)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportDcLfComplete(ReportNode reportNode, boolean succeeded, String outerloopStatus) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.dcLfComplete")).withUntypedValue("succeeded", succeeded)).withUntypedValue("outerloopStatus", outerloopStatus)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseNotStarted(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseNotStarted")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseTargetVIsImplausible(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseTargetVIsImplausible")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseInconsistentControlledBus(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseInconsistentControlledBus")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportGeneratorsDiscardedFromVoltageControlBecauseInconsistentTargetVoltages(ReportNode reportNode, int impactedGeneratorCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.generatorsDiscardedFromVoltageControlBecauseInconsistentTargetVoltages")).withUntypedValue(IMPACTED_GENERATOR_COUNT, impactedGeneratorCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportTransformersDiscardedFromVoltageControlBecauseTargetVIsInconsistent(ReportNode reportNode, int impactedTransformerCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.transformersDiscardedFromVoltageControlBecauseTargetVIsInconsistent")).withUntypedValue(IMPACTED_TRANSFORMER_COUNT, impactedTransformerCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportShuntsDiscardedFromVoltageControlBecauseTargetVIsInconsistent(ReportNode reportNode, int impactedShuntCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.shuntsDiscardedFromVoltageControlBecauseTargetVIsInconsistent")).withUntypedValue(IMPACTED_SHUNT_COUNT, impactedShuntCount)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportAcLfComplete(ReportNode reportNode, boolean success, String solverStatus, String outerloopStatus) {
        TypedValue severity = success ? TypedValue.INFO_SEVERITY : TypedValue.ERROR_SEVERITY;
        String successText = success ? "successfully" : "with error";
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.acLfComplete")).withUntypedValue("successText", successText)).withUntypedValue("solverStatus", solverStatus)).withUntypedValue("outerloopStatus", outerloopStatus)).withSeverity(severity)).add();
    }

    public static ReportNode createLoadFlowReporter(ReportNode reportNode, String networkId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.loadFlow")).withUntypedValue(NETWORK_ID, networkId)).add();
    }

    public static ReportNode createRootLfNetworkReportNode(ReportNode firstRootReportNode, int networkNumCc, int networkNumSc) {
        return ((ReportNodeBuilder)((ReportNodeBuilder)((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReportNode.getTreeContext().getLocale()).withAllResourceBundlesFromClasspath().withMessageTemplate(LF_NETWORK_KEY)).withUntypedValue(NETWORK_NUM_CC, networkNumCc)).withUntypedValue(NETWORK_NUM_SC, networkNumSc)).build();
    }

    public static ReportNode includeLfNetworkReportNode(ReportNode reportNode, ReportNode lfNetworkReportNode) {
        reportNode.include(lfNetworkReportNode);
        return lfNetworkReportNode;
    }

    public static ReportNode createNetworkInfoReporter(ReportNode reportNode) {
        return ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.networkInfo")).add();
    }

    public static ReportNode createOuterLoopReporter(ReportNode reportNode, String outerLoopType) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.OuterLoop")).withUntypedValue("outerLoopType", outerLoopType)).add();
    }

    public static ReportNode createOuterLoopIterationReporter(ReportNode reportNode, int outerLoopIteration) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.OuterLoopIteration")).withUntypedValue("outerLoopIteration", outerLoopIteration)).add();
    }

    public static ReportNode createSensitivityAnalysis(ReportNode reportNode, String networkId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.sensitivityAnalysis")).withUntypedValue(NETWORK_ID, networkId)).add();
    }

    public static ReportNode createAcSecurityAnalysis(ReportNode reportNode, String networkId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.acSecurityAnalysis")).withUntypedValue(NETWORK_ID, networkId)).add();
    }

    public static ReportNode createDcSecurityAnalysis(ReportNode reportNode, String networkId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.dcSecurityAnalysis")).withUntypedValue(NETWORK_ID, networkId)).add();
    }

    public static ReportNode createWoodburyDcSecurityAnalysis(ReportNode reportNode, String networkId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.woodburyDcSecurityAnalysis")).withUntypedValue(NETWORK_ID, networkId)).add();
    }

    public static ReportNode createPreContingencySimulation(ReportNode reportNode) {
        return ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.preContingencySimulation")).add();
    }

    public static ReportNode createPostContingencySimulation(ReportNode reportNode, String contingencyId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate(POST_CONTINGENCY_SIMULATION_KEY)).withUntypedValue(CONTINGENCY_ID, contingencyId)).add();
    }

    public static ReportNode createOperatorStrategySimulation(ReportNode reportNode, String operatorStrategyId) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.operatorStrategySimulation")).withUntypedValue("operatorStrategyId", operatorStrategyId)).add();
    }

    public static ReportNode createDetailedSolverReporter(ReportNode reportNode, String solverName, int networkNumCc, int networkNumSc) {
        ReportNode subReportNode = Reports.createSolverReport(reportNode, solverName, networkNumCc, networkNumSc);
        ((ReportNodeAdder)((ReportNodeAdder)subReportNode.newReportNode().withMessageTemplate("olf.solverNoOuterLoops")).withSeverity(TypedValue.INFO_SEVERITY)).add();
        return subReportNode;
    }

    public static ReportNode createDetailedSolverReporterOuterLoop(ReportNode reportNode, String solverName, int networkNumCc, int networkNumSc, int outerLoopIteration, String outerLoopType) {
        ReportNode subReportNode = Reports.createSolverReport(reportNode, solverName, networkNumCc, networkNumSc);
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)subReportNode.newReportNode().withMessageTemplate("olf.solverOuterLoopCurrentType")).withUntypedValue("outerLoopIteration", outerLoopIteration)).withUntypedValue("outerLoopType", outerLoopType)).withSeverity(TypedValue.INFO_SEVERITY)).add();
        return subReportNode;
    }

    public static ReportNode createSolverReport(ReportNode reportNode, String solverName, int networkNumCc, int networkNumSc) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.solver")).withUntypedValue(NETWORK_NUM_CC, networkNumCc)).withUntypedValue(NETWORK_NUM_SC, networkNumSc)).withUntypedValue("solverName", solverName)).add();
    }

    public static ReportNode createNewtonRaphsonMismatchReporter(ReportNode reportNode, int iteration) {
        if (iteration == 0) {
            return ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.mismatchInitial")).add();
        }
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.mismatchIteration")).withUntypedValue(ITERATION, iteration)).add();
    }

    public static void reportNewtonRaphsonError(ReportNode reportNode, String error) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.NRError")).withUntypedValue("error", error)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void reportNewtonRaphsonNorm(ReportNode reportNode, double norm) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.NRNorm")).withUntypedValue("norm", norm)).withSeverity(TypedValue.TRACE_SEVERITY)).add();
    }

    public static void reportNewtonRaphsonLargestMismatches(ReportNode reportNode, String acEquationType, BusReport busReport) {
        String mismatchUnit;
        ReportNode subReportNode = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.NRMismatch")).withUntypedValue("equationType", acEquationType)).withTypedValue(MISMATCH, (switch (acEquationType) {
            case "P" -> {
                mismatchUnit = "MW";
                yield 100.0;
            }
            case "Q" -> {
                mismatchUnit = "MVar";
                yield 100.0;
            }
            default -> {
                mismatchUnit = "p.u.";
                yield 1.0;
            }
        }) * busReport.mismatch(), "Mismatch")).withUntypedValue("mismatchUnit", mismatchUnit)).add();
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)subReportNode.newReportNode().withMessageTemplate("olf.NRMismatchBusInfo")).withUntypedValue(BUS_ID, busReport.busId())).withUntypedValue("busNominalV", busReport.nominalV())).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)subReportNode.newReportNode().withMessageTemplate("olf.NRMismatchBusV")).withUntypedValue("busV", busReport.v())).withUntypedValue("busPhi", busReport.phi())).withSeverity(TypedValue.TRACE_SEVERITY)).add();
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)subReportNode.newReportNode().withMessageTemplate("olf.NRMismatchBusInjection")).withUntypedValue("busP", busReport.p())).withUntypedValue("busQ", busReport.q())).withSeverity(TypedValue.TRACE_SEVERITY)).add();
    }

    public static void reportLineSearchStateVectorScaling(ReportNode reportNode, double stepSize) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.lineSearchStateVectorScaling")).withUntypedValue("stepSize", stepSize)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportMaxVoltageChangeStateVectorScaling(ReportNode reportNode, double stepSize, int vCutCount, int phiCutCount) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.maxVoltageChangeStateVectorScaling")).withUntypedValue("stepSize", stepSize)).withUntypedValue("vCutCount", vCutCount)).withUntypedValue("phiCutCount", phiCutCount)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportNewtonRaphsonBusesOutOfRealisticVoltageRange(ReportNode reportNode, Map<String, Double> busesOutOfRealisticVoltageRange, double minRealisticVoltage, double maxRealisticVoltage) {
        ReportNode voltageOutOfRangeReport = ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.newtonRaphsonBusesOutOfRealisticVoltageRange")).withUntypedValue("busCountOutOfRealisticVoltageRange", busesOutOfRealisticVoltageRange.size())).withUntypedValue("minRealisticVoltage", minRealisticVoltage)).withUntypedValue("maxRealisticVoltage", maxRealisticVoltage)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
        busesOutOfRealisticVoltageRange.forEach((id, voltage) -> ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)voltageOutOfRangeReport.newReportNode().withMessageTemplate("olf.newtonRaphsonBusesOutOfRealisticVoltageRangeDetails")).withUntypedValue(BUS_ID, id)).withUntypedValue("voltage", voltage.doubleValue())).withSeverity(TypedValue.TRACE_SEVERITY)).add());
    }

    public static void reportAngleReferenceBusAndSlackBuses(ReportNode reportNode, String referenceBus, List<String> slackBuses) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.angleReferenceBusSelection")).withUntypedValue("referenceBus", referenceBus)).withSeverity(TypedValue.INFO_SEVERITY)).add();
        slackBuses.forEach(slackBus -> ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.slackBusSelection")).withUntypedValue("slackBus", slackBus)).withSeverity(TypedValue.INFO_SEVERITY)).add());
    }

    public static void reportAcEmulationDisabledInWoodburyDcSecurityAnalysis(ReportNode reportNode) {
        ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.acEmulationDisabledInWoodburyDcSecurityAnalysis")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void reportContingencyActivePowerLossDistribution(ReportNode reportNode, double mismatch, double remaining) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("olf.contingencyActivePowerLossDistribution")).withUntypedValue(MISMATCH, mismatch)).withUntypedValue("distributed", mismatch - remaining)).withUntypedValue("remaining", remaining)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void reportActionApplicationFailure(String actionId, String contingencyId, ReportNode node) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)node.newReportNode().withMessageTemplate("olf.LfActionUtils")).withUntypedValue(ACTION_ID, actionId)).withUntypedValue(CONTINGENCY_ID, contingencyId)).add();
    }

    public static ReportNode createRootThreadReport(ReportNode firstRootReport) {
        return ((ReportNodeBuilder)ReportNode.newRootReportNode().withLocale(firstRootReport.getTreeContext().getLocale()).withAllResourceBundlesFromClasspath().withMessageTemplate("olf.threadRoot")).build();
    }

    public record BusReport(String busId, double mismatch, double nominalV, double v, double phi, double p, double q) {
    }
}

