/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseBus;
import java.util.Objects;

class SubstationConverter
extends AbstractConverter {
    private final PsseBus psseBus;

    SubstationConverter(PsseBus psseBus, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
    }

    Substation create() {
        String voltageLevelId = this.getContainersMapping().getVoltageLevelId(this.psseBus.getI());
        String substationId = this.getContainersMapping().getSubstationId(voltageLevelId);
        Substation substation = this.getNetwork().getSubstation(substationId);
        if (substation == null) {
            substation = ((SubstationAdder)this.getNetwork().newSubstation().setId(substationId)).add();
        }
        return substation;
    }
}

