/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorConverter
extends AbstractConverter {
    private final PsseGenerator psseGenerator;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorConverter.class);

    GeneratorConverter(PsseGenerator psseGenerator, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseGenerator = Objects.requireNonNull(psseGenerator);
    }

    void create() {
        String busId = GeneratorConverter.getBusId(this.psseGenerator.getI());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseGenerator.getI()));
        GeneratorAdder adder = ((GeneratorAdder)((GeneratorAdder)voltageLevel.newGenerator().setId(GeneratorConverter.getGeneratorId(busId, this.psseGenerator))).setConnectableBus(busId)).setTargetP(this.psseGenerator.getPg()).setMaxP(this.psseGenerator.getPt()).setMinP(this.psseGenerator.getPb()).setTargetQ(this.psseGenerator.getQg()).setVoltageRegulatorOn(false);
        adder.setBus(this.psseGenerator.getStat() == 1 ? busId : null);
        Generator generator = adder.add();
        generator.newMinMaxReactiveLimits().setMinQ(this.psseGenerator.getQb()).setMaxQ(this.psseGenerator.getQt()).add();
        if (this.psseGenerator.getRt() != 0.0 || this.psseGenerator.getXt() != 0.0) {
            LOGGER.warn("Implicit method where a transformer is specified with the generator is not supported ({})", (Object)generator.getId());
        }
    }

    void addControl(PsseBus psseBus) {
        String busId = GeneratorConverter.getBusId(this.psseGenerator.getI());
        Generator generator = this.getNetwork().getGenerator(GeneratorConverter.getGeneratorId(busId, this.psseGenerator));
        if (generator == null) {
            return;
        }
        Terminal regulatingTerminal = GeneratorConverter.defineRegulatingTerminal(this.psseGenerator, this.getNetwork());
        if (regulatingTerminal == null) {
            return;
        }
        boolean psseVoltageRegulatorOn = GeneratorConverter.defineVoltageRegulatorOn(psseBus);
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double targetV = this.psseGenerator.getVs() * vnom;
        boolean voltageRegulatorOn = false;
        if (targetV > 0.0 && this.psseGenerator.getQb() < this.psseGenerator.getQt()) {
            voltageRegulatorOn = psseVoltageRegulatorOn;
        }
        generator.setTargetV(targetV).setRegulatingTerminal(regulatingTerminal).setVoltageRegulatorOn(voltageRegulatorOn);
    }

    private static boolean defineVoltageRegulatorOn(PsseBus psseBus) {
        return psseBus.getIde() == 2 || psseBus.getIde() == 3;
    }

    private static Terminal defineRegulatingTerminal(PsseGenerator psseGenerator, Network network) {
        String defaultRegulatingBusId = GeneratorConverter.getBusId(psseGenerator.getI());
        Terminal regulatingTerminal = null;
        if (psseGenerator.getIreg() == 0) {
            Bus bus = network.getBusBreakerView().getBus(defaultRegulatingBusId);
            regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
        } else {
            String regulatingBusId = GeneratorConverter.getBusId(psseGenerator.getIreg());
            Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
            if (bus != null) {
                regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
            }
        }
        if (regulatingTerminal == null) {
            String generatorId = GeneratorConverter.getGeneratorId(defaultRegulatingBusId, psseGenerator);
            LOGGER.warn("Generator {}. Regulating terminal is not assigned as the bus is isolated", (Object)generatorId);
        }
        return regulatingTerminal;
    }

    private static String getGeneratorId(String busId, PsseGenerator psseGenerator) {
        return GeneratorConverter.getGeneratorId(busId, psseGenerator.getId());
    }

    private static String getGeneratorId(String busId, String generatorId) {
        return busId + "-G" + generatorId;
    }

    static void updateGenerators(Network network, PssePowerFlowModel psseModel, PssePowerFlowModel updatePsseModel) {
        psseModel.getGenerators().forEach(psseGen -> {
            updatePsseModel.addGenerators(Collections.singletonList(psseGen));
            PsseGenerator updatePsseGen = (PsseGenerator)updatePsseModel.getGenerators().get(updatePsseModel.getGenerators().size() - 1);
            String genId = GeneratorConverter.getGeneratorId(GeneratorConverter.getBusId(updatePsseGen.getI()), updatePsseGen.getId());
            Generator gen = network.getGenerator(genId);
            if (gen == null) {
                updatePsseGen.setStat(0);
            } else {
                updatePsseGen.setStat(GeneratorConverter.getStatus(gen));
                updatePsseGen.setPg(GeneratorConverter.getP(gen));
                updatePsseGen.setQg(GeneratorConverter.getQ(gen));
            }
        });
    }

    private static int getStatus(Generator gen) {
        if (gen.getTerminal().isConnected()) {
            return 1;
        }
        return 0;
    }

    private static double getP(Generator gen) {
        if (Double.isNaN(gen.getTerminal().getP())) {
            return gen.getTargetP();
        }
        return -gen.getTerminal().getP();
    }

    private static double getQ(Generator gen) {
        if (Double.isNaN(gen.getTerminal().getQ())) {
            return gen.getTargetQ();
        }
        return -gen.getTerminal().getQ();
    }
}

