/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LineConverter
extends AbstractConverter {
    private final PsseNonTransformerBranch psseLine;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final PsseVersion version;
    private static final Logger LOGGER = LoggerFactory.getLogger(LineConverter.class);

    LineConverter(PsseNonTransformerBranch psseLine, ContainersMapping containerMapping, PsseImporter.PerUnitContext perUnitContext, Network network, PsseVersion version) {
        super(containerMapping, network);
        this.psseLine = Objects.requireNonNull(psseLine);
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.version = Objects.requireNonNull(version);
    }

    void create() {
        String id = this.getLineId();
        String bus1Id = LineConverter.getBusId(this.psseLine.getI());
        String bus2Id = LineConverter.getBusId(this.psseLine.getJ());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseLine.getI());
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseLine.getJ());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double rEu = LineConverter.impedanceToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(this.psseLine.getR(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        double xEu = LineConverter.impedanceToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(this.psseLine.getX(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        Complex yEu = new Complex(rEu, xEu).reciprocal();
        double g1Eu = LineConverter.admittanceEnd1ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getReal(), this.psseLine.getGi(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        double b1Eu = LineConverter.admittanceEnd1ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getImaginary(), this.psseLine.getB() * 0.5 + this.psseLine.getBi(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        double g2Eu = LineConverter.admittanceEnd2ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getReal(), this.psseLine.getGj(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        double b2Eu = LineConverter.admittanceEnd2ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getImaginary(), this.psseLine.getB() * 0.5 + this.psseLine.getBj(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        LineAdder adder = ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)this.getNetwork().newLine().setId(id)).setEnsureIdUnicity(true)).setConnectableBus1(bus1Id)).setVoltageLevel1(voltageLevel1Id)).setConnectableBus2(bus2Id)).setVoltageLevel2(voltageLevel2Id)).setR(rEu).setX(xEu).setG1(g1Eu).setB1(b1Eu).setG2(g2Eu).setB2(b2Eu);
        adder.setBus1(this.psseLine.getSt() == 1 ? bus1Id : null);
        adder.setBus2(this.psseLine.getSt() == 1 ? bus2Id : null);
        Line line = adder.add();
        this.defineOperationalLimits(line, voltageLevel1.getNominalV(), voltageLevel2.getNominalV());
        if (this.psseLine.getGi() != 0.0 || this.psseLine.getGj() != 0.0) {
            LOGGER.warn("Branch G not supported ({})", (Object)this.psseLine.getI());
        }
    }

    private void defineOperationalLimits(Line line, double vnom1, double vnom2) {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseLine.getRates().getRate1() : this.psseLine.getRates().getRatea();
        double currentLimit1 = rateMva / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva / (Math.sqrt(3.0) * vnom2);
        if (currentLimit1 > 0.0) {
            CurrentLimitsAdder currentLimitFrom = line.newCurrentLimits1();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            CurrentLimitsAdder currentLimitTo = line.newCurrentLimits2();
            currentLimitTo.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitTo.add();
        }
    }

    private String getLineId() {
        return LineConverter.getLineId(this.psseLine);
    }

    private static String getLineId(PsseNonTransformerBranch psseLine) {
        return "L-" + psseLine.getI() + "-" + psseLine.getJ() + "-" + psseLine.getCkt();
    }

    static void updateLines(Network network, PssePowerFlowModel psseModel, PssePowerFlowModel updatePsseModel) {
        psseModel.getNonTransformerBranches().forEach(psseLine -> {
            updatePsseModel.addNonTransformerBranches(Collections.singletonList(psseLine));
            PsseNonTransformerBranch updatePsseLine = (PsseNonTransformerBranch)updatePsseModel.getNonTransformerBranches().get(updatePsseModel.getNonTransformerBranches().size() - 1);
            String lineId = LineConverter.getLineId(updatePsseLine);
            Line line = network.getLine(lineId);
            if (line == null) {
                updatePsseLine.setSt(0);
            } else {
                updatePsseLine.setSt(LineConverter.getStatus(line));
            }
        });
    }

    private static int getStatus(Line line) {
        if (line.getTerminal1().isConnected() && line.getTerminal2().isConnected()) {
            return 1;
        }
        return 0;
    }
}

