/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcConverter;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import java.util.Objects;

class TwoTerminalDcConverter
extends AbstractConverter {
    private static final double DEFAULT_MAXP_FACTOR = 1.2;
    private final PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc;

    TwoTerminalDcConverter(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseTwoTerminalDc = Objects.requireNonNull(psseTwoTerminalDc);
    }

    void create() {
        double lossFactor = 0.0;
        String busIdR = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getRectifier().getIp());
        VoltageLevel voltageLevelR = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getRectifier().getIp()));
        LccConverterStationAdder adderR = (LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelR.newLccConverterStation().setId(this.getLccConverterId(this.psseTwoTerminalDc, this.psseTwoTerminalDc.getRectifier()))).setName(this.psseTwoTerminalDc.getName())).setConnectableBus(busIdR)).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getRectifier())).setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdR);
        LccConverterStation cR = adderR.add();
        String busIdI = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getInverter().getIp());
        VoltageLevel voltageLevelI = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getInverter().getIp()));
        LccConverterStationAdder adderI = (LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelI.newLccConverterStation().setId(this.getLccConverterId(this.psseTwoTerminalDc, this.psseTwoTerminalDc.getInverter()))).setName(this.psseTwoTerminalDc.getName())).setConnectableBus(busIdI)).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getInverter())).setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdI);
        LccConverterStation cI = adderI.add();
        HvdcLineAdder adder = ((HvdcLineAdder)((HvdcLineAdder)this.getNetwork().newHvdcLine().setId(this.getTwoTerminalDcId(this.psseTwoTerminalDc))).setName(this.psseTwoTerminalDc.getName())).setR(this.psseTwoTerminalDc.getRdc()).setNominalV(this.psseTwoTerminalDc.getVschd()).setActivePowerSetpoint(TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(this.psseTwoTerminalDc)).setMaxP(TwoTerminalDcConverter.getTwoTerminalDcMaxP(this.psseTwoTerminalDc)).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setConverterStationId1(cR.getId()).setConverterStationId2(cI.getId());
        adder.add();
    }

    private static double getTwoTerminalDcActivePowerSetpoint(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        switch (psseTwoTerminalDc.getMdc()) {
            case 1: {
                return Math.abs(psseTwoTerminalDc.getSetvl());
            }
            case 2: {
                return psseTwoTerminalDc.getSetvl() * psseTwoTerminalDc.getVschd() / 1000.0;
            }
        }
        return 0.0;
    }

    private static double getTwoTerminalDcMaxP(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(psseTwoTerminalDc) * 1.2;
    }

    private static double getLccConverterPowerFactor(PsseTwoTerminalDcConverter converter) {
        return 0.5 * (Math.cos(Math.toRadians(converter.getAnmx())) + Math.cos(Math.toRadians(60.0)));
    }

    private String getLccConverterId(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc, PsseTwoTerminalDcConverter converter) {
        return Identifiables.getUniqueId((String)("LccConverter-" + psseTwoTerminalDc.getRectifier().getIp() + "-" + psseTwoTerminalDc.getInverter().getIp() + "-" + converter.getIp()), id -> this.getNetwork().getLccConverterStation(id) != null);
    }

    private String getTwoTerminalDcId(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return Identifiables.getUniqueId((String)("TwoTerminalDc-" + psseTwoTerminalDc.getRectifier().getIp() + "-" + psseTwoTerminalDc.getInverter().getIp()), id -> this.getNetwork().getHvdcLine(id) != null);
    }
}

