/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Network;
import com.powsybl.psse.converter.BusConverter;
import com.powsybl.psse.converter.FixedShuntCompensatorConverter;
import com.powsybl.psse.converter.GeneratorConverter;
import com.powsybl.psse.converter.LineConverter;
import com.powsybl.psse.converter.LoadConverter;
import com.powsybl.psse.converter.SwitchedShuntCompensatorConverter;
import com.powsybl.psse.converter.TransformerConverter;
import com.powsybl.psse.converter.extensions.PsseConversionContextExtension;
import com.powsybl.psse.converter.extensions.PsseModelExtension;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.io.PowerFlowRawData32;
import com.powsybl.psse.model.pf.io.PowerFlowRawData33;
import com.powsybl.psse.model.pf.io.PowerFlowRawData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawxData35;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

@AutoService(value={Exporter.class})
public class PsseExporter
implements Exporter {
    private static final String FORMAT = "PSS/E";
    private static final List<Parameter> STATIC_PARAMETERS = ImmutableList.of();

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(STATIC_PARAMETERS);
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getComment() {
        return "Update IIDM to PSS/E ";
    }

    public void export(Network network, Properties parameters, DataSource dataSource) {
        PssePowerFlowModel psseModel = ((PsseModelExtension)network.getExtension(PsseModelExtension.class)).getPsseModel();
        PssePowerFlowModel updatePsseModel = PsseExporter.createUpdatePsseModel(network, psseModel);
        Context context = ((PsseConversionContextExtension)network.getExtension(PsseConversionContextExtension.class)).getContext();
        if (context.getFileFormat() == FileFormat.JSON) {
            PsseVersion version = PsseVersion.fromRevision((float)updatePsseModel.getCaseIdentification().getRev());
            switch (version.major()) {
                case V35: {
                    PowerFlowRawxData35 rawXData35 = new PowerFlowRawxData35();
                    try {
                        rawXData35.write(updatePsseModel, context, dataSource);
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                default: {
                    throw new PsseException("Unsupported version " + version);
                }
            }
        } else {
            PsseVersion version = PsseVersion.fromRevision((float)updatePsseModel.getCaseIdentification().getRev());
            switch (version.major()) {
                case V35: {
                    PowerFlowRawData35 rawData35 = new PowerFlowRawData35();
                    try {
                        rawData35.write(updatePsseModel, context, dataSource);
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case V33: {
                    PowerFlowRawData33 rawData33 = new PowerFlowRawData33();
                    try {
                        rawData33.write(updatePsseModel, context, dataSource);
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case V32: {
                    PowerFlowRawData32 rawData32 = new PowerFlowRawData32();
                    try {
                        rawData32.write(updatePsseModel, context, dataSource);
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                default: {
                    throw new PsseException("Unsupported version " + version);
                }
            }
        }
    }

    private static PssePowerFlowModel createUpdatePsseModel(Network network, PssePowerFlowModel psseModel) {
        PssePowerFlowModel updatePsseModel = new PssePowerFlowModel(psseModel.getCaseIdentification());
        PsseExporter.copyPermanentBlocks(psseModel, updatePsseModel);
        PsseExporter.updateModifiedBlocks(network, psseModel, updatePsseModel);
        return updatePsseModel;
    }

    private static void copyPermanentBlocks(PssePowerFlowModel psseModel, PssePowerFlowModel updatePsseModel) {
        updatePsseModel.addAreas(psseModel.getAreas());
        updatePsseModel.addTwoTerminalDcTransmissionLines(psseModel.getTwoTerminalDcTransmissionLines());
        updatePsseModel.addVoltageSourceConverterDcTransmissionLines(psseModel.getVoltageSourceConverterDcTransmissionLines());
        updatePsseModel.addTransformerImpedanceCorrections(psseModel.getTransformerImpedanceCorrections());
        updatePsseModel.addMultiTerminalDcTransmissionLines(psseModel.getMultiTerminalDcTransmissionLines());
        updatePsseModel.addLineGrouping(psseModel.getLineGrouping());
        updatePsseModel.addZones(psseModel.getZones());
        updatePsseModel.addInterareaTransfer(psseModel.getInterareaTransfer());
        updatePsseModel.addOwners(psseModel.getOwners());
        updatePsseModel.addFacts(psseModel.getFacts());
        updatePsseModel.addGneDevice(psseModel.getGneDevice());
        updatePsseModel.addInductionMachines(psseModel.getInductionMachines());
    }

    private static void updateModifiedBlocks(Network network, PssePowerFlowModel psseModel, PssePowerFlowModel updatePsseModel) {
        BusConverter.updateBuses(network, psseModel, updatePsseModel);
        LoadConverter.updateLoads(network, psseModel, updatePsseModel);
        FixedShuntCompensatorConverter.updateFixedShunts(network, psseModel, updatePsseModel);
        GeneratorConverter.updateGenerators(network, psseModel, updatePsseModel);
        LineConverter.updateLines(network, psseModel, updatePsseModel);
        TransformerConverter.updateTransformers(network, psseModel, updatePsseModel);
        SwitchedShuntCompensatorConverter.updateSwitchedShunts(network, psseModel, updatePsseModel);
    }
}

