/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FixedShuntCompensatorConverter
extends AbstractConverter {
    private final PsseFixedShunt psseFixedShunt;
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedShuntCompensatorConverter.class);

    FixedShuntCompensatorConverter(PsseFixedShunt psseFixedShunt, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseFixedShunt = Objects.requireNonNull(psseFixedShunt);
    }

    void create() {
        if (this.psseFixedShunt.getGl() == 0.0 && this.psseFixedShunt.getBl() == 0.0) {
            LOGGER.warn("Shunt ({}) has Gl and Bl = 0, not imported ", (Object)this.psseFixedShunt.getI());
            return;
        }
        String busId = FixedShuntCompensatorConverter.getBusId(this.psseFixedShunt.getI());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseFixedShunt.getI()));
        ShuntCompensatorAdder adder = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)voltageLevel.newShuntCompensator().setId(this.getShuntId(busId))).setConnectableBus(busId)).setVoltageRegulatorOn(false).setSectionCount(1);
        adder.newLinearModel().setGPerSection(FixedShuntCompensatorConverter.powerToShuntAdmittance(this.psseFixedShunt.getGl(), voltageLevel.getNominalV())).setBPerSection(FixedShuntCompensatorConverter.powerToShuntAdmittance(this.psseFixedShunt.getBl(), voltageLevel.getNominalV())).setMaximumSectionCount(1).add();
        adder.setBus(this.psseFixedShunt.getStatus() == 1 ? busId : null);
        adder.add();
    }

    private String getShuntId(String busId) {
        return FixedShuntCompensatorConverter.getShuntId(busId, this.psseFixedShunt.getId());
    }

    private static String getShuntId(String busId, String fixedShuntId) {
        return busId + "-SH" + fixedShuntId;
    }

    static void updateFixedShunts(Network network, PssePowerFlowModel psseModel) {
        psseModel.getFixedShunts().forEach(psseFixedShunt -> {
            String fixedShuntId = FixedShuntCompensatorConverter.getShuntId(FixedShuntCompensatorConverter.getBusId(psseFixedShunt.getI()), psseFixedShunt.getId());
            ShuntCompensator fixedShunt = network.getShuntCompensator(fixedShuntId);
            if (fixedShunt == null) {
                psseFixedShunt.setStatus(0);
            } else {
                psseFixedShunt.setStatus(FixedShuntCompensatorConverter.getStatus(fixedShunt));
                psseFixedShunt.setBl(FixedShuntCompensatorConverter.getQ(fixedShunt));
            }
        });
    }

    private static int getStatus(ShuntCompensator fixedShunt) {
        if (fixedShunt.getTerminal().isConnected()) {
            return 1;
        }
        return 0;
    }

    private static double getQ(ShuntCompensator fixedShunt) {
        return FixedShuntCompensatorConverter.shuntAdmittanceToPower(fixedShunt.getB(fixedShunt.getSectionCount()), fixedShunt.getTerminal().getVoltageLevel().getNominalV());
    }
}

