/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTransformerWinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformerConverter
extends AbstractConverter {
    private static final double TOLERANCE = 1.0E-5;
    private final PsseTransformer psseTransformer;
    private final Map<Integer, PsseBus> busNumToPsseBus;
    private final double sbase;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final PsseVersion version;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerConverter.class);

    TransformerConverter(PsseTransformer psseTransformer, ContainersMapping containersMapping, PsseImporter.PerUnitContext perUnitContext, Network network, Map<Integer, PsseBus> busNumToPsseBus, double sbase, PsseVersion version) {
        super(containersMapping, network);
        this.psseTransformer = Objects.requireNonNull(psseTransformer);
        this.busNumToPsseBus = Objects.requireNonNull(busNumToPsseBus);
        this.sbase = sbase;
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.version = Objects.requireNonNull(version);
    }

    void create() {
        if (this.psseTransformer.getK() == 0) {
            this.createTwoWindingsTransformer();
        } else {
            this.createThreeWindingsTransformer();
        }
    }

    private void createTwoWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getCkt());
        String bus1Id = TransformerConverter.getBusId(this.psseTransformer.getI());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getI());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        double baskv1 = this.busNumToPsseBus.get(this.psseTransformer.getI()).getBaskv();
        String bus2Id = TransformerConverter.getBusId(this.psseTransformer.getJ());
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getJ());
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double baskv2 = this.busNumToPsseBus.get(this.psseTransformer.getJ()).getBaskv();
        double sbase12 = this.psseTransformer.getSbase12();
        double nomV1 = TransformerConverter.getNomV(this.psseTransformer.getWinding1(), voltageLevel1);
        double nomV2 = TransformerConverter.getNomV(this.psseTransformer.getWinding2(), voltageLevel2);
        Complex z = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR12(), this.psseTransformer.getX12(), this.sbase, sbase12, this.psseTransformer.getCz());
        ComplexRatio w1 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding1().getWindv(), this.psseTransformer.getWinding1().getAng(), baskv1, nomV1, this.psseTransformer.getCw());
        double w2 = TransformerConverter.defineRatio(this.psseTransformer.getWinding2().getWindv(), baskv2, nomV2, this.psseTransformer.getCw());
        TapChanger tapChanger = TransformerConverter.defineTapChanger(w1, this.psseTransformer.getWinding1(), baskv1, nomV1, this.psseTransformer.getCw());
        Complex ysh = TransformerConverter.defineShuntAdmittance(id, this.psseTransformer.getMag1(), this.psseTransformer.getMag2(), this.sbase, sbase12, baskv1, nomV1, this.psseTransformer.getCm());
        z = TransformerConverter.impedanceToEngineeringUnits(z, voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        ysh = TransformerConverter.admittanceToEngineeringUnits(ysh, voltageLevel2.getNominalV(), this.perUnitContext.getSb());
        z = TransformerConverter.impedanceAdjustmentAfterMovingRatio(z, w2);
        TapChanger tapChangerAdjustedRatio = this.tapChangerAdjustmentAfterMovingRatio(tapChanger, w2);
        TapChanger tapChangerAdjustedYsh = this.tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(tapChangerAdjustedRatio);
        TwoWindingsTransformerAdder adder = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((Substation)voltageLevel2.getSubstation().orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation"))).newTwoWindingsTransformer().setId(id)).setEnsureIdUnicity(true)).setConnectableBus1(bus1Id)).setVoltageLevel1(voltageLevel1Id)).setConnectableBus2(bus2Id)).setVoltageLevel2(voltageLevel2Id)).setRatedU1(voltageLevel1.getNominalV()).setRatedU2(voltageLevel2.getNominalV()).setR(z.getReal()).setX(z.getImaginary()).setG(ysh.getReal()).setB(ysh.getImaginary());
        adder.setBus1(this.psseTransformer.getStat() == 1 ? bus1Id : null);
        adder.setBus2(this.psseTransformer.getStat() == 1 ? bus2Id : null);
        TwoWindingsTransformer twt = adder.add();
        TransformerConverter.tapChangerToIidm(tapChangerAdjustedYsh, twt);
        this.defineOperationalLimits(twt, voltageLevel1.getNominalV(), voltageLevel2.getNominalV());
    }

    private void createThreeWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getCkt());
        String bus1Id = TransformerConverter.getBusId(this.psseTransformer.getI());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getI());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        double baskv1 = this.busNumToPsseBus.get(this.psseTransformer.getI()).getBaskv();
        String bus2Id = TransformerConverter.getBusId(this.psseTransformer.getJ());
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getJ());
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double baskv2 = this.busNumToPsseBus.get(this.psseTransformer.getJ()).getBaskv();
        String bus3Id = TransformerConverter.getBusId(this.psseTransformer.getK());
        String voltageLevel3Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getK());
        VoltageLevel voltageLevel3 = this.getNetwork().getVoltageLevel(voltageLevel3Id);
        double baskv3 = this.busNumToPsseBus.get(this.psseTransformer.getK()).getBaskv();
        double sbase12 = this.psseTransformer.getSbase12();
        double sbase23 = this.psseTransformer.getSbase23();
        double sbase31 = this.psseTransformer.getSbase31();
        double nomV1 = TransformerConverter.getNomV(this.psseTransformer.getWinding1(), voltageLevel1);
        double nomV2 = TransformerConverter.getNomV(this.psseTransformer.getWinding2(), voltageLevel2);
        double nomV3 = TransformerConverter.getNomV(this.psseTransformer.getWinding3(), voltageLevel3);
        Complex z12 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR12(), this.psseTransformer.getX12(), this.sbase, sbase12, this.psseTransformer.getCz());
        Complex z23 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR23(), this.psseTransformer.getX23(), this.sbase, sbase23, this.psseTransformer.getCz());
        Complex z31 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR31(), this.psseTransformer.getX31(), this.sbase, sbase31, this.psseTransformer.getCz());
        Complex z1 = z12.add(z31).subtract(z23).multiply(0.5);
        Complex z2 = z12.add(z23).subtract(z31).multiply(0.5);
        Complex z3 = z23.add(z31).subtract(z12).multiply(0.5);
        ComplexRatio w1 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding1().getWindv(), this.psseTransformer.getWinding1().getAng(), baskv1, nomV1, this.psseTransformer.getCw());
        ComplexRatio w2 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding2().getWindv(), this.psseTransformer.getWinding2().getAng(), baskv2, nomV2, this.psseTransformer.getCw());
        ComplexRatio w3 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding3().getWindv(), this.psseTransformer.getWinding3().getAng(), baskv3, nomV3, this.psseTransformer.getCw());
        TapChanger tapChanger1 = TransformerConverter.defineTapChanger(w1, this.psseTransformer.getWinding1(), baskv1, nomV1, this.psseTransformer.getCw());
        TapChanger tapChanger2 = TransformerConverter.defineTapChanger(w2, this.psseTransformer.getWinding2(), baskv2, nomV2, this.psseTransformer.getCw());
        TapChanger tapChanger3 = TransformerConverter.defineTapChanger(w3, this.psseTransformer.getWinding3(), baskv3, nomV3, this.psseTransformer.getCw());
        Complex ysh = TransformerConverter.defineShuntAdmittance(id, this.psseTransformer.getMag1(), this.psseTransformer.getMag2(), this.sbase, sbase12, baskv1, nomV1, this.psseTransformer.getCm());
        double v0 = 1.0;
        z1 = TransformerConverter.impedanceToEngineeringUnits(z1, v0, this.perUnitContext.getSb());
        z2 = TransformerConverter.impedanceToEngineeringUnits(z2, v0, this.perUnitContext.getSb());
        z3 = TransformerConverter.impedanceToEngineeringUnits(z3, v0, this.perUnitContext.getSb());
        ysh = TransformerConverter.admittanceToEngineeringUnits(ysh, v0, this.perUnitContext.getSb());
        TapChanger tapChanger1AdjustedYsh = this.tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(tapChanger1);
        ThreeWindingsTransformerAdder adder = ((ThreeWindingsTransformerAdder)((ThreeWindingsTransformerAdder)((Substation)voltageLevel1.getSubstation().orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation"))).newThreeWindingsTransformer().setRatedU0(v0).setEnsureIdUnicity(true)).setId(id)).newLeg1().setR(z1.getReal()).setX(z1.getImaginary()).setG(ysh.getReal()).setB(ysh.getImaginary()).setRatedU(voltageLevel1.getNominalV()).setConnectableBus(bus1Id).setVoltageLevel(voltageLevel1Id).setBus(this.leg1IsConnected() ? bus1Id : null).add().newLeg2().setR(z2.getReal()).setX(z2.getImaginary()).setG(0.0).setB(0.0).setRatedU(voltageLevel2.getNominalV()).setConnectableBus(bus2Id).setVoltageLevel(voltageLevel2Id).setBus(this.leg2IsConnected() ? bus2Id : null).add().newLeg3().setR(z3.getReal()).setX(z3.getImaginary()).setG(0.0).setB(0.0).setRatedU(voltageLevel3.getNominalV()).setConnectableBus(bus3Id).setVoltageLevel(voltageLevel3Id).setBus(this.leg3IsConnected() ? bus3Id : null).add();
        ThreeWindingsTransformer twt = adder.add();
        twt.setProperty("v", Double.toString(this.psseTransformer.getVmstar() * v0));
        twt.setProperty("angle", Double.toString(this.psseTransformer.getAnstar()));
        TransformerConverter.tapChangersToIidm(tapChanger1AdjustedYsh, tapChanger2, tapChanger3, twt);
        this.defineOperationalLimits(twt, voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), voltageLevel3.getNominalV());
    }

    private static double getNomV(PsseTransformerWinding winding, VoltageLevel voltageLevel) {
        double nomV = winding.getNomv();
        if (nomV == 0.0) {
            nomV = voltageLevel.getNominalV();
        }
        return nomV;
    }

    private boolean leg1IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 2 || this.psseTransformer.getStat() == 3;
    }

    private boolean leg2IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 3 || this.psseTransformer.getStat() == 4;
    }

    private boolean leg3IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 2 || this.psseTransformer.getStat() == 4;
    }

    private static Complex defineImpedanceBetweenWindings(double r, double x, double sbase, double windingSbase, int cz) {
        double xw;
        double rw;
        switch (cz) {
            case 1: {
                rw = r;
                xw = x;
                break;
            }
            case 2: {
                rw = r * sbase / windingSbase;
                xw = x * sbase / windingSbase;
                break;
            }
            case 3: {
                rw = r / windingSbase / 1000000.0;
                xw = Math.sqrt(x * x - rw * rw);
                rw = rw * sbase / windingSbase;
                xw = xw * sbase / windingSbase;
                break;
            }
            default: {
                throw new PsseException("Unexpected CZ = " + cz);
            }
        }
        return new Complex(rw, xw);
    }

    private static Complex defineShuntAdmittance(String id, double magG, double magB, double sbase, double windingSbase, double baskv, double nomV, int cm) {
        double b;
        double g;
        switch (cm) {
            case 1: {
                g = magG;
                b = magB;
                break;
            }
            case 2: {
                g = magG / (1000000.0 * sbase) * (baskv / nomV) * (baskv / nomV);
                double y = magB * (windingSbase / sbase) * (baskv / nomV) * (baskv / nomV);
                double b2 = y * y - g * g;
                if (b2 >= 0.0) {
                    b = -Math.sqrt(b2);
                    break;
                }
                b = 0.0;
                LOGGER.warn("Magnetizing susceptance of Transformer ({}) set to 0 because admittance module is ({}) and conductance is ({})  ", new Object[]{id, y, g});
                break;
            }
            default: {
                throw new PsseException("Unexpected CM = " + cm);
            }
        }
        return new Complex(g, b);
    }

    private static ComplexRatio defineComplexRatio(double windV, double ang, double baskv, double nomV, int cw) {
        return new ComplexRatio(TransformerConverter.defineRatio(windV, baskv, nomV, cw), ang);
    }

    private static double defineRatio(double windV, double baskv, double nomV, int cw) {
        return switch (cw) {
            case 1 -> windV;
            case 2 -> windV / baskv;
            case 3 -> windV * nomV / baskv;
            default -> throw new PsseException("Unexpected CW = " + cw);
        };
    }

    private static double defineWindV(double ratio, double baskv, double nomV, int cw) {
        return switch (cw) {
            case 1 -> ratio;
            case 2 -> ratio * baskv;
            case 3 -> ratio * baskv / nomV;
            default -> throw new PsseException("Unexpected CW = " + cw);
        };
    }

    private static TapChanger defineTapChanger(ComplexRatio complexRatio, PsseTransformerWinding winding, double baskv, double nomv, int cw) {
        TapChanger tapChanger = TransformerConverter.defineRawTapChanger(complexRatio, winding.getRma(), winding.getRmi(), winding.getNtp(), baskv, nomv, cw, winding.getCod());
        tapChanger.setTapPosition(TransformerConverter.defineTapPositionAndAdjustTapChangerToCurrentRatio(complexRatio, tapChanger));
        return tapChanger;
    }

    private static TapChanger defineRawTapChanger(ComplexRatio complexRatio, double rma, double rmi, int ntp, double baskv, double nomv, int cw, int cod) {
        TapChanger tapChanger = new TapChanger();
        if (ntp <= 1) {
            tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
            return tapChanger;
        }
        if (complexRatio.getAngle() == 0.0 && (cod == 1 || cod == 2)) {
            double stepRatioIncrement = (rma - rmi) / (double)(ntp - 1);
            for (int i = 0; i < ntp; ++i) {
                double ratio = TransformerConverter.defineRatio(rmi + stepRatioIncrement * (double)i, baskv, nomv, cw);
                tapChanger.getSteps().add(new TapChangerStep(ratio, complexRatio.getAngle()));
            }
            return tapChanger;
        }
        if (cod == 3) {
            double stepAngleIncrement = (rma - rmi) / (double)(ntp - 1);
            for (int i = 0; i < ntp; ++i) {
                double angle = rmi + stepAngleIncrement * (double)i;
                tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), angle));
            }
            return tapChanger;
        }
        tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
        return tapChanger;
    }

    private static int defineTapPositionAndAdjustTapChangerToCurrentRatio(ComplexRatio complexRatio, TapChanger tapChanger) {
        List<TapChangerStep> steps = tapChanger.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            TapChangerStep step = steps.get(i);
            double distanceRatio = TransformerConverter.distance(step.getRatio(), complexRatio.getRatio());
            double distanceAngle = TransformerConverter.distance(step.getAngle(), complexRatio.getAngle());
            if (distanceRatio == 0.0 && distanceAngle == 0.0) {
                return i;
            }
            if (!(distanceAngle > 0.0) && (distanceAngle != 0.0 || !(distanceRatio > 0.0))) continue;
            tapChanger.getSteps().add(i, new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
            return i;
        }
        tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
        return tapChanger.getSteps().size() - 1;
    }

    private static double distance(double stepValue, double currentValue) {
        double distance = stepValue - currentValue;
        if (Math.abs(distance) <= 1.0E-5) {
            return 0.0;
        }
        return distance;
    }

    private static void tapChangerToIidm(TapChanger tapChanger, TwoWindingsTransformer twt) {
        if (TransformerConverter.isPhaseTapChanger(tapChanger)) {
            PhaseTapChangerAdder ptc = twt.newPhaseTapChanger();
            TransformerConverter.tapChangerToPhaseTapChanger(tapChanger, ptc);
        } else if (TransformerConverter.isRatioTapChanger(tapChanger)) {
            RatioTapChangerAdder rtc = twt.newRatioTapChanger();
            TransformerConverter.tapChangerToRatioTapChanger(tapChanger, rtc);
        }
    }

    private static void tapChangersToIidm(TapChanger tapChanger1, TapChanger tapChanger2, TapChanger tapChanger3, ThreeWindingsTransformer twt) {
        TransformerConverter.tapChangerToIidmLeg(tapChanger1, twt.getLeg1());
        TransformerConverter.tapChangerToIidmLeg(tapChanger2, twt.getLeg2());
        TransformerConverter.tapChangerToIidmLeg(tapChanger3, twt.getLeg3());
    }

    private static void tapChangerToIidmLeg(TapChanger tapChanger, ThreeWindingsTransformer.Leg leg) {
        if (TransformerConverter.isPhaseTapChanger(tapChanger)) {
            PhaseTapChangerAdder ptc = leg.newPhaseTapChanger();
            TransformerConverter.tapChangerToPhaseTapChanger(tapChanger, ptc);
        } else if (TransformerConverter.isRatioTapChanger(tapChanger)) {
            RatioTapChangerAdder rtc = leg.newRatioTapChanger();
            TransformerConverter.tapChangerToRatioTapChanger(tapChanger, rtc);
        }
    }

    private static boolean isPhaseTapChanger(TapChanger tapChanger) {
        return tapChanger.getSteps().stream().anyMatch(step -> step.getAngle() != 0.0);
    }

    private static boolean isRatioTapChanger(TapChanger tapChanger) {
        return tapChanger.getSteps().stream().anyMatch(step -> step.getRatio() != 1.0);
    }

    private static void tapChangerToRatioTapChanger(TapChanger tapChanger, RatioTapChangerAdder rtc) {
        ((RatioTapChangerAdder)rtc.setLoadTapChangingCapabilities(false).setLowTapPosition(0)).setTapPosition(tapChanger.getTapPosition());
        tapChanger.getSteps().forEach(step -> ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtc.beginStep()).setRho(1.0 / step.getRatio())).setR(step.getR())).setX(step.getX())).setB(step.getB1())).setG(step.getG1())).endStep());
        rtc.add();
    }

    private static void tapChangerToPhaseTapChanger(TapChanger tapChanger, PhaseTapChangerAdder ptc) {
        ((PhaseTapChangerAdder)ptc.setLowTapPosition(0)).setTapPosition(tapChanger.getTapPosition());
        tapChanger.getSteps().forEach(step -> ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptc.beginStep()).setRho(1.0 / step.getRatio())).setAlpha(-step.getAngle())).setR(step.getR())).setX(step.getX())).setB(step.getB1())).setG(step.getG1())).endStep());
        ((PhaseTapChangerAdder)ptc.setRegulating(false)).setRegulationMode(PhaseTapChanger.RegulationMode.FIXED_TAP).add();
    }

    private static Complex impedanceAdjustmentAfterMovingRatio(Complex impedance, double a) {
        return impedance.multiply(a * a);
    }

    private static double admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(double admittance, Complex a) {
        return admittance * a.abs() * a.abs();
    }

    private TapChanger tapChangerAdjustmentAfterMovingRatio(TapChanger tapChanger, double a) {
        tapChanger.getSteps().forEach(step -> step.setRatio(step.getRatio() / a));
        return tapChanger;
    }

    private TapChanger tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(TapChanger tapChanger) {
        tapChanger.getSteps().forEach(step -> {
            Complex a = new Complex(step.getRatio() * Math.cos(Math.toRadians(step.getAngle())), step.getRatio() * Math.sin(Math.toRadians(step.getAngle())));
            step.setG1(100.0 * (TransformerConverter.admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(1.0 + step.getG1() / 100.0, a) - 1.0));
            step.setB1(100.0 * (TransformerConverter.admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(1.0 + step.getB1() / 100.0, a) - 1.0));
        });
        return tapChanger;
    }

    private void defineOperationalLimits(TwoWindingsTransformer twt, double vnom1, double vnom2) {
        double rateMva = this.getRateWinding1();
        double currentLimit1 = rateMva / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva / (Math.sqrt(3.0) * vnom2);
        if (currentLimit1 > 0.0) {
            CurrentLimitsAdder currentLimitFrom = twt.newCurrentLimits1();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            CurrentLimitsAdder currentLimitTo = twt.newCurrentLimits2();
            currentLimitTo.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitTo.add();
        }
    }

    private void defineOperationalLimits(ThreeWindingsTransformer twt, double vnom1, double vnom2, double vnom3) {
        CurrentLimitsAdder currentLimitFrom;
        double rateMva1 = this.getRateWinding1();
        double rateMva2 = this.getRateWinding2();
        double rateMva3 = this.getRateWinding3();
        double currentLimit1 = rateMva1 / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva2 / (Math.sqrt(3.0) * vnom2);
        double currentLimit3 = rateMva3 / (Math.sqrt(3.0) * vnom3);
        if (currentLimit1 > 0.0) {
            currentLimitFrom = twt.getLeg1().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            currentLimitFrom = twt.getLeg2().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit3 > 0.0) {
            currentLimitFrom = twt.getLeg3().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit3 * 1000.0);
            currentLimitFrom.add();
        }
    }

    private double getRateWinding1() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding1Rates().getRate1() : this.psseTransformer.getWinding1Rates().getRatea();
        return rateMva;
    }

    private double getRateWinding2() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding2Rates().getRate1() : this.psseTransformer.getWinding2Rates().getRatea();
        return rateMva;
    }

    private double getRateWinding3() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding3Rates().getRate1() : this.psseTransformer.getWinding3Rates().getRatea();
        return rateMva;
    }

    public void addControl() {
        if (TransformerConverter.isTwoWindingsTransformer(this.psseTransformer)) {
            this.addControlTwoWindingsTransformer();
        } else {
            this.addControlThreeWindingsTransformer();
        }
    }

    private static boolean isTwoWindingsTransformer(PsseTransformer psseTransformer) {
        return psseTransformer.getK() == 0;
    }

    private void addControlTwoWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getCkt());
        TwoWindingsTransformer twt = this.getNetwork().getTwoWindingsTransformer(id);
        if (twt == null) {
            return;
        }
        boolean regulatingForcedToOff = false;
        if (twt.hasRatioTapChanger()) {
            boolean regulating = TransformerConverter.defineVoltageControl(this.getNetwork(), twt.getId(), this.psseTransformer.getWinding1(), twt.getRatioTapChanger(), regulatingForcedToOff);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        if (twt.hasPhaseTapChanger()) {
            TransformerConverter.defineActivePowerControl(this.getNetwork(), twt.getId(), this.psseTransformer.getWinding1(), twt.getPhaseTapChanger(), regulatingForcedToOff);
        }
    }

    private void addControlThreeWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getCkt());
        ThreeWindingsTransformer twt = this.getNetwork().getThreeWindingsTransformer(id);
        if (twt == null) {
            return;
        }
        boolean regulatingForcedToOff = false;
        regulatingForcedToOff = TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg1(), this.psseTransformer.getWinding1(), regulatingForcedToOff);
        regulatingForcedToOff = TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg2(), this.psseTransformer.getWinding2(), regulatingForcedToOff);
        TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg3(), this.psseTransformer.getWinding3(), regulatingForcedToOff);
    }

    private static boolean addControlThreeWindingsTransformerLeg(Network network, String id, ThreeWindingsTransformer.Leg leg, PsseTransformerWinding winding, boolean regulatingForcedToOffInput) {
        boolean regulating;
        boolean regulatingForcedToOff = regulatingForcedToOffInput;
        if (leg.hasRatioTapChanger()) {
            regulating = TransformerConverter.defineVoltageControl(network, id, winding, leg.getRatioTapChanger(), regulatingForcedToOff);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        if (leg.hasPhaseTapChanger()) {
            regulating = TransformerConverter.defineActivePowerControl(network, id, winding, leg.getPhaseTapChanger(), regulatingForcedToOff);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        return regulatingForcedToOff;
    }

    private static boolean defineVoltageControl(Network network, String id, PsseTransformerWinding winding, RatioTapChanger rtc, boolean regulatingForcedToOff) {
        if (Math.abs(winding.getCod()) == 2) {
            LOGGER.warn("Transformer {}. Reactive power control not supported", (Object)id);
            return false;
        }
        if (Math.abs(winding.getCod()) != 1) {
            return false;
        }
        Terminal regulatingTerminal = TransformerConverter.defineRegulatingTerminal(network, id, winding);
        if (regulatingTerminal == null) {
            return false;
        }
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double vmin = winding.getVmi() * vnom;
        double vmax = winding.getVma() * vnom;
        double targetV = (vmin + vmax) * 0.5;
        double targetDeadBand = vmax - vmin;
        boolean regulating = true;
        if (targetV <= 0.0 || targetDeadBand < 0.0) {
            regulating = false;
        }
        if (regulating && regulatingForcedToOff) {
            LOGGER.warn("Transformer {}. Regulating control forced to off. Only one control is supported", (Object)id);
            regulating = false;
        }
        ((RatioTapChanger)((RatioTapChanger)rtc.setTargetV(targetV).setTargetDeadband(targetDeadBand)).setRegulationTerminal(regulatingTerminal)).setRegulating(regulating);
        return regulating;
    }

    private static boolean defineActivePowerControl(Network network, String id, PsseTransformerWinding winding, PhaseTapChanger ptc, boolean regulatingForcedToOff) {
        if (Math.abs(winding.getCod()) != 3) {
            return false;
        }
        Terminal regulatingTerminal = TransformerConverter.defineRegulatingTerminal(network, id, winding);
        if (regulatingTerminal == null) {
            return false;
        }
        double activePowerMin = winding.getVmi();
        double activePowerMax = winding.getVma();
        double targetValue = 0.5 * (activePowerMin + activePowerMax);
        double targetDeadBand = activePowerMax - activePowerMin;
        boolean regulating = true;
        if (targetDeadBand < 0.0) {
            regulating = false;
        }
        if (regulating && regulatingForcedToOff) {
            LOGGER.warn("Transformer {}. Regulating control forced to off. Only one control is supported", (Object)id);
            regulating = false;
        }
        ((PhaseTapChanger)((PhaseTapChanger)ptc.setRegulationValue(targetValue).setTargetDeadband(targetDeadBand)).setRegulationTerminal(regulatingTerminal)).setRegulationMode(PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL).setRegulating(regulating);
        return regulating;
    }

    private static boolean forceRegulatingToOff(boolean regulatingForcedToOff, boolean regulating) {
        return regulatingForcedToOff || regulating;
    }

    private static Terminal defineRegulatingTerminal(Network network, String id, PsseTransformerWinding winding) {
        Terminal regulatingTerminal = null;
        String regulatingBusId = TransformerConverter.getBusId(Math.abs(winding.getCont()));
        Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
        if (bus != null) {
            regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
        }
        if (regulatingTerminal == null) {
            LOGGER.warn("Transformer {}. Regulating terminal is not assigned as the bus is isolated", (Object)id);
        }
        return regulatingTerminal;
    }

    private static String getTransformerId(int i, int j, String ckt) {
        return "T-" + i + "-" + j + "-" + ckt;
    }

    private static String getTransformerId(int i, int j, int k, String ckt) {
        return "T-" + i + "-" + j + "-" + k + "-" + ckt;
    }

    static void updateTransformers(Network network, PssePowerFlowModel psseModel) {
        psseModel.getTransformers().forEach(psseTransformer -> {
            if (TransformerConverter.isTwoWindingsTransformer(psseTransformer)) {
                TransformerConverter.updateTwoWindingsTransformer(network, psseTransformer);
            } else {
                TransformerConverter.updateThreeWindingsTransformer(network, psseTransformer);
            }
        });
    }

    private static void updateTwoWindingsTransformer(Network network, PsseTransformer psseTransformer) {
        String transformerId = TransformerConverter.getTransformerId(psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getCkt());
        TwoWindingsTransformer tw2t = network.getTwoWindingsTransformer(transformerId);
        if (tw2t == null) {
            psseTransformer.setStat(0);
        } else {
            double baskv1 = tw2t.getTerminal1().getVoltageLevel().getNominalV();
            double nomV1 = TransformerConverter.getNomV(psseTransformer.getWinding1(), tw2t.getTerminal1().getVoltageLevel());
            psseTransformer.getWinding1().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(tw2t.getRatioTapChanger(), tw2t.getPhaseTapChanger()), baskv1, nomV1, psseTransformer.getCw()));
            psseTransformer.getWinding1().setAng(TransformerConverter.getAngle(tw2t.getPhaseTapChanger()));
            psseTransformer.setStat(TransformerConverter.getStatus(tw2t));
        }
    }

    private static int getStatus(TwoWindingsTransformer tw2t) {
        if (tw2t.getTerminal1().isConnected() && tw2t.getTerminal2().isConnected()) {
            return 1;
        }
        return 0;
    }

    private static void updateThreeWindingsTransformer(Network network, PsseTransformer psseTransformer) {
        String transformerId = TransformerConverter.getTransformerId(psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getK(), psseTransformer.getCkt());
        ThreeWindingsTransformer tw3t = network.getThreeWindingsTransformer(transformerId);
        if (tw3t == null) {
            psseTransformer.setStat(0);
        } else {
            double baskv1 = tw3t.getLeg1().getTerminal().getVoltageLevel().getNominalV();
            double nomV1 = TransformerConverter.getNomV(psseTransformer.getWinding1(), tw3t.getLeg1().getTerminal().getVoltageLevel());
            psseTransformer.getWinding1().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(tw3t.getLeg1().getRatioTapChanger(), tw3t.getLeg1().getPhaseTapChanger()), baskv1, nomV1, psseTransformer.getCw()));
            psseTransformer.getWinding1().setAng(TransformerConverter.getAngle(tw3t.getLeg1().getPhaseTapChanger()));
            double baskv2 = tw3t.getLeg2().getTerminal().getVoltageLevel().getNominalV();
            double nomV2 = TransformerConverter.getNomV(psseTransformer.getWinding2(), tw3t.getLeg2().getTerminal().getVoltageLevel());
            psseTransformer.getWinding2().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(tw3t.getLeg2().getRatioTapChanger(), tw3t.getLeg2().getPhaseTapChanger()), baskv2, nomV2, psseTransformer.getCw()));
            psseTransformer.getWinding2().setAng(TransformerConverter.getAngle(tw3t.getLeg2().getPhaseTapChanger()));
            double baskv3 = tw3t.getLeg3().getTerminal().getVoltageLevel().getNominalV();
            double nomV3 = TransformerConverter.getNomV(psseTransformer.getWinding3(), tw3t.getLeg3().getTerminal().getVoltageLevel());
            psseTransformer.getWinding3().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(tw3t.getLeg3().getRatioTapChanger(), tw3t.getLeg3().getPhaseTapChanger()), baskv3, nomV3, psseTransformer.getCw()));
            psseTransformer.getWinding3().setAng(TransformerConverter.getAngle(tw3t.getLeg3().getPhaseTapChanger()));
            psseTransformer.setStat(TransformerConverter.getStatus(tw3t));
        }
    }

    private static int getStatus(ThreeWindingsTransformer tw3t) {
        if (tw3t.getLeg1().getTerminal().isConnected() && tw3t.getLeg2().getTerminal().isConnected() && tw3t.getLeg3().getTerminal().isConnected()) {
            return 1;
        }
        if (tw3t.getLeg1().getTerminal().isConnected() && tw3t.getLeg2().getTerminal().isConnected()) {
            return 3;
        }
        if (tw3t.getLeg1().getTerminal().isConnected() && tw3t.getLeg3().getTerminal().isConnected()) {
            return 2;
        }
        if (tw3t.getLeg2().getTerminal().isConnected() && tw3t.getLeg3().getTerminal().isConnected()) {
            return 4;
        }
        return 0;
    }

    private static double getRatio(RatioTapChanger rtc, PhaseTapChanger ptc) {
        double rho = 1.0;
        if (rtc != null) {
            rho *= ((RatioTapChangerStep)rtc.getCurrentStep()).getRho();
        }
        if (ptc != null) {
            rho *= ((PhaseTapChangerStep)ptc.getCurrentStep()).getRho();
        }
        return 1.0 / rho;
    }

    private static double getAngle(PhaseTapChanger ptc) {
        double alpha = 0.0;
        if (ptc != null) {
            alpha = ((PhaseTapChangerStep)ptc.getCurrentStep()).getAlpha();
        }
        if (alpha != 0.0) {
            return -alpha;
        }
        return alpha;
    }

    static class ComplexRatio {
        double ratio;
        double angle;

        ComplexRatio(double ratio, double angle) {
            this.ratio = ratio;
            this.angle = angle;
        }

        double getRatio() {
            return this.ratio;
        }

        double getAngle() {
            return this.angle;
        }
    }

    static class TapChanger {
        int tapPosition;
        List<TapChangerStep> steps = new ArrayList<TapChangerStep>();

        TapChanger() {
        }

        void setTapPosition(int tapPosition) {
            this.tapPosition = tapPosition;
        }

        int getTapPosition() {
            return this.tapPosition;
        }

        List<TapChangerStep> getSteps() {
            return this.steps;
        }
    }

    static class TapChangerStep {
        double ratio;
        double angle;
        double r;
        double x;
        double g1;
        double b1;

        TapChangerStep(double ratio, double angle) {
            this.ratio = ratio;
            this.angle = angle;
            this.r = 0.0;
            this.x = 0.0;
            this.g1 = 0.0;
            this.b1 = 0.0;
        }

        TapChangerStep(double ratio, double angle, double r, double x, double g1, double b1) {
            this.ratio = ratio;
            this.angle = angle;
            this.r = r;
            this.x = x;
            this.g1 = g1;
            this.b1 = b1;
        }

        void setRatio(double ratio) {
            this.ratio = ratio;
        }

        double getRatio() {
            return this.ratio;
        }

        void setAngle(double angle) {
            this.angle = angle;
        }

        double getAngle() {
            return this.angle;
        }

        double getR() {
            return this.r;
        }

        double getX() {
            return this.x;
        }

        void setG1(double g1) {
            this.g1 = g1;
        }

        double getG1() {
            return this.g1;
        }

        void setB1(double b1) {
            this.b1 = b1;
        }

        double getB1() {
            return this.b1;
        }
    }
}

