/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.pf.PsseBus;
import java.util.Objects;

class VoltageLevelConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final PsseImporter.PerUnitContext perUnitContext;

    VoltageLevelConverter(PsseBus psseBus, ContainersMapping containerMapping, PsseImporter.PerUnitContext perUnitContext, Network network) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
    }

    VoltageLevel create(Substation substation) {
        String voltageLevelId = this.getContainersMapping().getVoltageLevelId(this.psseBus.getI());
        double nominalV = VoltageLevelConverter.getNominalV(this.psseBus, this.perUnitContext.isIgnoreBaseVoltage());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(voltageLevelId);
        if (voltageLevel == null) {
            voltageLevel = ((VoltageLevelAdder)substation.newVoltageLevel().setId(voltageLevelId)).setNominalV(nominalV).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        }
        return voltageLevel;
    }

    static double getNominalV(PsseBus psseBus, boolean isIgnoreBaseVoltage) {
        return isIgnoreBaseVoltage || psseBus.getBaskv() == 0.0 ? 1.0 : psseBus.getBaskv();
    }
}

