/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.google.auto.service.AutoService;
import com.google.common.io.ByteStreams;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.BusConverter;
import com.powsybl.psse.converter.FixedShuntCompensatorConverter;
import com.powsybl.psse.converter.GeneratorConverter;
import com.powsybl.psse.converter.LineConverter;
import com.powsybl.psse.converter.LoadConverter;
import com.powsybl.psse.converter.SlackConverter;
import com.powsybl.psse.converter.SubstationConverter;
import com.powsybl.psse.converter.SwitchedShuntCompensatorConverter;
import com.powsybl.psse.converter.TransformerConverter;
import com.powsybl.psse.converter.TwoTerminalDcConverter;
import com.powsybl.psse.converter.VoltageLevelConverter;
import com.powsybl.psse.converter.extensions.PsseConversionContextExtensionAdder;
import com.powsybl.psse.converter.extensions.PsseModelExtensionAdder;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PsseFixes;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseValidation;
import com.powsybl.psse.model.pf.io.PowerFlowDataFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Importer.class})
public class PsseImporter
implements Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsseImporter.class);
    private static final String FORMAT = "PSS/E";
    private static final String[] EXTENSIONS = new String[]{"raw", "RAW", "rawx", "RAWX"};
    private static final Parameter IGNORE_BASE_VOLTAGE_PARAMETER = new Parameter("psse.import.ignore-base-voltage", ParameterType.BOOLEAN, "Ignore base voltage specified in the file", (Object)Boolean.FALSE);

    public String getFormat() {
        return FORMAT;
    }

    public List<String> getSupportedExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<Parameter> getParameters() {
        return ConfiguredParameter.load(Collections.singletonList(IGNORE_BASE_VOLTAGE_PARAMETER), (String)this.getFormat(), (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
    }

    public String getComment() {
        return "PSS/E Format to IIDM converter";
    }

    public boolean exists(ReadOnlyDataSource dataSource) {
        try {
            String ext = this.findExtension(dataSource);
            return this.exists(dataSource, ext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String findExtension(ReadOnlyDataSource dataSource) throws IOException {
        for (String ext : EXTENSIONS) {
            if (!dataSource.isDataExtension(ext) || !dataSource.exists(null, ext)) continue;
            return ext;
        }
        return null;
    }

    private boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        if (ext != null) {
            try {
                return PowerFlowDataFactory.create((String)ext).isValidFile(dataSource, ext);
            }
            catch (PsseException | IOException e) {
                LOGGER.error(String.format("Invalid content in filename %s.%s: %s", dataSource.getBaseName(), ext, e.getMessage()));
            }
        }
        return false;
    }

    public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
        Objects.requireNonNull(fromDataSource);
        Objects.requireNonNull(toDataSource);
        try {
            String ext = this.findExtension(fromDataSource);
            if (!this.exists(fromDataSource, ext)) {
                throw new PowsyblException("From data source is not importable");
            }
            try (InputStream is = fromDataSource.newInputStream(null, ext);
                 OutputStream os = toDataSource.newOutputStream(null, ext, false);){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(networkFactory);
        try {
            String ext = this.findExtension(dataSource);
            if (ext == null) {
                throw new PsseException(String.format("No Power Flow Data file found. Basename: %s, supported extensions: %s", dataSource.getBaseName(), String.join((CharSequence)"|", EXTENSIONS)));
            }
            PsseVersion version = PowerFlowDataFactory.create((String)ext).readVersion(dataSource, ext);
            Context context = new Context();
            PssePowerFlowModel pssePowerFlowModel = PowerFlowDataFactory.create((String)ext, (PsseVersion)version).read(dataSource, ext, context);
            pssePowerFlowModel.getCaseIdentification().validate();
            new PsseFixes(pssePowerFlowModel, context.getVersion()).fix();
            PsseValidation psseValidation = new PsseValidation(pssePowerFlowModel, context.getVersion());
            if (!psseValidation.isValidCase()) {
                throw new PsseException("The PSS/E file is not a valid case");
            }
            Network network = networkFactory.createNetwork(dataSource.getBaseName(), FORMAT);
            this.convert(pssePowerFlowModel, network, parameters, version);
            ((PsseModelExtensionAdder)network.newExtension(PsseModelExtensionAdder.class)).withModel(pssePowerFlowModel).add();
            ((PsseConversionContextExtensionAdder)network.newExtension(PsseConversionContextExtensionAdder.class)).withContext(context).add();
            return network;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Network convert(PssePowerFlowModel psseModel, Network network, Properties parameters, PsseVersion version) {
        boolean ignoreBaseVoltage = Parameter.readBoolean((String)FORMAT, (Properties)parameters, (Parameter)IGNORE_BASE_VOLTAGE_PARAMETER, (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
        PerUnitContext perUnitContext = new PerUnitContext(psseModel.getCaseIdentification().getSbase(), ignoreBaseVoltage);
        Map<Integer, PsseBus> busNumToPsseBus = psseModel.getBuses().stream().collect(Collectors.toMap(PsseBus::getI, Function.identity()));
        ContainersMapping containersMapping = this.defineContainersMapping(psseModel, busNumToPsseBus, perUnitContext);
        PsseImporter.createBuses(psseModel, containersMapping, perUnitContext, network);
        for (PsseLoad psseLoad : psseModel.getLoads()) {
            new LoadConverter(psseLoad, containersMapping, network).create();
        }
        for (PsseFixedShunt psseShunt : psseModel.getFixedShunts()) {
            new FixedShuntCompensatorConverter(psseShunt, containersMapping, network).create();
        }
        for (PsseSwitchedShunt psseSwShunt : psseModel.getSwitchedShunts()) {
            new SwitchedShuntCompensatorConverter(psseSwShunt, containersMapping, network, version).create();
        }
        for (PsseGenerator psseGen : psseModel.getGenerators()) {
            new GeneratorConverter(psseGen, containersMapping, network).create();
        }
        for (PsseNonTransformerBranch psseLine : psseModel.getNonTransformerBranches()) {
            new LineConverter(psseLine, containersMapping, perUnitContext, network, version).create();
        }
        for (PsseTransformer psseTfo : psseModel.getTransformers()) {
            new TransformerConverter(psseTfo, containersMapping, perUnitContext, network, busNumToPsseBus, psseModel.getCaseIdentification().getSbase(), version).create();
        }
        for (PsseTwoTerminalDcTransmissionLine psseTwoTerminaDc : psseModel.getTwoTerminalDcTransmissionLines()) {
            new TwoTerminalDcConverter(psseTwoTerminaDc, containersMapping, network).create();
        }
        new SlackConverter(psseModel.getBuses(), containersMapping, network).create();
        for (PsseSwitchedShunt psseSwShunt : psseModel.getSwitchedShunts()) {
            new SwitchedShuntCompensatorConverter(psseSwShunt, containersMapping, network, version).addControl();
        }
        for (PsseGenerator psseGen : psseModel.getGenerators()) {
            new GeneratorConverter(psseGen, containersMapping, network).addControl(busNumToPsseBus.get(psseGen.getI()));
        }
        for (PsseTransformer psseTransformer : psseModel.getTransformers()) {
            new TransformerConverter(psseTransformer, containersMapping, perUnitContext, network, busNumToPsseBus, psseModel.getCaseIdentification().getSbase(), version).addControl();
        }
        return network;
    }

    private ContainersMapping defineContainersMapping(PssePowerFlowModel psseModel, Map<Integer, PsseBus> busNumToPsseBus, PerUnitContext perUnitContext) {
        ArrayList edges = new ArrayList();
        psseModel.getTransformers().forEach(t -> {
            if (t.getK() == 0) {
                edges.add(new Edge(t.getI(), t.getJ(), true, false));
            } else {
                edges.add(new Edge(t.getI(), t.getJ(), true, false));
                edges.add(new Edge(t.getI(), t.getK(), true, false));
            }
        });
        return ContainersMapping.create((List)psseModel.getBuses(), edges, PsseBus::getI, Edge::getBus1, Edge::getBus2, Edge::isZeroImpedance, Edge::isTransformer, busNumber -> this.getNominalVFromBusNumber(busNumToPsseBus, (int)busNumber, perUnitContext), busNums -> "VL" + busNums.stream().sorted().findFirst().orElseThrow(() -> new PsseException("Unexpected empty busNums")), substationNums -> "S" + substationNums.stream().sorted().findFirst().orElseThrow(() -> new PsseException("Unexpected empty substationNums")));
    }

    private double getNominalVFromBusNumber(Map<Integer, PsseBus> busNumToPsseBus, int busNumber, PerUnitContext perUnitContext) {
        if (!busNumToPsseBus.containsKey(busNumber)) {
            throw new PsseException("busId without PsseBus" + busNumber);
        }
        return VoltageLevelConverter.getNominalV(busNumToPsseBus.get(busNumber), perUnitContext.isIgnoreBaseVoltage());
    }

    private static void createBuses(PssePowerFlowModel psseModel, ContainersMapping containersMapping, PerUnitContext perUnitContext, Network network) {
        for (PsseBus psseBus : psseModel.getBuses()) {
            Substation substation = new SubstationConverter(psseBus, containersMapping, network).create();
            VoltageLevel voltageLevel = new VoltageLevelConverter(psseBus, containersMapping, perUnitContext, network).create(substation);
            new BusConverter(psseBus, containersMapping, network).create(voltageLevel);
        }
    }

    static class PerUnitContext {
        private final double sb;
        private final boolean ignoreBaseVoltage;

        PerUnitContext(double sb, boolean ignoreBaseVoltage) {
            this.sb = sb;
            this.ignoreBaseVoltage = ignoreBaseVoltage;
        }

        double getSb() {
            return this.sb;
        }

        boolean isIgnoreBaseVoltage() {
            return this.ignoreBaseVoltage;
        }
    }

    private static final class Edge {
        private final int bus1;
        private final int bus2;
        private final boolean transformer;
        private final boolean zeroImpedance;

        private Edge(int bus1, int bus2, boolean transformer, boolean zeroImpedance) {
            this.bus1 = bus1;
            this.bus2 = bus2;
            this.transformer = transformer;
            this.zeroImpedance = zeroImpedance;
        }

        private int getBus1() {
            return this.bus1;
        }

        private int getBus2() {
            return this.bus2;
        }

        private boolean isTransformer() {
            return this.transformer;
        }

        private boolean isZeroImpedance() {
            return this.zeroImpedance;
        }
    }
}

