/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.iidm.network.util.TerminalFinder;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseBus;
import java.util.List;
import java.util.Objects;

class SlackConverter
extends AbstractConverter {
    private final List<PsseBus> psseBusList;

    SlackConverter(List<PsseBus> psseBusList, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseBusList = Objects.requireNonNull(psseBusList);
    }

    void create() {
        for (PsseBus psseBus : this.psseBusList) {
            if (psseBus.getIde() != 3) continue;
            String busId = AbstractConverter.getBusId(psseBus.getI());
            Bus bus = this.getNetwork().getBusBreakerView().getBus(busId);
            if (!SlackConverter.slackBusIsValidForIidm(bus)) continue;
            SlackTerminal.attach((Bus)bus);
        }
    }

    private static boolean slackBusIsValidForIidm(Bus bus) {
        return bus != null && TerminalFinder.getDefault().find(bus.getConnectedTerminals()).isPresent();
    }
}

