/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Objects;

class LoadConverter
extends AbstractConverter {
    private final PsseLoad psseLoad;

    LoadConverter(PsseLoad psseLoad, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseLoad = Objects.requireNonNull(psseLoad);
    }

    void create() {
        boolean constantPower;
        String busId = LoadConverter.getBusId(this.psseLoad.getI());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseLoad.getI()));
        double p0 = this.psseLoad.getPl() + this.psseLoad.getIp() + this.psseLoad.getYp();
        double q0 = this.psseLoad.getQl() + this.psseLoad.getIq() + this.psseLoad.getYq();
        LoadAdder adder = ((LoadAdder)((LoadAdder)voltageLevel.newLoad().setId(this.getLoadId(busId))).setConnectableBus(busId)).setP0(p0).setQ0(q0);
        boolean bl = constantPower = this.psseLoad.getIp() == 0.0 && this.psseLoad.getYp() == 0.0 && this.psseLoad.getIq() == 0.0 && this.psseLoad.getYq() == 0.0;
        if (!(constantPower || p0 == 0.0 && q0 == 0.0)) {
            double c2q;
            double c1q;
            double c0q;
            double c2p;
            double c1p;
            double c0p;
            if (p0 != 0.0) {
                c0p = this.psseLoad.getPl() / p0;
                c1p = this.psseLoad.getIp() / p0;
                c2p = this.psseLoad.getYp() / p0;
            } else {
                c0p = 1.0;
                c1p = 0.0;
                c2p = 0.0;
            }
            if (q0 != 0.0) {
                c0q = this.psseLoad.getQl() / q0;
                c1q = this.psseLoad.getIq() / q0;
                c2q = this.psseLoad.getYq() / q0;
            } else {
                c0q = 1.0;
                c1q = 0.0;
                c2q = 0.0;
            }
            adder.newZipModel().setC0p(c0p).setC1p(c1p).setC2p(c2p).setC0q(c0q).setC1q(c1q).setC2q(c2q).add();
        }
        adder.setBus(this.psseLoad.getStatus() == 1 ? busId : null);
        adder.add();
    }

    private String getLoadId(String busId) {
        return LoadConverter.getLoadId(busId, this.psseLoad.getId());
    }

    private static String getLoadId(String busId, String loadId) {
        return busId + "-L" + loadId;
    }

    static void updateLoads(Network network, PssePowerFlowModel psseModel) {
        psseModel.getLoads().forEach(psseLoad -> {
            String loadId = LoadConverter.getLoadId(LoadConverter.getBusId(psseLoad.getI()), psseLoad.getId());
            Load load = network.getLoad(loadId);
            if (load == null) {
                psseLoad.setStatus(0);
            } else {
                psseLoad.setStatus(LoadConverter.getStatus(load));
                psseLoad.setPl(LoadConverter.getP(load));
                psseLoad.setQl(LoadConverter.getQ(load));
            }
        });
    }

    private static int getStatus(Load load) {
        if (load.getTerminal().isConnected()) {
            return 1;
        }
        return 0;
    }

    private static double getP(Load load) {
        if (Double.isNaN(load.getTerminal().getP())) {
            return load.getP0();
        }
        return load.getTerminal().getP();
    }

    private static double getQ(Load load) {
        if (Double.isNaN(load.getTerminal().getQ())) {
            return load.getQ0();
        }
        return load.getTerminal().getQ();
    }
}

