/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Objects;

class BusConverter
extends AbstractConverter {
    private final PsseBus psseBus;

    BusConverter(PsseBus psseBus, ContainersMapping containerMapping, Network network) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
    }

    void create(VoltageLevel voltageLevel) {
        String busId = BusConverter.getBusId(this.psseBus.getI());
        Bus bus = ((BusAdder)((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(busId)).setName(this.psseBus.getName())).add();
        bus.setV(this.psseBus.getVm() * voltageLevel.getNominalV()).setAngle(this.psseBus.getVa());
    }

    static void updateBuses(Network network, PssePowerFlowModel psseModel) {
        psseModel.getBuses().forEach(psseBus -> {
            String busId = AbstractConverter.getBusId(psseBus.getI());
            Bus bus = network.getBusBreakerView().getBus(busId);
            if (bus == null) {
                psseBus.setVm(0.0);
                psseBus.setVa(0.0);
                psseBus.setIde(4);
            } else {
                psseBus.setVm(bus.getV() / bus.getVoltageLevel().getNominalV());
                psseBus.setVa(bus.getAngle());
            }
        });
    }
}

