/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseArea;
import com.powsybl.psse.model.pf.PsseBus;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class AreaConverter
extends AbstractConverter {
    private static final String AREA_ID_PREFIX = "A";
    private static final boolean IS_AC = true;
    private static final boolean IS_DC = false;
    private static final String CONTROL_AREA_TYPE = "ControlArea";
    private final PsseArea psseArea;
    private final List<PsseBus> buses;

    AreaConverter(PsseArea psseArea, List<PsseBus> buses, ContainersMapping containersMapping, Network network) {
        super(containersMapping, network);
        this.psseArea = psseArea;
        this.buses = buses;
    }

    Area create() {
        String areaId = AREA_ID_PREFIX + this.psseArea.getI();
        Area area = ((AreaAdder)((AreaAdder)this.getNetwork().newArea().setId(areaId)).setAreaType(CONTROL_AREA_TYPE).setInterchangeTarget(this.psseArea.getPdes()).setName(this.psseArea.getArname())).add();
        this.addVoltageLevelsToArea(area);
        this.addAreaBoundaries(area);
        return area;
    }

    private void addVoltageLevelsToArea(Area area) {
        for (PsseBus bus : this.buses) {
            if (bus.getArea() != this.psseArea.getI()) continue;
            String voltageLevelId = this.getContainersMapping().getVoltageLevelId(bus.getI());
            VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(voltageLevelId);
            area.addVoltageLevel(voltageLevel);
        }
    }

    private void addAreaBoundaries(Area area) {
        Set<VoltageLevel> areaVoltageLevels = this.extractVoltageLevels(area);
        this.addLineBoundaryTerminals(area, areaVoltageLevels);
        this.addHvdcLinesBoundaryTerminals(area, areaVoltageLevels);
    }

    private void addLineBoundaryTerminals(Area area, Set<VoltageLevel> areaVoltageLevels) {
        this.getNetwork().getLines().forEach(line -> this.processTerminals(line.getTerminal1(), line.getTerminal2(), area, areaVoltageLevels, true));
    }

    private void addHvdcLinesBoundaryTerminals(Area area, Set<VoltageLevel> areaVoltageLevels) {
        this.getNetwork().getHvdcLines().forEach(line -> this.processTerminals(line.getConverterStation1().getTerminal(), line.getConverterStation2().getTerminal(), area, areaVoltageLevels, false));
    }

    private void processTerminals(Terminal terminal1, Terminal terminal2, Area area, Set<VoltageLevel> areaVoltageLevels, boolean isAC) {
        Terminal boundaryTerminal = this.boundaryTerminal(terminal1, terminal2, areaVoltageLevels);
        if (boundaryTerminal != null) {
            this.addAreaBoundary(area, boundaryTerminal, isAC);
        }
    }

    private Terminal boundaryTerminal(Terminal terminal1, Terminal terminal2, Set<VoltageLevel> areaVoltageLevels) {
        boolean isTerminal2InArea;
        boolean isTerminal1InArea = areaVoltageLevels.contains(terminal1.getVoltageLevel());
        if (isTerminal1InArea != (isTerminal2InArea = areaVoltageLevels.contains(terminal2.getVoltageLevel()))) {
            return isTerminal1InArea ? terminal1 : terminal2;
        }
        return null;
    }

    private Set<VoltageLevel> extractVoltageLevels(Area area) {
        return StreamSupport.stream(area.getVoltageLevels().spliterator(), false).collect(Collectors.toSet());
    }

    private void addAreaBoundary(Area area, Terminal terminal, boolean isAC) {
        area.newAreaBoundary().setTerminal(terminal).setAc(isAC).add();
    }
}

