/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Objects;
import java.util.Optional;

class BusConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final NodeBreakerImport nodeBreakerImport;

    BusConverter(PsseBus psseBus, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create(VoltageLevel voltageLevel) {
        if (this.nodeBreakerImport.isTopologicalBus(this.psseBus.getI())) {
            return;
        }
        String busId = BusConverter.getBusId(this.psseBus.getI());
        Bus bus = ((BusAdder)((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(busId)).setName(this.psseBus.getName())).add();
        bus.setV(this.psseBus.getVm() * voltageLevel.getNominalV()).setAngle(this.psseBus.getVa());
    }

    static void update(PssePowerFlowModel psseModel, ContextExport contextExport) {
        psseModel.getBuses().forEach(psseBus -> {
            Optional<Bus> busViewBus = contextExport.getLinkExport().getBusView(psseBus.getI());
            if (busViewBus.isPresent()) {
                BusConverter.updatePsseBus(busViewBus.get(), BusConverter.findBusType(busViewBus.get().getVoltageLevel(), busViewBus.get(), psseBus), psseBus);
            } else {
                BusConverter.updateIsolatedPsseBus(psseBus);
            }
        });
    }

    private static int findBusType(VoltageLevel voltageLevel, Bus busView, PsseBus psseBus) {
        return BusConverter.exportVoltageLevelAsNodeBreaker(voltageLevel) ? psseBus.getIde() : BusConverter.findBusViewBusType(voltageLevel, busView);
    }

    private static void updatePsseBus(Bus busView, int type, PsseBus psseBus) {
        if (busView == null) {
            BusConverter.updateIsolatedPsseBus(psseBus);
        } else if (type == 4) {
            BusConverter.updateIsolatedPsseBus(psseBus);
        } else {
            psseBus.setVm(BusConverter.getVm(busView));
            psseBus.setVa(BusConverter.getVa(busView));
            psseBus.setIde(type);
        }
    }

    private static void updateIsolatedPsseBus(PsseBus psseBus) {
        psseBus.setVm(0.0);
        psseBus.setVa(0.0);
        psseBus.setIde(4);
    }
}

