/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.pf.PsseSubstation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class ContextExport {
    private final LinkExport linkExport = new LinkExport();
    private final UpdateExport updateExport = new UpdateExport();

    ContextExport() {
    }

    LinkExport getLinkExport() {
        return this.linkExport;
    }

    UpdateExport getUpdateExport() {
        return this.updateExport;
    }

    static class LinkExport {
        private final Map<Integer, Bus> busIToBusView = new HashMap<Integer, Bus>();
        private final Map<String, Bus> voltageLevelNodeIdToBusView = new HashMap<String, Bus>();

        LinkExport() {
        }

        void addBusIBusViewLink(int busI, Bus busView) {
            this.busIToBusView.put(busI, busView);
        }

        Optional<Bus> getBusView(int busI) {
            return Optional.ofNullable(this.busIToBusView.get(busI));
        }

        void addNodeBusViewLink(VoltageLevel voltageLevel, int node, Bus busView) {
            this.voltageLevelNodeIdToBusView.put(AbstractConverter.getNodeId(voltageLevel, node), busView);
        }

        Optional<Bus> getBusView(VoltageLevel voltageLevel, int node) {
            return Optional.ofNullable(this.voltageLevelNodeIdToBusView.get(AbstractConverter.getNodeId(voltageLevel, node)));
        }
    }

    static class UpdateExport {
        private final Map<VoltageLevel, PsseSubstation> voltageLevelPsseSubstation = new HashMap<VoltageLevel, PsseSubstation>();

        UpdateExport() {
        }

        void addVoltageLevelPsseSubstation(VoltageLevel voltageLevel, PsseSubstation psseSubstation) {
            this.voltageLevelPsseSubstation.put(voltageLevel, psseSubstation);
        }

        Optional<PsseSubstation> getPsseSubstation(VoltageLevel voltageLevel) {
            return Optional.ofNullable(this.voltageLevelPsseSubstation.get(voltageLevel));
        }
    }
}

