/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorConverter
extends AbstractConverter {
    private final PsseGenerator psseGenerator;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorConverter.class);

    GeneratorConverter(PsseGenerator psseGenerator, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseGenerator = Objects.requireNonNull(psseGenerator);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseGenerator.getI())) {
            return;
        }
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseGenerator.getI()));
        GeneratorAdder adder = ((GeneratorAdder)voltageLevel.newGenerator().setId(GeneratorConverter.getGeneratorId(this.psseGenerator.getI(), this.psseGenerator.getId()))).setTargetP(this.psseGenerator.getPg()).setMaxP(this.psseGenerator.getPt()).setMinP(this.psseGenerator.getPb()).setTargetQ(this.psseGenerator.getQg()).setVoltageRegulatorOn(false);
        String equipmentId = GeneratorConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_GENERATOR, this.psseGenerator.getI(), this.psseGenerator.getId());
        OptionalInt node = this.nodeBreakerImport.getNode(GeneratorConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseGenerator.getI()));
        if (node.isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = GeneratorConverter.getBusId(this.psseGenerator.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseGenerator.getStat() == 1 ? busId : null);
        }
        Generator generator = adder.add();
        generator.newMinMaxReactiveLimits().setMinQ(this.psseGenerator.getQb()).setMaxQ(this.psseGenerator.getQt()).add();
        if (this.psseGenerator.getRt() != 0.0 || this.psseGenerator.getXt() != 0.0) {
            LOGGER.warn("Implicit method where a transformer is specified with the generator is not supported ({})", (Object)generator.getId());
        }
    }

    void addControl(PsseBus psseBus) {
        Generator generator = this.getNetwork().getGenerator(GeneratorConverter.getGeneratorId(this.psseGenerator.getI(), this.psseGenerator.getId()));
        if (generator == null) {
            return;
        }
        Terminal regulatingTerminal = GeneratorConverter.defineRegulatingTerminal(this.psseGenerator, this.getNetwork(), generator, this.nodeBreakerImport);
        if (regulatingTerminal == null) {
            return;
        }
        boolean psseVoltageRegulatorOn = GeneratorConverter.defineVoltageRegulatorOn(psseBus);
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double targetV = this.psseGenerator.getVs() * vnom;
        boolean voltageRegulatorOn = false;
        if (targetV > 0.0 && this.psseGenerator.getQb() < this.psseGenerator.getQt()) {
            voltageRegulatorOn = psseVoltageRegulatorOn;
        }
        generator.setTargetV(targetV).setRegulatingTerminal(regulatingTerminal).setVoltageRegulatorOn(voltageRegulatorOn);
    }

    private static boolean defineVoltageRegulatorOn(PsseBus psseBus) {
        return psseBus.getIde() == 2 || psseBus.getIde() == 3;
    }

    private static Terminal defineRegulatingTerminal(PsseGenerator psseGenerator, Network network, Generator generator, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = null;
        if (psseGenerator.getIreg() == 0) {
            regulatingTerminal = generator.getTerminal();
        } else {
            Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(psseGenerator.getIreg());
            if (control.isPresent() && psseGenerator.getNreg() != 0) {
                int controlledNode = psseGenerator.getNreg() != 0 ? psseGenerator.getNreg() : control.get().node();
                regulatingTerminal = GeneratorConverter.findTerminalNode(network, control.get().voltageLevelId(), controlledNode);
            } else {
                String regulatingBusId = GeneratorConverter.getBusId(psseGenerator.getIreg());
                Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
                if (bus != null) {
                    regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
                }
            }
        }
        if (regulatingTerminal == null && psseGenerator.getI() != psseGenerator.getIreg()) {
            String generatorId = GeneratorConverter.getGeneratorId(psseGenerator.getI(), psseGenerator.getId());
            LOGGER.warn("Generator {}. Regulating terminal is not assigned", (Object)generatorId);
        }
        return regulatingTerminal;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getGenerators().forEach(psseGen -> {
            String genId = GeneratorConverter.getGeneratorId(psseGen.getI(), psseGen.getId());
            Generator gen = network.getGenerator(genId);
            if (gen == null) {
                psseGen.setStat(0);
            } else {
                psseGen.setStat(GeneratorConverter.getStatus(gen));
                psseGen.setPg(GeneratorConverter.getP(gen));
                psseGen.setQg(GeneratorConverter.getQ(gen));
            }
        });
    }

    private static int getStatus(Generator gen) {
        if (gen.getTerminal().isConnected() && gen.getTerminal().getBusBreakerView().getBus() != null) {
            return 1;
        }
        return 0;
    }

    private static double getP(Generator gen) {
        if (Double.isNaN(gen.getTerminal().getP())) {
            return gen.getTargetP();
        }
        return -gen.getTerminal().getP();
    }

    private static double getQ(Generator gen) {
        if (Double.isNaN(gen.getTerminal().getQ())) {
            return gen.getTargetQ();
        }
        return -gen.getTerminal().getQ();
    }
}

