/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

final class NodeBreakerImport {
    private final Set<Integer> topologicalBuses = new HashSet<Integer>();
    private final Map<String, Integer> equipmentIdBusNode = new HashMap<String, Integer>();
    private final Map<Integer, ControlR> busControlR = new HashMap<Integer, ControlR>();
    private final Map<Integer, ControlR> slackBusControlNode = new HashMap<Integer, ControlR>();

    NodeBreakerImport() {
    }

    void addTopologicalBuses(Set<Integer> buses) {
        this.topologicalBuses.addAll(buses);
    }

    boolean isTopologicalBus(int bus) {
        return this.topologicalBuses.contains(bus);
    }

    void addEquipment(String equipmentIdBus, int node) {
        this.equipmentIdBusNode.put(equipmentIdBus, node);
    }

    OptionalInt getNode(String equipmentIdBus) {
        if (this.equipmentIdBusNode.containsKey(equipmentIdBus)) {
            return OptionalInt.of(this.equipmentIdBusNode.get(equipmentIdBus));
        }
        return OptionalInt.empty();
    }

    void addBusControl(int bus, String voltageLevelId, int defaultNode) {
        this.busControlR.put(bus, new ControlR(voltageLevelId, defaultNode));
    }

    Optional<ControlR> getControl(int bus) {
        if (this.busControlR.containsKey(bus)) {
            return Optional.of(this.busControlR.get(bus));
        }
        return Optional.empty();
    }

    void addSlackControl(int bus, String voltageLevelId, int node) {
        this.slackBusControlNode.put(bus, new ControlR(voltageLevelId, node));
    }

    Optional<ControlR> getSlackControlNode(int bus) {
        if (this.slackBusControlNode.containsKey(bus)) {
            return Optional.of(this.slackBusControlNode.get(bus));
        }
        return Optional.empty();
    }

    record ControlR(String voltageLevelId, int node) {
    }
}

