/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSubstation;
import com.powsybl.psse.model.pf.PsseTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.Pseudograph;

final class NodeBreakerValidation {
    private final boolean ignoreNodeBreakerTopology;
    private final Map<Integer, List<PsseSubstation>> busSubstations;
    private final Map<PsseSubstation, List<Integer>> substationBuses;
    private final Map<Integer, Set<Integer>> busNodesSet;
    private final Map<Integer, List<String>> busEquipmentTerminals;
    private final Set<PsseSubstation> invalidSubstations;

    NodeBreakerValidation(boolean ignoreNodeBreakerTopology) {
        this.ignoreNodeBreakerTopology = ignoreNodeBreakerTopology;
        this.busSubstations = new HashMap<Integer, List<PsseSubstation>>();
        this.substationBuses = new HashMap<PsseSubstation, List<Integer>>();
        this.busNodesSet = new HashMap<Integer, Set<Integer>>();
        this.busEquipmentTerminals = new HashMap<Integer, List<String>>();
        this.invalidSubstations = new HashSet<PsseSubstation>();
    }

    void fillAndValidate(PssePowerFlowModel pssePowerFlowModel, PsseVersion version) {
        if (version.major() != PsseVersion.Major.V35 || this.ignoreNodeBreakerTopology) {
            return;
        }
        pssePowerFlowModel.getSubstations().forEach(psseSubstation -> {
            if (NodeBreakerValidation.validInternalConnectivity(psseSubstation)) {
                this.fill((PsseSubstation)psseSubstation);
            }
        });
        this.busSubstations.forEach((bus, substationList) -> {
            if (substationList.size() >= 2) {
                this.invalidSubstations.addAll((Collection<PsseSubstation>)substationList);
            }
        });
        pssePowerFlowModel.getLoads().forEach(psseLoad -> {
            String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_LOAD, psseLoad.getI(), psseLoad.getId());
            this.checkEquipment(psseLoad.getI(), id);
        });
        pssePowerFlowModel.getFixedShunts().forEach(psseFixedShunt -> {
            String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_FIXED_SHUNT, psseFixedShunt.getI(), psseFixedShunt.getId());
            this.checkEquipment(psseFixedShunt.getI(), id);
        });
        pssePowerFlowModel.getGenerators().forEach(psseGenerator -> {
            String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_GENERATOR, psseGenerator.getI(), psseGenerator.getId());
            this.checkEquipment(psseGenerator.getI(), id);
            this.checkControl(psseGenerator.getIreg(), psseGenerator.getNreg());
        });
        pssePowerFlowModel.getNonTransformerBranches().forEach(psseNonTransformerBranch -> {
            String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_BRANCH, psseNonTransformerBranch.getI(), psseNonTransformerBranch.getJ(), psseNonTransformerBranch.getCkt());
            this.checkEquipment(psseNonTransformerBranch.getI(), id);
            this.checkEquipment(psseNonTransformerBranch.getJ(), id);
        });
        pssePowerFlowModel.getTransformers().forEach(psseTransformer -> {
            if (psseTransformer.getK() == 0) {
                this.twoWindingsTransformerNetworkValidation((PsseTransformer)psseTransformer);
            } else {
                this.threeWindingsTransformerNetworkValidation((PsseTransformer)psseTransformer);
            }
        });
        pssePowerFlowModel.getTwoTerminalDcTransmissionLines().forEach(psseTwoTerminalDcTransmissionLine -> {
            String idRectifier = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, psseTwoTerminalDcTransmissionLine.getRectifier().getIp(), psseTwoTerminalDcTransmissionLine.getName());
            String idInverter = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, psseTwoTerminalDcTransmissionLine.getInverter().getIp(), psseTwoTerminalDcTransmissionLine.getName());
            this.checkEquipment(psseTwoTerminalDcTransmissionLine.getRectifier().getIp(), idRectifier);
            this.checkEquipment(psseTwoTerminalDcTransmissionLine.getInverter().getIp(), idInverter);
        });
        pssePowerFlowModel.getSwitchedShunts().forEach(psseSwitchedShunt -> {
            String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_SWITCHED_SHUNT, psseSwitchedShunt.getI(), psseSwitchedShunt.getId());
            this.checkEquipment(psseSwitchedShunt.getI(), id);
            this.checkControl(psseSwitchedShunt.getSwreg(), psseSwitchedShunt.getNreg());
        });
    }

    private void twoWindingsTransformerNetworkValidation(PsseTransformer psseTransformer) {
        String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_WINDING, psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getCkt());
        this.checkEquipment(psseTransformer.getI(), id);
        this.checkEquipment(psseTransformer.getJ(), id);
        this.checkControl(psseTransformer.getWinding1().getCont(), psseTransformer.getWinding1().getNode());
    }

    private void threeWindingsTransformerNetworkValidation(PsseTransformer psseTransformer) {
        String id = AbstractConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_THREE_WINDING, psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getK(), psseTransformer.getCkt());
        this.checkEquipment(psseTransformer.getI(), id);
        this.checkEquipment(psseTransformer.getJ(), id);
        this.checkEquipment(psseTransformer.getK(), id);
        this.checkControl(psseTransformer.getWinding1().getCont(), psseTransformer.getWinding1().getNode());
        this.checkControl(psseTransformer.getWinding2().getCont(), psseTransformer.getWinding2().getNode());
        this.checkControl(psseTransformer.getWinding3().getCont(), psseTransformer.getWinding3().getNode());
    }

    private static boolean validInternalConnectivity(PsseSubstation psseSubstation) {
        Set<Integer> nodesSet = psseSubstation.getNodes().stream().map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
        Pseudograph sGraph = new Pseudograph(null, null, false);
        nodesSet.forEach(arg_0 -> ((Graph)sGraph).addVertex(arg_0));
        psseSubstation.getSwitchingDevices().forEach(arg_0 -> NodeBreakerValidation.lambda$validInternalConnectivity$9((Graph)sGraph, arg_0));
        List connectedSets = new ConnectivityInspector((Graph)sGraph).connectedSets();
        for (Set connectedSet : connectedSets) {
            Set<Integer> associatedBuses = NodeBreakerValidation.findAssociatedBuses(psseSubstation, connectedSet);
            if (associatedBuses.size() == 1) continue;
            return false;
        }
        return true;
    }

    private static Set<Integer> findAssociatedBuses(PsseSubstation psseSubstation, Set<Integer> connectedSet) {
        return psseSubstation.getNodes().stream().filter(psseNode -> connectedSet.contains(psseNode.getNi())).map(PsseSubstation.PsseSubstationNode::getI).collect(Collectors.toSet());
    }

    private void fill(PsseSubstation psseSubstation) {
        Set<Integer> buses = psseSubstation.getNodes().stream().map(PsseSubstation.PsseSubstationNode::getI).collect(Collectors.toSet());
        buses.forEach(bus -> {
            this.busSubstations.computeIfAbsent((Integer)bus, k -> new ArrayList()).add(psseSubstation);
            Set nodesSet = psseSubstation.getNodes().stream().filter(psseNode -> psseNode.getI() == bus.intValue()).map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
            this.busNodesSet.put((Integer)bus, nodesSet);
        });
        this.substationBuses.put(psseSubstation, buses.stream().toList());
        psseSubstation.getEquipmentTerminals().forEach(equipmentTerminal -> {
            String equipmentId = AbstractConverter.getNodeBreakerEquipmentId(equipmentTerminal.getType(), equipmentTerminal.getI(), equipmentTerminal.getJ(), equipmentTerminal.getK(), equipmentTerminal.getId());
            this.busEquipmentTerminals.computeIfAbsent(equipmentTerminal.getI(), k -> new ArrayList()).add(equipmentId);
        });
    }

    private void checkEquipment(int bus, String equipmentId) {
        if (!this.validEquipment(bus, equipmentId)) {
            this.invalidateSubstationAssociatedWithBus(bus);
        }
    }

    private boolean validEquipment(int bus, String equipmentId) {
        return this.busEquipmentTerminals.containsKey(bus) && this.busEquipmentTerminals.get(bus).contains(equipmentId);
    }

    private void checkControl(int bus, int node) {
        if (!this.validControl(bus, node)) {
            this.invalidateSubstationAssociatedWithBus(bus);
        }
    }

    private boolean validControl(int bus, int node) {
        return bus == 0 || node == 0 || this.busNodesSet.containsKey(bus) && this.busNodesSet.get(bus).contains(node);
    }

    private void invalidateSubstationAssociatedWithBus(int bus) {
        if (this.busSubstations.containsKey(bus)) {
            this.invalidSubstations.addAll((Collection<PsseSubstation>)this.busSubstations.get(bus));
        }
    }

    List<PsseSubstation> getValidSubstations() {
        return this.substationBuses.keySet().stream().filter(psseSubstation -> !this.invalidSubstations.contains(psseSubstation)).toList();
    }

    List<Integer> getBuses(PsseSubstation psseSubstation) {
        return this.substationBuses.containsKey(psseSubstation) ? this.substationBuses.get(psseSubstation) : new ArrayList<Integer>();
    }

    Set<Integer> getValidSubstationsIds(Set<Integer> buses) {
        if (buses.stream().anyMatch(bus -> !this.busAssociatedWithValidSubstation((int)bus))) {
            return new HashSet<Integer>();
        }
        return buses.stream().filter(this.busSubstations::containsKey).flatMap(bus -> this.busSubstations.get(bus).stream()).map(PsseSubstation::getIs).collect(Collectors.toSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean busAssociatedWithValidSubstation(int bus) {
        if (!this.busSubstations.containsKey(bus)) return false;
        if (!this.busSubstations.get(bus).stream().noneMatch(this.invalidSubstations::contains)) return false;
        return true;
    }

    boolean isConsideredNodeBreaker(Set<Integer> busesSet) {
        return this.getValidSubstationsIds(busesSet).size() == 1;
    }

    Optional<PsseSubstation> getTheOnlySubstation(int bus) {
        return this.getTheOnlySubstation(Set.of(Integer.valueOf(bus)));
    }

    Optional<PsseSubstation> getTheOnlySubstation(Set<Integer> busesSet) {
        Set psseSubstationSet = busesSet.stream().filter(this.busSubstations::containsKey).flatMap(bus -> this.busSubstations.get(bus).stream()).filter(psseSubstation -> !this.invalidSubstations.contains(psseSubstation)).collect(Collectors.toSet());
        return psseSubstationSet.size() == 1 ? Optional.of((PsseSubstation)psseSubstationSet.iterator().next()) : Optional.empty();
    }

    private static /* synthetic */ void lambda$validInternalConnectivity$9(Graph sGraph, PsseSubstation.PsseSubstationSwitchingDevice switchingDevice) {
        sGraph.addEdge((Object)switchingDevice.getNi(), (Object)switchingDevice.getNj(), (Object)Pair.of((Object)switchingDevice.getNi(), (Object)switchingDevice.getNj()));
    }
}

