/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.iidm.network.util.TerminalFinder;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseBus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class SlackConverter
extends AbstractConverter {
    private final List<PsseBus> psseBusList;
    private final NodeBreakerImport nodeBreakerImport;

    SlackConverter(List<PsseBus> psseBusList, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseBusList = Objects.requireNonNull(psseBusList);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        this.psseBusList.stream().filter(psseBus -> psseBus.getIde() == 3).forEach(psseBus -> {
            Optional<NodeBreakerImport.ControlR> slackControlNode = this.nodeBreakerImport.getSlackControlNode(psseBus.getI());
            if (slackControlNode.isPresent()) {
                Terminal terminal = SlackConverter.findTerminalNode(this.getNetwork(), slackControlNode.get().voltageLevelId(), slackControlNode.get().node());
                VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(slackControlNode.get().voltageLevelId());
                if (voltageLevel != null && terminal != null) {
                    SlackTerminal.reset((VoltageLevel)voltageLevel, (Terminal)terminal);
                }
            } else {
                String busId = AbstractConverter.getBusId(psseBus.getI());
                Bus bus = this.getNetwork().getBusBreakerView().getBus(busId);
                if (SlackConverter.slackBusIsValidForIidm(bus)) {
                    SlackTerminal.attach((Bus)bus);
                }
            }
        });
    }

    private static boolean slackBusIsValidForIidm(Bus bus) {
        return bus != null && TerminalFinder.getDefault().find(bus.getConnectedTerminals()).isPresent();
    }
}

