/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwitchedShuntCompensatorConverter
extends AbstractConverter {
    private final PsseSwitchedShunt psseSwitchedShunt;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchedShuntCompensatorConverter.class);

    SwitchedShuntCompensatorConverter(PsseSwitchedShunt psseSwitchedShunt, ContainersMapping containerMapping, Network network, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseSwitchedShunt = Objects.requireNonNull(psseSwitchedShunt);
        this.version = Objects.requireNonNull(version);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseSwitchedShunt.getI())) {
            return;
        }
        List<ShuntBlock> shuntBlocks = SwitchedShuntCompensatorConverter.defineShuntBlocks(this.psseSwitchedShunt, this.version);
        if (shuntBlocks.isEmpty()) {
            return;
        }
        String id = SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version);
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseSwitchedShunt.getI()));
        ShuntCompensatorAdder adder = ((ShuntCompensatorAdder)voltageLevel.newShuntCompensator().setId(SwitchedShuntCompensatorConverter.getSwitchedShuntId(this.psseSwitchedShunt.getI(), id))).setSectionCount(SwitchedShuntCompensatorConverter.defineSectionCount(this.psseSwitchedShunt.getBinit(), shuntBlocks));
        String equipmentId = SwitchedShuntCompensatorConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_SWITCHED_SHUNT, this.psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version));
        OptionalInt node = this.nodeBreakerImport.getNode(SwitchedShuntCompensatorConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseSwitchedShunt.getI()));
        if (node.isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = SwitchedShuntCompensatorConverter.getBusId(this.psseSwitchedShunt.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseSwitchedShunt.getStat() == 1 ? busId : null);
        }
        ShuntCompensatorNonLinearModelAdder modelAdder = adder.newNonLinearModel();
        shuntBlocks.forEach(shuntBlock -> {
            for (int i = 0; i < shuntBlock.getN(); ++i) {
                modelAdder.beginSection().setG(0.0).setB(SwitchedShuntCompensatorConverter.powerToShuntAdmittance(shuntBlock.getB(), voltageLevel.getNominalV())).endSection();
            }
        });
        modelAdder.add();
        adder.add();
    }

    void addControl() {
        String id = SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version);
        ShuntCompensator shunt = this.getNetwork().getShuntCompensator(SwitchedShuntCompensatorConverter.getSwitchedShuntId(this.psseSwitchedShunt.getI(), id));
        if (shunt == null) {
            return;
        }
        Terminal regulatingTerminal = SwitchedShuntCompensatorConverter.defineRegulatingTerminal(this.psseSwitchedShunt, this.getNetwork(), shunt, this.version, this.nodeBreakerImport);
        if (regulatingTerminal == null) {
            return;
        }
        if (!SwitchedShuntCompensatorConverter.isControllingVoltage(this.psseSwitchedShunt)) {
            return;
        }
        boolean psseVoltageRegulatorOn = true;
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double vLow = this.psseSwitchedShunt.getVswlo() * vnom;
        double vHigh = this.psseSwitchedShunt.getVswhi() * vnom;
        double targetV = 0.5 * (vLow + vHigh);
        boolean voltageRegulatorOn = false;
        double targetDeadband = 0.0;
        if (targetV != 0.0) {
            targetDeadband = vHigh - vLow;
            voltageRegulatorOn = psseVoltageRegulatorOn;
        }
        shunt.setTargetV(targetV).setTargetDeadband(targetDeadband).setVoltageRegulatorOn(voltageRegulatorOn).setRegulatingTerminal(regulatingTerminal);
    }

    private static boolean isControllingVoltage(PsseSwitchedShunt psseSwitchedShunt) {
        return psseSwitchedShunt.getModsw() == 1 || psseSwitchedShunt.getModsw() == 2;
    }

    private static Terminal defineRegulatingTerminal(PsseSwitchedShunt psseSwitchedShunt, Network network, ShuntCompensator shunt, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = null;
        if (SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version) == 0) {
            regulatingTerminal = shunt.getTerminal();
        } else {
            Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version));
            if (control.isPresent()) {
                int controlledNode = psseSwitchedShunt.getNreg() != 0 ? psseSwitchedShunt.getNreg() : control.get().node();
                regulatingTerminal = SwitchedShuntCompensatorConverter.findTerminalNode(network, control.get().voltageLevelId(), controlledNode);
            } else {
                String regulatingBusId = SwitchedShuntCompensatorConverter.getBusId(SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version));
                Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
                if (bus != null) {
                    regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
                }
            }
        }
        if (regulatingTerminal == null) {
            String shuntId = SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version);
            LOGGER.warn("SwitchedShunt {}. Regulating terminal is not assigned", (Object)shuntId);
        }
        return regulatingTerminal;
    }

    private static int switchedShuntRegulatingBus(PsseSwitchedShunt switchedShunt, PsseVersion psseVersion) {
        if (psseVersion.major() == PsseVersion.Major.V35) {
            return switchedShunt.getSwreg();
        }
        return switchedShunt.getSwrem();
    }

    private static int defineSectionCount(double binit, List<ShuntBlock> shuntBlocks) {
        double maxDistance = Double.MAX_VALUE;
        int sectionCount = 0;
        for (int i = 0; i < shuntBlocks.size(); ++i) {
            double d = Math.abs(binit - shuntBlocks.get(i).getB());
            if (!(d < maxDistance)) continue;
            maxDistance = d;
            sectionCount = i + 1;
        }
        return sectionCount;
    }

    private static List<ShuntBlock> defineShuntBlocks(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        List<ShuntBlock> psseBlocks = SwitchedShuntCompensatorConverter.collectShuntBlocks(psseSwitchedShunt, version);
        List<ShuntBlock> psseReactorBlocks = psseBlocks.stream().filter(sb -> sb.getB() < 0.0).collect(Collectors.toList());
        List<ShuntBlock> psseCapacitorBlocks = psseBlocks.stream().filter(sb -> sb.getB() > 0.0).collect(Collectors.toList());
        if (psseSwitchedShunt.getAdjm() == 1) {
            psseReactorBlocks.sort(Comparator.comparing(ShuntBlock::getB).reversed());
            psseCapacitorBlocks.sort(Comparator.comparing(ShuntBlock::getB));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Switched combination not exactly supported ({})", (Object)SwitchedShuntCompensatorConverter.getSwitchedShuntId(psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version)));
            }
        }
        double bAdd = 0.0;
        ArrayList<ShuntBlock> shuntBlocks = new ArrayList<ShuntBlock>();
        bAdd = SwitchedShuntCompensatorConverter.addShuntBlocks(psseReactorBlocks, bAdd, shuntBlocks);
        if (psseSwitchedShunt.getAdjm() == 1) {
            bAdd = 0.0;
        }
        SwitchedShuntCompensatorConverter.addShuntBlocks(psseCapacitorBlocks, bAdd, shuntBlocks);
        shuntBlocks.add(new ShuntBlock(1, 1, 0.0));
        shuntBlocks.sort(Comparator.comparing(ShuntBlock::getB));
        return shuntBlocks;
    }

    private static double addShuntBlocks(List<ShuntBlock> psseShuntBlocks, double bAddInitial, List<ShuntBlock> shuntBlocks) {
        double bAdd = bAddInitial;
        if (!psseShuntBlocks.isEmpty()) {
            for (ShuntBlock psseCapacitorBlock : psseShuntBlocks) {
                for (int j = 0; j < psseCapacitorBlock.getN(); ++j) {
                    shuntBlocks.add(new ShuntBlock(1, 1, bAdd += psseCapacitorBlock.getB()));
                }
            }
        }
        return bAdd;
    }

    private static List<ShuntBlock> collectShuntBlocks(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        ArrayList<ShuntBlock> shuntBlocks = new ArrayList<ShuntBlock>();
        if (version.major() == PsseVersion.Major.V35) {
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS1(), psseSwitchedShunt.getN1(), psseSwitchedShunt.getB1());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS2(), psseSwitchedShunt.getN2(), psseSwitchedShunt.getB2());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS3(), psseSwitchedShunt.getN3(), psseSwitchedShunt.getB3());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS4(), psseSwitchedShunt.getN4(), psseSwitchedShunt.getB4());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS5(), psseSwitchedShunt.getN5(), psseSwitchedShunt.getB5());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS6(), psseSwitchedShunt.getN6(), psseSwitchedShunt.getB6());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS7(), psseSwitchedShunt.getN7(), psseSwitchedShunt.getB7());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS8(), psseSwitchedShunt.getN8(), psseSwitchedShunt.getB8());
        } else {
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN1(), psseSwitchedShunt.getB1());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN2(), psseSwitchedShunt.getB2());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN3(), psseSwitchedShunt.getB3());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN4(), psseSwitchedShunt.getB4());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN5(), psseSwitchedShunt.getB5());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN6(), psseSwitchedShunt.getB6());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN7(), psseSwitchedShunt.getB7());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN8(), psseSwitchedShunt.getB8());
        }
        return shuntBlocks;
    }

    private static void addShuntBlock(List<ShuntBlock> shuntBlocks, int s, int n, double b) {
        if (s == 0 || n == 0 || b == 0.0) {
            return;
        }
        shuntBlocks.add(new ShuntBlock(s, n, b));
    }

    private static String defineShuntId(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        if (version.major() == PsseVersion.Major.V35) {
            return psseSwitchedShunt.getId();
        }
        return "1";
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        PsseVersion version = PsseVersion.fromRevision((float)psseModel.getCaseIdentification().getRev());
        psseModel.getSwitchedShunts().forEach(psseSwitchedShunt -> {
            String switchedShuntId = SwitchedShuntCompensatorConverter.getSwitchedShuntId(psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version));
            ShuntCompensator switchedShunt = network.getShuntCompensator(switchedShuntId);
            if (switchedShunt == null) {
                psseSwitchedShunt.setStat(0);
            } else {
                psseSwitchedShunt.setStat(SwitchedShuntCompensatorConverter.getStatus(switchedShunt));
                psseSwitchedShunt.setBinit(SwitchedShuntCompensatorConverter.getQ(switchedShunt));
            }
        });
    }

    private static double getQ(ShuntCompensator switchedShunt) {
        return SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(switchedShunt.getB(switchedShunt.getSectionCount()), switchedShunt.getTerminal().getVoltageLevel().getNominalV());
    }

    static class ShuntBlock {
        int s;
        int n;
        double b;

        ShuntBlock(int s, int n, double b) {
            this.s = s;
            this.n = n;
            this.b = b;
        }

        int getS() {
            return this.s;
        }

        int getN() {
            return this.n;
        }

        double getB() {
            return this.b;
        }
    }
}

