/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcConverter;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import java.util.Objects;
import java.util.OptionalInt;

class TwoTerminalDcConverter
extends AbstractConverter {
    private static final double DEFAULT_MAXP_FACTOR = 1.2;
    private final PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc;
    private final NodeBreakerImport nodeBreakerImport;

    TwoTerminalDcConverter(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseTwoTerminalDc = Objects.requireNonNull(psseTwoTerminalDc);
        this.nodeBreakerImport = nodeBreakerImport;
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseTwoTerminalDc.getRectifier().getIp()) || !this.getContainersMapping().isBusDefined(this.psseTwoTerminalDc.getInverter().getIp())) {
            return;
        }
        double lossFactor = 0.0;
        String busIdR = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getRectifier().getIp());
        VoltageLevel voltageLevelR = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getRectifier().getIp()));
        LccConverterStationAdder adderR = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelR.newLccConverterStation().setId(TwoTerminalDcConverter.getLccConverterId(this.getNetwork(), this.psseTwoTerminalDc, this.psseTwoTerminalDc.getRectifier()))).setName(this.psseTwoTerminalDc.getName())).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getRectifier()));
        String equipmentIdR = TwoTerminalDcConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, this.psseTwoTerminalDc.getRectifier().getIp(), this.psseTwoTerminalDc.getName());
        OptionalInt nodeR = this.nodeBreakerImport.getNode(TwoTerminalDcConverter.getNodeBreakerEquipmentIdBus(equipmentIdR, this.psseTwoTerminalDc.getRectifier().getIp()));
        if (nodeR.isPresent()) {
            adderR.setNode(nodeR.getAsInt());
        } else {
            adderR.setConnectableBus(busIdR);
            adderR.setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdR);
        }
        LccConverterStation cR = adderR.add();
        String busIdI = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getInverter().getIp());
        VoltageLevel voltageLevelI = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getInverter().getIp()));
        LccConverterStationAdder adderI = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelI.newLccConverterStation().setId(TwoTerminalDcConverter.getLccConverterId(this.getNetwork(), this.psseTwoTerminalDc, this.psseTwoTerminalDc.getInverter()))).setName(this.psseTwoTerminalDc.getName())).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getInverter()));
        String equipmentIdI = TwoTerminalDcConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, this.psseTwoTerminalDc.getInverter().getIp(), this.psseTwoTerminalDc.getName());
        OptionalInt nodeI = this.nodeBreakerImport.getNode(TwoTerminalDcConverter.getNodeBreakerEquipmentIdBus(equipmentIdI, this.psseTwoTerminalDc.getInverter().getIp()));
        if (nodeI.isPresent()) {
            adderI.setNode(nodeI.getAsInt());
        } else {
            adderI.setConnectableBus(busIdI);
            adderI.setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdI);
        }
        LccConverterStation cI = adderI.add();
        HvdcLineAdder adder = ((HvdcLineAdder)((HvdcLineAdder)this.getNetwork().newHvdcLine().setId(TwoTerminalDcConverter.getTwoTerminalDcId(this.psseTwoTerminalDc.getName()))).setName(this.psseTwoTerminalDc.getName())).setR(this.psseTwoTerminalDc.getRdc()).setNominalV(this.psseTwoTerminalDc.getVschd()).setActivePowerSetpoint(TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(this.psseTwoTerminalDc)).setMaxP(TwoTerminalDcConverter.getTwoTerminalDcMaxP(this.psseTwoTerminalDc)).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setConverterStationId1(cR.getId()).setConverterStationId2(cI.getId());
        adder.add();
    }

    private static double getTwoTerminalDcActivePowerSetpoint(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return switch (psseTwoTerminalDc.getMdc()) {
            case 1 -> Math.abs(psseTwoTerminalDc.getSetvl());
            case 2 -> TwoTerminalDcConverter.currentInAmpsToMw(psseTwoTerminalDc.getSetvl(), psseTwoTerminalDc.getVschd());
            default -> 0.0;
        };
    }

    private static double getTwoTerminalDcMaxP(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(psseTwoTerminalDc) * 1.2;
    }

    private static double getLccConverterPowerFactor(PsseTwoTerminalDcConverter converter) {
        return 0.5 * (Math.cos(Math.toRadians(converter.getAnmx())) + Math.cos(Math.toRadians(60.0)));
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getTwoTerminalDcTransmissionLines().forEach(psseTwoTerminalDc -> {
            String hvdcId = TwoTerminalDcConverter.getTwoTerminalDcId(psseTwoTerminalDc.getName());
            HvdcLine hvdcLine = network.getHvdcLine(hvdcId);
            if (hvdcLine == null) {
                psseTwoTerminalDc.setMdc(0);
            } else {
                psseTwoTerminalDc.setMdc(TwoTerminalDcConverter.findControlMode(hvdcLine, psseTwoTerminalDc.getMdc()));
            }
        });
    }

    private static int findControlMode(HvdcLine hvdcLine, int mdc) {
        if (hvdcLine.getConverterStation1().getTerminal().isConnected() && hvdcLine.getConverterStation1().getTerminal().getBusBreakerView().getBus() != null && hvdcLine.getConverterStation2().getTerminal().isConnected() && hvdcLine.getConverterStation2().getTerminal().getBusBreakerView().getBus() != null) {
            return mdc != 0 ? mdc : 1;
        }
        return 0;
    }
}

