/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.converter.NodeBreakerValidation;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSubstation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class VoltageLevelConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final NodeBreakerValidation nodeBreakerValidation;
    private final NodeBreakerImport nodeBreakerImport;

    VoltageLevelConverter(PsseBus psseBus, ContainersMapping containerMapping, PsseImporter.PerUnitContext perUnitContext, Network network, NodeBreakerValidation nodeBreakerValidation, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.nodeBreakerValidation = Objects.requireNonNull(nodeBreakerValidation);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    VoltageLevel create(Substation substation) {
        String voltageLevelId = this.getContainersMapping().getVoltageLevelId(this.psseBus.getI());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(voltageLevelId);
        if (voltageLevel == null) {
            double nominalV = VoltageLevelConverter.getNominalV(this.psseBus, this.perUnitContext.ignoreBaseVoltage());
            boolean isNodeBreakerValid = this.nodeBreakerValidation.isConsideredNodeBreaker(this.getContainersMapping().getBusesSet(voltageLevelId));
            TopologyKind topologyKind = isNodeBreakerValid ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER;
            voltageLevel = ((VoltageLevelAdder)substation.newVoltageLevel().setId(voltageLevelId)).setNominalV(nominalV).setTopologyKind(topologyKind).add();
            if (isNodeBreakerValid) {
                this.addNodeBreakerConnectivity(voltageLevelId, voltageLevel, this.nodeBreakerValidation, this.nodeBreakerImport);
            }
        }
        if (voltageLevel.getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER) && this.psseBus.getIde() == 3) {
            this.nodeBreakerImport.addSlackControl(this.psseBus.getI(), voltageLevelId, VoltageLevelConverter.findSlackNode(this.nodeBreakerValidation, this.psseBus.getI()));
        }
        return voltageLevel;
    }

    static double getNominalV(PsseBus psseBus, boolean isIgnoreBaseVoltage) {
        return isIgnoreBaseVoltage || psseBus.getBaskv() == 0.0 ? 1.0 : psseBus.getBaskv();
    }

    private void addNodeBreakerConnectivity(String voltageLevelId, VoltageLevel voltageLevel, NodeBreakerValidation nodeBreakerValidation, NodeBreakerImport nodeBreakerImport) {
        Set buses = this.getContainersMapping().getBusesSet(voltageLevelId);
        nodeBreakerImport.addTopologicalBuses(buses);
        Optional<PsseSubstation> psseSubstation = nodeBreakerValidation.getTheOnlySubstation(buses);
        if (psseSubstation.isPresent()) {
            int lastNode = psseSubstation.get().getNodes().stream().map(PsseSubstation.PsseSubstationNode::getNi).max(Comparator.naturalOrder()).orElseThrow();
            Iterator iterator = buses.iterator();
            while (iterator.hasNext()) {
                int bus = (Integer)iterator.next();
                lastNode = VoltageLevelConverter.addNodeBreakerConnectivity(voltageLevelId, voltageLevel, psseSubstation.get(), bus, lastNode, nodeBreakerImport);
            }
        }
    }

    private static int addNodeBreakerConnectivity(String voltageLevelId, VoltageLevel voltageLevel, PsseSubstation psseSubstation, int bus, int lastNodeInternalConnections, NodeBreakerImport nodeBreakerImport) {
        Set nodesSet = psseSubstation.getNodes().stream().filter(psseNode -> psseNode.getI() == bus).map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
        List<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceList = psseSubstation.getSwitchingDevices().stream().filter(sd -> nodesSet.contains(sd.getNi()) && nodesSet.contains(sd.getNj())).sorted(Comparator.comparing(VoltageLevelConverter::switchingDeviceString)).toList();
        for (PsseSubstation.PsseSubstationSwitchingDevice switchingDevice : switchingDeviceList) {
            ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)voltageLevel.getNodeBreakerView().newSwitch().setId(VoltageLevelConverter.getSwitchId(voltageLevelId, switchingDevice))).setName(switchingDevice.getName())).setNode1(switchingDevice.getNi()).setNode2(switchingDevice.getNj()).setKind(VoltageLevelConverter.findSwitchingKind(switchingDevice.getType())).setOpen(switchingDevice.getStatus() != 1).add();
        }
        HashSet<Integer> nodesWithEquipment = new HashSet<Integer>();
        List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList = psseSubstation.getEquipmentTerminals().stream().filter(eqt -> nodesSet.contains(eqt.getNi())).toList();
        int lastNode = lastNodeInternalConnections;
        for (PsseSubstation.PsseSubstationEquipmentTerminal equipmentTerminal : equipmentTerminalList) {
            String equipmentId = VoltageLevelConverter.getNodeBreakerEquipmentId(equipmentTerminal.getType(), equipmentTerminal.getI(), equipmentTerminal.getJ(), equipmentTerminal.getK(), equipmentTerminal.getId());
            String equipmentIdBus = VoltageLevelConverter.getNodeBreakerEquipmentIdBus(equipmentId, bus);
            if (nodesWithEquipment.contains(equipmentTerminal.getNi())) {
                voltageLevel.getNodeBreakerView().newInternalConnection().setNode1(equipmentTerminal.getNi()).setNode2(++lastNode).add();
                nodeBreakerImport.addEquipment(equipmentIdBus, lastNode);
                continue;
            }
            nodeBreakerImport.addEquipment(equipmentIdBus, equipmentTerminal.getNi());
            nodesWithEquipment.add(equipmentTerminal.getNi());
        }
        psseSubstation.getNodes().stream().filter(psseNode -> nodesSet.contains(psseNode.getNi()) && !nodesWithEquipment.contains(psseNode.getNi())).forEach(psseNode -> ((BusbarSectionAdder)((BusbarSectionAdder)voltageLevel.getNodeBreakerView().newBusbarSection().setId(VoltageLevelConverter.busbarSectionId(voltageLevel.getId(), psseNode.getNi()))).setName(psseNode.getName())).setNode(psseNode.getNi()).add());
        psseSubstation.getNodes().stream().filter(psseNode -> nodesSet.contains(psseNode.getNi())).forEach(psseNode -> VoltageLevelConverter.findBusViewNode(voltageLevel, psseNode.getNi()).ifPresent(busView -> {
            busView.setV(psseNode.getVm() * voltageLevel.getNominalV());
            busView.setAngle(psseNode.getVa());
        }));
        int defaultNode = (Integer)nodesSet.stream().sorted().findFirst().orElseThrow();
        nodeBreakerImport.addBusControl(bus, voltageLevelId, defaultNode);
        return lastNode;
    }

    private static String switchingDeviceString(PsseSubstation.PsseSubstationSwitchingDevice switchingDevice) {
        return switchingDevice.getNi() + "-" + switchingDevice.getNj() + "-" + switchingDevice.getCkt();
    }

    private static SwitchKind findSwitchingKind(int type) {
        return type == 2 ? SwitchKind.BREAKER : SwitchKind.DISCONNECTOR;
    }

    private static int findSlackNode(NodeBreakerValidation nodeBreakerValidation, int bus) {
        PsseSubstation psseSubstation = nodeBreakerValidation.getTheOnlySubstation(bus).orElseThrow();
        return psseSubstation.getNodes().stream().filter(n -> n.getI() == bus).map(PsseSubstation.PsseSubstationNode::getNi).min(Comparator.comparingInt(node -> VoltageLevelConverter.connectedGenerators(psseSubstation, node)).reversed().thenComparing(Comparator.naturalOrder())).orElseThrow();
    }

    private static int connectedGenerators(PsseSubstation psseSubstation, int node) {
        return (int)psseSubstation.getEquipmentTerminals().stream().filter(eqt -> eqt.getNi() == node && eqt.getType().equals(AbstractConverter.PsseEquipmentType.PSSE_GENERATOR.getTextCode())).count();
    }

    static ContextExport createContextExport(Network network, PssePowerFlowModel psseModel) {
        ContextExport contextExport = new ContextExport();
        VoltageLevelConverter.mapVoltageLevelsAndPsseSubstation(network, psseModel, contextExport);
        VoltageLevelConverter.getSortedVoltageLevels(network).forEach(voltageLevel -> {
            if (VoltageLevelConverter.exportVoltageLevelAsNodeBreaker(voltageLevel)) {
                VoltageLevelConverter.createNodeBreakerContextExport(voltageLevel, contextExport);
            } else {
                VoltageLevelConverter.createBusBranchContextExport(voltageLevel, contextExport);
            }
        });
        return contextExport;
    }

    private static List<VoltageLevel> getSortedVoltageLevels(Network network) {
        return network.getVoltageLevelStream().sorted(Comparator.comparingInt(VoltageLevelConverter::minBus).thenComparing(Identifiable::getId)).toList();
    }

    private static int minBus(VoltageLevel voltageLevel) {
        List<Integer> buses = VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId());
        return buses.isEmpty() ? Integer.MAX_VALUE : buses.get(0);
    }

    private static void mapVoltageLevelsAndPsseSubstation(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        HashMap busPsseSubstation = new HashMap();
        psseModel.getSubstations().forEach(psseSubstation -> {
            Set<Integer> buses = psseSubstation.getNodes().stream().map(PsseSubstation.PsseSubstationNode::getI).collect(Collectors.toSet());
            buses.forEach(bus -> busPsseSubstation.put(bus, psseSubstation));
        });
        network.getVoltageLevels().forEach(voltageLevel -> VoltageLevelConverter.getVoltageLevelPsseSubstation(voltageLevel, busPsseSubstation).ifPresent(psseSubstation -> contextExport.getUpdateExport().addVoltageLevelPsseSubstation((VoltageLevel)voltageLevel, (PsseSubstation)psseSubstation)));
    }

    private static Optional<PsseSubstation> getVoltageLevelPsseSubstation(VoltageLevel voltageLevel, Map<Integer, PsseSubstation> busPsseSubstation) {
        List<Integer> buses = VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId());
        Set psseSubstationSet = buses.stream().filter(busPsseSubstation::containsKey).map(busPsseSubstation::get).collect(Collectors.toSet());
        if (psseSubstationSet.size() > 1) {
            throw new PsseException("Only one PsseSubstation is allowed per VoltageLevel. VoltageLevelId: " + voltageLevel.getId());
        }
        return psseSubstationSet.stream().findFirst();
    }

    private static void createBusBranchContextExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        voltageLevel.getBusBreakerView().getBuses().forEach(busBreakerViewBus -> Optional.ofNullable(voltageLevel.getBusView().getMergedBus(busBreakerViewBus.getId())).ifPresent(mergedBus -> VoltageLevelConverter.extractBusNumber(busBreakerViewBus.getId()).ifPresent(busI -> contextExport.getLinkExport().addBusIBusViewLink(busI, (Bus)mergedBus))));
    }

    private static void createNodeBreakerContextExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        HashMap<Integer, List> busIBusViews = new HashMap<Integer, List>();
        PsseSubstation psseSubstation = contextExport.getUpdateExport().getPsseSubstation(voltageLevel).orElseThrow();
        for (int node : voltageLevel.getNodeBreakerView().getNodes()) {
            VoltageLevelConverter.findBusViewNode(voltageLevel, node).ifPresent(bus -> {
                contextExport.getLinkExport().addNodeBusViewLink(voltageLevel, node, (Bus)bus);
                VoltageLevelConverter.findBusI(psseSubstation, node).ifPresent(busI -> busIBusViews.computeIfAbsent((Integer)busI, k -> new ArrayList()).add(bus));
            });
        }
        busIBusViews.forEach((busI, busList) -> {
            Bus selectedBus = busList.stream().min(Comparator.comparingInt(busView -> VoltageLevelConverter.findPriorityType(voltageLevel, busView))).orElseThrow();
            contextExport.getLinkExport().addBusIBusViewLink((int)busI, selectedBus);
        });
    }

    private static int findPriorityType(VoltageLevel voltageLevel, Bus busView) {
        int type = VoltageLevelConverter.findBusViewBusType(voltageLevel, busView);
        return switch (type) {
            case 3 -> 0;
            case 2 -> 1;
            case 1 -> 2;
            case 4 -> 3;
            default -> throw new PsseException("Unexpected psse bus type: " + type);
        };
    }

    private static Optional<Integer> findBusI(PsseSubstation psseSubstation, int node) {
        return psseSubstation.getNodes().stream().filter(psseNode -> psseNode.getNi() == node).map(PsseSubstation.PsseSubstationNode::getI).findFirst();
    }

    static void updateSubstations(Network network, ContextExport contextExport) {
        network.getVoltageLevels().forEach(voltageLevel -> {
            if (voltageLevel.getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER)) {
                HashSet<Integer> buses = new HashSet<Integer>(VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId()));
                contextExport.getUpdateExport().getPsseSubstation((VoltageLevel)voltageLevel).ifPresent(psseSubstation -> VoltageLevelConverter.updateSubstation(voltageLevel, psseSubstation, buses, contextExport));
            }
        });
    }

    private static void updateSubstation(VoltageLevel voltageLevel, PsseSubstation psseSubstation, Set<Integer> busesSet, ContextExport contextExport) {
        Set<PsseSubstation.PsseSubstationNode> psseNodeSet = psseSubstation.getNodes().stream().filter(psseNode -> busesSet.contains(psseNode.getI())).collect(Collectors.toSet());
        psseNodeSet.forEach(psseSubstationNode -> {
            Optional<Bus> busView = contextExport.getLinkExport().getBusView(voltageLevel, psseSubstationNode.getNi());
            if (busView.isPresent()) {
                psseSubstationNode.setVm(VoltageLevelConverter.getVm(busView.get()));
                psseSubstationNode.setVa(VoltageLevelConverter.getVa(busView.get()));
            } else {
                psseSubstationNode.setVm(1.0);
                psseSubstationNode.setVa(0.0);
            }
        });
        Set nodesSet = psseNodeSet.stream().map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
        Set<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceSet = psseSubstation.getSwitchingDevices().stream().filter(sd -> nodesSet.contains(sd.getNi()) && nodesSet.contains(sd.getNj())).collect(Collectors.toSet());
        switchingDeviceSet.forEach(switchingDevice -> {
            String switchId = VoltageLevelConverter.getSwitchId(voltageLevel.getId(), switchingDevice);
            Switch sw = voltageLevel.getNodeBreakerView().getSwitch(switchId);
            if (sw == null) {
                throw new PsseException("Unexpected null breaker: " + switchId);
            }
            switchingDevice.setStatus(sw.isOpen() ? 0 : 1);
        });
    }
}

