/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.pf.PsseSubstation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Stream;

final class ContextExport {
    private final boolean isFullExport;
    private final UpdateExport updateExport;
    private final FullExport fullExport;

    ContextExport(boolean isFullExport) {
        this.isFullExport = isFullExport;
        this.updateExport = new UpdateExport();
        this.fullExport = new FullExport();
    }

    boolean isFullExport() {
        return this.isFullExport;
    }

    UpdateExport getUpdateExport() {
        return this.updateExport;
    }

    FullExport getFullExport() {
        return this.fullExport;
    }

    static class UpdateExport {
        private final Map<Integer, Bus> busIBusView = new HashMap<Integer, Bus>();
        private final Map<String, Bus> voltageLevelNodeIdBusView = new HashMap<String, Bus>();
        private final Map<VoltageLevel, PsseSubstation> voltageLevelPsseSubstation = new HashMap<VoltageLevel, PsseSubstation>();

        UpdateExport() {
        }

        void addBusIBusView(int busI, Bus busView) {
            this.busIBusView.put(busI, busView);
        }

        Optional<Bus> getBusView(int busI) {
            return this.busIBusView.containsKey(busI) ? Optional.of(this.busIBusView.get(busI)) : Optional.empty();
        }

        void addNodeBusView(VoltageLevel voltageLevel, int node, Bus busView) {
            this.voltageLevelNodeIdBusView.put(AbstractConverter.getNodeId(voltageLevel, node), busView);
        }

        Optional<Bus> getBusView(VoltageLevel voltageLevel, int node) {
            return Optional.ofNullable(this.voltageLevelNodeIdBusView.get(AbstractConverter.getNodeId(voltageLevel, node)));
        }

        void addVoltageLevelPsseSubstation(VoltageLevel voltageLevel, PsseSubstation psseSubstation) {
            this.voltageLevelPsseSubstation.put(voltageLevel, psseSubstation);
        }

        Optional<PsseSubstation> getPsseSubstation(VoltageLevel voltageLevel) {
            return Optional.ofNullable(this.voltageLevelPsseSubstation.get(voltageLevel));
        }
    }

    static class FullExport {
        private int maxPsseBus = 0;
        private int maxPsseSubstation = 0;
        private final Map<Bus, Integer> busViewBusI = new HashMap<Bus, Integer>();
        private final Map<Integer, Bus> busIBusView = new HashMap<Integer, Bus>();
        private final Map<DanglingLine, Integer> danglingLineBusI = new HashMap<DanglingLine, Integer>();
        private final Map<String, NodeData> voltageLevelNodeIdNodeData = new HashMap<String, NodeData>();
        private final Map<String, Integer> psseSubstationIdLastPsseNode = new HashMap<String, Integer>();
        private final Map<String, Set<VoltageLevel>> psseSubstationIdVoltageLevels = new HashMap<String, Set<VoltageLevel>>();
        private final Set<VoltageLevel> voltageLevelsExportedAsNodeBreaker = new HashSet<VoltageLevel>();
        private final Map<String, String> equipmentIdCkt = new HashMap<String, String>();
        private final Map<String, Integer> equipmentBusesIdMaxCkt = new HashMap<String, Integer>();

        FullExport() {
        }

        int getNewPsseBusI() {
            return ++this.maxPsseBus;
        }

        int getNewPsseSubstationIs() {
            return ++this.maxPsseSubstation;
        }

        void addBusIBusView(int busI, Bus busView) {
            this.busIBusView.put(busI, busView);
            if (busView != null) {
                this.busViewBusI.put(busView, busI);
            }
        }

        void addDanglingLineBusI(DanglingLine danglingLine, int busI) {
            this.danglingLineBusI.put(danglingLine, busI);
        }

        Set<Integer> getBusISet() {
            return this.busIBusView.keySet();
        }

        OptionalInt getBusI(Bus busView) {
            return Optional.ofNullable(this.busViewBusI.get(busView)).map(OptionalInt::of).orElse(OptionalInt.empty());
        }

        OptionalInt getBusI(DanglingLine danglingLine) {
            return Optional.ofNullable(this.danglingLineBusI.get(danglingLine)).map(OptionalInt::of).orElse(OptionalInt.empty());
        }

        Optional<Bus> getBusView(int busI) {
            return Optional.ofNullable(this.busIBusView.get(busI));
        }

        void addNodeData(VoltageLevel voltageLevel, int node, int psseBusI, int psseNode, Bus voltageBusViewBus) {
            this.voltageLevelNodeIdNodeData.put(AbstractConverter.getNodeId(voltageLevel, node), new NodeData(voltageLevel, node, psseBusI, psseNode, voltageBusViewBus));
        }

        OptionalInt getBusI(VoltageLevel voltageLevel, int node) {
            String voltageLevelNodeId = AbstractConverter.getNodeId(voltageLevel, node);
            return Optional.ofNullable(this.voltageLevelNodeIdNodeData.get(voltageLevelNodeId)).map(nodeData -> OptionalInt.of(nodeData.psseBusI)).orElse(OptionalInt.empty());
        }

        OptionalInt getPsseNode(VoltageLevel voltageLevel, int node) {
            String voltageLevelNodeId = AbstractConverter.getNodeId(voltageLevel, node);
            return Optional.ofNullable(this.voltageLevelNodeIdNodeData.get(voltageLevelNodeId)).map(nodeData -> OptionalInt.of(nodeData.psseNode)).orElse(OptionalInt.empty());
        }

        Optional<Bus> getVoltageBus(VoltageLevel voltageLevel, int node) {
            String voltageLevelNodeId = AbstractConverter.getNodeId(voltageLevel, node);
            return Optional.ofNullable(this.voltageLevelNodeIdNodeData.get(voltageLevelNodeId)).map(nodeData -> nodeData.voltageBusViewBus);
        }

        boolean isDeEnergized(VoltageLevel voltageLevel, int node) {
            return this.getVoltageBus(voltageLevel, node).map(bus -> bus.getV() == 0.0 && bus.getAngle() == 0.0).orElse(true);
        }

        Optional<VoltageLevel> getVoltageLevel(int busI) {
            return this.voltageLevelNodeIdNodeData.values().stream().filter(nodeData -> nodeData.psseBusI == busI).map(nodeData -> nodeData.voltageLevel).findFirst();
        }

        OptionalInt getNode(int busI) {
            return this.voltageLevelNodeIdNodeData.values().stream().filter(nodeData -> nodeData.psseBusI == busI).mapToInt(nodeData -> nodeData.node).findFirst();
        }

        int getNewPsseNode(String psseSubstationId) {
            int newPsseNode = this.getLastPsseNode(psseSubstationId) + 1;
            this.psseSubstationIdLastPsseNode.put(psseSubstationId, newPsseNode);
            return newPsseNode;
        }

        int getLastPsseNode(String psseSubstationId) {
            return this.psseSubstationIdLastPsseNode.getOrDefault(psseSubstationId, 0);
        }

        void addPsseSubstationIdVoltageLevel(String psseSubstationId, VoltageLevel voltageLevel) {
            this.psseSubstationIdVoltageLevels.computeIfAbsent(psseSubstationId, k -> new HashSet()).add(voltageLevel);
            this.voltageLevelsExportedAsNodeBreaker.add(voltageLevel);
        }

        List<String> getSortedPsseSubstationIds() {
            return this.psseSubstationIdVoltageLevels.keySet().stream().sorted().toList();
        }

        Set<VoltageLevel> getVoltageLevelSet(String psseSubstationId) {
            return this.psseSubstationIdVoltageLevels.getOrDefault(psseSubstationId, Collections.emptySet());
        }

        boolean isExportedAsNodeBreaker(VoltageLevel voltageLevel) {
            return this.voltageLevelsExportedAsNodeBreaker.contains(voltageLevel);
        }

        String getEquipmentCkt(String equipmentId, String psseEquipmentType, int busI) {
            return this.getEquipmentCkt(null, equipmentId, psseEquipmentType, busI, 0, 0);
        }

        String getEquipmentCkt(VoltageLevel voltageLevel, String equipmentId, int busI, int busJ) {
            return this.getEquipmentCkt(voltageLevel, equipmentId, IdentifiableType.SWITCH.name(), busI, busJ, 0);
        }

        String getEquipmentCkt(String equipmentId, String psseEquipmentType, int busI, int busJ) {
            return this.getEquipmentCkt(null, equipmentId, psseEquipmentType, busI, busJ, 0);
        }

        String getEquipmentCkt(String equipmentId, String psseEquipmentType, int busI, int busJ, int busK) {
            return this.getEquipmentCkt(null, equipmentId, psseEquipmentType, busI, busJ, busK);
        }

        private String getEquipmentCkt(VoltageLevel voltageLevel, String equipmentId, String psseEquipmentType, int busI, int busJ, int busK) {
            if (this.equipmentIdCkt.containsKey(equipmentId)) {
                return this.equipmentIdCkt.get(equipmentId);
            }
            String equipmentBusesId = FullExport.getEquipmentBusesId(equipmentId, FullExport.getVoltageLevelType(voltageLevel, psseEquipmentType), busI, busJ, busK);
            int cktInteger = this.getNewCkt(equipmentBusesId);
            String cktString = String.format("%02d", cktInteger);
            this.addCkt(equipmentId, equipmentBusesId, cktInteger, cktString);
            return cktString;
        }

        private void addCkt(String equipmentId, String equipmentBusesId, int maxCkt, String ckt) {
            this.equipmentBusesIdMaxCkt.put(equipmentBusesId, maxCkt);
            this.equipmentIdCkt.put(equipmentId, ckt);
        }

        private int getNewCkt(String equipmentBusesId) {
            return this.equipmentBusesIdMaxCkt.containsKey(equipmentBusesId) ? this.equipmentBusesIdMaxCkt.get(equipmentBusesId) + 1 : 1;
        }

        private static String getVoltageLevelType(VoltageLevel voltageLevel, String psseEquipmentType) {
            return voltageLevel != null ? voltageLevel.getId() + "-" + psseEquipmentType : psseEquipmentType;
        }

        private static String getEquipmentBusesId(String equipmentId, String type, int busI, int busJ, int busK) {
            List<Integer> sortedBuses = Stream.of(busI, busJ, busK).filter(bus -> bus != 0).sorted().toList();
            if (sortedBuses.size() == 1) {
                return type + "-" + sortedBuses.get(0);
            }
            if (sortedBuses.size() == 2) {
                return type + "-" + sortedBuses.get(0) + "-" + sortedBuses.get(1);
            }
            if (sortedBuses.size() == 3) {
                return type + "-" + sortedBuses.get(0) + "-" + sortedBuses.get(1) + "-" + sortedBuses.get(2);
            }
            throw new PsseException("All the buses are zero. EquipmentId: " + equipmentId);
        }

        private record NodeData(VoltageLevel voltageLevel, int node, int psseBusI, int psseNode, Bus voltageBusViewBus) {
        }
    }
}

