/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseFacts;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FactsDeviceConverter
extends AbstractConverter {
    private final PsseFacts psseFactsDevice;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(FactsDeviceConverter.class);

    FactsDeviceConverter(PsseFacts psseFactsDevice, ContainersMapping containerMapping, Network network, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseFactsDevice = Objects.requireNonNull(psseFactsDevice);
        this.version = version;
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseFactsDevice.getI())) {
            return;
        }
        if (FactsDeviceConverter.isStatCom(this.psseFactsDevice)) {
            this.createStatCom();
        }
    }

    private void createStatCom() {
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseFactsDevice.getI()));
        double maxReactivePower = this.psseFactsDevice.getShmx();
        double bMax = FactsDeviceConverter.powerToShuntAdmittance(maxReactivePower, voltageLevel.getNominalV());
        StaticVarCompensatorAdder adder = ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)voltageLevel.newStaticVarCompensator().setId(FactsDeviceConverter.getFactsDeviceId(this.psseFactsDevice.getName()))).setName(this.psseFactsDevice.getName())).setRegulating(false).setRegulationMode(StaticVarCompensator.RegulationMode.REACTIVE_POWER).setBmin(-bMax).setBmax(bMax);
        String equipmentId = FactsDeviceConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_FACTS_DEVICE, this.psseFactsDevice.getI(), this.psseFactsDevice.getJ(), this.psseFactsDevice.getName());
        OptionalInt node = this.nodeBreakerImport.getNode(FactsDeviceConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseFactsDevice.getI(), 0, 0, this.psseFactsDevice.getI(), "I"));
        if (node.isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = FactsDeviceConverter.getBusId(this.psseFactsDevice.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseFactsDevice.getMode() == 0 ? null : busId);
        }
        adder.add();
    }

    void addControl() {
        StaticVarCompensator staticVarCompensator = this.getNetwork().getStaticVarCompensator(FactsDeviceConverter.getFactsDeviceId(this.psseFactsDevice.getName()));
        if (staticVarCompensator == null) {
            return;
        }
        Terminal regulatingTerminal = FactsDeviceConverter.defineRegulatingTerminal(this.psseFactsDevice, this.getNetwork(), staticVarCompensator, this.version, this.nodeBreakerImport);
        if (regulatingTerminal == null) {
            return;
        }
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double targetQ = this.psseFactsDevice.getQdes();
        double targetV = this.psseFactsDevice.getVset() * vnom;
        boolean isRegulating = false;
        StaticVarCompensator.RegulationMode regulationMode = StaticVarCompensator.RegulationMode.REACTIVE_POWER;
        if (Double.isFinite(targetV) && targetV > 0.0) {
            regulationMode = StaticVarCompensator.RegulationMode.VOLTAGE;
            isRegulating = true;
        } else if (Double.isFinite(targetQ)) {
            isRegulating = true;
        }
        staticVarCompensator.setVoltageSetpoint(targetV).setReactivePowerSetpoint(targetQ).setRegulatingTerminal(regulatingTerminal).setRegulationMode(regulationMode).setRegulating(isRegulating);
    }

    private static Terminal defineRegulatingTerminal(PsseFacts psseFactsDevice, Network network, StaticVarCompensator staticVarCompensator, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = null;
        if (FactsDeviceConverter.factsDeviceRegulatingBus(psseFactsDevice, version) == 0) {
            regulatingTerminal = staticVarCompensator.getTerminal();
        } else {
            Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(FactsDeviceConverter.factsDeviceRegulatingBus(psseFactsDevice, version));
            if (control.isPresent()) {
                regulatingTerminal = FactsDeviceConverter.findTerminalNode(network, control.get().voltageLevelId(), control.get().node());
            } else {
                String regulatingBusId = FactsDeviceConverter.getBusId(FactsDeviceConverter.factsDeviceRegulatingBus(psseFactsDevice, version));
                Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
                if (bus != null) {
                    regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
                }
            }
        }
        if (regulatingTerminal == null) {
            LOGGER.warn("FactsDevice {}. Regulating terminal is not assigned as the bus is isolated", (Object)psseFactsDevice.getName());
        }
        return regulatingTerminal;
    }

    private static int factsDeviceRegulatingBus(PsseFacts factsDevice, PsseVersion psseVersion) {
        if (psseVersion.major() == PsseVersion.Major.V35) {
            return factsDevice.getFcreg();
        }
        return factsDevice.getRemot();
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        network.getStaticVarCompensators().forEach(staticVarCompensator -> psseModel.addFacts(Collections.singletonList(FactsDeviceConverter.createFactsDevice(staticVarCompensator, contextExport))));
        psseModel.replaceAllFacts(psseModel.getFacts().stream().sorted(Comparator.comparing(PsseFacts::getName)).toList());
    }

    private static PsseFacts createFactsDevice(StaticVarCompensator staticVarCompensator, ContextExport contextExport) {
        PsseFacts psseFactsDevice = FactsDeviceConverter.createDefaultFactsDevice();
        int busI = FactsDeviceConverter.getTerminalBusI(staticVarCompensator.getTerminal(), contextExport);
        double maxReactivePower = FactsDeviceConverter.shuntAdmittanceToPower(staticVarCompensator.getBmax(), staticVarCompensator.getTerminal().getVoltageLevel().getNominalV());
        psseFactsDevice.setName(FactsDeviceConverter.extractFactsDeviceName(staticVarCompensator.getId()));
        psseFactsDevice.setI(busI);
        psseFactsDevice.setMode(FactsDeviceConverter.getStatus(staticVarCompensator.getTerminal(), contextExport));
        FactsDeviceConverter.findTargetQ(staticVarCompensator).ifPresent(arg_0 -> ((PsseFacts)psseFactsDevice).setQdes(arg_0));
        FactsDeviceConverter.findTargetV(staticVarCompensator).ifPresent(arg_0 -> ((PsseFacts)psseFactsDevice).setVset(arg_0));
        psseFactsDevice.setShmx(maxReactivePower);
        psseFactsDevice.setFcreg(FactsDeviceConverter.getRegulatingTerminalBusI(staticVarCompensator.getRegulatingTerminal(), busI, psseFactsDevice.getFcreg(), contextExport));
        psseFactsDevice.setNreg(FactsDeviceConverter.getRegulatingTerminalNode(staticVarCompensator.getRegulatingTerminal(), contextExport));
        return psseFactsDevice;
    }

    private static PsseFacts createDefaultFactsDevice() {
        PsseFacts psseFactsDevice = new PsseFacts();
        psseFactsDevice.setName("");
        psseFactsDevice.setI(0);
        psseFactsDevice.setJ(0);
        psseFactsDevice.setMode(1);
        psseFactsDevice.setPdes(0.0);
        psseFactsDevice.setQdes(0.0);
        psseFactsDevice.setVset(1.0);
        psseFactsDevice.setShmx(9999.0);
        psseFactsDevice.setTrmx(9999.0);
        psseFactsDevice.setVtmn(0.9);
        psseFactsDevice.setVtmx(1.1);
        psseFactsDevice.setVsmx(1.0);
        psseFactsDevice.setImx(0.0);
        psseFactsDevice.setLinx(0.05);
        psseFactsDevice.setRmpct(100.0);
        psseFactsDevice.setOwner(1);
        psseFactsDevice.setSet1(0.0);
        psseFactsDevice.setSet2(0.0);
        psseFactsDevice.setVsref(0);
        psseFactsDevice.setFcreg(0);
        psseFactsDevice.setNreg(0);
        psseFactsDevice.setMname("");
        return psseFactsDevice;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getFacts().forEach(psseFactsDevice -> {
            String factsDeviceName = FactsDeviceConverter.getFactsDeviceId(psseFactsDevice.getName());
            StaticVarCompensator staticVarCompensator = network.getStaticVarCompensator(factsDeviceName);
            if (staticVarCompensator == null) {
                psseFactsDevice.setMode(0);
            } else if (FactsDeviceConverter.isStatCom(psseFactsDevice)) {
                psseFactsDevice.setMode(FactsDeviceConverter.getUpdatedStatus(staticVarCompensator.getTerminal()));
            } else {
                psseFactsDevice.setMode(FactsDeviceConverter.getUpdatedStatus(staticVarCompensator.getTerminal()));
                FactsDeviceConverter.findTargetQ(staticVarCompensator).ifPresent(arg_0 -> ((PsseFacts)psseFactsDevice).setQdes(arg_0));
                FactsDeviceConverter.findTargetV(staticVarCompensator).ifPresent(arg_0 -> ((PsseFacts)psseFactsDevice).setVset(arg_0));
            }
        });
    }

    private static OptionalDouble findTargetQ(StaticVarCompensator staticVarCompensator) {
        return Double.isFinite(staticVarCompensator.getReactivePowerSetpoint()) ? OptionalDouble.of(staticVarCompensator.getReactivePowerSetpoint()) : OptionalDouble.empty();
    }

    private static OptionalDouble findTargetV(StaticVarCompensator staticVarCompensator) {
        return staticVarCompensator.getRegulatingTerminal() != null ? OptionalDouble.of(staticVarCompensator.getVoltageSetpoint() / staticVarCompensator.getRegulatingTerminal().getVoltageLevel().getNominalV()) : OptionalDouble.empty();
    }

    private static boolean isStatCom(PsseFacts psseFactsDevice) {
        return psseFactsDevice.getJ() == 0;
    }
}

