/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.converter.PsseExporter;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseRates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.commons.math3.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LineConverter
extends AbstractConverter {
    private final PsseNonTransformerBranch psseLine;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(LineConverter.class);

    LineConverter(PsseNonTransformerBranch psseLine, ContainersMapping containerMapping, PsseImporter.PerUnitContext perUnitContext, Network network, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseLine = Objects.requireNonNull(psseLine);
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.version = Objects.requireNonNull(version);
        this.nodeBreakerImport = nodeBreakerImport;
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseLine.getI()) || !this.getContainersMapping().isBusDefined(this.psseLine.getJ())) {
            return;
        }
        String id = LineConverter.getLineId(this.psseLine.getI(), this.psseLine.getJ(), this.psseLine.getCkt());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseLine.getI());
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseLine.getJ());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double rEu = LineConverter.impedanceToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(this.psseLine.getR(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        double xEu = LineConverter.impedanceToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(this.psseLine.getX(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        Complex yEu = new Complex(rEu, xEu).reciprocal();
        double g1Eu = LineConverter.admittanceEnd1ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getReal(), this.psseLine.getGi(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        double b1Eu = LineConverter.admittanceEnd1ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getImaginary(), this.psseLine.getB() * 0.5 + this.psseLine.getBi(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        double g2Eu = LineConverter.admittanceEnd2ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getReal(), this.psseLine.getGj(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        double b2Eu = LineConverter.admittanceEnd2ToEngineeringUnitsForLinesWithDifferentNominalVoltageAtEnds(yEu.getImaginary(), this.psseLine.getB() * 0.5 + this.psseLine.getBj(), voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), this.perUnitContext.sb());
        LineAdder adder = ((LineAdder)((LineAdder)((LineAdder)((LineAdder)this.getNetwork().newLine().setId(id)).setEnsureIdUnicity(true)).setVoltageLevel1(voltageLevel1Id)).setVoltageLevel2(voltageLevel2Id)).setR(rEu).setX(xEu).setG1(g1Eu).setB1(b1Eu).setG2(g2Eu).setB2(b2Eu);
        String equipmentId = LineConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_BRANCH, this.psseLine.getI(), this.psseLine.getJ(), this.psseLine.getCkt());
        OptionalInt node1 = this.nodeBreakerImport.getNode(LineConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseLine.getI(), this.psseLine.getJ(), 0, this.psseLine.getI(), "I"));
        if (node1.isPresent()) {
            adder.setNode1(node1.getAsInt());
        } else {
            String bus1Id = LineConverter.getBusId(this.psseLine.getI());
            adder.setConnectableBus1(bus1Id);
            adder.setBus1(this.psseLine.getSt() == 1 ? bus1Id : null);
        }
        OptionalInt node2 = this.nodeBreakerImport.getNode(LineConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseLine.getI(), this.psseLine.getJ(), 0, this.psseLine.getJ(), "J"));
        if (node2.isPresent()) {
            adder.setNode2(node2.getAsInt());
        } else {
            String bus2Id = LineConverter.getBusId(this.psseLine.getJ());
            adder.setConnectableBus2(bus2Id);
            adder.setBus2(this.psseLine.getSt() == 1 ? bus2Id : null);
        }
        Line line = adder.add();
        this.defineOperationalLimits(line, voltageLevel1.getNominalV(), voltageLevel2.getNominalV());
        if (this.psseLine.getGi() != 0.0 || this.psseLine.getGj() != 0.0) {
            LOGGER.warn("Branch G not supported ({})", (Object)this.psseLine.getI());
        }
    }

    private void defineOperationalLimits(Line line, double vnom1, double vnom2) {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseLine.getRates().getRate1() : this.psseLine.getRates().getRatea();
        double currentLimit1 = rateMva / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva / (Math.sqrt(3.0) * vnom2);
        if (currentLimit1 > 0.0) {
            CurrentLimitsAdder currentLimitFrom = line.getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            CurrentLimitsAdder currentLimitTo = line.getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits();
            currentLimitTo.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitTo.add();
        }
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        ArrayList branches = new ArrayList();
        network.getLines().forEach(line -> branches.add(LineConverter.createLine(line, contextExport, perUnitContext)));
        psseModel.addNonTransformerBranches(branches);
        psseModel.replaceAllNonTransformerBranches(psseModel.getNonTransformerBranches().stream().sorted(Comparator.comparingInt(PsseNonTransformerBranch::getI).thenComparingInt(PsseNonTransformerBranch::getJ).thenComparing(PsseNonTransformerBranch::getCkt)).toList());
    }

    private static PsseNonTransformerBranch createLine(Line line, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseNonTransformerBranch psseLine = LineConverter.createDefaultNonTransformerBranch();
        int busI = LineConverter.getTerminalBusI(line.getTerminal1(), contextExport);
        int busJ = LineConverter.getTerminalBusI(line.getTerminal2(), contextExport);
        double vNom1 = line.getTerminal1().getVoltageLevel().getNominalV();
        double vNom2 = line.getTerminal2().getVoltageLevel().getNominalV();
        Complex transmissionAdmittance = new Complex(line.getR(), line.getX()).reciprocal();
        psseLine.setI(busI);
        psseLine.setJ(busJ);
        psseLine.setCkt(contextExport.getFullExport().getEquipmentCkt(line.getId(), AbstractConverter.PsseEquipmentType.PSSE_BRANCH.getTextCode(), busI, busJ));
        psseLine.setR(LineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(line.getR(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setX(LineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(line.getX(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setName(LineConverter.fixNonTransformerBranchName(line.getNameOrId()));
        psseLine.setRates(LineConverter.createRates(line, vNom1, vNom2));
        psseLine.setGi(LineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getReal(), line.getG1(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setBi(LineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getImaginary(), line.getB1(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setGj(LineConverter.admittanceEnd2ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getReal(), line.getG2(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setBj(LineConverter.admittanceEnd2ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getImaginary(), line.getB2(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setSt(LineConverter.getStatus(line.getTerminal1(), line.getTerminal2(), contextExport));
        return psseLine;
    }

    private static PsseRates createRates(Line line, double vNominal1, double vNominal2) {
        PsseRates windingRates = LineConverter.createDefaultRates();
        line.getApparentPowerLimits1().ifPresent(apparentPowerLimits1 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(apparentPowerLimits1), windingRates));
        if (line.getApparentPowerLimits1().isEmpty()) {
            line.getApparentPowerLimits2().ifPresent(apparentPowerLimits2 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(apparentPowerLimits2), windingRates));
        }
        if (line.getApparentPowerLimits1().isEmpty() && line.getApparentPowerLimits2().isEmpty()) {
            line.getCurrentLimits1().ifPresent(currentLimits1 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(currentLimits1, vNominal1), windingRates));
        }
        if (line.getApparentPowerLimits1().isEmpty() && line.getApparentPowerLimits2().isEmpty() && line.getCurrentLimits1().isEmpty()) {
            line.getCurrentLimits2().ifPresent(currentLimits2 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(currentLimits2, vNominal2), windingRates));
        }
        if (line.getApparentPowerLimits1().isEmpty() && line.getApparentPowerLimits2().isEmpty() && line.getCurrentLimits1().isEmpty() && line.getCurrentLimits2().isEmpty()) {
            line.getActivePowerLimits1().ifPresent(activePowerLimits1 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(activePowerLimits1), windingRates));
        }
        if (line.getApparentPowerLimits1().isEmpty() && line.getApparentPowerLimits2().isEmpty() && line.getCurrentLimits1().isEmpty() && line.getCurrentLimits2().isEmpty() && line.getActivePowerLimits1().isEmpty()) {
            line.getActivePowerLimits2().ifPresent(activePowerLimits2 -> LineConverter.setSortedRatesToPsseRates(LineConverter.getSortedRates(activePowerLimits2), windingRates));
        }
        return windingRates;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getNonTransformerBranches().forEach(psseLine -> {
            String lineId = LineConverter.getLineId(psseLine.getI(), psseLine.getJ(), psseLine.getCkt());
            Line line = network.getLine(lineId);
            if (line == null) {
                psseLine.setSt(0);
            } else {
                psseLine.setSt(LineConverter.getUpdatedStatus(line.getTerminal1(), line.getTerminal2()));
            }
        });
    }
}

