/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;

class LoadConverter
extends AbstractConverter {
    private final PsseLoad psseLoad;
    private final NodeBreakerImport nodeBreakerImport;

    LoadConverter(PsseLoad psseLoad, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseLoad = Objects.requireNonNull(psseLoad);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        String equipmentId;
        OptionalInt node;
        boolean constantPower;
        if (!this.getContainersMapping().isBusDefined(this.psseLoad.getI())) {
            return;
        }
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseLoad.getI()));
        double p0 = this.psseLoad.getPl() + this.psseLoad.getIp() + this.psseLoad.getYp();
        double q0 = this.psseLoad.getQl() + this.psseLoad.getIq() + this.psseLoad.getYq();
        LoadAdder adder = ((LoadAdder)voltageLevel.newLoad().setId(LoadConverter.getLoadId(this.psseLoad.getI(), this.psseLoad.getId()))).setP0(p0).setQ0(q0);
        boolean bl = constantPower = this.psseLoad.getIp() == 0.0 && this.psseLoad.getYp() == 0.0 && this.psseLoad.getIq() == 0.0 && this.psseLoad.getYq() == 0.0;
        if (!(constantPower || p0 == 0.0 && q0 == 0.0)) {
            double c2q;
            double c1q;
            double c0q;
            double c2p;
            double c1p;
            double c0p;
            if (p0 != 0.0) {
                c0p = this.psseLoad.getPl() / p0;
                c1p = this.psseLoad.getIp() / p0;
                c2p = this.psseLoad.getYp() / p0;
            } else {
                c0p = 1.0;
                c1p = 0.0;
                c2p = 0.0;
            }
            if (q0 != 0.0) {
                c0q = this.psseLoad.getQl() / q0;
                c1q = this.psseLoad.getIq() / q0;
                c2q = this.psseLoad.getYq() / q0;
            } else {
                c0q = 1.0;
                c1q = 0.0;
                c2q = 0.0;
            }
            adder.newZipModel().setC0p(c0p).setC1p(c1p).setC2p(c2p).setC0q(c0q).setC1q(c1q).setC2q(c2q).add();
        }
        if ((node = this.nodeBreakerImport.getNode(LoadConverter.getNodeBreakerEquipmentIdBus(equipmentId = LoadConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_LOAD, this.psseLoad.getI(), this.psseLoad.getId()), this.psseLoad.getI(), 0, 0, this.psseLoad.getI(), "I"))).isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = LoadConverter.getBusId(this.psseLoad.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseLoad.getStatus() == 1 ? busId : null);
        }
        adder.add();
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        ArrayList loads = new ArrayList();
        network.getLoads().forEach(load -> loads.add(LoadConverter.createLoad(load, contextExport)));
        psseModel.addLoads(loads);
        psseModel.replaceAllLoads(psseModel.getLoads().stream().sorted(Comparator.comparingInt(PsseLoad::getI).thenComparing(PsseLoad::getId)).toList());
    }

    private static PsseLoad createLoad(Load load, ContextExport contextExport) {
        PsseLoad psseLoad = LoadConverter.createDefaultLoad();
        int busI = LoadConverter.getTerminalBusI(load.getTerminal(), contextExport);
        psseLoad.setI(busI);
        psseLoad.setId(contextExport.getFullExport().getEquipmentCkt(load.getId(), AbstractConverter.PsseEquipmentType.PSSE_LOAD.getTextCode(), busI));
        psseLoad.setStatus(LoadConverter.getStatus(load.getTerminal(), contextExport));
        psseLoad.setPl(LoadConverter.getP(load));
        psseLoad.setQl(LoadConverter.getQ(load));
        return psseLoad;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getLoads().forEach(psseLoad -> {
            String loadId = LoadConverter.getLoadId(psseLoad.getI(), psseLoad.getId());
            Load load = network.getLoad(loadId);
            if (load == null) {
                psseLoad.setStatus(0);
            } else {
                LoadConverter.updateLoad(load, psseLoad);
            }
        });
    }

    private static void updateLoad(Load load, PsseLoad psseLoad) {
        psseLoad.setStatus(LoadConverter.getUpdatedStatus(load.getTerminal()));
        psseLoad.setPl(LoadConverter.getP(load));
        psseLoad.setQl(LoadConverter.getQ(load));
    }

    private static double getP(Load load) {
        if (Double.isNaN(load.getTerminal().getP())) {
            return load.getP0();
        }
        return load.getTerminal().getP();
    }

    private static double getQ(Load load) {
        if (Double.isNaN(load.getTerminal().getQ())) {
            return load.getQ0();
        }
        return load.getTerminal().getQ();
    }
}

