/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.google.auto.service.AutoService;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Network;
import com.powsybl.psse.converter.BatteryConverter;
import com.powsybl.psse.converter.BusConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.DanglingLineConverter;
import com.powsybl.psse.converter.FactsDeviceConverter;
import com.powsybl.psse.converter.FixedShuntCompensatorConverter;
import com.powsybl.psse.converter.GeneratorConverter;
import com.powsybl.psse.converter.LineConverter;
import com.powsybl.psse.converter.LoadConverter;
import com.powsybl.psse.converter.SwitchedShuntCompensatorConverter;
import com.powsybl.psse.converter.TieLineConverter;
import com.powsybl.psse.converter.TransformerConverter;
import com.powsybl.psse.converter.TwoTerminalDcConverter;
import com.powsybl.psse.converter.VoltageLevelConverter;
import com.powsybl.psse.converter.VscDcTransmissionLineConverter;
import com.powsybl.psse.converter.extensions.PsseConversionContextExtension;
import com.powsybl.psse.converter.extensions.PsseModelExtension;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.io.PowerFlowDataFactory;
import com.powsybl.psse.model.pf.io.PowerFlowRawData32;
import com.powsybl.psse.model.pf.io.PowerFlowRawData33;
import com.powsybl.psse.model.pf.io.PowerFlowRawData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawxData35;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

@AutoService(value={Exporter.class})
public class PsseExporter
implements Exporter {
    private static final double BASE_MVA = 100.0;
    private static final String FORMAT = "PSS/E";
    private static final Parameter EXPORT_UPDATE = new Parameter("psse.export.update", ParameterType.BOOLEAN, "Export by updating values on the imported psse model", (Object)Boolean.TRUE);
    private static final Parameter EXPORT_AS_RAW_FORMAT = new Parameter("psse.export.raw-format", ParameterType.BOOLEAN, "Export as raw format", (Object)Boolean.TRUE);
    private static final List<Parameter> STATIC_PARAMETERS = List.of(EXPORT_UPDATE, EXPORT_AS_RAW_FORMAT);

    public String getFormat() {
        return FORMAT;
    }

    public List<Parameter> getParameters() {
        return ConfiguredParameter.load(STATIC_PARAMETERS, (String)this.getFormat(), (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
    }

    public String getComment() {
        return "Update IIDM to PSS/E ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void export(Network network, Properties parameters, DataSource dataSource) {
        Context context;
        PssePowerFlowModel updatePsseModel;
        boolean updateExport = Parameter.readBoolean((String)FORMAT, (Properties)parameters, (Parameter)EXPORT_UPDATE, (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
        boolean isFullExport = PsseExporter.isFullExport(network, updateExport);
        if (isFullExport) {
            boolean rawFormat = Parameter.readBoolean((String)FORMAT, (Properties)parameters, (Parameter)EXPORT_AS_RAW_FORMAT, (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
            updatePsseModel = PsseExporter.createPsseModel(network);
            context = PowerFlowDataFactory.createPsseContext((boolean)rawFormat);
        } else {
            PssePowerFlowModel psseModel = ((PsseModelExtension)network.getExtension(PsseModelExtension.class)).getPsseModel();
            updatePsseModel = PsseExporter.createUpdatePsseModel(network, psseModel);
            context = ((PsseConversionContextExtension)network.getExtension(PsseConversionContextExtension.class)).getContext();
        }
        PsseVersion version = PsseVersion.fromRevision((float)updatePsseModel.getCaseIdentification().getRev());
        if (context.getFileFormat() == FileFormat.JSON) {
            if (Objects.requireNonNull(version.major()) != PsseVersion.Major.V35) throw new PsseException("Unsupported version " + version);
            PowerFlowRawxData35 rawXData35 = new PowerFlowRawxData35();
            try {
                rawXData35.write(updatePsseModel, context, dataSource);
                return;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            this.exportNotJson(context, updatePsseModel, version, dataSource);
        }
    }

    private static boolean isFullExport(Network network, boolean updateExport) {
        return !updateExport || network.getExtension(PsseModelExtension.class) == null;
    }

    private void exportNotJson(Context context, PssePowerFlowModel updatePsseModel, PsseVersion version, DataSource dataSource) {
        switch (version.major()) {
            case V35: {
                PowerFlowRawData35 rawData35 = new PowerFlowRawData35();
                try {
                    rawData35.write(updatePsseModel, context, dataSource);
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case V33: {
                PowerFlowRawData33 rawData33 = new PowerFlowRawData33();
                try {
                    rawData33.write(updatePsseModel, context, dataSource);
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case V32: {
                PowerFlowRawData32 rawData32 = new PowerFlowRawData32();
                try {
                    rawData32.write(updatePsseModel, context, dataSource);
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            default: {
                throw new PsseException("Unsupported version " + version);
            }
        }
    }

    private static PssePowerFlowModel createUpdatePsseModel(Network network, PssePowerFlowModel psseModel) {
        PssePowerFlowModel updatedPsseModel = psseModel.referenceAndCopyPssePowerFlowModel();
        PsseExporter.updateModifiedBlocks(network, updatedPsseModel);
        return updatedPsseModel;
    }

    private static void updateModifiedBlocks(Network network, PssePowerFlowModel updatedPsseModel) {
        ContextExport contextExport = VoltageLevelConverter.createContextExport(network, updatedPsseModel, false);
        VoltageLevelConverter.updateSubstations(network, contextExport);
        BusConverter.update(updatedPsseModel, contextExport);
        LoadConverter.update(network, updatedPsseModel);
        FixedShuntCompensatorConverter.update(network, updatedPsseModel);
        GeneratorConverter.update(network, updatedPsseModel);
        LineConverter.update(network, updatedPsseModel);
        TransformerConverter.update(network, updatedPsseModel);
        TwoTerminalDcConverter.update(network, updatedPsseModel);
        VscDcTransmissionLineConverter.update(network, updatedPsseModel);
        FactsDeviceConverter.update(network, updatedPsseModel);
        SwitchedShuntCompensatorConverter.update(network, updatedPsseModel);
    }

    private static PssePowerFlowModel createPsseModel(Network network) {
        PerUnitContext perUnitContext = new PerUnitContext(100.0);
        PsseCaseIdentification caseIdentification = PsseExporter.createCaseIdentification(network, perUnitContext);
        PssePowerFlowModel psseModel = new PssePowerFlowModel(caseIdentification);
        ContextExport contextExport = VoltageLevelConverter.createContextExport(network, psseModel, true);
        VoltageLevelConverter.createSubstations(psseModel, contextExport);
        BusConverter.create(psseModel, contextExport);
        LoadConverter.create(network, psseModel, contextExport);
        FixedShuntCompensatorConverter.create(network, psseModel, contextExport);
        GeneratorConverter.create(network, psseModel, contextExport, perUnitContext);
        LineConverter.create(network, psseModel, contextExport, perUnitContext);
        TransformerConverter.create(network, psseModel, contextExport, perUnitContext);
        TwoTerminalDcConverter.create(network, psseModel, contextExport);
        VscDcTransmissionLineConverter.create(network, psseModel, contextExport);
        FactsDeviceConverter.create(network, psseModel, contextExport);
        SwitchedShuntCompensatorConverter.create(network, psseModel, contextExport);
        BatteryConverter.create(network, psseModel, contextExport);
        TieLineConverter.create(network, psseModel, contextExport, perUnitContext);
        DanglingLineConverter.create(network, psseModel, contextExport, perUnitContext);
        return psseModel;
    }

    private static PsseCaseIdentification createCaseIdentification(Network network, PerUnitContext perUnitContext) {
        PsseCaseIdentification caseIdentification = new PsseCaseIdentification();
        caseIdentification.setIc(0);
        caseIdentification.setSbase(perUnitContext.sBase);
        caseIdentification.setRev(35.0f);
        caseIdentification.setXfrrat(0.0);
        caseIdentification.setNxfrat(0.0);
        caseIdentification.setBasfrq(50.0);
        String caseDate = network.getCaseDate().format(DateTimeFormatter.RFC_1123_DATE_TIME);
        String caseName = network.getNameOrId();
        caseIdentification.setTitle1(String.format("%s %s", caseDate, caseName));
        caseIdentification.setTitle2("");
        return caseIdentification;
    }

    record PerUnitContext(double sBase) {
    }
}

