/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwitchedShuntCompensatorConverter
extends AbstractConverter {
    private final PsseSwitchedShunt psseSwitchedShunt;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchedShuntCompensatorConverter.class);

    SwitchedShuntCompensatorConverter(PsseSwitchedShunt psseSwitchedShunt, ContainersMapping containerMapping, Network network, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseSwitchedShunt = Objects.requireNonNull(psseSwitchedShunt);
        this.version = Objects.requireNonNull(version);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseSwitchedShunt.getI())) {
            return;
        }
        List<ShuntBlock> shuntBlocks = SwitchedShuntCompensatorConverter.defineShuntBlocks(this.psseSwitchedShunt, this.version);
        if (shuntBlocks.isEmpty()) {
            return;
        }
        String id = SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version);
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseSwitchedShunt.getI()));
        ShuntCompensatorAdder adder = ((ShuntCompensatorAdder)voltageLevel.newShuntCompensator().setId(SwitchedShuntCompensatorConverter.getSwitchedShuntId(this.psseSwitchedShunt.getI(), id))).setSectionCount(SwitchedShuntCompensatorConverter.defineSectionCount(this.psseSwitchedShunt.getBinit(), shuntBlocks));
        String equipmentId = SwitchedShuntCompensatorConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_SWITCHED_SHUNT, this.psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version));
        OptionalInt node = this.nodeBreakerImport.getNode(SwitchedShuntCompensatorConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseSwitchedShunt.getI(), 0, 0, this.psseSwitchedShunt.getI(), "I"));
        if (node.isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = SwitchedShuntCompensatorConverter.getBusId(this.psseSwitchedShunt.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseSwitchedShunt.getStat() == 1 ? busId : null);
        }
        ShuntCompensatorNonLinearModelAdder modelAdder = adder.newNonLinearModel();
        shuntBlocks.forEach(shuntBlock -> {
            for (int i = 0; i < shuntBlock.getN(); ++i) {
                modelAdder.beginSection().setG(0.0).setB(SwitchedShuntCompensatorConverter.powerToShuntAdmittance(shuntBlock.getB(), voltageLevel.getNominalV())).endSection();
            }
        });
        modelAdder.add();
        adder.add();
    }

    void addControl() {
        String id = SwitchedShuntCompensatorConverter.defineShuntId(this.psseSwitchedShunt, this.version);
        ShuntCompensator shunt = this.getNetwork().getShuntCompensator(SwitchedShuntCompensatorConverter.getSwitchedShuntId(this.psseSwitchedShunt.getI(), id));
        if (shunt == null) {
            return;
        }
        Terminal regulatingTerminal = SwitchedShuntCompensatorConverter.defineRegulatingTerminal(this.psseSwitchedShunt, this.getNetwork(), shunt, this.version, this.nodeBreakerImport);
        if (regulatingTerminal == null) {
            return;
        }
        if (!SwitchedShuntCompensatorConverter.isControllingVoltage(this.psseSwitchedShunt)) {
            return;
        }
        boolean psseVoltageRegulatorOn = true;
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double vLow = this.psseSwitchedShunt.getVswlo() * vnom;
        double vHigh = this.psseSwitchedShunt.getVswhi() * vnom;
        double targetV = 0.5 * (vLow + vHigh);
        boolean voltageRegulatorOn = false;
        double targetDeadband = 0.0;
        if (targetV != 0.0) {
            targetDeadband = vHigh - vLow;
            voltageRegulatorOn = psseVoltageRegulatorOn;
        }
        shunt.setTargetV(targetV).setTargetDeadband(targetDeadband).setVoltageRegulatorOn(voltageRegulatorOn).setRegulatingTerminal(regulatingTerminal);
    }

    private static boolean isControllingVoltage(PsseSwitchedShunt psseSwitchedShunt) {
        return psseSwitchedShunt.getModsw() == 1 || psseSwitchedShunt.getModsw() == 2;
    }

    private static Terminal defineRegulatingTerminal(PsseSwitchedShunt psseSwitchedShunt, Network network, ShuntCompensator shunt, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = null;
        if (SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version) == 0) {
            regulatingTerminal = shunt.getTerminal();
        } else {
            Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version));
            if (control.isPresent()) {
                int controlledNode = psseSwitchedShunt.getNreg() != 0 ? psseSwitchedShunt.getNreg() : control.get().node();
                regulatingTerminal = SwitchedShuntCompensatorConverter.findTerminalNode(network, control.get().voltageLevelId(), controlledNode);
            } else {
                String regulatingBusId = SwitchedShuntCompensatorConverter.getBusId(SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version));
                Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
                if (bus != null) {
                    regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
                }
            }
        }
        if (regulatingTerminal == null) {
            String shuntId = SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version);
            LOGGER.warn("SwitchedShunt {}. Regulating terminal is not assigned", (Object)shuntId);
        }
        return regulatingTerminal;
    }

    private static int switchedShuntRegulatingBus(PsseSwitchedShunt switchedShunt, PsseVersion psseVersion) {
        if (psseVersion.major() == PsseVersion.Major.V35) {
            return switchedShunt.getSwreg();
        }
        return switchedShunt.getSwrem();
    }

    private static int defineSectionCount(double binit, List<ShuntBlock> shuntBlocks) {
        double maxDistance = Double.MAX_VALUE;
        int sectionCount = 0;
        for (int i = 0; i < shuntBlocks.size(); ++i) {
            double d = Math.abs(binit - shuntBlocks.get(i).getB());
            if (!(d < maxDistance)) continue;
            maxDistance = d;
            sectionCount = i + 1;
        }
        return sectionCount;
    }

    private static List<ShuntBlock> defineShuntBlocks(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        List<ShuntBlock> psseBlocks = SwitchedShuntCompensatorConverter.collectShuntBlocks(psseSwitchedShunt, version);
        List<ShuntBlock> psseReactorBlocks = psseBlocks.stream().filter(sb -> sb.getB() < 0.0).collect(Collectors.toList());
        List<ShuntBlock> psseCapacitorBlocks = psseBlocks.stream().filter(sb -> sb.getB() > 0.0).collect(Collectors.toList());
        if (psseSwitchedShunt.getAdjm() == 1) {
            psseReactorBlocks.sort(Comparator.comparing(ShuntBlock::getB).reversed());
            psseCapacitorBlocks.sort(Comparator.comparing(ShuntBlock::getB));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Switched combination not exactly supported ({})", (Object)SwitchedShuntCompensatorConverter.getSwitchedShuntId(psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version)));
            }
        }
        double bAdd = 0.0;
        ArrayList<ShuntBlock> shuntBlocks = new ArrayList<ShuntBlock>();
        bAdd = SwitchedShuntCompensatorConverter.addShuntBlocks(psseReactorBlocks, bAdd, shuntBlocks);
        if (psseSwitchedShunt.getAdjm() == 1) {
            bAdd = 0.0;
        }
        SwitchedShuntCompensatorConverter.addShuntBlocks(psseCapacitorBlocks, bAdd, shuntBlocks);
        shuntBlocks.add(new ShuntBlock(1, 1, 0.0));
        shuntBlocks.sort(Comparator.comparing(ShuntBlock::getB));
        return shuntBlocks;
    }

    private static double addShuntBlocks(List<ShuntBlock> psseShuntBlocks, double bAddInitial, List<ShuntBlock> shuntBlocks) {
        double bAdd = bAddInitial;
        if (!psseShuntBlocks.isEmpty()) {
            for (ShuntBlock psseCapacitorBlock : psseShuntBlocks) {
                for (int j = 0; j < psseCapacitorBlock.getN(); ++j) {
                    shuntBlocks.add(new ShuntBlock(1, 1, bAdd += psseCapacitorBlock.getB()));
                }
            }
        }
        return bAdd;
    }

    private static List<ShuntBlock> collectShuntBlocks(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        ArrayList<ShuntBlock> shuntBlocks = new ArrayList<ShuntBlock>();
        if (version.major() == PsseVersion.Major.V35) {
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS1(), psseSwitchedShunt.getN1(), psseSwitchedShunt.getB1());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS2(), psseSwitchedShunt.getN2(), psseSwitchedShunt.getB2());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS3(), psseSwitchedShunt.getN3(), psseSwitchedShunt.getB3());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS4(), psseSwitchedShunt.getN4(), psseSwitchedShunt.getB4());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS5(), psseSwitchedShunt.getN5(), psseSwitchedShunt.getB5());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS6(), psseSwitchedShunt.getN6(), psseSwitchedShunt.getB6());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS7(), psseSwitchedShunt.getN7(), psseSwitchedShunt.getB7());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, psseSwitchedShunt.getS8(), psseSwitchedShunt.getN8(), psseSwitchedShunt.getB8());
        } else {
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN1(), psseSwitchedShunt.getB1());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN2(), psseSwitchedShunt.getB2());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN3(), psseSwitchedShunt.getB3());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN4(), psseSwitchedShunt.getB4());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN5(), psseSwitchedShunt.getB5());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN6(), psseSwitchedShunt.getB6());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN7(), psseSwitchedShunt.getB7());
            SwitchedShuntCompensatorConverter.addShuntBlock(shuntBlocks, 1, psseSwitchedShunt.getN8(), psseSwitchedShunt.getB8());
        }
        return shuntBlocks;
    }

    private static void addShuntBlock(List<ShuntBlock> shuntBlocks, int s, int n, double b) {
        if (s == 0 || n == 0 || b == 0.0) {
            return;
        }
        shuntBlocks.add(new ShuntBlock(s, n, b));
    }

    private static String defineShuntId(PsseSwitchedShunt psseSwitchedShunt, PsseVersion version) {
        if (version.major() == PsseVersion.Major.V35) {
            return psseSwitchedShunt.getId();
        }
        return "1";
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        PsseVersion version = PsseVersion.fromRevision((float)psseModel.getCaseIdentification().getRev());
        ArrayList switchedShunts = new ArrayList();
        network.getShuntCompensators().forEach(shuntCompensator -> {
            if (!SwitchedShuntCompensatorConverter.isFixedShunt(shuntCompensator)) {
                switchedShunts.add(SwitchedShuntCompensatorConverter.createSwitchedShunt(shuntCompensator, version, contextExport));
            }
        });
        psseModel.addSwitchedShunts(switchedShunts);
        psseModel.replaceAllSwitchedShunts(psseModel.getSwitchedShunts().stream().sorted(Comparator.comparingInt(PsseSwitchedShunt::getI).thenComparing(PsseSwitchedShunt::getId)).toList());
    }

    static PsseSwitchedShunt createSwitchedShunt(ShuntCompensator shuntCompensator, PsseVersion version, ContextExport contextExport) {
        PsseSwitchedShunt psseSwitchedShunt = SwitchedShuntCompensatorConverter.createDefaultSwitchedShunt();
        int busI = SwitchedShuntCompensatorConverter.getTerminalBusI(shuntCompensator.getTerminal(), contextExport);
        int regulatingBus = SwitchedShuntCompensatorConverter.getRegulatingTerminalBusI(shuntCompensator.getRegulatingTerminal(), busI, SwitchedShuntCompensatorConverter.switchedShuntRegulatingBus(psseSwitchedShunt, version), contextExport);
        psseSwitchedShunt.setI(busI);
        psseSwitchedShunt.setId(contextExport.getFullExport().getEquipmentCkt(shuntCompensator.getId(), AbstractConverter.PsseEquipmentType.PSSE_SWITCHED_SHUNT.getTextCode(), busI));
        psseSwitchedShunt.setModsw(SwitchedShuntCompensatorConverter.getModsw(shuntCompensator));
        psseSwitchedShunt.setStat(SwitchedShuntCompensatorConverter.getStatus(shuntCompensator.getTerminal(), contextExport));
        psseSwitchedShunt.setVswhi(SwitchedShuntCompensatorConverter.getVswhi(shuntCompensator));
        psseSwitchedShunt.setVswlo(SwitchedShuntCompensatorConverter.getVswlo(shuntCompensator));
        psseSwitchedShunt.setSwreg(regulatingBus);
        psseSwitchedShunt.setNreg(SwitchedShuntCompensatorConverter.getRegulatingTerminalNode(shuntCompensator.getRegulatingTerminal(), contextExport));
        psseSwitchedShunt.setBinit(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(shuntCompensator.getB(), shuntCompensator.getTerminal().getVoltageLevel().getNominalV()));
        SwitchedShuntCompensatorConverter.setShuntBlocks(shuntCompensator, psseSwitchedShunt);
        return psseSwitchedShunt;
    }

    private static int getModsw(ShuntCompensator shuntCompensator) {
        return shuntCompensator.isVoltageRegulatorOn() ? 1 : 0;
    }

    private static double getVswhi(ShuntCompensator shuntCompensator) {
        double targetV = shuntCompensator.getTargetV() + shuntCompensator.getTargetDeadband() * 0.5;
        double nominalV = SwitchedShuntCompensatorConverter.getRegulatingTerminalNominalV(shuntCompensator);
        return Double.isFinite(targetV) && Double.isFinite(nominalV) && targetV > 0.0 && nominalV > 0.0 ? targetV / nominalV : 1.0;
    }

    private static double getVswlo(ShuntCompensator shuntCompensator) {
        double targetV = shuntCompensator.getTargetV() - shuntCompensator.getTargetDeadband() * 0.5;
        double nominalV = SwitchedShuntCompensatorConverter.getRegulatingTerminalNominalV(shuntCompensator);
        return Double.isFinite(targetV) && Double.isFinite(nominalV) && targetV > 0.0 && nominalV > 0.0 ? targetV / nominalV : 1.0;
    }

    private static double getRegulatingTerminalNominalV(ShuntCompensator shuntCompensator) {
        return shuntCompensator.getRegulatingTerminal() != null ? shuntCompensator.getRegulatingTerminal().getVoltageLevel().getNominalV() : shuntCompensator.getTerminal().getVoltageLevel().getNominalV();
    }

    private static void setShuntBlocks(ShuntCompensator shuntCompensator, PsseSwitchedShunt psseSwitchedShunt) {
        if (shuntCompensator.getModelType() == ShuntCompensatorModelType.LINEAR) {
            ShuntCompensatorLinearModel linearModel = (ShuntCompensatorLinearModel)shuntCompensator.getModel();
            SwitchedShuntCompensatorConverter.setShuntBlocksForLinearModel(linearModel, shuntCompensator.getMaximumSectionCount(), shuntCompensator.getTerminal().getVoltageLevel().getNominalV(), psseSwitchedShunt);
        } else {
            ShuntCompensatorNonLinearModel nonLinearModel = (ShuntCompensatorNonLinearModel)shuntCompensator.getModel();
            SwitchedShuntCompensatorConverter.setShuntBlocksForNonLinearModel(nonLinearModel, shuntCompensator.getTerminal().getVoltageLevel().getNominalV(), psseSwitchedShunt);
        }
    }

    private static void setShuntBlocksForLinearModel(ShuntCompensatorLinearModel linearModel, int maximumSectionCount, double nominalV, PsseSwitchedShunt psseSwitchedShunt) {
        psseSwitchedShunt.setN1(maximumSectionCount);
        psseSwitchedShunt.setB1(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(linearModel.getBPerSection(), nominalV));
    }

    private static void setShuntBlocksForNonLinearModel(ShuntCompensatorNonLinearModel nonLinearModel, double nominalV, PsseSwitchedShunt psseSwitchedShunt) {
        List<ShuntCompensatorNonLinearModel.Section> sections = nonLinearModel.getAllSections().stream().filter(section -> section.getB() != 0.0).toList();
        psseSwitchedShunt.setN1(SwitchedShuntCompensatorConverter.getN(sections, 0));
        psseSwitchedShunt.setB1(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 0), nominalV));
        psseSwitchedShunt.setN2(SwitchedShuntCompensatorConverter.getN(sections, 1));
        psseSwitchedShunt.setB2(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 1), nominalV));
        psseSwitchedShunt.setN3(SwitchedShuntCompensatorConverter.getN(sections, 2));
        psseSwitchedShunt.setB3(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 2), nominalV));
        psseSwitchedShunt.setN4(SwitchedShuntCompensatorConverter.getN(sections, 3));
        psseSwitchedShunt.setB4(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 3), nominalV));
        psseSwitchedShunt.setN5(SwitchedShuntCompensatorConverter.getN(sections, 4));
        psseSwitchedShunt.setB5(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 4), nominalV));
        psseSwitchedShunt.setN6(SwitchedShuntCompensatorConverter.getN(sections, 5));
        psseSwitchedShunt.setB6(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 5), nominalV));
        psseSwitchedShunt.setN7(SwitchedShuntCompensatorConverter.getN(sections, 6));
        psseSwitchedShunt.setB7(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getB(sections, 6), nominalV));
        psseSwitchedShunt.setN8(SwitchedShuntCompensatorConverter.getRemainderN(sections, 7));
        psseSwitchedShunt.setB8(SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(SwitchedShuntCompensatorConverter.getRemainderB(sections, 7), nominalV));
    }

    private static int getN(List<ShuntCompensatorNonLinearModel.Section> sections, int index) {
        return sections.size() > index ? 1 : 0;
    }

    private static double getB(List<ShuntCompensatorNonLinearModel.Section> sections, int index) {
        return sections.size() > index ? sections.get(index).getB() : 0.0;
    }

    private static int getRemainderN(List<ShuntCompensatorNonLinearModel.Section> sections, int index) {
        return sections.size() > index ? sections.size() - index : 0;
    }

    private static double getRemainderB(List<ShuntCompensatorNonLinearModel.Section> sections, int index) {
        int n = SwitchedShuntCompensatorConverter.getRemainderN(sections, index);
        if (n <= 0) {
            return 0.0;
        }
        double remainderB = 0.0;
        for (int i = index; i < sections.size(); ++i) {
            remainderB += sections.get(i).getB();
        }
        return remainderB / (double)n;
    }

    private static PsseSwitchedShunt createDefaultSwitchedShunt() {
        PsseSwitchedShunt psseSwitchedShunt = new PsseSwitchedShunt();
        psseSwitchedShunt.setI(0);
        psseSwitchedShunt.setId("1");
        psseSwitchedShunt.setModsw(1);
        psseSwitchedShunt.setAdjm(0);
        psseSwitchedShunt.setStat(1);
        psseSwitchedShunt.setVswhi(1.0);
        psseSwitchedShunt.setVswlo(1.0);
        psseSwitchedShunt.setSwreg(0);
        psseSwitchedShunt.setNreg(0);
        psseSwitchedShunt.setRmpct(100.0);
        psseSwitchedShunt.setRmidnt("");
        psseSwitchedShunt.setBinit(0.0);
        psseSwitchedShunt.setS1(1);
        psseSwitchedShunt.setN1(0);
        psseSwitchedShunt.setB1(0.0);
        psseSwitchedShunt.setS2(1);
        psseSwitchedShunt.setN2(0);
        psseSwitchedShunt.setB2(0.0);
        psseSwitchedShunt.setS3(1);
        psseSwitchedShunt.setN3(0);
        psseSwitchedShunt.setB3(0.0);
        psseSwitchedShunt.setS4(1);
        psseSwitchedShunt.setN4(0);
        psseSwitchedShunt.setB4(0.0);
        psseSwitchedShunt.setS5(1);
        psseSwitchedShunt.setN5(0);
        psseSwitchedShunt.setB5(0.0);
        psseSwitchedShunt.setS6(1);
        psseSwitchedShunt.setN6(0);
        psseSwitchedShunt.setB6(0.0);
        psseSwitchedShunt.setS7(1);
        psseSwitchedShunt.setN7(0);
        psseSwitchedShunt.setB7(0.0);
        psseSwitchedShunt.setS8(1);
        psseSwitchedShunt.setN8(0);
        psseSwitchedShunt.setB8(0.0);
        return psseSwitchedShunt;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        PsseVersion version = PsseVersion.fromRevision((float)psseModel.getCaseIdentification().getRev());
        psseModel.getSwitchedShunts().forEach(psseSwitchedShunt -> {
            String switchedShuntId = SwitchedShuntCompensatorConverter.getSwitchedShuntId(psseSwitchedShunt.getI(), SwitchedShuntCompensatorConverter.defineShuntId(psseSwitchedShunt, version));
            ShuntCompensator switchedShunt = network.getShuntCompensator(switchedShuntId);
            if (switchedShunt == null) {
                psseSwitchedShunt.setStat(0);
            } else {
                psseSwitchedShunt.setStat(SwitchedShuntCompensatorConverter.getUpdatedStatus(switchedShunt.getTerminal()));
                psseSwitchedShunt.setBinit(SwitchedShuntCompensatorConverter.getQ(switchedShunt));
            }
        });
    }

    private static double getQ(ShuntCompensator switchedShunt) {
        return SwitchedShuntCompensatorConverter.shuntAdmittanceToPower(switchedShunt.getB(switchedShunt.getSectionCount()), switchedShunt.getTerminal().getVoltageLevel().getNominalV());
    }

    static class ShuntBlock {
        int s;
        int n;
        double b;

        ShuntBlock(int s, int n, double b) {
            this.s = s;
            this.n = n;
            this.b = b;
        }

        int getS() {
            return this.s;
        }

        int getN() {
            return this.n;
        }

        double getB() {
            return this.b;
        }
    }
}

