/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.converter.NodeBreakerValidation;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSubstation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.Pseudograph;

class VoltageLevelConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final NodeBreakerValidation nodeBreakerValidation;
    private final NodeBreakerImport nodeBreakerImport;

    VoltageLevelConverter(PsseBus psseBus, ContainersMapping containerMapping, PsseImporter.PerUnitContext perUnitContext, Network network, NodeBreakerValidation nodeBreakerValidation, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.nodeBreakerValidation = Objects.requireNonNull(nodeBreakerValidation);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    VoltageLevel create(Substation substation) {
        String voltageLevelId = this.getContainersMapping().getVoltageLevelId(this.psseBus.getI());
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(voltageLevelId);
        if (voltageLevel == null) {
            double nominalV = VoltageLevelConverter.getNominalV(this.psseBus, this.perUnitContext.ignoreBaseVoltage());
            boolean isNodeBreakerValid = this.nodeBreakerValidation.isConsideredNodeBreaker(this.getContainersMapping().getBusesSet(voltageLevelId));
            TopologyKind topologyKind = isNodeBreakerValid ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER;
            voltageLevel = ((VoltageLevelAdder)substation.newVoltageLevel().setId(voltageLevelId)).setNominalV(nominalV).setTopologyKind(topologyKind).add();
            if (isNodeBreakerValid) {
                this.addNodeBreakerConnectivity(voltageLevelId, voltageLevel, this.nodeBreakerValidation, this.nodeBreakerImport);
            }
        }
        if (voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER && this.psseBus.getIde() == 3) {
            this.nodeBreakerImport.addSlackControl(this.psseBus.getI(), voltageLevelId, VoltageLevelConverter.findSlackNode(this.nodeBreakerValidation, this.psseBus.getI()));
        }
        return voltageLevel;
    }

    static double getNominalV(PsseBus psseBus, boolean isIgnoreBaseVoltage) {
        return isIgnoreBaseVoltage || psseBus.getBaskv() == 0.0 ? 1.0 : psseBus.getBaskv();
    }

    private void addNodeBreakerConnectivity(String voltageLevelId, VoltageLevel voltageLevel, NodeBreakerValidation nodeBreakerValidation, NodeBreakerImport nodeBreakerImport) {
        Set buses = this.getContainersMapping().getBusesSet(voltageLevelId);
        nodeBreakerImport.addTopologicalBuses(buses);
        Optional<PsseSubstation> psseSubstation = nodeBreakerValidation.getTheOnlySubstation(buses);
        if (psseSubstation.isPresent()) {
            int lastNode = psseSubstation.get().getNodes().stream().map(PsseSubstation.PsseSubstationNode::getNi).max(Comparator.naturalOrder()).orElseThrow();
            Iterator iterator = buses.iterator();
            while (iterator.hasNext()) {
                int bus = (Integer)iterator.next();
                lastNode = VoltageLevelConverter.addNodeBreakerConnectivity(voltageLevelId, voltageLevel, psseSubstation.get(), bus, lastNode, nodeBreakerImport);
            }
        }
    }

    private static int addNodeBreakerConnectivity(String voltageLevelId, VoltageLevel voltageLevel, PsseSubstation psseSubstation, int bus, int lastNodeUsedForInternalConnections, NodeBreakerImport nodeBreakerImport) {
        Set nodesSet = psseSubstation.getNodes().stream().filter(psseNode -> psseNode.getI() == bus).map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
        List<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceList = psseSubstation.getSwitchingDevices().stream().filter(sd -> nodesSet.contains(sd.getNi()) && nodesSet.contains(sd.getNj())).sorted(Comparator.comparing(VoltageLevelConverter::switchingDeviceString)).toList();
        for (PsseSubstation.PsseSubstationSwitchingDevice switchingDevice : switchingDeviceList) {
            ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)voltageLevel.getNodeBreakerView().newSwitch().setId(VoltageLevelConverter.getSwitchId(voltageLevelId, switchingDevice))).setName(switchingDevice.getName())).setNode1(switchingDevice.getNi()).setNode2(switchingDevice.getNj()).setKind(VoltageLevelConverter.findSwitchingKind(switchingDevice.getType())).setOpen(switchingDevice.getStatus() != 1).add();
        }
        HashSet<Integer> nodesWithEquipment = new HashSet<Integer>();
        List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList = psseSubstation.getEquipmentTerminals().stream().filter(eqt -> nodesSet.contains(eqt.getNi())).toList();
        int lastNode = lastNodeUsedForInternalConnections;
        Map<String, List<PsseSubstation.PsseSubstationEquipmentTerminal>> equipmentTerminalsGroupedByBus = equipmentTerminalList.stream().collect(Collectors.groupingBy(VoltageLevelConverter::getEquipmentTerminalGroupingKey));
        List sortedKeys = equipmentTerminalsGroupedByBus.keySet().stream().sorted().toList();
        for (String key : sortedKeys) {
            List<PsseSubstation.PsseSubstationEquipmentTerminal> busEquipmentTerminalList = equipmentTerminalsGroupedByBus.get(key);
            for (int index = 0; index < busEquipmentTerminalList.size(); ++index) {
                PsseSubstation.PsseSubstationEquipmentTerminal equipmentTerminal = busEquipmentTerminalList.get(index);
                String equipmentId = VoltageLevelConverter.getNodeBreakerEquipmentId(equipmentTerminal.getType(), equipmentTerminal.getI(), equipmentTerminal.getJ(), equipmentTerminal.getK(), equipmentTerminal.getId());
                String equipmentIdBus = VoltageLevelConverter.getNodeBreakerEquipmentIdBus(equipmentId, bus, VoltageLevelConverter.getEquipmentTerminalEnd(equipmentTerminal, bus, index));
                if (nodesWithEquipment.contains(equipmentTerminal.getNi())) {
                    voltageLevel.getNodeBreakerView().newInternalConnection().setNode1(equipmentTerminal.getNi()).setNode2(++lastNode).add();
                    nodeBreakerImport.addEquipment(equipmentIdBus, lastNode);
                    continue;
                }
                nodeBreakerImport.addEquipment(equipmentIdBus, equipmentTerminal.getNi());
                nodesWithEquipment.add(equipmentTerminal.getNi());
            }
        }
        psseSubstation.getNodes().stream().filter(psseNode -> nodesSet.contains(psseNode.getNi()) && !nodesWithEquipment.contains(psseNode.getNi())).forEach(psseNode -> ((BusbarSectionAdder)((BusbarSectionAdder)voltageLevel.getNodeBreakerView().newBusbarSection().setId(VoltageLevelConverter.busbarSectionId(voltageLevel.getId(), psseNode.getNi()))).setName(psseNode.getName())).setNode(psseNode.getNi()).add());
        int defaultNode = (Integer)nodesSet.stream().sorted().findFirst().orElseThrow();
        nodeBreakerImport.addBusControl(bus, voltageLevelId, defaultNode);
        return lastNode;
    }

    private static String getEquipmentTerminalGroupingKey(PsseSubstation.PsseSubstationEquipmentTerminal equipmentTerminal) {
        return VoltageLevelConverter.getNodeBreakerEquipmentId(equipmentTerminal.getType(), equipmentTerminal.getI(), equipmentTerminal.getJ(), equipmentTerminal.getK(), equipmentTerminal.getId()) + "." + equipmentTerminal.getI();
    }

    private static int getEquipmentTerminalEnd(PsseSubstation.PsseSubstationEquipmentTerminal equipmentTerminal, int bus, int busIndex) {
        List<Integer> sortedNonZeroBuses = Stream.of(equipmentTerminal.getI(), equipmentTerminal.getJ(), equipmentTerminal.getK()).filter(e -> e != 0).sorted().toList();
        int index = sortedNonZeroBuses.indexOf(bus);
        if (index == -1) {
            throw new PsseException("Unexpected bus: " + bus);
        }
        return index + 1 + busIndex;
    }

    private static String switchingDeviceString(PsseSubstation.PsseSubstationSwitchingDevice switchingDevice) {
        return switchingDevice.getNi() + "-" + switchingDevice.getNj() + "-" + switchingDevice.getCkt();
    }

    private static SwitchKind findSwitchingKind(int type) {
        return type == 2 ? SwitchKind.BREAKER : SwitchKind.DISCONNECTOR;
    }

    private static int findSlackNode(NodeBreakerValidation nodeBreakerValidation, int bus) {
        PsseSubstation psseSubstation = nodeBreakerValidation.getTheOnlySubstation(bus).orElseThrow();
        return psseSubstation.getNodes().stream().filter(n -> n.getI() == bus).map(PsseSubstation.PsseSubstationNode::getNi).min(Comparator.comparingInt(node -> VoltageLevelConverter.connectedGenerators(psseSubstation, node)).reversed().thenComparing(Comparator.naturalOrder())).orElseThrow();
    }

    private static int connectedGenerators(PsseSubstation psseSubstation, int node) {
        return (int)psseSubstation.getEquipmentTerminals().stream().filter(eqt -> eqt.getNi() == node && eqt.getType().equals(AbstractConverter.PsseEquipmentType.PSSE_GENERATOR.getTextCode())).count();
    }

    static void updateNodeVoltage(PsseSubstation psseSubstation, Network network, ContainersMapping containersMapping) {
        psseSubstation.getNodes().forEach(psseNode -> {
            VoltageLevel voltageLevel = network.getVoltageLevel(containersMapping.getVoltageLevelId(psseNode.getI()));
            if (voltageLevel != null) {
                VoltageLevelConverter.findConnectedBusViewNode(voltageLevel, psseNode.getNi()).ifPresent(busView -> {
                    busView.setV(psseNode.getVm() * voltageLevel.getNominalV());
                    busView.setAngle(psseNode.getVa());
                });
            }
        });
    }

    static ContextExport createContextExport(Network network, PssePowerFlowModel psseModel, boolean isFullExport) {
        ContextExport contextExport = new ContextExport(isFullExport);
        if (!isFullExport) {
            VoltageLevelConverter.mapVoltageLevelsAndPsseSubstation(network, psseModel, contextExport);
        }
        VoltageLevelConverter.getSortedVoltageLevels(network).forEach(voltageLevel -> {
            if (VoltageLevelConverter.exportVoltageLevelAsNodeBreaker(voltageLevel)) {
                boolean isCreated = VoltageLevelConverter.createNodeBreakerContextExport(voltageLevel, contextExport);
                if (!isCreated) {
                    VoltageLevelConverter.createBusBranchContextExport(voltageLevel, contextExport);
                }
            } else {
                VoltageLevelConverter.createBusBranchContextExport(voltageLevel, contextExport);
            }
        });
        return contextExport;
    }

    private static List<VoltageLevel> getSortedVoltageLevels(Network network) {
        return network.getVoltageLevelStream().sorted(Comparator.comparingInt(VoltageLevelConverter::minBus).thenComparing(vl -> vl.getSubstation().map(Identifiable::getId).orElse(vl.getId())).thenComparing(Comparator.comparingDouble(VoltageLevel::getNominalV).reversed())).toList();
    }

    private static int minBus(VoltageLevel voltageLevel) {
        List<Integer> buses = VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId());
        return buses.isEmpty() ? Integer.MAX_VALUE : buses.get(0);
    }

    private static void mapVoltageLevelsAndPsseSubstation(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        HashMap busPsseSubstation = new HashMap();
        psseModel.getSubstations().forEach(psseSubstation -> {
            Set<Integer> buses = psseSubstation.getNodes().stream().map(PsseSubstation.PsseSubstationNode::getI).collect(Collectors.toSet());
            buses.forEach(bus -> busPsseSubstation.put(bus, psseSubstation));
        });
        network.getVoltageLevels().forEach(voltageLevel -> VoltageLevelConverter.getVoltageLevelPsseSubstation(voltageLevel, busPsseSubstation).ifPresent(psseSubstation -> contextExport.getUpdateExport().addVoltageLevelPsseSubstation((VoltageLevel)voltageLevel, (PsseSubstation)psseSubstation)));
    }

    private static Optional<PsseSubstation> getVoltageLevelPsseSubstation(VoltageLevel voltageLevel, Map<Integer, PsseSubstation> busPsseSubstation) {
        List<Integer> buses = VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId());
        Set psseSubstationSet = buses.stream().filter(busPsseSubstation::containsKey).map(busPsseSubstation::get).collect(Collectors.toSet());
        if (psseSubstationSet.size() > 1) {
            throw new PsseException("Only one PsseSubstation is allowed per VoltageLevel. VoltageLevelId: " + voltageLevel.getId());
        }
        return psseSubstationSet.stream().findFirst();
    }

    private static void createBusBranchContextExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        if (contextExport.isFullExport()) {
            VoltageLevelConverter.createBusBranchContextExportForFullExport(voltageLevel, contextExport);
        } else {
            VoltageLevelConverter.createBusBranchContextExportForUpdating(voltageLevel, contextExport);
        }
    }

    private static void createBusBranchContextExportForFullExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        voltageLevel.getBusView().getBuses().forEach(bus -> contextExport.getFullExport().addBusIBusView(contextExport.getFullExport().getNewPsseBusI(), (Bus)bus));
        voltageLevel.getDanglingLineStream().filter(danglingLine -> !danglingLine.isPaired()).forEach(danglingLine -> contextExport.getFullExport().addDanglingLineBusI((DanglingLine)danglingLine, contextExport.getFullExport().getNewPsseBusI()));
    }

    private static void createBusBranchContextExportForUpdating(VoltageLevel voltageLevel, ContextExport contextExport) {
        voltageLevel.getBusBreakerView().getBuses().forEach(busBreakerViewBus -> Optional.ofNullable(voltageLevel.getBusView().getMergedBus(busBreakerViewBus.getId())).ifPresent(mergedBus -> VoltageLevelConverter.extractBusNumber(busBreakerViewBus.getId()).ifPresent(busI -> contextExport.getUpdateExport().addBusIBusView(busI, (Bus)mergedBus))));
    }

    private static boolean createNodeBreakerContextExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        if (contextExport.isFullExport()) {
            return VoltageLevelConverter.createNodeBreakerContextExportForFullExport(voltageLevel, contextExport);
        }
        VoltageLevelConverter.createNodeBreakerContextExportForUpdating(voltageLevel, contextExport);
        return true;
    }

    private static void createNodeBreakerContextExportForUpdating(VoltageLevel voltageLevel, ContextExport contextExport) {
        HashMap<Integer, List> busIBusViews = new HashMap<Integer, List>();
        PsseSubstation psseSubstation = contextExport.getUpdateExport().getPsseSubstation(voltageLevel).orElseThrow();
        for (int node : voltageLevel.getNodeBreakerView().getNodes()) {
            VoltageLevelConverter.findConnectedBusViewNode(voltageLevel, node).ifPresent(bus -> {
                contextExport.getUpdateExport().addNodeBusView(voltageLevel, node, (Bus)bus);
                VoltageLevelConverter.findBusI(psseSubstation, node).ifPresent(busI -> busIBusViews.computeIfAbsent((Integer)busI, k -> new ArrayList()).add(bus));
            });
        }
        busIBusViews.forEach((busI, busList) -> {
            Bus selectedBus = busList.stream().min(Comparator.comparingInt(VoltageLevelConverter::findPriorityType)).orElseThrow();
            contextExport.getUpdateExport().addBusIBusView((int)busI, selectedBus);
        });
    }

    private static boolean createNodeBreakerContextExportForFullExport(VoltageLevel voltageLevel, ContextExport contextExport) {
        boolean psseSubstationByVoltageLevel = false;
        String psseSubstationId = VoltageLevelConverter.findPsseSubstationId(voltageLevel, psseSubstationByVoltageLevel);
        Map<Integer, Integer> representativeForInternalConnectionsNodes = VoltageLevelConverter.findRepresentativeNodes(voltageLevel);
        List<Set<Integer>> connectedSetsBySwitchesAndInternalConnections = VoltageLevelConverter.connectedSetsBySwitchesAndInternalConnections(voltageLevel);
        if (connectedSetsBySwitchesAndInternalConnections.isEmpty()) {
            return false;
        }
        if (contextExport.getFullExport().getLastPsseNode(psseSubstationId) + VoltageLevelConverter.newPsseNodes(connectedSetsBySwitchesAndInternalConnections, representativeForInternalConnectionsNodes) > VoltageLevelConverter.getMaxPsseNodeBySubstation()) {
            return false;
        }
        contextExport.getFullExport().addPsseSubstationIdVoltageLevel(psseSubstationId, voltageLevel);
        connectedSetsBySwitchesAndInternalConnections.forEach(connectedSet -> {
            int busI = contextExport.getFullExport().getNewPsseBusI();
            HashSet busViewBusesForBusI = new HashSet();
            connectedSet.stream().filter(node -> !VoltageLevelConverter.isRepresented(representativeForInternalConnectionsNodes, node)).forEach(nonRepresentedNode -> VoltageLevelConverter.contextForNonRepresentedNode(voltageLevel, nonRepresentedNode, busI, busViewBusesForBusI, psseSubstationId, contextExport));
            connectedSet.stream().filter(node -> VoltageLevelConverter.isRepresented(representativeForInternalConnectionsNodes, node)).forEach(representedNode -> {
                int representativeNode = (Integer)representativeForInternalConnectionsNodes.get(representedNode);
                VoltageLevelConverter.contextForRepresentedNode(voltageLevel, representedNode, representativeNode, contextExport);
            });
            Bus selectedBus = busViewBusesForBusI.stream().min(Comparator.comparingInt(VoltageLevelConverter::findPriorityType)).orElse(null);
            contextExport.getFullExport().addBusIBusView(busI, selectedBus);
        });
        voltageLevel.getDanglingLineStream().filter(danglingLine -> !danglingLine.isPaired()).forEach(danglingLine -> contextExport.getFullExport().addDanglingLineBusI((DanglingLine)danglingLine, contextExport.getFullExport().getNewPsseBusI()));
        Set mergedSet = connectedSetsBySwitchesAndInternalConnections.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (int node : voltageLevel.getNodeBreakerView().getNodes()) {
            if (mergedSet.contains(node)) continue;
            int busI = contextExport.getFullExport().getNewPsseBusI();
            VoltageLevelConverter.contextForIsolatedNode(voltageLevel, node, busI, psseSubstationId, contextExport);
            contextExport.getFullExport().addBusIBusView(busI, null);
        }
        return true;
    }

    private static int newPsseNodes(List<Set<Integer>> connectedSetsBySwitchesAndInternalConnections, Map<Integer, Integer> representativeForInternalConnectionsNodes) {
        return connectedSetsBySwitchesAndInternalConnections.stream().mapToInt(connectedSet -> (int)connectedSet.stream().filter(node -> !VoltageLevelConverter.isRepresented(representativeForInternalConnectionsNodes, node)).count()).sum();
    }

    private static String findPsseSubstationId(VoltageLevel voltageLevel, boolean psseSubstationByVoltageLevel) {
        return psseSubstationByVoltageLevel ? voltageLevel.getId() : voltageLevel.getSubstation().map(Identifiable::getId).orElse(voltageLevel.getId());
    }

    private static Map<Integer, Integer> findRepresentativeNodes(VoltageLevel voltageLevel) {
        List<Set<Integer>> connectedSetsByInternalConnections = VoltageLevelConverter.connectedSetsByInternalConnections(voltageLevel);
        HashSet nodesOfSwitches = new HashSet();
        voltageLevel.getNodeBreakerView().getSwitches().forEach(sw -> {
            nodesOfSwitches.add(voltageLevel.getNodeBreakerView().getNode1(sw.getId()));
            nodesOfSwitches.add(voltageLevel.getNodeBreakerView().getNode2(sw.getId()));
        });
        HashMap<Integer, Integer> representativeForInternalConnectionsNodes = new HashMap<Integer, Integer>();
        connectedSetsByInternalConnections.forEach(connectedSetByInternalConnections -> {
            int representativeNode = VoltageLevelConverter.findRepresentativeNode(connectedSetByInternalConnections, nodesOfSwitches);
            connectedSetByInternalConnections.forEach(node -> representativeForInternalConnectionsNodes.put((Integer)node, representativeNode));
        });
        return representativeForInternalConnectionsNodes;
    }

    private static List<Set<Integer>> connectedSetsByInternalConnections(VoltageLevel voltageLevel) {
        Pseudograph icGraph = new Pseudograph(null, null, false);
        VoltageLevelConverter.addInternalConnections(voltageLevel, (Graph<Integer, Pair<Integer, Integer>>)icGraph);
        return new ConnectivityInspector((Graph)icGraph).connectedSets();
    }

    private static void addInternalConnections(VoltageLevel voltageLevel, Graph<Integer, Pair<Integer, Integer>> icGraph) {
        voltageLevel.getNodeBreakerView().getInternalConnections().forEach(internalConnection -> {
            int node1 = internalConnection.getNode1();
            int node2 = internalConnection.getNode2();
            icGraph.addVertex((Object)node1);
            icGraph.addVertex((Object)node2);
            icGraph.addEdge((Object)node1, (Object)node2, (Object)Pair.of((Object)node1, (Object)node2));
        });
    }

    private static int findRepresentativeNode(Set<Integer> connectedSetByInternalConnections, Set<Integer> nodesOfSwitches) {
        return connectedSetByInternalConnections.stream().filter(nodesOfSwitches::contains).min(Comparator.naturalOrder()).orElse((Integer)connectedSetByInternalConnections.stream().min(Comparator.naturalOrder()).orElseThrow());
    }

    private static List<Set<Integer>> connectedSetsBySwitchesAndInternalConnections(VoltageLevel voltageLevel) {
        Pseudograph swIcGraph = new Pseudograph(null, null, false);
        VoltageLevelConverter.addInternalConnections(voltageLevel, (Graph<Integer, Pair<Integer, Integer>>)swIcGraph);
        voltageLevel.getNodeBreakerView().getSwitches().forEach(arg_0 -> VoltageLevelConverter.lambda$connectedSetsBySwitchesAndInternalConnections$40(voltageLevel, (Graph)swIcGraph, arg_0));
        return new ConnectivityInspector((Graph)swIcGraph).connectedSets();
    }

    private static boolean isRepresented(Map<Integer, Integer> representativeForInternalConnectionsNodes, int node) {
        return Optional.ofNullable(representativeForInternalConnectionsNodes.get(node)).map(representativeNode -> representativeNode != node).orElse(false);
    }

    private static void contextForNonRepresentedNode(VoltageLevel voltageLevel, int node, int busI, Set<Bus> busViewBusesForBusI, String psseSubstationId, ContextExport contextExport) {
        int psseNode = contextExport.getFullExport().getNewPsseNode(psseSubstationId);
        VoltageLevelConverter.findConnectedBusViewNode(voltageLevel, node).ifPresentOrElse(busView -> {
            contextExport.getFullExport().addNodeData(voltageLevel, node, busI, psseNode, (Bus)busView);
            busViewBusesForBusI.add((Bus)busView);
        }, () -> contextExport.getFullExport().addNodeData(voltageLevel, node, busI, psseNode, null));
    }

    private static void contextForRepresentedNode(VoltageLevel voltageLevel, int node, int representativeNode, ContextExport contextExport) {
        int busI = contextExport.getFullExport().getBusI(voltageLevel, representativeNode).orElseThrow();
        int psseNode = contextExport.getFullExport().getPsseNode(voltageLevel, representativeNode).orElseThrow();
        Bus busView = contextExport.getFullExport().getVoltageBus(voltageLevel, representativeNode).orElse(null);
        contextExport.getFullExport().addNodeData(voltageLevel, node, busI, psseNode, busView);
    }

    private static void contextForIsolatedNode(VoltageLevel voltageLevel, int node, int busI, String psseSubstationId, ContextExport contextExport) {
        int psseNode = contextExport.getFullExport().getNewPsseNode(psseSubstationId);
        contextExport.getFullExport().addNodeData(voltageLevel, node, busI, psseNode, null);
    }

    private static int findPriorityType(Bus busView) {
        int type = VoltageLevelConverter.findBusViewBusType(busView);
        return switch (type) {
            case 3 -> 0;
            case 2 -> 1;
            case 1 -> 2;
            case 4 -> 3;
            default -> throw new PsseException("Unexpected psse bus type: " + type);
        };
    }

    static void createSubstations(PssePowerFlowModel psseModel, ContextExport contextExport) {
        ArrayList psseSubstations = new ArrayList();
        contextExport.getFullExport().getSortedPsseSubstationIds().forEach(psseSubstationId -> {
            ArrayList nodes = new ArrayList();
            ArrayList switchingDevices = new ArrayList();
            ArrayList equipmentTerminals = new ArrayList();
            contextExport.getFullExport().getVoltageLevelSet((String)psseSubstationId).forEach(voltageLevel -> {
                nodes.addAll(VoltageLevelConverter.createPsseSubstationNodes(voltageLevel, contextExport));
                switchingDevices.addAll(VoltageLevelConverter.createPsseSubstationSwitchingDevices(voltageLevel, contextExport));
                equipmentTerminals.addAll(VoltageLevelConverter.createPsseSubstationEquipmentTerminals(voltageLevel, contextExport));
            });
            PsseSubstation psseSubstation = new PsseSubstation(VoltageLevelConverter.createPsseSubstationSubstationRecord(psseSubstationId, contextExport), nodes.stream().sorted(Comparator.comparingInt(PsseSubstation.PsseSubstationNode::getNi)).toList(), switchingDevices.stream().sorted(Comparator.comparingInt(PsseSubstation.PsseSubstationSwitchingDevice::getNi).thenComparingInt(PsseSubstation.PsseSubstationSwitchingDevice::getNj).thenComparing(PsseSubstation.PsseSubstationSwitchingDevice::getCkt)).toList(), equipmentTerminals.stream().sorted(Comparator.comparingInt(PsseSubstation.PsseSubstationEquipmentTerminal::getI).thenComparingInt(PsseSubstation.PsseSubstationEquipmentTerminal::getNi).thenComparingInt(PsseSubstation.PsseSubstationEquipmentTerminal::getJ).thenComparingInt(PsseSubstation.PsseSubstationEquipmentTerminal::getK).thenComparing(PsseSubstation.PsseSubstationEquipmentTerminal::getId).thenComparing(PsseSubstation.PsseSubstationEquipmentTerminal::getType)).toList());
            psseSubstations.add(psseSubstation);
        });
        psseModel.addSubstations(psseSubstations);
    }

    private static PsseSubstation.PsseSubstationRecord createPsseSubstationSubstationRecord(String psseSubstationId, ContextExport contextExport) {
        PsseSubstation.PsseSubstationRecord substationRecord = new PsseSubstation.PsseSubstationRecord();
        substationRecord.setIs(contextExport.getFullExport().getNewPsseSubstationIs());
        substationRecord.setName(psseSubstationId);
        substationRecord.setLati(0.0);
        substationRecord.setLong(0.0);
        substationRecord.setSrg(0.1);
        return substationRecord;
    }

    private static List<PsseSubstation.PsseSubstationNode> createPsseSubstationNodes(VoltageLevel voltageLevel, ContextExport contextExport) {
        ArrayList<PsseSubstation.PsseSubstationNode> nodes = new ArrayList<PsseSubstation.PsseSubstationNode>();
        for (int node : voltageLevel.getNodeBreakerView().getNodes()) {
            contextExport.getFullExport().getBusI(voltageLevel, node).ifPresent(busI -> {
                int ni = contextExport.getFullExport().getPsseNode(voltageLevel, node).orElseThrow();
                Bus voltageBusView = contextExport.getFullExport().getVoltageBus(voltageLevel, node).orElse(null);
                boolean isDeEnergized = contextExport.getFullExport().isDeEnergized(voltageLevel, node);
                PsseSubstation.PsseSubstationNode psseNode = new PsseSubstation.PsseSubstationNode();
                psseNode.setNi(ni);
                psseNode.setName(VoltageLevelConverter.getNodeId(voltageLevel, node));
                psseNode.setI(busI);
                psseNode.setStatus(isDeEnergized ? 0 : 1);
                psseNode.setVm(VoltageLevelConverter.getVm(voltageBusView));
                psseNode.setVa(VoltageLevelConverter.getVa(voltageBusView));
                nodes.add(psseNode);
            });
        }
        return nodes;
    }

    private static List<PsseSubstation.PsseSubstationSwitchingDevice> createPsseSubstationSwitchingDevices(VoltageLevel voltageLevel, ContextExport contextExport) {
        ArrayList<PsseSubstation.PsseSubstationSwitchingDevice> switchingDevices = new ArrayList<PsseSubstation.PsseSubstationSwitchingDevice>();
        voltageLevel.getSwitches().forEach(sw -> {
            int ni = contextExport.getFullExport().getPsseNode(voltageLevel, sw.getVoltageLevel().getNodeBreakerView().getNode1(sw.getId())).orElseThrow();
            int nj = contextExport.getFullExport().getPsseNode(voltageLevel, sw.getVoltageLevel().getNodeBreakerView().getNode2(sw.getId())).orElseThrow();
            PsseSubstation.PsseSubstationSwitchingDevice switchingDevice = new PsseSubstation.PsseSubstationSwitchingDevice();
            switchingDevice.setNi(ni);
            switchingDevice.setNj(nj);
            switchingDevice.setCkt(contextExport.getFullExport().getEquipmentCkt(voltageLevel, sw.getId(), ni, nj));
            switchingDevice.setName(sw.getId());
            switchingDevice.setType(VoltageLevelConverter.getSwitchingDeviceType(sw));
            switchingDevice.setStatus(sw.isOpen() ? 0 : 1);
            switchingDevice.setNstat(1);
            switchingDevice.setX(1.0E-4);
            switchingDevice.setRate1(0.0);
            switchingDevice.setRate2(0.0);
            switchingDevice.setRate3(0.0);
            switchingDevices.add(switchingDevice);
        });
        return switchingDevices;
    }

    private static int getSwitchingDeviceType(Switch sw) {
        return switch (sw.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case SwitchKind.BREAKER, SwitchKind.LOAD_BREAK_SWITCH -> 2;
            case SwitchKind.DISCONNECTOR -> 3;
        };
    }

    private static List<PsseSubstation.PsseSubstationEquipmentTerminal> createPsseSubstationEquipmentTerminals(VoltageLevel voltageLevel, ContextExport contextExport) {
        ArrayList<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminals = new ArrayList<PsseSubstation.PsseSubstationEquipmentTerminal>();
        VoltageLevelConverter.getEquipmentListToBeExported(voltageLevel).forEach(equipmentId -> {
            Identifiable<?> identifiable = VoltageLevelConverter.getIdentifiable(voltageLevel, equipmentId);
            String type = VoltageLevelConverter.getPsseEquipmentType(identifiable);
            List<Terminal> terminals = VoltageLevelConverter.getEquipmentTerminals(voltageLevel, equipmentId);
            VoltageLevelConverter.getNodesInsideVoltageLevelPreservingOrder(voltageLevel, terminals, contextExport).forEach(nodeBusR -> {
                List<Integer> otherBuses = VoltageLevelConverter.getTwoOtherBusesPreservingOrder(identifiable, terminals, nodeBusR, contextExport);
                String ckt = contextExport.getFullExport().getEquipmentCkt((String)equipmentId, type, nodeBusR.busI(), otherBuses.get(0), otherBuses.get(1));
                PsseSubstation.PsseSubstationEquipmentTerminal equipmentTerminal = new PsseSubstation.PsseSubstationEquipmentTerminal();
                equipmentTerminal.setNi(nodeBusR.psseNode);
                equipmentTerminal.setType(type);
                equipmentTerminal.setId(VoltageLevelConverter.getEquipmentTerminalId(type, identifiable, ckt));
                equipmentTerminal.setI(nodeBusR.busI);
                equipmentTerminal.setJ(otherBuses.get(0).intValue());
                equipmentTerminal.setK(otherBuses.get(1).intValue());
                equipmentTerminals.add(equipmentTerminal);
            });
        });
        return equipmentTerminals;
    }

    private static String getEquipmentTerminalId(String type, Identifiable<?> identifiable, String ckt) {
        return switch (type) {
            case "A" -> VoltageLevelConverter.extractFactsDeviceName(identifiable.getId());
            case "D" -> VoltageLevelConverter.extractTwoTerminalDcName(identifiable.getId());
            case "V" -> VoltageLevelConverter.extractVscDcTransmissionLineName(identifiable.getId());
            default -> ckt;
        };
    }

    private static List<NodeBusR> getNodesInsideVoltageLevelPreservingOrder(VoltageLevel voltageLevel, List<Terminal> terminals, ContextExport contextExport) {
        return terminals.stream().filter(terminal -> terminal.getVoltageLevel().equals(voltageLevel)).map(terminal -> VoltageLevelConverter.findNodeBusR(terminal, contextExport)).toList();
    }

    private static NodeBusR findNodeBusR(Terminal terminal, ContextExport contextExport) {
        int node = terminal.getNodeBreakerView().getNode();
        int busI = contextExport.getFullExport().getBusI(terminal.getVoltageLevel(), node).orElseThrow();
        int psseNode = contextExport.getFullExport().getPsseNode(terminal.getVoltageLevel(), node).orElseThrow();
        return new NodeBusR(terminal.getVoltageLevel(), node, psseNode, busI);
    }

    private static List<Integer> getTwoOtherBusesPreservingOrder(Identifiable<?> identifiable, List<Terminal> terminals, NodeBusR nodeBusR, ContextExport contextExport) {
        ArrayList<Integer> buses = new ArrayList<Integer>();
        if (identifiable.getType() == IdentifiableType.DANGLING_LINE) {
            buses.add(contextExport.getFullExport().getBusI((DanglingLine)identifiable).orElseThrow());
        } else {
            terminals.forEach(terminal -> {
                if (contextExport.getFullExport().isExportedAsNodeBreaker(terminal.getVoltageLevel())) {
                    NodeBusR otherNodeBusR = VoltageLevelConverter.findNodeBusR(terminal, contextExport);
                    if (!nodeBusR.equals(otherNodeBusR)) {
                        buses.add(otherNodeBusR.busI);
                    }
                } else {
                    Bus busView = VoltageLevelConverter.getTerminalConnectableBusView(terminal);
                    buses.add(contextExport.getFullExport().getBusI(busView).orElseThrow());
                }
            });
        }
        VoltageLevelConverter.completeWithZerosUntilTwoBuses(identifiable.getId(), buses);
        return buses;
    }

    private static void completeWithZerosUntilTwoBuses(String equipmentId, List<Integer> buses) {
        if (buses.isEmpty()) {
            buses.add(0);
            buses.add(0);
        } else if (buses.size() == 1) {
            buses.add(0);
        } else if (buses.size() > 2) {
            throw new PsseException("Unexpected number of buses for equipmentId: " + equipmentId);
        }
    }

    private static Identifiable<?> getIdentifiable(VoltageLevel voltageLevel, String identifiableId) {
        Identifiable identifiable = voltageLevel.getNetwork().getIdentifiable(identifiableId);
        if (identifiable != null) {
            return identifiable;
        }
        throw new PsseException("Unexpected identifiableId: " + identifiableId);
    }

    private static Optional<Integer> findBusI(PsseSubstation psseSubstation, int node) {
        return psseSubstation.getNodes().stream().filter(psseNode -> psseNode.getNi() == node).map(PsseSubstation.PsseSubstationNode::getI).findFirst();
    }

    static void updateSubstations(Network network, ContextExport contextExport) {
        network.getVoltageLevels().forEach(voltageLevel -> {
            if (voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
                HashSet<Integer> buses = new HashSet<Integer>(VoltageLevelConverter.extractBusesFromVoltageLevelId(voltageLevel.getId()));
                contextExport.getUpdateExport().getPsseSubstation((VoltageLevel)voltageLevel).ifPresent(psseSubstation -> VoltageLevelConverter.updateSubstation(voltageLevel, psseSubstation, buses, contextExport));
            }
        });
    }

    private static void updateSubstation(VoltageLevel voltageLevel, PsseSubstation psseSubstation, Set<Integer> busesSet, ContextExport contextExport) {
        Set<PsseSubstation.PsseSubstationNode> psseNodeSet = psseSubstation.getNodes().stream().filter(psseNode -> busesSet.contains(psseNode.getI())).collect(Collectors.toSet());
        psseNodeSet.forEach(psseSubstationNode -> {
            Optional<Bus> busView = contextExport.getUpdateExport().getBusView(voltageLevel, psseSubstationNode.getNi());
            if (busView.isPresent()) {
                psseSubstationNode.setVm(VoltageLevelConverter.getVm(busView.get()));
                psseSubstationNode.setVa(VoltageLevelConverter.getVa(busView.get()));
            } else {
                psseSubstationNode.setVm(1.0);
                psseSubstationNode.setVa(0.0);
            }
        });
        Set nodesSet = psseNodeSet.stream().map(PsseSubstation.PsseSubstationNode::getNi).collect(Collectors.toSet());
        Set<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceSet = psseSubstation.getSwitchingDevices().stream().filter(sd -> nodesSet.contains(sd.getNi()) && nodesSet.contains(sd.getNj())).collect(Collectors.toSet());
        switchingDeviceSet.forEach(switchingDevice -> {
            String switchId = VoltageLevelConverter.getSwitchId(voltageLevel.getId(), switchingDevice);
            Switch sw = voltageLevel.getNodeBreakerView().getSwitch(switchId);
            if (sw == null) {
                throw new PsseException("Unexpected null breaker: " + switchId);
            }
            switchingDevice.setStatus(sw.isOpen() ? 0 : 1);
        });
    }

    private static /* synthetic */ void lambda$connectedSetsBySwitchesAndInternalConnections$40(VoltageLevel voltageLevel, Graph swIcGraph, Switch sw) {
        int node1 = voltageLevel.getNodeBreakerView().getNode1(sw.getId());
        int node2 = voltageLevel.getNodeBreakerView().getNode2(sw.getId());
        swIcGraph.addVertex((Object)node1);
        swIcGraph.addVertex((Object)node2);
        swIcGraph.addEdge((Object)node1, (Object)node2, (Object)Pair.of((Object)node1, (Object)node2));
    }

    private record NodeBusR(VoltageLevel voltageLevel, int node, int psseNode, int busI) {
        boolean equals(NodeBusR other) {
            return this.voltageLevel().equals(other.voltageLevel()) && this.node() == other.node();
        }
    }
}

