/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Network;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.ArrayList;
import java.util.Comparator;

class BatteryConverter
extends AbstractConverter {
    BatteryConverter(Network network) {
        super(network);
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        ArrayList loads = new ArrayList();
        network.getBatteries().forEach(battery -> loads.add(BatteryConverter.createBattery(battery, contextExport)));
        psseModel.addLoads(loads);
        psseModel.replaceAllLoads(psseModel.getLoads().stream().sorted(Comparator.comparingInt(PsseLoad::getI).thenComparing(PsseLoad::getId)).toList());
    }

    private static PsseLoad createBattery(Battery battery, ContextExport contextExport) {
        PsseLoad psseLoad = BatteryConverter.createDefaultLoad();
        int busI = BatteryConverter.getTerminalBusI(battery.getTerminal(), contextExport);
        psseLoad.setI(busI);
        psseLoad.setId(contextExport.getFullExport().getEquipmentCkt(battery.getId(), AbstractConverter.PsseEquipmentType.PSSE_LOAD.getTextCode(), busI));
        psseLoad.setStatus(BatteryConverter.getStatus(battery.getTerminal(), contextExport));
        psseLoad.setPl(BatteryConverter.getP(battery));
        psseLoad.setQl(BatteryConverter.getQ(battery));
        return psseLoad;
    }

    private static double getP(Battery battery) {
        return Double.isNaN(battery.getTargetP()) ? 0.0 : -battery.getTargetP();
    }

    private static double getQ(Battery battery) {
        return Double.isNaN(battery.getTargetQ()) ? 0.0 : -battery.getTargetQ();
    }
}

