/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

class BusConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final NodeBreakerImport nodeBreakerImport;

    BusConverter(PsseBus psseBus, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create(VoltageLevel voltageLevel) {
        if (this.nodeBreakerImport.isTopologicalBus(this.psseBus.getI())) {
            return;
        }
        String busId = BusConverter.getBusId(this.psseBus.getI());
        Bus bus = ((BusAdder)((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(busId)).setName(this.psseBus.getName())).add();
        bus.setV(this.psseBus.getVm() * voltageLevel.getNominalV()).setAngle(this.psseBus.getVa());
    }

    static void create(PssePowerFlowModel psseModel, ContextExport contextExport) {
        ArrayList buses = new ArrayList();
        contextExport.getFullExport().getBusISet().forEach(busI -> {
            double nominalV;
            String busName;
            Bus busViewBus = contextExport.getFullExport().getBusView((int)busI).orElse(null);
            int type = BusConverter.findBusViewBusType(busViewBus);
            if (busViewBus != null) {
                busName = BusConverter.fixBusName(busViewBus.getNameOrId());
                nominalV = busViewBus.getVoltageLevel().getNominalV();
            } else {
                VoltageLevel voltageLevel = contextExport.getFullExport().getVoltageLevel((int)busI).orElseThrow();
                int node = contextExport.getFullExport().getNode((int)busI).orElseThrow();
                busName = BusConverter.fixBusName(voltageLevel.getNameOrId() + "-" + node);
                nominalV = voltageLevel.getNominalV();
            }
            buses.add(BusConverter.createBus(busViewBus, busI, busName, nominalV, type));
        });
        psseModel.addBuses(buses);
        psseModel.replaceAllBuses(psseModel.getBuses().stream().sorted(Comparator.comparingInt(PsseBus::getI)).toList());
    }

    private static PsseBus createBus(Bus bus, int busI, String busName, double nominalV, int type) {
        PsseBus psseBus = BusConverter.createDefaultBus();
        psseBus.setI(busI);
        psseBus.setName(busName);
        psseBus.setBaskv(nominalV);
        psseBus.setIde(type);
        psseBus.setVm(BusConverter.getVm(bus));
        psseBus.setVa(BusConverter.getVa(bus));
        psseBus.setNvhi(BusConverter.getHighVm(bus));
        psseBus.setNvlo(BusConverter.getLowVm(bus));
        psseBus.setEvhi(BusConverter.getHighVm(bus));
        psseBus.setEvlo(BusConverter.getLowVm(bus));
        return psseBus;
    }

    static void update(PssePowerFlowModel psseModel, ContextExport contextExport) {
        psseModel.getBuses().forEach(psseBus -> {
            Optional<Bus> busViewBus = contextExport.getUpdateExport().getBusView(psseBus.getI());
            if (busViewBus.isPresent()) {
                BusConverter.updatePsseBus(busViewBus.get(), BusConverter.findBusType(busViewBus.get().getVoltageLevel(), busViewBus.get(), psseBus), psseBus);
            } else {
                BusConverter.updateIsolatedPsseBus(psseBus);
            }
        });
    }

    private static int findBusType(VoltageLevel voltageLevel, Bus busView, PsseBus psseBus) {
        return BusConverter.exportVoltageLevelAsNodeBreaker(voltageLevel) ? psseBus.getIde() : BusConverter.findBusViewBusType(busView);
    }

    private static void updatePsseBus(Bus busView, int type, PsseBus psseBus) {
        if (busView == null) {
            BusConverter.updateIsolatedPsseBus(psseBus);
        } else if (type == 4) {
            BusConverter.updateIsolatedPsseBus(psseBus);
        } else {
            psseBus.setVm(BusConverter.getVm(busView));
            psseBus.setVa(BusConverter.getVa(busView));
            psseBus.setIde(type);
        }
    }

    private static void updateIsolatedPsseBus(PsseBus psseBus) {
        psseBus.setVm(0.0);
        psseBus.setVa(0.0);
        psseBus.setIde(4);
    }
}

