/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.util.DanglingLineData;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.PsseExporter;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseRates;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.math3.complex.Complex;

class DanglingLineConverter
extends AbstractConverter {
    DanglingLineConverter(Network network) {
        super(network);
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        List<DanglingLine> unPairedDanglingLines = network.getDanglingLineStream().filter(danglingLine -> !danglingLine.isPaired()).toList();
        if (!unPairedDanglingLines.isEmpty()) {
            DanglingLineConverter.createUnpairedDanglingLines(unPairedDanglingLines, psseModel, contextExport, perUnitContext);
        }
    }

    private static void createUnpairedDanglingLines(List<DanglingLine> unPairedDanglingLines, PssePowerFlowModel psseModel, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        unPairedDanglingLines.forEach(danglingLine -> {
            PsseBus psseBus = DanglingLineConverter.createDanglingLineBus(danglingLine, contextExport);
            psseModel.addBuses(Collections.singletonList(psseBus));
            psseModel.addNonTransformerBranches(Collections.singletonList(DanglingLineConverter.createDanglingLineBranch(danglingLine, psseBus.getI(), contextExport, perUnitContext)));
            DanglingLineConverter.createDanglingLineLoad(danglingLine, psseBus.getI(), contextExport).ifPresent(psseLoad -> psseModel.addLoads(Collections.singletonList(psseLoad)));
            DanglingLineConverter.createDanglingLineGenerator(danglingLine, psseBus.getI(), contextExport, perUnitContext).ifPresent(psseGenerator -> psseModel.addGenerators(Collections.singletonList(psseGenerator)));
        });
        psseModel.replaceAllBuses(psseModel.getBuses().stream().sorted(Comparator.comparingInt(PsseBus::getI)).toList());
        psseModel.replaceAllNonTransformerBranches(psseModel.getNonTransformerBranches().stream().sorted(Comparator.comparingInt(PsseNonTransformerBranch::getI).thenComparingInt(PsseNonTransformerBranch::getJ).thenComparing(PsseNonTransformerBranch::getCkt)).toList());
        psseModel.replaceAllLoads(psseModel.getLoads().stream().sorted(Comparator.comparingInt(PsseLoad::getI).thenComparing(PsseLoad::getId)).toList());
        psseModel.replaceAllGenerators(psseModel.getGenerators().stream().sorted(Comparator.comparingInt(PsseGenerator::getI).thenComparing(PsseGenerator::getId)).toList());
    }

    private static PsseBus createDanglingLineBus(DanglingLine danglingLine, ContextExport contextExport) {
        Bus networkBusView = DanglingLineConverter.getTerminalConnectableBusView(danglingLine.getTerminal());
        PsseBus psseBus = DanglingLineConverter.createDefaultBus();
        psseBus.setI(contextExport.getFullExport().getBusI(danglingLine).orElseThrow());
        psseBus.setName(DanglingLineConverter.fixBusName(danglingLine.getNameOrId()));
        psseBus.setBaskv(danglingLine.getTerminal().getVoltageLevel().getNominalV());
        psseBus.setIde(DanglingLineConverter.findType(danglingLine, contextExport));
        psseBus.setVm(DanglingLineConverter.getVm(new DanglingLineData(danglingLine).getBoundaryBusU()));
        psseBus.setVa(DanglingLineConverter.getVa(Math.toDegrees(new DanglingLineData(danglingLine).getBoundaryBusTheta())));
        psseBus.setNvhi(DanglingLineConverter.getHighVm(networkBusView));
        psseBus.setNvlo(DanglingLineConverter.getLowVm(networkBusView));
        psseBus.setEvhi(DanglingLineConverter.getHighVm(networkBusView));
        psseBus.setEvlo(DanglingLineConverter.getLowVm(networkBusView));
        return psseBus;
    }

    private static int findType(DanglingLine danglingLine, ContextExport contextExport) {
        if (DanglingLineConverter.getStatus(danglingLine.getTerminal(), contextExport) == 1) {
            return DanglingLineConverter.isVoltageRegulationOn(danglingLine) ? 2 : 1;
        }
        return 4;
    }

    private static PsseNonTransformerBranch createDanglingLineBranch(DanglingLine danglingLine, int busJ, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseNonTransformerBranch psseLine = DanglingLineConverter.createDefaultNonTransformerBranch();
        int busI = DanglingLineConverter.getTerminalBusI(danglingLine.getTerminal(), contextExport);
        double vNom1 = danglingLine.getTerminal().getVoltageLevel().getNominalV();
        Complex transmissionAdmittance = new Complex(danglingLine.getR(), danglingLine.getX()).reciprocal();
        psseLine.setI(busI);
        psseLine.setJ(busJ);
        psseLine.setCkt(contextExport.getFullExport().getEquipmentCkt(danglingLine.getId(), AbstractConverter.PsseEquipmentType.PSSE_BRANCH.getTextCode(), busI, busJ));
        psseLine.setR(DanglingLineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(danglingLine.getR(), vNom1, vNom1, perUnitContext.sBase()));
        psseLine.setX(DanglingLineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(danglingLine.getX(), vNom1, vNom1, perUnitContext.sBase()));
        psseLine.setName(DanglingLineConverter.fixNonTransformerBranchName(danglingLine.getNameOrId()));
        psseLine.setRates(DanglingLineConverter.createRates(danglingLine, vNom1));
        psseLine.setGi(DanglingLineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getReal(), danglingLine.getG(), vNom1, vNom1, perUnitContext.sBase()));
        psseLine.setBi(DanglingLineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getImaginary(), danglingLine.getB(), vNom1, vNom1, perUnitContext.sBase()));
        psseLine.setSt(DanglingLineConverter.getStatus(danglingLine.getTerminal(), contextExport));
        return psseLine;
    }

    private static PsseRates createRates(DanglingLine danglingLine, double vNominal1) {
        PsseRates windingRates = DanglingLineConverter.createDefaultRates();
        danglingLine.getApparentPowerLimits().ifPresent(apparentPowerLimits -> DanglingLineConverter.setSortedRatesToPsseRates(DanglingLineConverter.getSortedRates(apparentPowerLimits), windingRates));
        if (danglingLine.getApparentPowerLimits().isEmpty()) {
            danglingLine.getCurrentLimits().ifPresent(currentLimits -> DanglingLineConverter.setSortedRatesToPsseRates(DanglingLineConverter.getSortedRates(currentLimits, vNominal1), windingRates));
        }
        if (danglingLine.getApparentPowerLimits().isEmpty() && danglingLine.getCurrentLimits().isEmpty()) {
            danglingLine.getActivePowerLimits().ifPresent(activePowerLimits -> DanglingLineConverter.setSortedRatesToPsseRates(DanglingLineConverter.getSortedRates(activePowerLimits), windingRates));
        }
        return windingRates;
    }

    private static Optional<PsseLoad> createDanglingLineLoad(DanglingLine danglingLine, int busJ, ContextExport contextExport) {
        if (!DanglingLineConverter.isLoadDefined(danglingLine)) {
            return Optional.empty();
        }
        PsseLoad psseLoad = DanglingLineConverter.createDefaultLoad();
        psseLoad.setI(busJ);
        psseLoad.setId(contextExport.getFullExport().getEquipmentCkt(danglingLine.getId(), AbstractConverter.PsseEquipmentType.PSSE_LOAD.getTextCode(), busJ));
        psseLoad.setStatus(1);
        psseLoad.setPl(danglingLine.getP0());
        psseLoad.setQl(danglingLine.getQ0());
        return Optional.of(psseLoad);
    }

    private static boolean isLoadDefined(DanglingLine danglingLine) {
        return Double.isFinite(danglingLine.getP0()) && Double.isFinite(danglingLine.getQ0()) && (danglingLine.getP0() != 0.0 || danglingLine.getQ0() != 0.0);
    }

    private static Optional<PsseGenerator> createDanglingLineGenerator(DanglingLine danglingLine, int busJ, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        if (DanglingLineConverter.isGeneratorDefined(danglingLine)) {
            return Optional.of(DanglingLineConverter.createGenerator(danglingLine, danglingLine.getGeneration(), busJ, contextExport, perUnitContext));
        }
        return Optional.empty();
    }

    private static PsseGenerator createGenerator(DanglingLine danglingLine, DanglingLine.Generation generation, int busJ, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseGenerator psseGenerator = DanglingLineConverter.createDefaultGenerator();
        psseGenerator.setI(busJ);
        psseGenerator.setId(contextExport.getFullExport().getEquipmentCkt(danglingLine.getId(), AbstractConverter.PsseEquipmentType.PSSE_GENERATOR.getTextCode(), busJ));
        psseGenerator.setPg(generation.getTargetP());
        psseGenerator.setQg(generation.getTargetQ());
        psseGenerator.setQt(Math.max(DanglingLineConverter.getMaxQ(generation), DanglingLineConverter.getMinQ(generation)));
        psseGenerator.setQb(DanglingLineConverter.getMinQ(generation));
        psseGenerator.setVs(DanglingLineConverter.getTargetV(danglingLine, generation));
        psseGenerator.setIreg(busJ);
        psseGenerator.setNreg(0);
        psseGenerator.setMbase(perUnitContext.sBase());
        psseGenerator.setStat(1);
        psseGenerator.setPt(DanglingLineConverter.getMaxP(generation));
        psseGenerator.setPb(DanglingLineConverter.getMinP(generation));
        return psseGenerator;
    }

    private static boolean isGeneratorDefined(DanglingLine danglingLine) {
        return danglingLine.getGeneration() != null;
    }

    private static boolean isVoltageRegulationOn(DanglingLine danglingLine) {
        return danglingLine.getGeneration() != null && danglingLine.getGeneration().isVoltageRegulationOn();
    }

    private static double getMaxP(DanglingLine.Generation generation) {
        return Double.isNaN(generation.getMaxP()) ? 9999.0 : generation.getMaxP();
    }

    private static double getMinP(DanglingLine.Generation generation) {
        return Double.isNaN(generation.getMinP()) ? -9999.0 : generation.getMinP();
    }

    private static double getMaxQ(DanglingLine.Generation generation) {
        return generation.getReactiveLimits() != null ? generation.getReactiveLimits().getMaxQ(generation.getTargetP()) : 9999.0;
    }

    private static double getMinQ(DanglingLine.Generation generation) {
        return generation.getReactiveLimits() != null ? generation.getReactiveLimits().getMinQ(generation.getTargetP()) : -9999.0;
    }

    private static double getTargetV(DanglingLine danglingLine, DanglingLine.Generation generation) {
        if (Double.isNaN(generation.getTargetV()) || generation.getTargetV() <= 0.0) {
            return 1.0;
        }
        return generation.getTargetV() / danglingLine.getTerminal().getVoltageLevel().getNominalV();
    }
}

