/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FixedShuntCompensatorConverter
extends AbstractConverter {
    private final PsseFixedShunt psseFixedShunt;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedShuntCompensatorConverter.class);

    FixedShuntCompensatorConverter(PsseFixedShunt psseFixedShunt, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseFixedShunt = Objects.requireNonNull(psseFixedShunt);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseFixedShunt.getI())) {
            return;
        }
        if (this.psseFixedShunt.getGl() == 0.0 && this.psseFixedShunt.getBl() == 0.0) {
            LOGGER.warn("Shunt ({}) has Gl and Bl = 0, not imported ", (Object)this.psseFixedShunt.getI());
            return;
        }
        VoltageLevel voltageLevel = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseFixedShunt.getI()));
        ShuntCompensatorAdder adder = ((ShuntCompensatorAdder)voltageLevel.newShuntCompensator().setId(FixedShuntCompensatorConverter.getFixedShuntId(this.psseFixedShunt.getI(), this.psseFixedShunt.getId()))).setVoltageRegulatorOn(false).setSectionCount(1);
        adder.newLinearModel().setGPerSection(FixedShuntCompensatorConverter.powerToShuntAdmittance(this.psseFixedShunt.getGl(), voltageLevel.getNominalV())).setBPerSection(FixedShuntCompensatorConverter.powerToShuntAdmittance(this.psseFixedShunt.getBl(), voltageLevel.getNominalV())).setMaximumSectionCount(1).add();
        String equipmentId = FixedShuntCompensatorConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_FIXED_SHUNT, this.psseFixedShunt.getI(), this.psseFixedShunt.getId());
        OptionalInt node = this.nodeBreakerImport.getNode(FixedShuntCompensatorConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseFixedShunt.getI(), 0, 0, this.psseFixedShunt.getI(), "I"));
        if (node.isPresent()) {
            adder.setNode(node.getAsInt());
        } else {
            String busId = FixedShuntCompensatorConverter.getBusId(this.psseFixedShunt.getI());
            adder.setConnectableBus(busId);
            adder.setBus(this.psseFixedShunt.getStatus() == 1 ? busId : null);
        }
        adder.add();
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        ArrayList fixedShunts = new ArrayList();
        network.getShuntCompensators().forEach(shuntCompensator -> fixedShunts.add(FixedShuntCompensatorConverter.createFixedShunt(shuntCompensator, contextExport)));
        psseModel.addFixedShunts(fixedShunts);
        psseModel.replaceAllFixedShunts(psseModel.getFixedShunts().stream().sorted(Comparator.comparingInt(PsseFixedShunt::getI).thenComparing(PsseFixedShunt::getId)).toList());
    }

    static PsseFixedShunt createFixedShunt(ShuntCompensator shuntCompensator, ContextExport contextExport) {
        PsseFixedShunt psseFixedShunt = new PsseFixedShunt();
        int busI = FixedShuntCompensatorConverter.getTerminalBusI(shuntCompensator.getTerminal(), contextExport);
        psseFixedShunt.setI(busI);
        psseFixedShunt.setId(contextExport.getFullExport().getEquipmentCkt(shuntCompensator.getId(), AbstractConverter.PsseEquipmentType.PSSE_FIXED_SHUNT.getTextCode(), busI));
        psseFixedShunt.setStatus(FixedShuntCompensatorConverter.getStatus(shuntCompensator.getTerminal(), contextExport));
        psseFixedShunt.setGl(FixedShuntCompensatorConverter.getP(shuntCompensator));
        psseFixedShunt.setBl(FixedShuntCompensatorConverter.getQ(shuntCompensator));
        return psseFixedShunt;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getFixedShunts().forEach(psseFixedShunt -> {
            String fixedShuntId = FixedShuntCompensatorConverter.getFixedShuntId(psseFixedShunt.getI(), psseFixedShunt.getId());
            ShuntCompensator fixedShunt = network.getShuntCompensator(fixedShuntId);
            if (fixedShunt == null) {
                psseFixedShunt.setStatus(0);
            } else {
                psseFixedShunt.setStatus(FixedShuntCompensatorConverter.getUpdatedStatus(fixedShunt.getTerminal()));
                psseFixedShunt.setGl(FixedShuntCompensatorConverter.getP(fixedShunt));
                psseFixedShunt.setBl(FixedShuntCompensatorConverter.getQ(fixedShunt));
            }
        });
    }

    private static double getP(ShuntCompensator shuntCompensator) {
        return FixedShuntCompensatorConverter.shuntAdmittanceToPower(shuntCompensator.getG(shuntCompensator.getSectionCount()), shuntCompensator.getTerminal().getVoltageLevel().getNominalV());
    }

    private static double getQ(ShuntCompensator shuntCompensator) {
        return FixedShuntCompensatorConverter.shuntAdmittanceToPower(shuntCompensator.getB(shuntCompensator.getSectionCount()), shuntCompensator.getTerminal().getVoltageLevel().getNominalV());
    }
}

