/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.google.auto.service.AutoService;
import com.google.common.io.ByteStreams;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.AreaConverter;
import com.powsybl.psse.converter.BusConverter;
import com.powsybl.psse.converter.FactsDeviceConverter;
import com.powsybl.psse.converter.FixedShuntCompensatorConverter;
import com.powsybl.psse.converter.GeneratorConverter;
import com.powsybl.psse.converter.LineConverter;
import com.powsybl.psse.converter.LoadConverter;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.converter.NodeBreakerValidation;
import com.powsybl.psse.converter.SlackConverter;
import com.powsybl.psse.converter.SubstationConverter;
import com.powsybl.psse.converter.SwitchedShuntCompensatorConverter;
import com.powsybl.psse.converter.TransformerConverter;
import com.powsybl.psse.converter.TwoTerminalDcConverter;
import com.powsybl.psse.converter.VoltageLevelConverter;
import com.powsybl.psse.converter.VscDcTransmissionLineConverter;
import com.powsybl.psse.converter.extensions.PsseConversionContextExtensionAdder;
import com.powsybl.psse.converter.extensions.PsseModelExtensionAdder;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.pf.PsseArea;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseFacts;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PsseFixes;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSubstation;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseValidation;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverterDcTransmissionLine;
import com.powsybl.psse.model.pf.io.PowerFlowDataFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Importer.class})
public class PsseImporter
implements Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsseImporter.class);
    private static final String FORMAT = "PSS/E";
    private static final String[] EXTENSIONS = new String[]{"raw", "RAW", "rawx", "RAWX"};
    private static final Parameter IGNORE_BASE_VOLTAGE_PARAMETER = new Parameter("psse.import.ignore-base-voltage", ParameterType.BOOLEAN, "Ignore base voltage specified in the file", (Object)Boolean.FALSE);
    private static final Parameter IGNORE_NODE_BREAKER_TOPOLOGY_PARAMETER = new Parameter("psse.import.ignore-node-breaker-topology", ParameterType.BOOLEAN, "Ignore the node breaker topology specified in the substation data of the file", (Object)Boolean.FALSE);

    public String getFormat() {
        return FORMAT;
    }

    public List<String> getSupportedExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<Parameter> getParameters() {
        List<Parameter> parameterList = List.of(IGNORE_BASE_VOLTAGE_PARAMETER, IGNORE_NODE_BREAKER_TOPOLOGY_PARAMETER);
        return ConfiguredParameter.load(parameterList, (String)this.getFormat(), (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
    }

    public String getComment() {
        return "PSS/E Format to IIDM converter";
    }

    public boolean exists(ReadOnlyDataSource dataSource) {
        try {
            String ext = this.findExtension(dataSource);
            return this.exists(dataSource, ext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String findExtension(ReadOnlyDataSource dataSource) throws IOException {
        for (String ext : EXTENSIONS) {
            if (!dataSource.isDataExtension(ext) || !dataSource.exists(null, ext)) continue;
            return ext;
        }
        return null;
    }

    private boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        if (ext != null) {
            try {
                return PowerFlowDataFactory.create((String)ext).isValidFile(dataSource, ext);
            }
            catch (PsseException | IOException e) {
                LOGGER.error(String.format("Invalid content in filename %s.%s: %s", dataSource.getBaseName(), ext, e.getMessage()));
            }
        }
        return false;
    }

    public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
        Objects.requireNonNull(fromDataSource);
        Objects.requireNonNull(toDataSource);
        try {
            String ext = this.findExtension(fromDataSource);
            if (!this.exists(fromDataSource, ext)) {
                throw new PowsyblException("From data source is not importable");
            }
            try (InputStream is = fromDataSource.newInputStream(null, ext);
                 OutputStream os = toDataSource.newOutputStream(null, ext, false);){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(networkFactory);
        try {
            String ext = this.findExtension(dataSource);
            if (ext == null) {
                throw new PsseException(String.format("No Power Flow Data file found. Basename: %s, supported extensions: %s", dataSource.getBaseName(), String.join((CharSequence)"|", EXTENSIONS)));
            }
            PsseVersion version = PowerFlowDataFactory.create((String)ext).readVersion(dataSource, ext);
            Context context = new Context();
            PssePowerFlowModel pssePowerFlowModel = PowerFlowDataFactory.create((String)ext, (PsseVersion)version).read(dataSource, ext, context);
            pssePowerFlowModel.getCaseIdentification().validate();
            new PsseFixes(pssePowerFlowModel, context.getVersion()).fix();
            PsseValidation psseValidation = new PsseValidation(pssePowerFlowModel, context.getVersion());
            if (!psseValidation.isValidCase()) {
                throw new PsseException("The PSS/E file is not a valid case");
            }
            Network network = networkFactory.createNetwork(dataSource.getBaseName(), FORMAT);
            this.convert(pssePowerFlowModel, network, parameters, version);
            ((PsseModelExtensionAdder)network.newExtension(PsseModelExtensionAdder.class)).withModel(pssePowerFlowModel).add();
            ((PsseConversionContextExtensionAdder)network.newExtension(PsseConversionContextExtensionAdder.class)).withContext(context).add();
            return network;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Network convert(PssePowerFlowModel psseModel, Network network, Properties parameters, PsseVersion version) {
        boolean ignoreBaseVoltage = Parameter.readBoolean((String)FORMAT, (Properties)parameters, (Parameter)IGNORE_BASE_VOLTAGE_PARAMETER, (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
        boolean ignoreNodeBreakerTopology = Parameter.readBoolean((String)FORMAT, (Properties)parameters, (Parameter)IGNORE_NODE_BREAKER_TOPOLOGY_PARAMETER, (ParameterDefaultValueConfig)ParameterDefaultValueConfig.INSTANCE);
        PerUnitContext perUnitContext = new PerUnitContext(psseModel.getCaseIdentification().getSbase(), ignoreBaseVoltage);
        Map<Integer, PsseBus> busNumToPsseBus = psseModel.getBuses().stream().collect(Collectors.toMap(PsseBus::getI, Function.identity()));
        NodeBreakerValidation nodeBreakerValidation = new NodeBreakerValidation(ignoreNodeBreakerTopology);
        nodeBreakerValidation.fillAndValidate(psseModel, version);
        ContainersMapping containersMapping = this.defineContainersMapping(psseModel, busNumToPsseBus, perUnitContext, nodeBreakerValidation);
        NodeBreakerImport nodeBreakerImport = PsseImporter.createBuses(psseModel, containersMapping, perUnitContext, network, nodeBreakerValidation);
        for (PsseLoad psseLoad : psseModel.getLoads()) {
            new LoadConverter(psseLoad, containersMapping, network, nodeBreakerImport).create();
        }
        for (PsseFixedShunt psseShunt : psseModel.getFixedShunts()) {
            new FixedShuntCompensatorConverter(psseShunt, containersMapping, network, nodeBreakerImport).create();
        }
        for (PsseGenerator psseGen : psseModel.getGenerators()) {
            new GeneratorConverter(psseGen, containersMapping, network, nodeBreakerImport).create();
        }
        for (PsseNonTransformerBranch psseLine : psseModel.getNonTransformerBranches()) {
            new LineConverter(psseLine, containersMapping, perUnitContext, network, version, nodeBreakerImport).create();
        }
        for (PsseTransformer psseTfo : psseModel.getTransformers()) {
            new TransformerConverter(psseTfo, containersMapping, perUnitContext, network, busNumToPsseBus, psseModel.getCaseIdentification().getSbase(), version, nodeBreakerImport).create();
        }
        for (PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc : psseModel.getTwoTerminalDcTransmissionLines()) {
            new TwoTerminalDcConverter(psseTwoTerminalDc, containersMapping, network, nodeBreakerImport).create();
        }
        for (PsseVoltageSourceConverterDcTransmissionLine psseVscDcTransmissionLine : psseModel.getVoltageSourceConverterDcTransmissionLines()) {
            new VscDcTransmissionLineConverter(psseVscDcTransmissionLine, containersMapping, network, version, nodeBreakerImport).create();
        }
        for (PsseFacts psseFactsDevice : psseModel.getFacts()) {
            new FactsDeviceConverter(psseFactsDevice, containersMapping, network, version, nodeBreakerImport).create();
        }
        for (PsseSwitchedShunt psseSwShunt : psseModel.getSwitchedShunts()) {
            new SwitchedShuntCompensatorConverter(psseSwShunt, containersMapping, network, version, nodeBreakerImport).create();
        }
        for (PsseArea psseArea : psseModel.getAreas()) {
            new AreaConverter(psseArea, psseModel.getBuses(), containersMapping, network).create();
        }
        new SlackConverter(psseModel.getBuses(), containersMapping, network, nodeBreakerImport).create();
        for (PsseGenerator psseGen : psseModel.getGenerators()) {
            new GeneratorConverter(psseGen, containersMapping, network, nodeBreakerImport).addControl(busNumToPsseBus.get(psseGen.getI()));
        }
        for (PsseTransformer psseTransformer : psseModel.getTransformers()) {
            new TransformerConverter(psseTransformer, containersMapping, perUnitContext, network, busNumToPsseBus, psseModel.getCaseIdentification().getSbase(), version, nodeBreakerImport).addControl();
        }
        for (PsseVoltageSourceConverterDcTransmissionLine psseVscDcTransmissionLine : psseModel.getVoltageSourceConverterDcTransmissionLines()) {
            new VscDcTransmissionLineConverter(psseVscDcTransmissionLine, containersMapping, network, version, nodeBreakerImport).addControl();
        }
        for (PsseFacts psseFactsDevice : psseModel.getFacts()) {
            new FactsDeviceConverter(psseFactsDevice, containersMapping, network, version, nodeBreakerImport).addControl();
        }
        for (PsseSwitchedShunt psseSwShunt : psseModel.getSwitchedShunts()) {
            new SwitchedShuntCompensatorConverter(psseSwShunt, containersMapping, network, version, nodeBreakerImport).addControl();
        }
        for (PsseSubstation psseSubstation : psseModel.getSubstations()) {
            VoltageLevelConverter.updateNodeVoltage(psseSubstation, network, containersMapping);
        }
        return network;
    }

    private ContainersMapping defineContainersMapping(PssePowerFlowModel psseModel, Map<Integer, PsseBus> busNumToPsseBus, PerUnitContext perUnitContext, NodeBreakerValidation nodeBreakerValidation) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        this.defineEdgesForTransformers(psseModel, busNumToPsseBus, edges);
        this.defineEdgesForBusesInsideSubstation(nodeBreakerValidation, edges);
        return ContainersMapping.create((List)psseModel.getBuses(), edges, PsseBus::getI, Edge::bus1, Edge::bus2, Edge::zeroImpedance, Edge::transformer, busNumber -> this.getNominalVFromBusNumber(busNumToPsseBus, (int)busNumber, perUnitContext), AbstractConverter::getVoltageLevelId, substationNums -> PsseImporter.getSubstationId(nodeBreakerValidation, substationNums));
    }

    private void defineEdgesForTransformers(PssePowerFlowModel psseModel, Map<Integer, PsseBus> busNumToPsseBus, List<Edge> edges) {
        psseModel.getTransformers().forEach(t -> {
            if (t.getK() == 0) {
                if (busNumToPsseBus.containsKey(t.getI()) && busNumToPsseBus.containsKey(t.getJ())) {
                    edges.add(new Edge(t.getI(), t.getJ(), true, false));
                }
            } else if (busNumToPsseBus.containsKey(t.getI()) && busNumToPsseBus.containsKey(t.getJ()) && busNumToPsseBus.containsKey(t.getK())) {
                edges.add(new Edge(t.getI(), t.getJ(), true, false));
                edges.add(new Edge(t.getI(), t.getK(), true, false));
            }
        });
    }

    private void defineEdgesForBusesInsideSubstation(NodeBreakerValidation nodeBreakerValidation, List<Edge> edges) {
        nodeBreakerValidation.getValidSubstations().forEach(psseSubstation -> {
            List<Integer> busesInside = nodeBreakerValidation.getBuses((PsseSubstation)psseSubstation);
            if (busesInside.size() >= 2) {
                int bus = busesInside.get(0);
                for (int index = 1; index < busesInside.size(); ++index) {
                    edges.add(new Edge(bus, busesInside.get(index), true, false));
                }
            }
        });
    }

    private static String getSubstationId(NodeBreakerValidation nodeBreakerValidation, Set<Integer> substationBusNumbers) {
        Set<Integer> validSubstationIds = nodeBreakerValidation.getValidSubstationsIds(substationBusNumbers);
        return validSubstationIds.isEmpty() ? AbstractConverter.getSubstationIdFromBuses(substationBusNumbers) : AbstractConverter.getSubstationIdFromPsseSubstationIds(validSubstationIds);
    }

    private double getNominalVFromBusNumber(Map<Integer, PsseBus> busNumToPsseBus, int busNumber, PerUnitContext perUnitContext) {
        if (!busNumToPsseBus.containsKey(busNumber)) {
            throw new PsseException("busId without PsseBus" + busNumber);
        }
        return VoltageLevelConverter.getNominalV(busNumToPsseBus.get(busNumber), perUnitContext.ignoreBaseVoltage());
    }

    private static NodeBreakerImport createBuses(PssePowerFlowModel psseModel, ContainersMapping containersMapping, PerUnitContext perUnitContext, Network network, NodeBreakerValidation nodeBreakerValidation) {
        NodeBreakerImport nodeBreakerImport = new NodeBreakerImport();
        for (PsseBus psseBus : psseModel.getBuses()) {
            Substation substation = new SubstationConverter(psseBus, containersMapping, nodeBreakerValidation, network).create();
            VoltageLevel voltageLevel = new VoltageLevelConverter(psseBus, containersMapping, perUnitContext, network, nodeBreakerValidation, nodeBreakerImport).create(substation);
            new BusConverter(psseBus, containersMapping, network, nodeBreakerImport).create(voltageLevel);
        }
        return nodeBreakerImport;
    }

    record PerUnitContext(double sb, boolean ignoreBaseVoltage) {
    }

    private record Edge(int bus1, int bus2, boolean transformer, boolean zeroImpedance) {
    }
}

