/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.NodeBreakerValidation;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseSubstation;
import java.util.Objects;
import java.util.Optional;

class SubstationConverter
extends AbstractConverter {
    private final PsseBus psseBus;
    private final NodeBreakerValidation nodeBreakerValidation;

    SubstationConverter(PsseBus psseBus, ContainersMapping containerMapping, NodeBreakerValidation nodeBreakerValidation, Network network) {
        super(containerMapping, network);
        this.psseBus = Objects.requireNonNull(psseBus);
        this.nodeBreakerValidation = Objects.requireNonNull(nodeBreakerValidation);
    }

    Substation create() {
        String voltageLevelId = this.getContainersMapping().getVoltageLevelId(this.psseBus.getI());
        String substationId = this.getContainersMapping().getSubstationId(voltageLevelId);
        Substation substation = this.getNetwork().getSubstation(substationId);
        if (substation == null) {
            substation = ((SubstationAdder)this.getNetwork().newSubstation().setId(substationId)).add();
            Optional<PsseSubstation> psseSubstation = this.nodeBreakerValidation.getTheOnlySubstation(this.psseBus.getI());
            if (psseSubstation.isPresent()) {
                substation.setName(psseSubstation.get().getName());
            }
        }
        return substation;
    }
}

