/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.PsseExporter;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseRates;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.math3.complex.Complex;

class TieLineConverter
extends AbstractConverter {
    TieLineConverter(Network network) {
        super(network);
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        network.getTieLines().forEach(tieLine -> psseModel.addNonTransformerBranches(Collections.singletonList(TieLineConverter.createTieLine(tieLine, contextExport, perUnitContext))));
        psseModel.replaceAllNonTransformerBranches(psseModel.getNonTransformerBranches().stream().sorted(Comparator.comparingInt(PsseNonTransformerBranch::getI).thenComparingInt(PsseNonTransformerBranch::getJ).thenComparing(PsseNonTransformerBranch::getCkt)).toList());
    }

    private static PsseNonTransformerBranch createTieLine(TieLine tieLine, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseNonTransformerBranch psseLine = TieLineConverter.createDefaultNonTransformerBranch();
        int busI = TieLineConverter.getTerminalBusI(tieLine.getTerminal1(), contextExport);
        int busJ = TieLineConverter.getTerminalBusI(tieLine.getTerminal2(), contextExport);
        double vNom1 = tieLine.getTerminal1().getVoltageLevel().getNominalV();
        double vNom2 = tieLine.getTerminal2().getVoltageLevel().getNominalV();
        Complex transmissionAdmittance = new Complex(tieLine.getR(), tieLine.getX()).reciprocal();
        psseLine.setI(busI);
        psseLine.setJ(busJ);
        psseLine.setCkt(contextExport.getFullExport().getEquipmentCkt(tieLine.getId(), AbstractConverter.PsseEquipmentType.PSSE_BRANCH.getTextCode(), busI, busJ));
        psseLine.setR(TieLineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(tieLine.getR(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setX(TieLineConverter.impedanceToPerUnitForLinesWithDifferentNominalVoltageAtEnds(tieLine.getX(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setName(tieLine.getNameOrId().substring(0, Math.min(40, tieLine.getNameOrId().length())));
        psseLine.setRates(TieLineConverter.createRates(tieLine, vNom1, vNom2));
        psseLine.setGi(TieLineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getReal(), tieLine.getG1(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setBi(TieLineConverter.admittanceEnd1ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getImaginary(), tieLine.getB1(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setGj(TieLineConverter.admittanceEnd2ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getReal(), tieLine.getG2(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setBj(TieLineConverter.admittanceEnd2ToPerUnitForLinesWithDifferentNominalVoltageAtEnds(transmissionAdmittance.getImaginary(), tieLine.getB2(), vNom1, vNom2, perUnitContext.sBase()));
        psseLine.setSt(TieLineConverter.getStatus(tieLine.getTerminal1(), tieLine.getTerminal2(), contextExport));
        return psseLine;
    }

    private static PsseRates createRates(TieLine tieLine, double vNominal1, double vNominal2) {
        PsseRates windingRates = TieLineConverter.createDefaultRates();
        tieLine.getApparentPowerLimits1().ifPresent(apparentPowerLimits1 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(apparentPowerLimits1), windingRates));
        if (tieLine.getApparentPowerLimits1().isEmpty()) {
            tieLine.getApparentPowerLimits2().ifPresent(apparentPowerLimits2 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(apparentPowerLimits2), windingRates));
        }
        if (tieLine.getApparentPowerLimits1().isEmpty() && tieLine.getApparentPowerLimits2().isEmpty()) {
            tieLine.getCurrentLimits1().ifPresent(currentLimits1 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(currentLimits1, vNominal1), windingRates));
        }
        if (tieLine.getApparentPowerLimits1().isEmpty() && tieLine.getApparentPowerLimits2().isEmpty() && tieLine.getCurrentLimits1().isEmpty()) {
            tieLine.getCurrentLimits2().ifPresent(currentLimits2 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(currentLimits2, vNominal2), windingRates));
        }
        if (tieLine.getApparentPowerLimits1().isEmpty() && tieLine.getApparentPowerLimits2().isEmpty() && tieLine.getCurrentLimits1().isEmpty() && tieLine.getCurrentLimits2().isEmpty()) {
            tieLine.getActivePowerLimits1().ifPresent(activePowerLimits1 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(activePowerLimits1), windingRates));
        }
        if (tieLine.getApparentPowerLimits1().isEmpty() && tieLine.getApparentPowerLimits2().isEmpty() && tieLine.getCurrentLimits1().isEmpty() && tieLine.getCurrentLimits2().isEmpty() && tieLine.getActivePowerLimits1().isEmpty()) {
            tieLine.getActivePowerLimits2().ifPresent(activePowerLimits2 -> TieLineConverter.setSortedRatesToPsseRates(TieLineConverter.getSortedRates(activePowerLimits2), windingRates));
        }
        return windingRates;
    }
}

