/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.converter.PsseExporter;
import com.powsybl.psse.converter.PsseImporter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseRates;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTransformerWinding;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.math3.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformerConverter
extends AbstractConverter {
    private static final double TOLERANCE = 1.0E-5;
    private final PsseTransformer psseTransformer;
    private final Map<Integer, PsseBus> busNumToPsseBus;
    private final double sbase;
    private final PsseImporter.PerUnitContext perUnitContext;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerConverter.class);

    TransformerConverter(PsseTransformer psseTransformer, ContainersMapping containersMapping, PsseImporter.PerUnitContext perUnitContext, Network network, Map<Integer, PsseBus> busNumToPsseBus, double sbase, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containersMapping, network);
        this.psseTransformer = Objects.requireNonNull(psseTransformer);
        this.busNumToPsseBus = Objects.requireNonNull(busNumToPsseBus);
        this.sbase = sbase;
        this.perUnitContext = Objects.requireNonNull(perUnitContext);
        this.version = Objects.requireNonNull(version);
        this.nodeBreakerImport = Objects.requireNonNull(nodeBreakerImport);
    }

    void create() {
        if (this.psseTransformer.getK() == 0) {
            this.createTwoWindingsTransformer();
        } else {
            this.createThreeWindingsTransformer();
        }
    }

    private void createTwoWindingsTransformer() {
        if (!this.getContainersMapping().isBusDefined(this.psseTransformer.getI()) || !this.getContainersMapping().isBusDefined(this.psseTransformer.getJ())) {
            return;
        }
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getCkt());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getI());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        double baskv1 = this.busNumToPsseBus.get(this.psseTransformer.getI()).getBaskv();
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getJ());
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double baskv2 = this.busNumToPsseBus.get(this.psseTransformer.getJ()).getBaskv();
        double sbase12 = this.psseTransformer.getSbase12();
        double nomV1 = TransformerConverter.getNomV(this.psseTransformer.getWinding1(), voltageLevel1);
        double nomV2 = TransformerConverter.getNomV(this.psseTransformer.getWinding2(), voltageLevel2);
        Complex z = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR12(), this.psseTransformer.getX12(), this.sbase, sbase12, this.psseTransformer.getCz());
        ComplexRatio w1 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding1().getWindv(), this.psseTransformer.getWinding1().getAng(), baskv1, nomV1, this.psseTransformer.getCw());
        double w2 = TransformerConverter.defineRatio(this.psseTransformer.getWinding2().getWindv(), baskv2, nomV2, this.psseTransformer.getCw());
        TapChanger tapChanger = TransformerConverter.defineTapChanger(w1, this.psseTransformer.getWinding1(), baskv1, nomV1, this.psseTransformer.getCw());
        Complex ysh = TransformerConverter.defineShuntAdmittance(id, this.psseTransformer.getMag1(), this.psseTransformer.getMag2(), this.sbase, sbase12, baskv1, nomV1, this.psseTransformer.getCm());
        z = TransformerConverter.impedanceToEngineeringUnits(z, voltageLevel2.getNominalV(), this.perUnitContext.sb());
        ysh = TransformerConverter.admittanceToEngineeringUnits(ysh, voltageLevel2.getNominalV(), this.perUnitContext.sb());
        z = TransformerConverter.impedanceAdjustmentAfterMovingRatio(z, w2);
        TapChanger tapChangerAdjustedRatio = this.tapChangerAdjustmentAfterMovingRatio(tapChanger, w2);
        TapChanger tapChangerAdjustedYsh = this.tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(tapChangerAdjustedRatio);
        TwoWindingsTransformerAdder adder = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((Substation)voltageLevel2.getSubstation().orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation"))).newTwoWindingsTransformer().setId(id)).setEnsureIdUnicity(true)).setVoltageLevel1(voltageLevel1Id)).setVoltageLevel2(voltageLevel2Id)).setRatedU1(voltageLevel1.getNominalV()).setRatedU2(voltageLevel2.getNominalV()).setR(z.getReal()).setX(z.getImaginary()).setG(ysh.getReal()).setB(ysh.getImaginary());
        String equipmentId = TransformerConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_WINDING, this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getCkt());
        OptionalInt node1 = this.nodeBreakerImport.getNode(TransformerConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseTransformer.getI(), this.psseTransformer.getJ(), 0, this.psseTransformer.getI(), "I"));
        if (node1.isPresent()) {
            adder.setNode1(node1.getAsInt());
        } else {
            String bus1Id = TransformerConverter.getBusId(this.psseTransformer.getI());
            adder.setConnectableBus1(bus1Id);
            adder.setBus1(this.psseTransformer.getStat() == 1 ? bus1Id : null);
        }
        OptionalInt node2 = this.nodeBreakerImport.getNode(TransformerConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseTransformer.getI(), this.psseTransformer.getJ(), 0, this.psseTransformer.getJ(), "J"));
        if (node2.isPresent()) {
            adder.setNode2(node2.getAsInt());
        } else {
            String bus2Id = TransformerConverter.getBusId(this.psseTransformer.getJ());
            adder.setConnectableBus2(bus2Id);
            adder.setBus2(this.psseTransformer.getStat() == 1 ? bus2Id : null);
        }
        TwoWindingsTransformer twt = adder.add();
        TransformerConverter.tapChangerToIidm(tapChangerAdjustedYsh, twt);
        this.defineOperationalLimits(twt, voltageLevel1.getNominalV(), voltageLevel2.getNominalV());
    }

    private void createThreeWindingsTransformer() {
        if (!(this.getContainersMapping().isBusDefined(this.psseTransformer.getI()) && this.getContainersMapping().isBusDefined(this.psseTransformer.getJ()) && this.getContainersMapping().isBusDefined(this.psseTransformer.getK()))) {
            return;
        }
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getCkt());
        String bus1Id = TransformerConverter.getBusId(this.psseTransformer.getI());
        String voltageLevel1Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getI());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(voltageLevel1Id);
        double baskv1 = this.busNumToPsseBus.get(this.psseTransformer.getI()).getBaskv();
        String bus2Id = TransformerConverter.getBusId(this.psseTransformer.getJ());
        String voltageLevel2Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getJ());
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(voltageLevel2Id);
        double baskv2 = this.busNumToPsseBus.get(this.psseTransformer.getJ()).getBaskv();
        String bus3Id = TransformerConverter.getBusId(this.psseTransformer.getK());
        String voltageLevel3Id = this.getContainersMapping().getVoltageLevelId(this.psseTransformer.getK());
        VoltageLevel voltageLevel3 = this.getNetwork().getVoltageLevel(voltageLevel3Id);
        double baskv3 = this.busNumToPsseBus.get(this.psseTransformer.getK()).getBaskv();
        double sbase12 = this.psseTransformer.getSbase12();
        double sbase23 = this.psseTransformer.getSbase23();
        double sbase31 = this.psseTransformer.getSbase31();
        double nomV1 = TransformerConverter.getNomV(this.psseTransformer.getWinding1(), voltageLevel1);
        double nomV2 = TransformerConverter.getNomV(this.psseTransformer.getWinding2(), voltageLevel2);
        double nomV3 = TransformerConverter.getNomV(this.psseTransformer.getWinding3(), voltageLevel3);
        Complex z12 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR12(), this.psseTransformer.getX12(), this.sbase, sbase12, this.psseTransformer.getCz());
        Complex z23 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR23(), this.psseTransformer.getX23(), this.sbase, sbase23, this.psseTransformer.getCz());
        Complex z31 = TransformerConverter.defineImpedanceBetweenWindings(this.psseTransformer.getR31(), this.psseTransformer.getX31(), this.sbase, sbase31, this.psseTransformer.getCz());
        Complex z1 = z12.add(z31).subtract(z23).multiply(0.5);
        Complex z2 = z12.add(z23).subtract(z31).multiply(0.5);
        Complex z3 = z23.add(z31).subtract(z12).multiply(0.5);
        ComplexRatio w1 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding1().getWindv(), this.psseTransformer.getWinding1().getAng(), baskv1, nomV1, this.psseTransformer.getCw());
        ComplexRatio w2 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding2().getWindv(), this.psseTransformer.getWinding2().getAng(), baskv2, nomV2, this.psseTransformer.getCw());
        ComplexRatio w3 = TransformerConverter.defineComplexRatio(this.psseTransformer.getWinding3().getWindv(), this.psseTransformer.getWinding3().getAng(), baskv3, nomV3, this.psseTransformer.getCw());
        TapChanger tapChanger1 = TransformerConverter.defineTapChanger(w1, this.psseTransformer.getWinding1(), baskv1, nomV1, this.psseTransformer.getCw());
        TapChanger tapChanger2 = TransformerConverter.defineTapChanger(w2, this.psseTransformer.getWinding2(), baskv2, nomV2, this.psseTransformer.getCw());
        TapChanger tapChanger3 = TransformerConverter.defineTapChanger(w3, this.psseTransformer.getWinding3(), baskv3, nomV3, this.psseTransformer.getCw());
        Complex ysh = TransformerConverter.defineShuntAdmittance(id, this.psseTransformer.getMag1(), this.psseTransformer.getMag2(), this.sbase, sbase12, baskv1, nomV1, this.psseTransformer.getCm());
        double v0 = 1.0;
        z1 = TransformerConverter.impedanceToEngineeringUnits(z1, v0, this.perUnitContext.sb());
        z2 = TransformerConverter.impedanceToEngineeringUnits(z2, v0, this.perUnitContext.sb());
        z3 = TransformerConverter.impedanceToEngineeringUnits(z3, v0, this.perUnitContext.sb());
        ysh = TransformerConverter.admittanceToEngineeringUnits(ysh, v0, this.perUnitContext.sb());
        TapChanger tapChanger1AdjustedYsh = this.tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(tapChanger1);
        ThreeWindingsTransformerAdder adder = (ThreeWindingsTransformerAdder)((ThreeWindingsTransformerAdder)((Substation)voltageLevel1.getSubstation().orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation"))).newThreeWindingsTransformer().setRatedU0(v0).setEnsureIdUnicity(true)).setId(id);
        ThreeWindingsTransformerAdder.LegAdder legAdder1 = adder.newLeg1().setR(z1.getReal()).setX(z1.getImaginary()).setG(ysh.getReal()).setB(ysh.getImaginary()).setRatedU(voltageLevel1.getNominalV()).setVoltageLevel(voltageLevel1Id);
        ThreeWindingsTransformerAdder.LegAdder legAdder2 = adder.newLeg2().setR(z2.getReal()).setX(z2.getImaginary()).setG(0.0).setB(0.0).setRatedU(voltageLevel2.getNominalV()).setVoltageLevel(voltageLevel2Id);
        ThreeWindingsTransformerAdder.LegAdder legAdder3 = adder.newLeg3().setR(z3.getReal()).setX(z3.getImaginary()).setG(0.0).setB(0.0).setRatedU(voltageLevel3.getNominalV()).setVoltageLevel(voltageLevel3Id);
        String equipmentId = TransformerConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_THREE_WINDING, this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getCkt());
        this.legConnectivity(legAdder1, TransformerConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getI(), "I"), bus1Id, this.leg1IsConnected());
        legAdder1.add();
        this.legConnectivity(legAdder2, TransformerConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getJ(), "J"), bus2Id, this.leg2IsConnected());
        legAdder2.add();
        this.legConnectivity(legAdder3, TransformerConverter.getNodeBreakerEquipmentIdBus(equipmentId, this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getK(), "K"), bus3Id, this.leg3IsConnected());
        legAdder3.add();
        ThreeWindingsTransformer twt = adder.add();
        twt.setProperty("v", Double.toString(this.psseTransformer.getVmstar() * v0));
        twt.setProperty("angle", Double.toString(this.psseTransformer.getAnstar()));
        TransformerConverter.tapChangersToIidm(tapChanger1AdjustedYsh, tapChanger2, tapChanger3, twt);
        this.defineOperationalLimits(twt, voltageLevel1.getNominalV(), voltageLevel2.getNominalV(), voltageLevel3.getNominalV());
    }

    private void legConnectivity(ThreeWindingsTransformerAdder.LegAdder legAdder, String equipmentIdBus, String busId, boolean isLegConnected) {
        OptionalInt node1 = this.nodeBreakerImport.getNode(equipmentIdBus);
        if (node1.isPresent()) {
            legAdder.setNode(node1.getAsInt());
        } else {
            legAdder.setConnectableBus(busId);
            legAdder.setBus(isLegConnected ? busId : null);
        }
    }

    private static double getNomV(PsseTransformerWinding winding, VoltageLevel voltageLevel) {
        double nomV = winding.getNomv();
        if (nomV == 0.0) {
            nomV = voltageLevel.getNominalV();
        }
        return nomV;
    }

    private boolean leg1IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 2 || this.psseTransformer.getStat() == 3;
    }

    private boolean leg2IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 3 || this.psseTransformer.getStat() == 4;
    }

    private boolean leg3IsConnected() {
        return this.psseTransformer.getStat() == 1 || this.psseTransformer.getStat() == 2 || this.psseTransformer.getStat() == 4;
    }

    private static Complex defineImpedanceBetweenWindings(double r, double x, double sbase, double windingSbase, int cz) {
        double xw;
        double rw;
        switch (cz) {
            case 1: {
                rw = r;
                xw = x;
                break;
            }
            case 2: {
                rw = r * sbase / windingSbase;
                xw = x * sbase / windingSbase;
                break;
            }
            case 3: {
                rw = r / windingSbase / 1000000.0;
                xw = Math.sqrt(x * x - rw * rw);
                rw = rw * sbase / windingSbase;
                xw = xw * sbase / windingSbase;
                break;
            }
            default: {
                throw new PsseException("Unexpected CZ = " + cz);
            }
        }
        return new Complex(rw, xw);
    }

    private static Complex defineShuntAdmittance(String id, double magG, double magB, double sbase, double windingSbase, double baskv, double nomV, int cm) {
        double b;
        double g;
        switch (cm) {
            case 1: {
                g = magG;
                b = magB;
                break;
            }
            case 2: {
                g = magG / (1000000.0 * sbase) * (baskv / nomV) * (baskv / nomV);
                double y = magB * (windingSbase / sbase) * (baskv / nomV) * (baskv / nomV);
                double b2 = y * y - g * g;
                if (b2 >= 0.0) {
                    b = -Math.sqrt(b2);
                    break;
                }
                b = 0.0;
                LOGGER.warn("Magnetizing susceptance of Transformer ({}) set to 0 because admittance module is ({}) and conductance is ({})  ", new Object[]{id, y, g});
                break;
            }
            default: {
                throw new PsseException("Unexpected CM = " + cm);
            }
        }
        return new Complex(g, b);
    }

    private static ComplexRatio defineComplexRatio(double windV, double ang, double baskv, double nomV, int cw) {
        return new ComplexRatio(TransformerConverter.defineRatio(windV, baskv, nomV, cw), ang);
    }

    private static double defineRatio(double windV, double baskv, double nomV, int cw) {
        return switch (cw) {
            case 1 -> windV;
            case 2 -> windV / baskv;
            case 3 -> windV * nomV / baskv;
            default -> throw new PsseException("Unexpected CW = " + cw);
        };
    }

    private static double defineWindV(double ratio, double baskv, double nomV, int cw) {
        return switch (cw) {
            case 1 -> ratio;
            case 2 -> ratio * baskv;
            case 3 -> ratio * baskv / nomV;
            default -> throw new PsseException("Unexpected CW = " + cw);
        };
    }

    private static TapChanger defineTapChanger(ComplexRatio complexRatio, PsseTransformerWinding winding, double baskv, double nomv, int cw) {
        TapChanger tapChanger = TransformerConverter.defineRawTapChanger(complexRatio, winding.getRma(), winding.getRmi(), winding.getNtp(), baskv, nomv, cw, winding.getCod());
        tapChanger.setTapPosition(TransformerConverter.defineTapPositionAndAdjustTapChangerToCurrentRatio(complexRatio, tapChanger));
        return tapChanger;
    }

    private static TapChanger defineRawTapChanger(ComplexRatio complexRatio, double rma, double rmi, int ntp, double baskv, double nomv, int cw, int cod) {
        TapChanger tapChanger = new TapChanger();
        if (ntp <= 1) {
            tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
            return tapChanger;
        }
        if (complexRatio.getAngle() == 0.0 && (TransformerConverter.isVoltageControl(cod) || TransformerConverter.isReactivePowerControl(cod))) {
            double stepRatioIncrement = (rma - rmi) / (double)(ntp - 1);
            for (int i = 0; i < ntp; ++i) {
                double ratio = TransformerConverter.defineRatio(rmi + stepRatioIncrement * (double)i, baskv, nomv, cw);
                tapChanger.getSteps().add(new TapChangerStep(ratio, complexRatio.getAngle()));
            }
            return tapChanger;
        }
        if (TransformerConverter.isActivePowerControl(cod)) {
            double stepAngleIncrement = (rma - rmi) / (double)(ntp - 1);
            for (int i = 0; i < ntp; ++i) {
                double angle = rmi + stepAngleIncrement * (double)i;
                tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), angle));
            }
            return tapChanger;
        }
        tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
        return tapChanger;
    }

    private static boolean isVoltageControl(int cod) {
        return Math.abs(cod) == 1;
    }

    private static boolean isReactivePowerControl(int cod) {
        return Math.abs(cod) == 2;
    }

    private static boolean isActivePowerControl(int cod) {
        return Math.abs(cod) == 3;
    }

    private static int defineTapPositionAndAdjustTapChangerToCurrentRatio(ComplexRatio complexRatio, TapChanger tapChanger) {
        List<TapChangerStep> steps = tapChanger.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            TapChangerStep step = steps.get(i);
            double distanceRatio = TransformerConverter.distance(step.getRatio(), complexRatio.getRatio());
            double distanceAngle = TransformerConverter.distance(step.getAngle(), complexRatio.getAngle());
            if (distanceRatio == 0.0 && distanceAngle == 0.0) {
                return i;
            }
            if (!(distanceAngle > 0.0) && (distanceAngle != 0.0 || !(distanceRatio > 0.0))) continue;
            tapChanger.getSteps().add(i, new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
            return i;
        }
        tapChanger.getSteps().add(new TapChangerStep(complexRatio.getRatio(), complexRatio.getAngle()));
        return tapChanger.getSteps().size() - 1;
    }

    private static double distance(double stepValue, double currentValue) {
        double distance = stepValue - currentValue;
        if (Math.abs(distance) <= 1.0E-5) {
            return 0.0;
        }
        return distance;
    }

    private static void tapChangerToIidm(TapChanger tapChanger, TwoWindingsTransformer twt) {
        if (TransformerConverter.isPhaseTapChanger(tapChanger)) {
            PhaseTapChangerAdder ptc = twt.newPhaseTapChanger();
            TransformerConverter.tapChangerToPhaseTapChanger(tapChanger, ptc);
        } else if (TransformerConverter.isRatioTapChanger(tapChanger)) {
            RatioTapChangerAdder rtc = twt.newRatioTapChanger();
            TransformerConverter.tapChangerToRatioTapChanger(tapChanger, rtc);
        }
    }

    private static void tapChangersToIidm(TapChanger tapChanger1, TapChanger tapChanger2, TapChanger tapChanger3, ThreeWindingsTransformer twt) {
        TransformerConverter.tapChangerToIidmLeg(tapChanger1, twt.getLeg1());
        TransformerConverter.tapChangerToIidmLeg(tapChanger2, twt.getLeg2());
        TransformerConverter.tapChangerToIidmLeg(tapChanger3, twt.getLeg3());
    }

    private static void tapChangerToIidmLeg(TapChanger tapChanger, ThreeWindingsTransformer.Leg leg) {
        if (TransformerConverter.isPhaseTapChanger(tapChanger)) {
            PhaseTapChangerAdder ptc = leg.newPhaseTapChanger();
            TransformerConverter.tapChangerToPhaseTapChanger(tapChanger, ptc);
        } else if (TransformerConverter.isRatioTapChanger(tapChanger)) {
            RatioTapChangerAdder rtc = leg.newRatioTapChanger();
            TransformerConverter.tapChangerToRatioTapChanger(tapChanger, rtc);
        }
    }

    private static boolean isPhaseTapChanger(TapChanger tapChanger) {
        return tapChanger.getSteps().stream().anyMatch(step -> step.getAngle() != 0.0);
    }

    private static boolean isRatioTapChanger(TapChanger tapChanger) {
        return tapChanger.getSteps().stream().anyMatch(step -> step.getRatio() != 1.0);
    }

    private static void tapChangerToRatioTapChanger(TapChanger tapChanger, RatioTapChangerAdder rtc) {
        ((RatioTapChangerAdder)((RatioTapChangerAdder)rtc.setLoadTapChangingCapabilities(false)).setLowTapPosition(0)).setTapPosition(tapChanger.getTapPosition());
        tapChanger.getSteps().forEach(step -> ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtc.beginStep()).setRho(1.0 / step.getRatio())).setR(step.getR())).setX(step.getX())).setB(step.getB1())).setG(step.getG1())).endStep());
        rtc.add();
    }

    private static void tapChangerToPhaseTapChanger(TapChanger tapChanger, PhaseTapChangerAdder ptc) {
        ((PhaseTapChangerAdder)ptc.setLowTapPosition(0)).setTapPosition(tapChanger.getTapPosition());
        tapChanger.getSteps().forEach(step -> ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptc.beginStep()).setRho(1.0 / step.getRatio())).setAlpha(-step.getAngle())).setR(step.getR())).setX(step.getX())).setB(step.getB1())).setG(step.getG1())).endStep());
        ((PhaseTapChangerAdder)ptc.setRegulating(false)).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).add();
    }

    private static Complex impedanceAdjustmentAfterMovingRatio(Complex impedance, double a) {
        return impedance.multiply(a * a);
    }

    private static double admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(double admittance, Complex a) {
        return admittance * a.abs() * a.abs();
    }

    private TapChanger tapChangerAdjustmentAfterMovingRatio(TapChanger tapChanger, double a) {
        tapChanger.getSteps().forEach(step -> step.setRatio(step.getRatio() / a));
        return tapChanger;
    }

    private TapChanger tapChangerAdjustmentAfterMovingShuntAdmittanceBetweenRatioAndTransmissionImpedance(TapChanger tapChanger) {
        tapChanger.getSteps().forEach(step -> {
            Complex a = new Complex(step.getRatio() * Math.cos(Math.toRadians(step.getAngle())), step.getRatio() * Math.sin(Math.toRadians(step.getAngle())));
            step.setG1(100.0 * (TransformerConverter.admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(1.0 + step.getG1() / 100.0, a) - 1.0));
            step.setB1(100.0 * (TransformerConverter.admittanceAdjustmentAfterMovingItBetweenRatioAndTransmissionImpedance(1.0 + step.getB1() / 100.0, a) - 1.0));
        });
        return tapChanger;
    }

    private void defineOperationalLimits(TwoWindingsTransformer twt, double vnom1, double vnom2) {
        double rateMva = this.getRateWinding1();
        double currentLimit1 = rateMva / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva / (Math.sqrt(3.0) * vnom2);
        if (currentLimit1 > 0.0) {
            CurrentLimitsAdder currentLimitFrom = twt.getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            CurrentLimitsAdder currentLimitTo = twt.getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits();
            currentLimitTo.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitTo.add();
        }
    }

    private void defineOperationalLimits(ThreeWindingsTransformer twt, double vnom1, double vnom2, double vnom3) {
        CurrentLimitsAdder currentLimitFrom;
        double rateMva1 = this.getRateWinding1();
        double rateMva2 = this.getRateWinding2();
        double rateMva3 = this.getRateWinding3();
        double currentLimit1 = rateMva1 / (Math.sqrt(3.0) * vnom1);
        double currentLimit2 = rateMva2 / (Math.sqrt(3.0) * vnom2);
        double currentLimit3 = rateMva3 / (Math.sqrt(3.0) * vnom3);
        if (currentLimit1 > 0.0) {
            currentLimitFrom = twt.getLeg1().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit1 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit2 > 0.0) {
            currentLimitFrom = twt.getLeg2().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit2 * 1000.0);
            currentLimitFrom.add();
        }
        if (currentLimit3 > 0.0) {
            currentLimitFrom = twt.getLeg3().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits();
            currentLimitFrom.setPermanentLimit(currentLimit3 * 1000.0);
            currentLimitFrom.add();
        }
    }

    private double getRateWinding1() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding1Rates().getRate1() : this.psseTransformer.getWinding1Rates().getRatea();
        return rateMva;
    }

    private double getRateWinding2() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding2Rates().getRate1() : this.psseTransformer.getWinding2Rates().getRatea();
        return rateMva;
    }

    private double getRateWinding3() {
        double rateMva = this.version.major() == PsseVersion.Major.V35 ? this.psseTransformer.getWinding3Rates().getRate1() : this.psseTransformer.getWinding3Rates().getRatea();
        return rateMva;
    }

    public void addControl() {
        if (TransformerConverter.isTwoWindingsTransformer(this.psseTransformer)) {
            this.addControlTwoWindingsTransformer();
        } else {
            this.addControlThreeWindingsTransformer();
        }
    }

    private static boolean isTwoWindingsTransformer(PsseTransformer psseTransformer) {
        return psseTransformer.getK() == 0;
    }

    private void addControlTwoWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getCkt());
        TwoWindingsTransformer twt = this.getNetwork().getTwoWindingsTransformer(id);
        if (twt == null) {
            return;
        }
        boolean regulatingForcedToOff = false;
        if (twt.hasRatioTapChanger()) {
            boolean regulating = TransformerConverter.defineVoltageControl(this.getNetwork(), twt.getId(), this.psseTransformer.getWinding1(), twt.getRatioTapChanger(), regulatingForcedToOff, this.nodeBreakerImport);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        if (twt.hasPhaseTapChanger()) {
            TransformerConverter.defineActivePowerControl(this.getNetwork(), twt.getId(), this.psseTransformer.getWinding1(), twt.getPhaseTapChanger(), regulatingForcedToOff, this.nodeBreakerImport);
        }
    }

    private void addControlThreeWindingsTransformer() {
        String id = TransformerConverter.getTransformerId(this.psseTransformer.getI(), this.psseTransformer.getJ(), this.psseTransformer.getK(), this.psseTransformer.getCkt());
        ThreeWindingsTransformer twt = this.getNetwork().getThreeWindingsTransformer(id);
        if (twt == null) {
            return;
        }
        boolean regulatingForcedToOff = false;
        regulatingForcedToOff = TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg1(), this.psseTransformer.getWinding1(), regulatingForcedToOff, this.nodeBreakerImport);
        regulatingForcedToOff = TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg2(), this.psseTransformer.getWinding2(), regulatingForcedToOff, this.nodeBreakerImport);
        TransformerConverter.addControlThreeWindingsTransformerLeg(this.getNetwork(), twt.getId(), twt.getLeg3(), this.psseTransformer.getWinding3(), regulatingForcedToOff, this.nodeBreakerImport);
    }

    private static boolean addControlThreeWindingsTransformerLeg(Network network, String id, ThreeWindingsTransformer.Leg leg, PsseTransformerWinding winding, boolean regulatingForcedToOffInput, NodeBreakerImport nodeBreakerImport) {
        boolean regulating;
        boolean regulatingForcedToOff = regulatingForcedToOffInput;
        if (leg.hasRatioTapChanger()) {
            regulating = TransformerConverter.defineVoltageControl(network, id, winding, leg.getRatioTapChanger(), regulatingForcedToOff, nodeBreakerImport);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        if (leg.hasPhaseTapChanger()) {
            regulating = TransformerConverter.defineActivePowerControl(network, id, winding, leg.getPhaseTapChanger(), regulatingForcedToOff, nodeBreakerImport);
            regulatingForcedToOff = TransformerConverter.forceRegulatingToOff(regulatingForcedToOff, regulating);
        }
        return regulatingForcedToOff;
    }

    private static boolean defineVoltageControl(Network network, String id, PsseTransformerWinding winding, RatioTapChanger rtc, boolean regulatingForcedToOff, NodeBreakerImport nodeBreakerImport) {
        boolean regulating;
        if (Math.abs(winding.getCod()) == 2) {
            LOGGER.warn("Transformer {}. Reactive power control not supported", (Object)id);
            return false;
        }
        if (!TransformerConverter.isVoltageControl(winding.getCod())) {
            return false;
        }
        Terminal regulatingTerminal = TransformerConverter.defineRegulatingTerminal(network, id, winding, nodeBreakerImport);
        if (regulatingTerminal == null) {
            return false;
        }
        double vnom = regulatingTerminal.getVoltageLevel().getNominalV();
        double vmin = winding.getVmi() * vnom;
        double vmax = winding.getVma() * vnom;
        double targetV = (vmin + vmax) * 0.5;
        double targetDeadBand = vmax - vmin;
        boolean bl = regulating = targetV > 0.0 && targetDeadBand >= 0.0;
        if (regulating && regulatingForcedToOff) {
            LOGGER.warn("Transformer {}. Regulating control forced to off. Only one control is supported", (Object)id);
            regulating = false;
        }
        ((RatioTapChanger)((RatioTapChanger)((RatioTapChanger)rtc.setTargetV(targetV).setTargetDeadband(targetDeadBand)).setRegulationTerminal(regulatingTerminal)).setLoadTapChangingCapabilities(regulating)).setRegulating(regulating);
        return regulating;
    }

    private static boolean defineActivePowerControl(Network network, String id, PsseTransformerWinding winding, PhaseTapChanger ptc, boolean regulatingForcedToOff, NodeBreakerImport nodeBreakerImport) {
        boolean regulating;
        if (Math.abs(winding.getCod()) != 3) {
            return false;
        }
        Terminal regulatingTerminal = TransformerConverter.defineRegulatingTerminal(network, id, winding, nodeBreakerImport);
        if (regulatingTerminal == null) {
            return false;
        }
        double activePowerMin = winding.getVmi();
        double activePowerMax = winding.getVma();
        double targetValue = 0.5 * (activePowerMin + activePowerMax);
        double targetDeadBand = activePowerMax - activePowerMin;
        boolean bl = regulating = targetDeadBand >= 0.0;
        if (regulating && regulatingForcedToOff) {
            LOGGER.warn("Transformer {}. Regulating control forced to off. Only one control is supported", (Object)id);
            regulating = false;
        }
        ((PhaseTapChanger)((PhaseTapChanger)ptc.setRegulationValue(targetValue).setTargetDeadband(targetDeadBand)).setRegulationTerminal(regulatingTerminal)).setRegulationMode(PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL).setRegulating(regulating);
        return regulating;
    }

    private static boolean forceRegulatingToOff(boolean regulatingForcedToOff, boolean regulating) {
        return regulatingForcedToOff || regulating;
    }

    private static Terminal defineRegulatingTerminal(Network network, String id, PsseTransformerWinding winding, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = null;
        int busI = Math.abs(winding.getCont());
        Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(busI);
        if (control.isPresent()) {
            int controlledNode = winding.getNode() != 0 ? winding.getNode() : control.get().node();
            regulatingTerminal = TransformerConverter.findTerminalNode(network, control.get().voltageLevelId(), controlledNode);
        } else {
            String regulatingBusId = TransformerConverter.getBusId(busI);
            Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
            if (bus != null) {
                regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
            }
        }
        if (regulatingTerminal == null) {
            LOGGER.warn("Transformer {}. Regulating terminal is not assigned", (Object)id);
        }
        return regulatingTerminal;
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        ArrayList transformers = new ArrayList();
        network.getTwoWindingsTransformers().forEach(t2w -> transformers.add(TransformerConverter.createTwoWindingsTransformer(t2w, contextExport, perUnitContext)));
        network.getThreeWindingsTransformers().forEach(t3w -> transformers.add(TransformerConverter.createThreeWindingsTransformer(t3w, contextExport, perUnitContext)));
        psseModel.addTransformers(transformers);
        psseModel.replaceAllTransformers(psseModel.getTransformers().stream().sorted(Comparator.comparingInt(PsseTransformer::getI).thenComparingInt(PsseTransformer::getJ).thenComparingInt(PsseTransformer::getK).thenComparing(PsseTransformer::getCkt)).toList());
    }

    private static PsseTransformer createTwoWindingsTransformer(TwoWindingsTransformer t2w, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseTransformer psseTransformer = TransformerConverter.createDefaultTransformer();
        int busI = TransformerConverter.getTerminalBusI(t2w.getTerminal1(), contextExport);
        int busJ = TransformerConverter.getTerminalBusI(t2w.getTerminal2(), contextExport);
        Complex ysh = TransformerConverter.admittanceToPerUnit(new Complex(TransformerConverter.getG(t2w), TransformerConverter.getB(t2w)), t2w.getTerminal2().getVoltageLevel().getNominalV(), perUnitContext.sBase());
        psseTransformer.setI(busI);
        psseTransformer.setJ(busJ);
        psseTransformer.setCkt(contextExport.getFullExport().getEquipmentCkt(t2w.getId(), AbstractConverter.PsseEquipmentType.PSSE_TWO_WINDING.getTextCode(), busI, busJ));
        psseTransformer.setMag1(ysh.getReal());
        psseTransformer.setMag2(ysh.getImaginary());
        psseTransformer.setName(t2w.getNameOrId().substring(0, Math.min(40, t2w.getNameOrId().length())));
        psseTransformer.setStat(TransformerConverter.getStatus(t2w.getTerminal1(), t2w.getTerminal2(), contextExport));
        Complex z = TransformerConverter.impedanceToPerUnit(new Complex(TransformerConverter.getR(t2w), TransformerConverter.getX(t2w)), t2w.getTerminal2().getVoltageLevel().getNominalV(), perUnitContext.sBase());
        psseTransformer.setR12(z.getReal());
        psseTransformer.setX12(z.getImaginary());
        psseTransformer.setSbase12(perUnitContext.sBase());
        psseTransformer.setWinding1(TransformerConverter.createWinding(t2w, contextExport), TransformerConverter.createRates(t2w));
        return psseTransformer;
    }

    private static PsseTransformerWinding createWinding(TwoWindingsTransformer t2w, ContextExport contextExport) {
        PsseTransformerWinding winding = TransformerConverter.createDefaultWinding();
        RatioR ratioR = TransformerConverter.findRatioData(t2w.getRatioTapChanger(), t2w.getPhaseTapChanger(), TransformerConverter.getPerUnitRatio0(t2w), contextExport);
        winding.setWindv(ratioR.windv);
        winding.setAng(ratioR.ang);
        winding.setCod(ratioR.cod);
        winding.setCont(ratioR.cont);
        winding.setNode(ratioR.node);
        winding.setRma(ratioR.rma);
        winding.setRmi(ratioR.rmi);
        winding.setNtp(ratioR.ntp);
        return winding;
    }

    private static double getPerUnitRatio0(TwoWindingsTransformer t2w) {
        return t2w.getRatedU1() * t2w.getTerminal2().getVoltageLevel().getNominalV() / (t2w.getRatedU2() * t2w.getTerminal1().getVoltageLevel().getNominalV());
    }

    private static double getR(TwoWindingsTransformer t2w) {
        return TransformerConverter.getValue(t2w.getR(), t2w.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getR()).orElse(0.0), t2w.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getR()).orElse(0.0));
    }

    private static double getX(TwoWindingsTransformer t2w) {
        return TransformerConverter.getValue(t2w.getX(), t2w.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getX()).orElse(0.0), t2w.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getX()).orElse(0.0));
    }

    private static double getG(TwoWindingsTransformer t2w) {
        return TransformerConverter.getValue(t2w.getG(), t2w.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), t2w.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB(TwoWindingsTransformer t2w) {
        return TransformerConverter.getValue(t2w.getB(), t2w.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), t2w.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static PsseRates createRates(TwoWindingsTransformer t2w) {
        PsseRates windingRates = TransformerConverter.createDefaultRates();
        t2w.getApparentPowerLimits1().ifPresent(apparentPowerLimits1 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(apparentPowerLimits1), windingRates));
        if (t2w.getApparentPowerLimits1().isEmpty()) {
            t2w.getApparentPowerLimits2().ifPresent(apparentPowerLimits2 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(apparentPowerLimits2), windingRates));
        }
        if (t2w.getApparentPowerLimits1().isEmpty() && t2w.getApparentPowerLimits2().isEmpty()) {
            t2w.getCurrentLimits1().ifPresent(currentLimits1 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(currentLimits1, t2w.getTerminal1().getVoltageLevel().getNominalV()), windingRates));
        }
        if (t2w.getApparentPowerLimits1().isEmpty() && t2w.getApparentPowerLimits2().isEmpty() && t2w.getCurrentLimits1().isEmpty()) {
            t2w.getCurrentLimits2().ifPresent(currentLimits2 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(currentLimits2, t2w.getTerminal2().getVoltageLevel().getNominalV()), windingRates));
        }
        if (t2w.getApparentPowerLimits1().isEmpty() && t2w.getApparentPowerLimits2().isEmpty() && t2w.getCurrentLimits1().isEmpty() && t2w.getCurrentLimits2().isEmpty()) {
            t2w.getActivePowerLimits1().ifPresent(activePowerLimits1 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(activePowerLimits1), windingRates));
        }
        if (t2w.getApparentPowerLimits1().isEmpty() && t2w.getApparentPowerLimits2().isEmpty() && t2w.getCurrentLimits1().isEmpty() && t2w.getCurrentLimits2().isEmpty() && t2w.getActivePowerLimits1().isEmpty()) {
            t2w.getActivePowerLimits2().ifPresent(activePowerLimits2 -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(activePowerLimits2), windingRates));
        }
        return windingRates;
    }

    private static PsseTransformer createThreeWindingsTransformer(ThreeWindingsTransformer t3w, ContextExport contextExport, PsseExporter.PerUnitContext perUnitContext) {
        PsseTransformer psseTransformer = TransformerConverter.createDefaultTransformer();
        int busI = TransformerConverter.getTerminalBusI(t3w.getLeg1().getTerminal(), contextExport);
        int busJ = TransformerConverter.getTerminalBusI(t3w.getLeg2().getTerminal(), contextExport);
        int busK = TransformerConverter.getTerminalBusI(t3w.getLeg3().getTerminal(), contextExport);
        Complex ysh = TransformerConverter.admittanceToPerUnit(new Complex(TransformerConverter.getG(t3w.getLeg1()), TransformerConverter.getB(t3w.getLeg1())), t3w.getRatedU0(), perUnitContext.sBase());
        psseTransformer.setI(busI);
        psseTransformer.setJ(busJ);
        psseTransformer.setK(busK);
        psseTransformer.setCkt(contextExport.getFullExport().getEquipmentCkt(t3w.getId(), AbstractConverter.PsseEquipmentType.PSSE_THREE_WINDING.getTextCode(), busI, busJ, busK));
        psseTransformer.setMag1(ysh.getReal());
        psseTransformer.setMag2(ysh.getImaginary());
        psseTransformer.setName(t3w.getNameOrId().substring(0, Math.min(40, t3w.getNameOrId().length())));
        psseTransformer.setStat(TransformerConverter.getStatus(t3w, contextExport));
        psseTransformer.setOwnership(TransformerConverter.createDefaultOwnership());
        Complex z1 = new Complex(TransformerConverter.getR(t3w.getLeg1()), TransformerConverter.getX(t3w.getLeg1()));
        Complex z2 = new Complex(TransformerConverter.getR(t3w.getLeg2()), TransformerConverter.getX(t3w.getLeg2()));
        Complex z3 = new Complex(TransformerConverter.getR(t3w.getLeg3()), TransformerConverter.getX(t3w.getLeg3()));
        Complex z12 = TransformerConverter.impedanceToPerUnit(z1.add(z2), t3w.getRatedU0(), perUnitContext.sBase());
        Complex z23 = TransformerConverter.impedanceToPerUnit(z2.add(z3), t3w.getRatedU0(), perUnitContext.sBase());
        Complex z31 = TransformerConverter.impedanceToPerUnit(z3.add(z1), t3w.getRatedU0(), perUnitContext.sBase());
        psseTransformer.setR12(z12.getReal());
        psseTransformer.setX12(z12.getImaginary());
        psseTransformer.setSbase12(perUnitContext.sBase());
        psseTransformer.setR23(z23.getReal());
        psseTransformer.setX23(z23.getImaginary());
        psseTransformer.setSbase23(perUnitContext.sBase());
        psseTransformer.setR31(z31.getReal());
        psseTransformer.setX31(z31.getImaginary());
        psseTransformer.setSbase31(perUnitContext.sBase());
        psseTransformer.setWinding1(TransformerConverter.createWinding(t3w.getLeg1(), t3w.getRatedU0(), contextExport), TransformerConverter.createRates(t3w.getLeg1()));
        psseTransformer.setWinding2(TransformerConverter.createWinding(t3w.getLeg2(), t3w.getRatedU0(), contextExport), TransformerConverter.createRates(t3w.getLeg2()));
        psseTransformer.setWinding3(TransformerConverter.createWinding(t3w.getLeg3(), t3w.getRatedU0(), contextExport), TransformerConverter.createRates(t3w.getLeg3()));
        return psseTransformer;
    }

    private static PsseTransformerWinding createWinding(ThreeWindingsTransformer.Leg leg, double ratedU0, ContextExport contextExport) {
        PsseTransformerWinding winding = TransformerConverter.createDefaultWinding();
        RatioR ratioR = TransformerConverter.findRatioData(leg.getRatioTapChanger(), leg.getPhaseTapChanger(), TransformerConverter.getPerUnitRatio0(leg, ratedU0), contextExport);
        winding.setWindv(ratioR.windv);
        winding.setAng(ratioR.ang);
        winding.setCod(ratioR.cod);
        winding.setCont(ratioR.cont);
        winding.setNode(ratioR.node);
        winding.setRma(ratioR.rma);
        winding.setRmi(ratioR.rmi);
        winding.setNtp(ratioR.ntp);
        return winding;
    }

    private static double getPerUnitRatio0(ThreeWindingsTransformer.Leg leg, double ratedU0) {
        return leg.getRatedU() * ratedU0 / (ratedU0 * leg.getTerminal().getVoltageLevel().getNominalV());
    }

    private static double getR(ThreeWindingsTransformer.Leg leg) {
        return TransformerConverter.getValue(leg.getR(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getR()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getR()).orElse(0.0));
    }

    private static double getX(ThreeWindingsTransformer.Leg leg) {
        return TransformerConverter.getValue(leg.getX(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getX()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getX()).orElse(0.0));
    }

    private static double getG(ThreeWindingsTransformer.Leg leg) {
        return TransformerConverter.getValue(leg.getG(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB(ThreeWindingsTransformer.Leg leg) {
        return TransformerConverter.getValue(leg.getB(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static double getValue(double initialValue, double rtcStepValue, double ptcStepValue) {
        return initialValue * (1.0 + rtcStepValue / 100.0) * (1.0 + ptcStepValue / 100.0);
    }

    private static PsseRates createRates(ThreeWindingsTransformer.Leg leg) {
        PsseRates windingRates = TransformerConverter.createDefaultRates();
        leg.getApparentPowerLimits().ifPresent(apparentPowerLimits -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(apparentPowerLimits), windingRates));
        if (leg.getApparentPowerLimits().isEmpty()) {
            leg.getCurrentLimits().ifPresent(currentLimits -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(currentLimits, leg.getTerminal().getVoltageLevel().getNominalV()), windingRates));
        }
        if (leg.getApparentPowerLimits().isEmpty() && leg.getCurrentLimits().isEmpty()) {
            leg.getActivePowerLimits().ifPresent(activePowerLimits -> TransformerConverter.setSortedRatesToPsseRates(TransformerConverter.getSortedRates(activePowerLimits), windingRates));
        }
        return windingRates;
    }

    private static RatioR findRatioData(RatioTapChanger rtc, PhaseTapChanger ptc, double a0, ContextExport contextExport) {
        if (rtc != null && ptc != null) {
            return TransformerConverter.findRatioDataRtcAndPtc(rtc, ptc, a0, contextExport);
        }
        if (rtc != null) {
            return TransformerConverter.findRatioDataRtc(rtc, a0, contextExport);
        }
        if (ptc != null) {
            return TransformerConverter.findRatioDataPtc(ptc, a0, contextExport);
        }
        return new RatioR(0, a0, 0.0, 0, 0, 1.1, 0.9, 33);
    }

    private static RatioR findRatioDataRtcAndPtc(RatioTapChanger rtc, PhaseTapChanger ptc, double a0, ContextExport contextExport) {
        if (ptc.isRegulating() && !rtc.isRegulating()) {
            int regulatingBusI = TransformerConverter.getRegulatingTerminalBusI(ptc.getRegulationTerminal(), contextExport);
            return new RatioR(TransformerConverter.getSteps(ptc) > 1 && regulatingBusI != 0 ? 3 : 0, a0 * TransformerConverter.getRatio(rtc) * TransformerConverter.getRatio(ptc), TransformerConverter.getAngle(ptc), regulatingBusI, TransformerConverter.getRegulatingTerminalNode(ptc.getRegulationTerminal(), contextExport), TransformerConverter.getMaxAngle(ptc), TransformerConverter.getMinAngle(ptc), TransformerConverter.getSteps(ptc));
        }
        int regulatingBusI = TransformerConverter.getRegulatingTerminalBusI(rtc.getRegulationTerminal(), contextExport);
        return new RatioR(TransformerConverter.getSteps(rtc) > 1 && regulatingBusI != 0 ? 1 : 0, a0 * TransformerConverter.getRatio(rtc) * TransformerConverter.getRatio(ptc), TransformerConverter.getAngle(ptc), regulatingBusI, TransformerConverter.getRegulatingTerminalNode(rtc.getRegulationTerminal(), contextExport), TransformerConverter.getMaxRatio(rtc) * TransformerConverter.getRatio(ptc), TransformerConverter.getMinRatio(rtc) * TransformerConverter.getRatio(ptc), TransformerConverter.getSteps(rtc));
    }

    private static RatioR findRatioDataRtc(RatioTapChanger rtc, double a0, ContextExport contextExport) {
        int regulatingBusI = TransformerConverter.getRegulatingTerminalBusI(rtc.getRegulationTerminal(), contextExport);
        return new RatioR(TransformerConverter.getSteps(rtc) > 1 && regulatingBusI != 0 ? 1 : 0, a0 * TransformerConverter.getRatio(rtc), 0.0, regulatingBusI, TransformerConverter.getRegulatingTerminalNode(rtc.getRegulationTerminal(), contextExport), TransformerConverter.getMaxRatio(rtc), TransformerConverter.getMinRatio(rtc), TransformerConverter.getSteps(rtc));
    }

    private static RatioR findRatioDataPtc(PhaseTapChanger ptc, double a0, ContextExport contextExport) {
        int regulatingBusI = TransformerConverter.getRegulatingTerminalBusI(ptc.getRegulationTerminal(), contextExport);
        return new RatioR(TransformerConverter.getSteps(ptc) > 1 && regulatingBusI != 0 ? 3 : 0, a0 * TransformerConverter.getRatio(ptc), TransformerConverter.getAngle(ptc), regulatingBusI, TransformerConverter.getRegulatingTerminalNode(ptc.getRegulationTerminal(), contextExport), TransformerConverter.getMaxAngle(ptc), TransformerConverter.getMinAngle(ptc), TransformerConverter.getSteps(ptc));
    }

    private static double getMinRatio(RatioTapChanger rtc) {
        double firstRatio = 1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getLowTapPosition())).getRho();
        double lastRatio = 1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getHighTapPosition())).getRho();
        return Math.min(firstRatio, lastRatio);
    }

    private static double getMaxRatio(RatioTapChanger rtc) {
        double firstRatio = 1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getLowTapPosition())).getRho();
        double lastRatio = 1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getHighTapPosition())).getRho();
        return Math.max(firstRatio, lastRatio);
    }

    private static int getSteps(RatioTapChanger rtc) {
        int steps = rtc.getHighTapPosition() - rtc.getLowTapPosition();
        return rtc.getLowTapPosition() < 0 ? steps : steps + 1;
    }

    private static double getMinAngle(PhaseTapChanger ptc) {
        double firstAngle = TransformerConverter.convertToAngle(((PhaseTapChangerStep)ptc.getStep(ptc.getLowTapPosition())).getAlpha());
        double lastAngle = TransformerConverter.convertToAngle(((PhaseTapChangerStep)ptc.getStep(ptc.getHighTapPosition())).getAlpha());
        return Math.min(firstAngle, lastAngle);
    }

    private static double getMaxAngle(PhaseTapChanger ptc) {
        double firstAngle = TransformerConverter.convertToAngle(((PhaseTapChangerStep)ptc.getStep(ptc.getLowTapPosition())).getAlpha());
        double lastAngle = TransformerConverter.convertToAngle(((PhaseTapChangerStep)ptc.getStep(ptc.getHighTapPosition())).getAlpha());
        return Math.max(firstAngle, lastAngle);
    }

    private static int getSteps(PhaseTapChanger ptc) {
        int steps = ptc.getHighTapPosition() - ptc.getLowTapPosition();
        return ptc.getLowTapPosition() < 0 ? steps : steps + 1;
    }

    private static PsseTransformer createDefaultTransformer() {
        PsseTransformer psseTransformer = new PsseTransformer();
        psseTransformer.setI(0);
        psseTransformer.setJ(0);
        psseTransformer.setK(0);
        psseTransformer.setCkt("1");
        psseTransformer.setCw(1);
        psseTransformer.setCz(1);
        psseTransformer.setCm(1);
        psseTransformer.setMag1(0.0);
        psseTransformer.setMag2(0.0);
        psseTransformer.setNmetr(2);
        psseTransformer.setName("");
        psseTransformer.setStat(1);
        psseTransformer.setOwnership(TransformerConverter.createDefaultOwnership());
        psseTransformer.setVecgrp("            ");
        psseTransformer.setZcod(0);
        TransformerConverter.createDefaultTransformerImpedances(psseTransformer);
        psseTransformer.setWinding1(TransformerConverter.createDefaultWinding(), TransformerConverter.createDefaultRates());
        psseTransformer.setWinding2(TransformerConverter.createDefaultWinding(), TransformerConverter.createDefaultRates());
        psseTransformer.setWinding3(TransformerConverter.createDefaultWinding(), TransformerConverter.createDefaultRates());
        return psseTransformer;
    }

    private static void createDefaultTransformerImpedances(PsseTransformer psseTransformer) {
        psseTransformer.setImpedances(new PsseTransformer.TransformerImpedances());
        psseTransformer.setR12(0.0);
        psseTransformer.setX12(0.0);
        psseTransformer.setSbase12(0.0);
        psseTransformer.setR23(0.0);
        psseTransformer.setX23(0.0);
        psseTransformer.setSbase23(0.0);
        psseTransformer.setR31(0.0);
        psseTransformer.setX31(0.0);
        psseTransformer.setSbase31(0.0);
        psseTransformer.setVmstar(0.0);
        psseTransformer.setAnstar(0.0);
    }

    private static PsseTransformerWinding createDefaultWinding() {
        PsseTransformerWinding winding = new PsseTransformerWinding();
        winding.setWindv(1.0);
        winding.setNomv(0.0);
        winding.setAng(0.0);
        winding.setCod(0);
        winding.setCont(0);
        winding.setNode(0);
        winding.setRma(1.1);
        winding.setRmi(0.9);
        winding.setVma(1.1);
        winding.setVmi(0.9);
        winding.setNtp(33);
        winding.setTab(0);
        winding.setCr(0.0);
        winding.setCx(0.0);
        winding.setCnxa(0.0);
        return winding;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getTransformers().forEach(psseTransformer -> {
            if (TransformerConverter.isTwoWindingsTransformer(psseTransformer)) {
                TransformerConverter.updateTwoWindingsTransformer(network, psseTransformer);
            } else {
                TransformerConverter.updateThreeWindingsTransformer(network, psseTransformer);
            }
        });
    }

    private static void updateTwoWindingsTransformer(Network network, PsseTransformer psseTransformer) {
        String transformerId = TransformerConverter.getTransformerId(psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getCkt());
        TwoWindingsTransformer t2w = network.getTwoWindingsTransformer(transformerId);
        if (t2w == null) {
            psseTransformer.setStat(0);
        } else {
            double baskv1 = t2w.getTerminal1().getVoltageLevel().getNominalV();
            double nomV1 = TransformerConverter.getNomV(psseTransformer.getWinding1(), t2w.getTerminal1().getVoltageLevel());
            psseTransformer.getWinding1().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(t2w.getRatioTapChanger(), t2w.getPhaseTapChanger()), baskv1, nomV1, psseTransformer.getCw()));
            psseTransformer.getWinding1().setAng(TransformerConverter.getAngle(t2w.getPhaseTapChanger()));
            psseTransformer.setStat(TransformerConverter.getUpdatedStatus(t2w.getTerminal1(), t2w.getTerminal2()));
        }
    }

    private static void updateThreeWindingsTransformer(Network network, PsseTransformer psseTransformer) {
        String transformerId = TransformerConverter.getTransformerId(psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getK(), psseTransformer.getCkt());
        ThreeWindingsTransformer t3w = network.getThreeWindingsTransformer(transformerId);
        if (t3w == null) {
            psseTransformer.setStat(0);
        } else {
            double baskv1 = t3w.getLeg1().getTerminal().getVoltageLevel().getNominalV();
            double nomV1 = TransformerConverter.getNomV(psseTransformer.getWinding1(), t3w.getLeg1().getTerminal().getVoltageLevel());
            psseTransformer.getWinding1().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(t3w.getLeg1().getRatioTapChanger(), t3w.getLeg1().getPhaseTapChanger()), baskv1, nomV1, psseTransformer.getCw()));
            psseTransformer.getWinding1().setAng(TransformerConverter.getAngle(t3w.getLeg1().getPhaseTapChanger()));
            double baskv2 = t3w.getLeg2().getTerminal().getVoltageLevel().getNominalV();
            double nomV2 = TransformerConverter.getNomV(psseTransformer.getWinding2(), t3w.getLeg2().getTerminal().getVoltageLevel());
            psseTransformer.getWinding2().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(t3w.getLeg2().getRatioTapChanger(), t3w.getLeg2().getPhaseTapChanger()), baskv2, nomV2, psseTransformer.getCw()));
            psseTransformer.getWinding2().setAng(TransformerConverter.getAngle(t3w.getLeg2().getPhaseTapChanger()));
            double baskv3 = t3w.getLeg3().getTerminal().getVoltageLevel().getNominalV();
            double nomV3 = TransformerConverter.getNomV(psseTransformer.getWinding3(), t3w.getLeg3().getTerminal().getVoltageLevel());
            psseTransformer.getWinding3().setWindv(TransformerConverter.defineWindV(TransformerConverter.getRatio(t3w.getLeg3().getRatioTapChanger(), t3w.getLeg3().getPhaseTapChanger()), baskv3, nomV3, psseTransformer.getCw()));
            psseTransformer.getWinding3().setAng(TransformerConverter.getAngle(t3w.getLeg3().getPhaseTapChanger()));
            psseTransformer.setStat(TransformerConverter.getUpdatedStatus(t3w));
        }
    }

    private static int getStatus(ThreeWindingsTransformer t3w, ContextExport contextExport) {
        return TransformerConverter.getStatus(TransformerConverter.getStatus(t3w.getLeg1().getTerminal(), contextExport), TransformerConverter.getStatus(t3w.getLeg2().getTerminal(), contextExport), TransformerConverter.getStatus(t3w.getLeg3().getTerminal(), contextExport));
    }

    private static int getUpdatedStatus(ThreeWindingsTransformer t3w) {
        return TransformerConverter.getStatus(TransformerConverter.getUpdatedStatus(t3w.getLeg1().getTerminal()), TransformerConverter.getUpdatedStatus(t3w.getLeg2().getTerminal()), TransformerConverter.getUpdatedStatus(t3w.getLeg3().getTerminal()));
    }

    private static int getStatus(int statusLeg1, int statusLeg2, int statusLeg3) {
        if (statusLeg1 == 1 && statusLeg2 == 1 && statusLeg3 == 1) {
            return 1;
        }
        if (statusLeg1 == 1 && statusLeg2 == 1) {
            return 3;
        }
        if (statusLeg1 == 1 && statusLeg3 == 1) {
            return 2;
        }
        if (statusLeg2 == 1 && statusLeg3 == 1) {
            return 4;
        }
        return 0;
    }

    private static double getRatio(RatioTapChanger rtc, PhaseTapChanger ptc) {
        if (rtc != null && ptc != null) {
            return TransformerConverter.getRatio(rtc) * TransformerConverter.getRatio(ptc);
        }
        if (rtc != null) {
            return TransformerConverter.getRatio(rtc);
        }
        if (ptc != null) {
            return TransformerConverter.getRatio(ptc);
        }
        return 1.0;
    }

    private static double getRatio(RatioTapChanger rtc) {
        return rtc != null ? 1.0 / ((RatioTapChangerStep)rtc.getCurrentStep()).getRho() : 1.0;
    }

    private static double getRatio(PhaseTapChanger ptc) {
        return ptc != null ? 1.0 / ((PhaseTapChangerStep)ptc.getCurrentStep()).getRho() : 1.0;
    }

    private static double getAngle(PhaseTapChanger ptc) {
        return ptc != null ? TransformerConverter.convertToAngle(((PhaseTapChangerStep)ptc.getCurrentStep()).getAlpha()) : 0.0;
    }

    private static double convertToAngle(double alpha) {
        return alpha != 0.0 ? -alpha : alpha;
    }

    static class ComplexRatio {
        double ratio;
        double angle;

        ComplexRatio(double ratio, double angle) {
            this.ratio = ratio;
            this.angle = angle;
        }

        double getRatio() {
            return this.ratio;
        }

        double getAngle() {
            return this.angle;
        }
    }

    static class TapChanger {
        int tapPosition;
        List<TapChangerStep> steps = new ArrayList<TapChangerStep>();

        TapChanger() {
        }

        void setTapPosition(int tapPosition) {
            this.tapPosition = tapPosition;
        }

        int getTapPosition() {
            return this.tapPosition;
        }

        List<TapChangerStep> getSteps() {
            return this.steps;
        }
    }

    static class TapChangerStep {
        double ratio;
        double angle;
        double r;
        double x;
        double g1;
        double b1;

        TapChangerStep(double ratio, double angle) {
            this.ratio = ratio;
            this.angle = angle;
            this.r = 0.0;
            this.x = 0.0;
            this.g1 = 0.0;
            this.b1 = 0.0;
        }

        TapChangerStep(double ratio, double angle, double r, double x, double g1, double b1) {
            this.ratio = ratio;
            this.angle = angle;
            this.r = r;
            this.x = x;
            this.g1 = g1;
            this.b1 = b1;
        }

        void setRatio(double ratio) {
            this.ratio = ratio;
        }

        double getRatio() {
            return this.ratio;
        }

        void setAngle(double angle) {
            this.angle = angle;
        }

        double getAngle() {
            return this.angle;
        }

        double getR() {
            return this.r;
        }

        double getX() {
            return this.x;
        }

        void setG1(double g1) {
            this.g1 = g1;
        }

        double getG1() {
            return this.g1;
        }

        void setB1(double b1) {
            this.b1 = b1;
        }

        double getB1() {
            return this.b1;
        }
    }

    private record RatioR(int cod, double windv, double ang, int cont, int node, double rma, double rmi, int ntp) {
    }
}

