/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcConverter;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;

class TwoTerminalDcConverter
extends AbstractConverter {
    private static final double DEFAULT_MAXP_FACTOR = 1.2;
    private final PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc;
    private final NodeBreakerImport nodeBreakerImport;

    TwoTerminalDcConverter(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc, ContainersMapping containerMapping, Network network, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseTwoTerminalDc = Objects.requireNonNull(psseTwoTerminalDc);
        this.nodeBreakerImport = nodeBreakerImport;
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseTwoTerminalDc.getRectifier().getIp()) || !this.getContainersMapping().isBusDefined(this.psseTwoTerminalDc.getInverter().getIp())) {
            return;
        }
        double lossFactor = 0.0;
        String busIdR = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getRectifier().getIp());
        VoltageLevel voltageLevelR = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getRectifier().getIp()));
        LccConverterStationAdder adderR = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelR.newLccConverterStation().setId(TwoTerminalDcConverter.getLccConverterId(this.getNetwork(), this.psseTwoTerminalDc, this.psseTwoTerminalDc.getRectifier()))).setName(this.psseTwoTerminalDc.getName())).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getRectifier()));
        String equipmentIdR = TwoTerminalDcConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, this.psseTwoTerminalDc.getRectifier().getIp(), this.psseTwoTerminalDc.getName());
        OptionalInt nodeR = this.nodeBreakerImport.getNode(TwoTerminalDcConverter.getNodeBreakerEquipmentIdBus(equipmentIdR, this.psseTwoTerminalDc.getRectifier().getIp(), 0, 0, this.psseTwoTerminalDc.getRectifier().getIp(), "I"));
        if (nodeR.isPresent()) {
            adderR.setNode(nodeR.getAsInt());
        } else {
            adderR.setConnectableBus(busIdR);
            adderR.setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdR);
        }
        LccConverterStation cR = adderR.add();
        String busIdI = TwoTerminalDcConverter.getBusId(this.psseTwoTerminalDc.getInverter().getIp());
        VoltageLevel voltageLevelI = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(this.psseTwoTerminalDc.getInverter().getIp()));
        LccConverterStationAdder adderI = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)voltageLevelI.newLccConverterStation().setId(TwoTerminalDcConverter.getLccConverterId(this.getNetwork(), this.psseTwoTerminalDc, this.psseTwoTerminalDc.getInverter()))).setName(this.psseTwoTerminalDc.getName())).setLossFactor((float)lossFactor)).setPowerFactor((float)TwoTerminalDcConverter.getLccConverterPowerFactor(this.psseTwoTerminalDc.getInverter()));
        String equipmentIdI = TwoTerminalDcConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_TWO_TERMINAL_DC_LINE, this.psseTwoTerminalDc.getInverter().getIp(), this.psseTwoTerminalDc.getName());
        OptionalInt nodeI = this.nodeBreakerImport.getNode(TwoTerminalDcConverter.getNodeBreakerEquipmentIdBus(equipmentIdI, this.psseTwoTerminalDc.getInverter().getIp(), 0, 0, this.psseTwoTerminalDc.getInverter().getIp(), "I"));
        if (nodeI.isPresent()) {
            adderI.setNode(nodeI.getAsInt());
        } else {
            adderI.setConnectableBus(busIdI);
            adderI.setBus(this.psseTwoTerminalDc.getMdc() == 0 ? null : busIdI);
        }
        LccConverterStation cI = adderI.add();
        HvdcLineAdder adder = ((HvdcLineAdder)((HvdcLineAdder)this.getNetwork().newHvdcLine().setId(TwoTerminalDcConverter.getTwoTerminalDcId(this.psseTwoTerminalDc.getName()))).setName(this.psseTwoTerminalDc.getName())).setR(this.psseTwoTerminalDc.getRdc()).setNominalV(this.psseTwoTerminalDc.getVschd()).setActivePowerSetpoint(TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(this.psseTwoTerminalDc)).setMaxP(TwoTerminalDcConverter.getTwoTerminalDcMaxP(this.psseTwoTerminalDc)).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setConverterStationId1(cR.getId()).setConverterStationId2(cI.getId());
        adder.add();
    }

    private static double getTwoTerminalDcActivePowerSetpoint(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return switch (psseTwoTerminalDc.getMdc()) {
            case 1 -> Math.abs(psseTwoTerminalDc.getSetvl());
            case 2 -> TwoTerminalDcConverter.currentInAmpsToMw(psseTwoTerminalDc.getSetvl(), psseTwoTerminalDc.getVschd());
            default -> 0.0;
        };
    }

    private static double getTwoTerminalDcMaxP(PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc) {
        return TwoTerminalDcConverter.getTwoTerminalDcActivePowerSetpoint(psseTwoTerminalDc) * 1.2;
    }

    private static double getLccConverterPowerFactor(PsseTwoTerminalDcConverter converter) {
        return 0.5 * (Math.cos(Math.toRadians(converter.getAnmx())) + Math.cos(Math.toRadians(60.0)));
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        network.getHvdcLines().forEach(hvdcLine -> {
            if (TwoTerminalDcConverter.isTwoTerminalDcTransmissionLine(hvdcLine)) {
                psseModel.addTwoTerminalDcTransmissionLines(Collections.singletonList(TwoTerminalDcConverter.createTwoTerminalDcTransmissionLine(hvdcLine, contextExport)));
            }
        });
        psseModel.replaceAllTwoTerminalDcTransmissionLines(psseModel.getTwoTerminalDcTransmissionLines().stream().sorted(Comparator.comparing(PsseTwoTerminalDcTransmissionLine::getName)).toList());
    }

    private static PsseTwoTerminalDcTransmissionLine createTwoTerminalDcTransmissionLine(HvdcLine hvdcLine, ContextExport contextExport) {
        PsseTwoTerminalDcTransmissionLine psseTwoTerminalDc = new PsseTwoTerminalDcTransmissionLine();
        psseTwoTerminalDc.setName(TwoTerminalDcConverter.extractTwoTerminalDcName(hvdcLine.getId()));
        psseTwoTerminalDc.setMdc(TwoTerminalDcConverter.findControlMode(hvdcLine, psseTwoTerminalDc.getMdc(), contextExport));
        psseTwoTerminalDc.setRdc(hvdcLine.getR());
        psseTwoTerminalDc.setSetvl(TwoTerminalDcConverter.getVl(hvdcLine));
        psseTwoTerminalDc.setVschd(hvdcLine.getNominalV());
        psseTwoTerminalDc.setVcmod(0.0);
        psseTwoTerminalDc.setRcomp(0.0);
        psseTwoTerminalDc.setDelti(0.0);
        psseTwoTerminalDc.setMeter("I");
        psseTwoTerminalDc.setDcvmin(0.0);
        psseTwoTerminalDc.setCccitmx(20);
        psseTwoTerminalDc.setCccacc(1.0);
        if (hvdcLine.getConvertersMode() == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            psseTwoTerminalDc.setRectifier(TwoTerminalDcConverter.findConverter((LccConverterStation)hvdcLine.getConverterStation1(), contextExport));
            psseTwoTerminalDc.setInverter(TwoTerminalDcConverter.findConverter((LccConverterStation)hvdcLine.getConverterStation2(), contextExport));
        } else {
            psseTwoTerminalDc.setRectifier(TwoTerminalDcConverter.findConverter((LccConverterStation)hvdcLine.getConverterStation2(), contextExport));
            psseTwoTerminalDc.setInverter(TwoTerminalDcConverter.findConverter((LccConverterStation)hvdcLine.getConverterStation1(), contextExport));
        }
        return psseTwoTerminalDc;
    }

    private static double getVl(HvdcLine hvdcLine) {
        return Double.isFinite(hvdcLine.getActivePowerSetpoint()) ? hvdcLine.getActivePowerSetpoint() : 0.0;
    }

    private static PsseTwoTerminalDcConverter findConverter(LccConverterStation lccConverter, ContextExport contextExport) {
        PsseTwoTerminalDcConverter converter = TwoTerminalDcConverter.createDefaultConverter();
        converter.setIp(TwoTerminalDcConverter.getTerminalBusI(lccConverter.getTerminal(), contextExport));
        converter.setAnmx(TwoTerminalDcConverter.getAmnx(lccConverter.getPowerFactor()));
        return converter;
    }

    private static double getAmnx(double powerFactor) {
        double cosValue = powerFactor * 2.0 - Math.cos(Math.toRadians(60.0));
        cosValue = cosValue < -1.0 ? -1.0 : cosValue;
        cosValue = cosValue > 1.0 ? 1.0 : cosValue;
        return Math.toDegrees(Math.acos(cosValue));
    }

    private static PsseTwoTerminalDcConverter createDefaultConverter() {
        PsseTwoTerminalDcConverter converter = new PsseTwoTerminalDcConverter();
        converter.setIp(0);
        converter.setNb(0);
        converter.setAnmx(0.0);
        converter.setAnmn(0.0);
        converter.setRc(0.0);
        converter.setXc(0.0);
        converter.setEbas(0.0);
        converter.setTr(1.0);
        converter.setTap(1.0);
        converter.setTmx(1.5);
        converter.setTmn(0.51);
        converter.setStp(0.00625);
        converter.setIc(0);
        converter.setNd(0);
        converter.setIf(0);
        converter.setIt(0);
        converter.setId("1");
        converter.setXcap(0.0);
        return converter;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getTwoTerminalDcTransmissionLines().forEach(psseTwoTerminalDc -> {
            String hvdcId = TwoTerminalDcConverter.getTwoTerminalDcId(psseTwoTerminalDc.getName());
            HvdcLine hvdcLine = network.getHvdcLine(hvdcId);
            if (hvdcLine == null) {
                psseTwoTerminalDc.setMdc(0);
            } else {
                psseTwoTerminalDc.setMdc(TwoTerminalDcConverter.findUpdatedControlMode(hvdcLine, psseTwoTerminalDc.getMdc()));
            }
        });
    }

    private static int findControlMode(HvdcLine hvdcLine, int mdc, ContextExport contextExport) {
        return TwoTerminalDcConverter.findControlMode(TwoTerminalDcConverter.getStatus(hvdcLine.getConverterStation1().getTerminal(), contextExport), TwoTerminalDcConverter.getStatus(hvdcLine.getConverterStation2().getTerminal(), contextExport), mdc);
    }

    private static int findUpdatedControlMode(HvdcLine hvdcLine, int mdc) {
        return TwoTerminalDcConverter.findControlMode(TwoTerminalDcConverter.getUpdatedStatus(hvdcLine.getConverterStation1().getTerminal()), TwoTerminalDcConverter.getUpdatedStatus(hvdcLine.getConverterStation2().getTerminal()), mdc);
    }

    private static int findControlMode(int status1, int status2, int mdc) {
        if (status1 == 1 && status2 == 1) {
            return mdc != 0 ? mdc : 1;
        }
        return 0;
    }
}

