/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.converter;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.util.ContainersMapping;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.psse.converter.AbstractConverter;
import com.powsybl.psse.converter.ContextExport;
import com.powsybl.psse.converter.NodeBreakerImport;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverter;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverterDcTransmissionLine;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;

class VscDcTransmissionLineConverter
extends AbstractConverter {
    private static final double DEFAULT_MAXP_FACTOR = 1.2;
    private final PsseVoltageSourceConverterDcTransmissionLine psseVscDcTransmissionLine;
    private final PsseVersion version;
    private final NodeBreakerImport nodeBreakerImport;

    VscDcTransmissionLineConverter(PsseVoltageSourceConverterDcTransmissionLine psseVscDcTransmissionLine, ContainersMapping containerMapping, Network network, PsseVersion version, NodeBreakerImport nodeBreakerImport) {
        super(containerMapping, network);
        this.psseVscDcTransmissionLine = Objects.requireNonNull(psseVscDcTransmissionLine);
        this.version = Objects.requireNonNull(version);
        this.nodeBreakerImport = nodeBreakerImport;
    }

    void create() {
        if (!this.getContainersMapping().isBusDefined(this.psseVscDcTransmissionLine.getConverter1().getIbus()) || !this.getContainersMapping().isBusDefined(this.psseVscDcTransmissionLine.getConverter2().getIbus())) {
            return;
        }
        PsseVoltageSourceConverter converter1 = this.psseVscDcTransmissionLine.getConverter1();
        PsseVoltageSourceConverter converter2 = this.psseVscDcTransmissionLine.getConverter2();
        double activePowerSetpoint = VscDcTransmissionLineConverter.getVscDcTransmissionLineActivePowerSetpoint(converter1, converter2);
        HvdcLine.ConvertersMode convertersMode = VscDcTransmissionLineConverter.getConvertersMode(converter1, converter2);
        String busId1 = VscDcTransmissionLineConverter.getBusId(converter1.getIbus());
        VoltageLevel voltageLevel1 = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(converter1.getIbus()));
        VscConverterStationAdder adder1 = ((VscConverterStationAdder)((VscConverterStationAdder)voltageLevel1.newVscConverterStation().setId(VscDcTransmissionLineConverter.getVscConverterId(this.getNetwork(), this.psseVscDcTransmissionLine, converter1))).setLossFactor((float)VscDcTransmissionLineConverter.getLossFactor1(converter1, activePowerSetpoint, convertersMode))).setReactivePowerSetpoint(VscDcTransmissionLineConverter.getReactiveSetpoint(converter1, activePowerSetpoint)).setVoltageRegulatorOn(false);
        String equipmentId1 = VscDcTransmissionLineConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_VSC_DC_LINE, converter1.getIbus(), this.psseVscDcTransmissionLine.getName());
        OptionalInt node1 = this.nodeBreakerImport.getNode(VscDcTransmissionLineConverter.getNodeBreakerEquipmentIdBus(equipmentId1, converter1.getIbus(), 0, 0, converter1.getIbus(), "I"));
        if (node1.isPresent()) {
            adder1.setNode(node1.getAsInt());
        } else {
            adder1.setConnectableBus(busId1);
            adder1.setBus(this.psseVscDcTransmissionLine.getMdc() == 0 ? null : busId1);
        }
        VscConverterStation c1 = adder1.add();
        VscDcTransmissionLineConverter.addReactiveLimits(c1, converter1);
        String busId2 = VscDcTransmissionLineConverter.getBusId(converter2.getIbus());
        VoltageLevel voltageLevel2 = this.getNetwork().getVoltageLevel(this.getContainersMapping().getVoltageLevelId(converter2.getIbus()));
        VscConverterStationAdder adder2 = ((VscConverterStationAdder)((VscConverterStationAdder)voltageLevel2.newVscConverterStation().setId(VscDcTransmissionLineConverter.getVscConverterId(this.getNetwork(), this.psseVscDcTransmissionLine, converter2))).setLossFactor((float)VscDcTransmissionLineConverter.getLossFactor2(converter2, activePowerSetpoint, convertersMode))).setReactivePowerSetpoint(VscDcTransmissionLineConverter.getReactiveSetpoint(converter2, activePowerSetpoint)).setVoltageRegulatorOn(false);
        String equipmentId2 = VscDcTransmissionLineConverter.getNodeBreakerEquipmentId(AbstractConverter.PsseEquipmentType.PSSE_VSC_DC_LINE, converter2.getIbus(), this.psseVscDcTransmissionLine.getName());
        OptionalInt node2 = this.nodeBreakerImport.getNode(VscDcTransmissionLineConverter.getNodeBreakerEquipmentIdBus(equipmentId2, converter2.getIbus(), 0, 0, converter2.getIbus(), "I"));
        if (node2.isPresent()) {
            adder2.setNode(node2.getAsInt());
        } else {
            adder2.setConnectableBus(busId2);
            adder2.setBus(this.psseVscDcTransmissionLine.getMdc() == 0 ? null : busId2);
        }
        VscConverterStation c2 = adder2.add();
        VscDcTransmissionLineConverter.addReactiveLimits(c2, converter2);
        HvdcLineAdder adder = ((HvdcLineAdder)((HvdcLineAdder)this.getNetwork().newHvdcLine().setId(VscDcTransmissionLineConverter.getVscDcTransmissionLineId(this.psseVscDcTransmissionLine.getName()))).setName(this.psseVscDcTransmissionLine.getName())).setR(this.psseVscDcTransmissionLine.getRdc()).setNominalV(VscDcTransmissionLineConverter.getHvdcLineNominalV(voltageLevel1, voltageLevel2)).setActivePowerSetpoint(activePowerSetpoint).setMaxP(VscDcTransmissionLineConverter.getVscDcTransmissionLineMaxP(converter1, voltageLevel1.getNominalV(), converter2, voltageLevel2.getNominalV(), activePowerSetpoint)).setConvertersMode(convertersMode).setConverterStationId1(c1.getId()).setConverterStationId2(c2.getId());
        adder.add();
    }

    private static double getLossFactor1(PsseVoltageSourceConverter converter1, double activePowerSetpoint, HvdcLine.ConvertersMode convertersMode) {
        return convertersMode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER ? VscDcTransmissionLineConverter.getLossFactor(converter1, activePowerSetpoint, true) : VscDcTransmissionLineConverter.getLossFactor(converter1, activePowerSetpoint, false);
    }

    private static double getLossFactor2(PsseVoltageSourceConverter converter2, double activePowerSetpoint, HvdcLine.ConvertersMode convertersMode) {
        return convertersMode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER ? VscDcTransmissionLineConverter.getLossFactor(converter2, activePowerSetpoint, false) : VscDcTransmissionLineConverter.getLossFactor(converter2, activePowerSetpoint, true);
    }

    private static double getLossFactor(PsseVoltageSourceConverter converter1, double activePowerSetpoint, boolean isRectifier) {
        if (isRectifier) {
            double pAC = activePowerSetpoint + Math.abs(converter1.getAloss() / 1000.0);
            return pAC > 0.0 ? (1.0 - activePowerSetpoint / pAC) * 100.0 : 0.0;
        }
        double pAC = activePowerSetpoint - Math.abs(converter1.getAloss() / 1000.0);
        return activePowerSetpoint > 0.0 ? (1.0 - pAC / activePowerSetpoint) * 100.0 : 0.0;
    }

    private static double getReactiveSetpoint(PsseVoltageSourceConverter converter, double activePowerSetpoint) {
        if (converter.getMode() == 1) {
            return 0.0;
        }
        double powerFactor = converter.getAcset();
        return powerFactor != 0.0 && Math.abs(powerFactor) <= 1.0 ? activePowerSetpoint * Math.sqrt(1.0 - powerFactor * powerFactor) / powerFactor : 0.0;
    }

    private static void addReactiveLimits(VscConverterStation c, PsseVoltageSourceConverter converter) {
        c.newMinMaxReactiveLimits().setMaxQ(VscDcTransmissionLineConverter.getMaxQ(converter)).setMinQ(VscDcTransmissionLineConverter.getMinQ(converter)).add();
    }

    private static double getMaxQ(PsseVoltageSourceConverter converter) {
        return converter.getMode() == 1 ? converter.getMaxq() : 0.0;
    }

    private static double getMinQ(PsseVoltageSourceConverter converter) {
        return converter.getMode() == 1 ? converter.getMinq() : 0.0;
    }

    private static double getHvdcLineNominalV(VoltageLevel voltageLevel1, VoltageLevel voltageLevel2) {
        return Math.max(voltageLevel1.getNominalV(), voltageLevel2.getNominalV());
    }

    private static double getVscDcTransmissionLineActivePowerSetpoint(PsseVoltageSourceConverter converter1, PsseVoltageSourceConverter converter2) {
        if (converter1.getType() == 2) {
            return Math.abs(converter1.getDcset());
        }
        if (converter2.getType() == 2) {
            return Math.abs(converter2.getDcset());
        }
        return 0.0;
    }

    private static double getVscDcTransmissionLineMaxP(PsseVoltageSourceConverter converter1, double nominalV1, PsseVoltageSourceConverter converter2, double nominalV2, double activePowerSetpoint) {
        double maxP = Stream.of(converter1.getSmax(), VscDcTransmissionLineConverter.currentInAmpsToMw(converter1.getImax(), nominalV1), converter2.getSmax(), VscDcTransmissionLineConverter.currentInAmpsToMw(converter2.getImax(), nominalV2)).max(Comparator.naturalOrder()).orElse(0.0);
        return maxP > 0.0 ? maxP : activePowerSetpoint * 1.2;
    }

    private static HvdcLine.ConvertersMode getConvertersMode(PsseVoltageSourceConverter converter1, PsseVoltageSourceConverter converter2) {
        if (converter1.getType() == 2) {
            return converter1.getDcset() > 0.0 ? HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER : HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
        }
        if (converter2.getType() == 2) {
            return converter1.getDcset() > 0.0 ? HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER : HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
        }
        return HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
    }

    public void addControl() {
        String id = VscDcTransmissionLineConverter.getVscDcTransmissionLineId(this.psseVscDcTransmissionLine.getName());
        HvdcLine hvdcLine = this.getNetwork().getHvdcLine(id);
        if (hvdcLine == null) {
            return;
        }
        VscDcTransmissionLineConverter.addControlConverter(this.getNetwork(), this.psseVscDcTransmissionLine.getConverter1(), (VscConverterStation)hvdcLine.getConverterStation1(), this.version, this.nodeBreakerImport);
        VscDcTransmissionLineConverter.addControlConverter(this.getNetwork(), this.psseVscDcTransmissionLine.getConverter2(), (VscConverterStation)hvdcLine.getConverterStation2(), this.version, this.nodeBreakerImport);
    }

    private static void addControlConverter(Network network, PsseVoltageSourceConverter converter, VscConverterStation c, PsseVersion psseVersion, NodeBreakerImport nodeBreakerImport) {
        Terminal regulatingTerminal = VscDcTransmissionLineConverter.findRegulatingTerminal(network, converter, c, nodeBreakerImport, psseVersion);
        c.setRegulatingTerminal(regulatingTerminal).setVoltageSetpoint(VscDcTransmissionLineConverter.findTargetVpu(converter) * regulatingTerminal.getVoltageLevel().getNominalV()).setVoltageRegulatorOn(VscDcTransmissionLineConverter.findIsRegulatingOn(converter));
    }

    private static Terminal findRegulatingTerminal(Network network, PsseVoltageSourceConverter converter, VscConverterStation c, NodeBreakerImport nodeBreakerImport, PsseVersion psseVersion) {
        Terminal regulatingTerminal = null;
        Optional<NodeBreakerImport.ControlR> control = nodeBreakerImport.getControl(VscDcTransmissionLineConverter.vscDcTransmissionLineRegulatingBus(converter, psseVersion));
        if (control.isPresent()) {
            regulatingTerminal = VscDcTransmissionLineConverter.findTerminalNode(network, control.get().voltageLevelId(), control.get().node());
        } else {
            String regulatingBusId = VscDcTransmissionLineConverter.getBusId(VscDcTransmissionLineConverter.vscDcTransmissionLineRegulatingBus(converter, psseVersion));
            Bus bus = network.getBusBreakerView().getBus(regulatingBusId);
            if (bus != null) {
                regulatingTerminal = bus.getConnectedTerminalStream().findFirst().orElse(null);
            }
        }
        return regulatingTerminal != null ? regulatingTerminal : c.getTerminal();
    }

    private static int vscDcTransmissionLineRegulatingBus(PsseVoltageSourceConverter converter, PsseVersion psseVersion) {
        if (psseVersion.major() == PsseVersion.Major.V35) {
            return converter.getVsreg();
        }
        return converter.getRemot();
    }

    private static double findTargetVpu(PsseVoltageSourceConverter converter) {
        return converter.getMode() == 1 && VscDcTransmissionLineConverter.isVoltageSetpointValid(converter.getAcset()) ? converter.getAcset() : 1.0;
    }

    private static boolean isVoltageSetpointValid(double targetV) {
        return Double.isFinite(targetV) && targetV > 0.0;
    }

    private static boolean findIsRegulatingOn(PsseVoltageSourceConverter converter) {
        return converter.getMode() == 1;
    }

    static void create(Network network, PssePowerFlowModel psseModel, ContextExport contextExport) {
        PsseVersion version = PsseVersion.fromRevision((float)psseModel.getCaseIdentification().getRev());
        network.getHvdcLines().forEach(hvdcLine -> {
            if (VscDcTransmissionLineConverter.isVscDcTransmissionLine(hvdcLine)) {
                psseModel.addVoltageSourceConverterDcTransmissionLines(Collections.singletonList(VscDcTransmissionLineConverter.createVscDcTransmissionLine(hvdcLine, version, contextExport)));
            }
        });
        psseModel.replaceAllVoltageSourceConverterDcTransmissionLines(psseModel.getVoltageSourceConverterDcTransmissionLines().stream().sorted(Comparator.comparing(PsseVoltageSourceConverterDcTransmissionLine::getName)).toList());
    }

    private static PsseVoltageSourceConverterDcTransmissionLine createVscDcTransmissionLine(HvdcLine hvdcLine, PsseVersion version, ContextExport contextExport) {
        PsseVoltageSourceConverterDcTransmissionLine vscDcTransmissionLine = new PsseVoltageSourceConverterDcTransmissionLine();
        vscDcTransmissionLine.setName(VscDcTransmissionLineConverter.extractVscDcTransmissionLineName(hvdcLine.getId()));
        vscDcTransmissionLine.setMdc(VscDcTransmissionLineConverter.findControlMode(hvdcLine, contextExport));
        vscDcTransmissionLine.setRdc(hvdcLine.getR());
        vscDcTransmissionLine.setOwnership(VscDcTransmissionLineConverter.createDefaultOwnership());
        vscDcTransmissionLine.setConverter1(VscDcTransmissionLineConverter.createConverter((VscConverterStation)hvdcLine.getConverterStation1(), version, contextExport));
        vscDcTransmissionLine.setConverter2(VscDcTransmissionLineConverter.createConverter((VscConverterStation)hvdcLine.getConverterStation2(), version, contextExport));
        return vscDcTransmissionLine;
    }

    private static PsseVoltageSourceConverter createConverter(VscConverterStation vscConverter, PsseVersion version, ContextExport contextExport) {
        PsseVoltageSourceConverter psseConverter = VscDcTransmissionLineConverter.createDefaultConverter();
        int busI = VscDcTransmissionLineConverter.getTerminalBusI(vscConverter.getTerminal(), contextExport);
        int regulatingBus = VscDcTransmissionLineConverter.getRegulatingTerminalBusI(vscConverter.getRegulatingTerminal(), busI, VscDcTransmissionLineConverter.vscDcTransmissionLineRegulatingBus(psseConverter, version), contextExport);
        double converterTargetP = HvdcUtils.getConverterStationTargetP((HvdcConverterStation)vscConverter);
        psseConverter.setIbus(busI);
        psseConverter.setType(2);
        psseConverter.setMode(VscDcTransmissionLineConverter.getMode(vscConverter));
        psseConverter.setDcset(converterTargetP);
        psseConverter.setAcset(VscDcTransmissionLineConverter.findAcset(vscConverter, VscDcTransmissionLineConverter.getMode(vscConverter), converterTargetP));
        psseConverter.setAloss(VscDcTransmissionLineConverter.findALosses(vscConverter.getLossFactor(), converterTargetP));
        psseConverter.setMaxq(VscDcTransmissionLineConverter.checkAndFixMaxQ(vscConverter.getReactiveLimits().getMaxQ(converterTargetP)));
        psseConverter.setMinq(VscDcTransmissionLineConverter.checkAndFixMinQ(vscConverter.getReactiveLimits().getMinQ(converterTargetP)));
        psseConverter.setVsreg(regulatingBus);
        psseConverter.setNreg(VscDcTransmissionLineConverter.getRegulatingTerminalNode(vscConverter.getRegulatingTerminal(), contextExport));
        return psseConverter;
    }

    private static int getMode(VscConverterStation vscConverter) {
        return vscConverter.isVoltageRegulatorOn() ? 1 : 2;
    }

    private static double findAcset(VscConverterStation vscConverter, int mode, double targetP) {
        if (mode == 1) {
            double targetV = vscConverter.getVoltageSetpoint();
            return Double.isFinite(targetV) && targetV > 0.0 ? targetV / vscConverter.getRegulatingTerminal().getVoltageLevel().getNominalV() : 1.0;
        }
        double targetQ = vscConverter.getReactivePowerSetpoint();
        return Double.isFinite(targetP) && targetP != 0.0 && Double.isFinite(targetQ) && targetQ != 0.0 ? targetP / Math.sqrt(targetP * targetP + targetQ * targetQ) : 1.0;
    }

    private static double findALosses(double lossFactor, double converterTargetP) {
        return converterTargetP != 0.0 ? 1000.0 * lossFactor * converterTargetP / 100.0 : 0.0;
    }

    private static double checkAndFixMaxQ(double maxQ) {
        return Double.isNaN(maxQ) ? 9999.0 : maxQ;
    }

    private static double checkAndFixMinQ(double minQ) {
        return Double.isNaN(minQ) ? -9999.0 : minQ;
    }

    private static PsseVoltageSourceConverter createDefaultConverter() {
        PsseVoltageSourceConverter converter = new PsseVoltageSourceConverter();
        converter.setIbus(0);
        converter.setType(1);
        converter.setMode(1);
        converter.setDcset(0.0);
        converter.setAcset(1.0);
        converter.setAloss(0.0);
        converter.setBloss(0.0);
        converter.setMinloss(0.0);
        converter.setSmax(0.0);
        converter.setImax(0.0);
        converter.setPwf(1.0);
        converter.setMaxq(9999.0);
        converter.setMinq(-9999.0);
        converter.setVsreg(0);
        converter.setNreg(0);
        converter.setRmpct(100.0);
        return converter;
    }

    static void update(Network network, PssePowerFlowModel psseModel) {
        psseModel.getVoltageSourceConverterDcTransmissionLines().forEach(psseVscDcTransmissionLine -> {
            String hvdcId = VscDcTransmissionLineConverter.getVscDcTransmissionLineId(psseVscDcTransmissionLine.getName());
            HvdcLine hvdcLine = network.getHvdcLine(hvdcId);
            if (hvdcLine == null) {
                psseVscDcTransmissionLine.setMdc(0);
            } else {
                psseVscDcTransmissionLine.setMdc(VscDcTransmissionLineConverter.findUpdatedControlMode(hvdcLine));
            }
        });
    }

    private static int findControlMode(HvdcLine hvdcLine, ContextExport contextExport) {
        return VscDcTransmissionLineConverter.getStatus(hvdcLine.getConverterStation1().getTerminal(), contextExport) == 1 && VscDcTransmissionLineConverter.getStatus(hvdcLine.getConverterStation2().getTerminal(), contextExport) == 1 ? 1 : 0;
    }

    private static int findUpdatedControlMode(HvdcLine hvdcLine) {
        return VscDcTransmissionLineConverter.getUpdatedStatus(hvdcLine.getConverterStation1().getTerminal()) == 1 && VscDcTransmissionLineConverter.getUpdatedStatus(hvdcLine.getConverterStation2().getTerminal()) == 1 ? 1 : 0;
    }
}

