/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIOJson;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.io.Util;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class CaseIdentificationData
extends AbstractRecordGroup<PsseCaseIdentification> {
    CaseIdentificationData() {
        super(PowerFlowRecordGroup.CASE_IDENTIFICATION, "ic", "sbase", "rev", "xfrrat", "nxfrat", "basfrq", "title1", "title2");
        this.withQuotedFields("title1", "title2");
        this.withIO(FileFormat.LEGACY_TEXT, new CaseIdentificationLegacyText(this));
        this.withIO(FileFormat.JSON, new CaseIdentificationJson(this));
    }

    @Override
    protected Class<PsseCaseIdentification> psseTypeClass() {
        return PsseCaseIdentification.class;
    }

    private static class CaseIdentificationLegacyText
    extends RecordGroupIOLegacyText<PsseCaseIdentification> {
        protected CaseIdentificationLegacyText(AbstractRecordGroup<PsseCaseIdentification> recordGroup) {
            super(recordGroup);
        }

        @Override
        public PsseCaseIdentification readHead(BufferedReader reader, Context context) throws IOException {
            String line = CaseIdentificationLegacyText.readRecordLine(reader);
            context.detectDelimiter(line);
            String[] headers = this.recordGroup.fieldNames(context.getVersion());
            PsseCaseIdentification caseIdentification = (PsseCaseIdentification)this.recordGroup.parseSingleRecord(line, headers, context);
            caseIdentification.setTitle1(reader.readLine());
            caseIdentification.setTitle2(reader.readLine());
            context.setFieldNames(this.recordGroup.getIdentification(), headers);
            context.setVersion(PsseVersion.fromRevision(caseIdentification.getRev()));
            return caseIdentification;
        }

        @Override
        public void writeHead(PsseCaseIdentification caseIdentification, Context context, OutputStream outputStream) {
            String[] headers = (String[])ArrayUtils.removeElements((Object[])context.getFieldNames(this.recordGroup.getIdentification()), (Object[])new String[]{"title1", "title2"});
            String[] quotedFields = this.recordGroup.quotedFields();
            this.write(Collections.singletonList(caseIdentification), headers, Util.retainAll(quotedFields, headers), context, outputStream);
            CaseIdentificationLegacyText.writeLine(caseIdentification.getTitle1(), outputStream);
            CaseIdentificationLegacyText.writeLine(caseIdentification.getTitle2(), outputStream);
        }

        private static void writeLine(String s, OutputStream outputStream) {
            try {
                outputStream.write(s.getBytes());
                outputStream.write(System.lineSeparator().getBytes());
            }
            catch (IOException e) {
                throw new PsseException("Writing head record", e);
            }
        }

        @Override
        public List<PsseCaseIdentification> read(BufferedReader reader, Context context) throws IOException {
            throw new PsseException("Case Identification can not be read as a record group, it was be read as head record");
        }

        @Override
        public void write(List<PsseCaseIdentification> psseObjects, Context context, OutputStream outputStream) {
            throw new PsseException("Case Identification can not be written as a record group, it was be written as head record");
        }
    }

    private static class CaseIdentificationJson
    extends RecordGroupIOJson<PsseCaseIdentification> {
        public CaseIdentificationJson(AbstractRecordGroup<PsseCaseIdentification> recordGroup) {
            super(recordGroup);
        }

        @Override
        public PsseCaseIdentification readHead(BufferedReader reader, Context context) throws IOException {
            PsseCaseIdentification caseIdentification = (PsseCaseIdentification)this.read(reader, context).get(0);
            context.setVersion(PsseVersion.fromRevision(caseIdentification.getRev()));
            return caseIdentification;
        }

        @Override
        public void writeHead(PsseCaseIdentification caseIdentification, Context context, OutputStream outputStream) {
            this.write(Collections.singletonList(caseIdentification), context, outputStream);
        }
    }
}

