/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcConverter;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TwoTerminalDcTransmissionLineData
extends AbstractRecordGroup<PsseTwoTerminalDcTransmissionLine> {
    private static final String[] FIELD_NAMES_32_33 = new String[]{"name", "mdc", "rdc", "setvl", "vschd", "vcmod", "rcomp", "delti", "meter", "dcvmin", "cccitmx", "cccacc"};
    private static final String[] FIELD_NAMES_CONVERTER_32_33 = new String[]{"ip", "nb", "anmx", "anmn", "rc", "xc", "ebas", "tr", "tap", "tmx", "tmn", "stp", "ic", "if", "it", "id", "xcap"};

    TwoTerminalDcTransmissionLineData() {
        super(PowerFlowRecordGroup.TWO_TERMINAL_DC_TRANSMISSION_LINE, new String[0]);
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
        this.withFieldNames(PsseVersion.Major.V32, FIELD_NAMES_32_33);
        this.withFieldNames(PsseVersion.Major.V33, FIELD_NAMES_32_33);
        this.withFieldNames(PsseVersion.Major.V35, "name", "mdc", "rdc", "setvl", "vschd", "vcmod", "rcomp", "delti", "met", "dcvmin", "cccitmx", "cccacc");
        this.withQuotedFields("name", "meter", "idr", "idi", "met");
    }

    @Override
    protected Class<PsseTwoTerminalDcTransmissionLine> psseTypeClass() {
        return PsseTwoTerminalDcTransmissionLine.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseTwoTerminalDcTransmissionLine> {
        IOLegacyText(AbstractRecordGroup<PsseTwoTerminalDcTransmissionLine> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseTwoTerminalDcTransmissionLine> read(BufferedReader reader, Context context) throws IOException {
            ArrayList<String> mainRecords = new ArrayList<String>();
            ArrayList<String> converterRecords = new ArrayList<String>();
            if (!this.isQRecordFound()) {
                String line = IOLegacyText.readRecordLine(reader);
                while (!this.endOfBlock(line)) {
                    mainRecords.add(line);
                    converterRecords.add(IOLegacyText.readRecordLine(reader));
                    converterRecords.add(IOLegacyText.readRecordLine(reader));
                    line = IOLegacyText.readRecordLine(reader);
                }
            }
            List<PsseTwoTerminalDcTransmissionLine> twoTerminalDcList = this.recordGroup.readFromStrings(mainRecords, context);
            List convertersList = new PsseTwoTerminalDcConverterRecordData().readFromStrings(converterRecords, context);
            int index = 0;
            for (PsseTwoTerminalDcTransmissionLine twoTerminalDc : twoTerminalDcList) {
                twoTerminalDc.setRectifier((PsseTwoTerminalDcConverter)convertersList.get(index));
                twoTerminalDc.setInverter((PsseTwoTerminalDcConverter)convertersList.get(++index));
                ++index;
            }
            return twoTerminalDcList;
        }

        @Override
        public void write(List<PsseTwoTerminalDcTransmissionLine> twoTerminalDcList, Context context, OutputStream outputStream) {
            PsseTwoTerminalDcConverterRecordData converterRecordData = new PsseTwoTerminalDcConverterRecordData();
            String[] mainHeaders = context.getFieldNames(PowerFlowRecordGroup.TWO_TERMINAL_DC_TRANSMISSION_LINE);
            String[] quotedFields = this.recordGroup.quotedFields();
            String[] converterHeaders = context.getFieldNames(PowerFlowRecordGroup.INTERNAL_TWO_TERMINAL_DC_TRANSMISSION_LINE_CONVERTER);
            ArrayList mainList = new ArrayList();
            ArrayList converterList = new ArrayList();
            twoTerminalDcList.forEach(twoTerminalDc -> {
                mainList.add(twoTerminalDc);
                converterList.add(twoTerminalDc.getRectifier());
                converterList.add(twoTerminalDc.getInverter());
            });
            List<String> mainStringList = this.recordGroup.buildRecords(mainList, mainHeaders, quotedFields, context);
            List<String> converterStringList = converterRecordData.buildRecords(converterList, converterHeaders, quotedFields, context);
            this.writeBegin(outputStream);
            int index = 0;
            for (String main : mainStringList) {
                String rectifier = converterStringList.get(index);
                String inverter = converterStringList.get(++index);
                ++index;
                IOLegacyText.write(Arrays.asList(main, rectifier, inverter), outputStream);
            }
            this.writeEnd(outputStream);
        }

        private static class PsseTwoTerminalDcConverterRecordData
        extends AbstractRecordGroup<PsseTwoTerminalDcConverter> {
            PsseTwoTerminalDcConverterRecordData() {
                super(PowerFlowRecordGroup.INTERNAL_TWO_TERMINAL_DC_TRANSMISSION_LINE_CONVERTER, new String[0]);
                this.withFieldNames(PsseVersion.Major.V32, FIELD_NAMES_CONVERTER_32_33);
                this.withFieldNames(PsseVersion.Major.V33, FIELD_NAMES_CONVERTER_32_33);
                this.withFieldNames(PsseVersion.Major.V35, "ip", "nb", "anmx", "anmn", "rc", "xc", "ebas", "tr", "tap", "tmx", "tmn", "stp", "ic", "nd", "if", "it", "id", "xcap");
                this.withQuotedFields(new String[0]);
            }

            @Override
            protected Class<PsseTwoTerminalDcConverter> psseTypeClass() {
                return PsseTwoTerminalDcConverter.class;
            }
        }
    }
}

