/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.io.PowerFlowData;
import com.powsybl.psse.model.pf.io.PowerFlowRawData32;
import com.powsybl.psse.model.pf.io.PowerFlowRawData33;
import com.powsybl.psse.model.pf.io.PowerFlowRawData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawDataAllVersions;
import com.powsybl.psse.model.pf.io.PowerFlowRawxData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawxDataAllVersions;

public final class PowerFlowDataFactory {
    private PowerFlowDataFactory() {
    }

    public static PowerFlowData create(String extension) {
        if (extension.equalsIgnoreCase("rawx")) {
            return new PowerFlowRawxDataAllVersions();
        }
        return new PowerFlowRawDataAllVersions();
    }

    public static PowerFlowData create(String extension, PsseVersion version) {
        if (extension.equalsIgnoreCase("rawx")) {
            switch (version.major()) {
                case V35: {
                    return new PowerFlowRawxData35();
                }
            }
            throw new PsseException("Unsupported version " + version);
        }
        switch (version.major()) {
            case V35: {
                return new PowerFlowRawData35();
            }
            case V33: {
                return new PowerFlowRawData33();
            }
            case V32: {
                return new PowerFlowRawData32();
            }
        }
        throw new PsseException("Unsupported version " + version);
    }
}

