/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PsseVersion {
    private static final int MAJOR_FACTOR = 100;
    static final PsseVersion MAX_VERSION = PsseVersion.fromRevision(99.99f);
    private static final PsseVersion VERSION_32 = new PsseVersion(3200);
    private static final PsseVersion VERSION_33 = new PsseVersion(3300);
    private static final PsseVersion VERSION_35 = new PsseVersion(3500);
    private static final List<PsseVersion> SUPPORTED_VERSIONS = Arrays.asList(VERSION_32, VERSION_33, VERSION_35);
    private static final Set<Integer> SUPPORTED_MAJORS = SUPPORTED_VERSIONS.stream().map(PsseVersion::getMajorNumber).collect(Collectors.toSet());
    private static final String STR_SUPPORTED_MAJORS = SUPPORTED_MAJORS.stream().sorted().map(Object::toString).collect(Collectors.joining(", "));
    private final int number;

    private PsseVersion(int number) {
        this.number = number;
    }

    private PsseVersion(float revision) {
        this.number = (int)(revision * 100.0f);
    }

    public int getMajorNumber() {
        return this.number / 100;
    }

    public int getMinorNumber() {
        return this.number % 100;
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        return this.getMinorNumber() != 0 ? String.format("%d.%d", this.getMajorNumber(), this.getMinorNumber()) : String.format("%d", this.getMajorNumber());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsseVersion that = (PsseVersion)o;
        return this.number == that.number;
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public static PsseVersion fromRevision(float revisionNumber) {
        return new PsseVersion(revisionNumber);
    }

    public static String supportedVersions() {
        return STR_SUPPORTED_MAJORS;
    }

    public boolean isSupported() {
        return SUPPORTED_MAJORS.contains(this.getMajorNumber());
    }

    public Major major() {
        return Major.fromNumber(this.getMajorNumber());
    }

    public static enum Major {
        V32(32),
        V33(33),
        V35(35);

        private static final Map<Integer, Major> BY_NUMBER;
        int number;

        private static Major fromNumber(int major) {
            return BY_NUMBER.get(major);
        }

        private Major(int major) {
            this.number = major;
        }

        private int getNumber() {
            return this.number;
        }

        static {
            BY_NUMBER = Arrays.stream(Major.values()).collect(Collectors.toMap(Major::getNumber, Function.identity()));
        }
    }
}

